; -------------------------------------------------------------------- ;
; : CONTROL.INC                                                    ;
; -------------------------------------------------------------------- ;
; ம। ᫮ ᥬ஢  ७     ;
; Turbo Assembler 3.xx                                                 ;
; -------------------------------------------------------------------- ;
; ᪮ ࠢ (C) 02-14-95 ਩ .⥪                     ;
; -------------------------------------------------------------------- ;

.xlist

;=======================================================================
; ᭮ 
;=======================================================================
; ਬ砭: ࠦ  㣫  ᪮  ।⠢  ᮡ 㬥
;             .
;-----------------------------------------------------------------------
; 믮   ୠ⨢  
;-----------------------------------------------------------------------
; @if (cond_1) [then]
;     commands...
; [@elseif (cond_2)
;     commands...
; [@else
;     commands...
; @endif
;-----------------------------------------------------------------------
;   ࠬ஬
;-----------------------------------------------------------------------
; @for (exp)          ;;   (exp)--
;     commands...
; [@loop [(cond_1)]]  ;; ࠢ  @next
;     commands...
; [@exit [(cond_2)]]  ;; ࠢ  @next
;     commands...
; @next               ;; --(exp), ஢ઠ
;
; ந  뫪 (exp)  CX. ᫨ (exp)   ⠭⮩, -
;   客    ᠭ  jcxz.   ᮫⥫-
;  :
;
;       mov  cx,(exp)
; loop:[jcxz exit]
;       push cx
;            commands...
; next: pop  cx
;       loop loop
; exit:
;
; ᫨  ⠭  横 㦥 室  CX, ᯮ 맮: @for cx.
; ᫨   室  ࠭  CX  (commands...     -
;  ᮤন CX), ᯮ :
;
; @cycle (exp)        ;;   (exp)--
;     commands...
; [@loop [(cond_1)]]  ;; ࠢ  @next
;     commands...
; [@exit [(cond_2)]]  ;; ࠢ  @next
;     commands...
; @endcycle           ;; --(exp), ஢ઠ
;
;     ᥬ  @for...@next, ⮫쪮  -
;   push cx  pop cx.
;-----------------------------------------------------------------------
;   ᫮
;-----------------------------------------------------------------------
; @dowhile (cond_1)   ;; 室  横  ⨭ (cond_1)
;     commands...
; [@loop [(cond_2)]]  ;; । ࠢ  @dowhile
;     commands...
; [@exit [(cond_3)]]  ;; । ࠢ  @enddo
;     commands...
; @enddo              ;; । ࠢ  @dowhile
;
;
; @repeat
;     commands...
; [@loop [(cond_1)]]  ;; । ࠢ  @when
;     commands...
; [@exit [(cond_2)]]  ;; । ࠢ  @when
;     commands...
; @when (cond_3)      ;; 室  @repeat  ⨭ (cond_3)
;
; ᫨   室   ᪮   横,   ᯮ   ਠ -
;  @repeat...@allways
;-----------------------------------------------------------------------
; ࠢ  ᫮
;-----------------------------------------------------------------------
; (exp_1) (cond) (exp_2)  --> log
; <(log_1)> and <(log_2)> --> log
; <(log_1)> or  <(log_2)> --> log
;
; (exp_1)   (exp_2)   ᮤঠ ஡,    ।-
;   ᢮ ᯮ짮.
;
; ⨬ ࠦ  (cond) ᬮ  ᠭ  ?cond. ਬ
;   ⠢ ࠦ:
;
; @if ax == 10
; @if <ax == 10> and <bx -= 11>
; @if <<ax == 10> and <bx -= 11>> or <CF == 1>
;
;=======================================================================
; 㦥 
;=======================================================================
; ?inc  (exp)        - ६ ࠦ (exp).
; ?dec  (exp)        - ६ ࠦ (exp).
;
; ?cond (a) (r) (b)  -   㦥  ६  ?comp,   ?goTrue
;                        ?goFals ଠ樥, 室  ନ஢-
;                       ᫮ 室.
;
; ?pushif (exp)      - ⮫ ࠦ  ⥪ @if/@endif
; ?popif  (exp)      - ⮫ ࠦ  ⥪ @if/@endif
; ?getif  (exp)      -  ࠦ  設 ⥪ @if/@endif
; ?pushdo (exp)      - ⮫ ࠦ  ⥪ @do/@enddo
; ?popdo  (exp)      - ⮫ ࠦ  ⥪ @do/@enddo
; ?getdo  (exp)      -  ࠦ  設 ⥪ @do/@enddo
;
; ?mvr (reg),(exp)   -  ࠦ (exp)  ॣ (reg).  -
;                       , ᫨  ࠦ  ᮢ   
;                      ॣ.  뫪  㫥 祭  
;                       xor (reg),(reg)
;=======================================================================
; ᥢ 
;=======================================================================
;
; sds (label),(reg)   ->  mov word label,reg
;                         mov word label+2,ds
;
; ses (label),(reg)   ->  mov word label,reg
;                         mov word label+2,es
;
; sdx (label)         ->  mov word label,ax
;                         mov word label+2,dx
;
; ldx (label)         ->  mov ax,word label
;                         mov dx,word label+2
;
; mvx (dst),(src)     ->  mov ax,src
;                         mov dst,ax
;
; mvd (dst),(src)     ->  mvx dst,src
;                         mvx dst[2],src[2]
;
; mvl (dst),(src)     ->  mov al,src
;                         mov dst,al
;
; mvs (dst),(src)     ->  push src
;                         pop  dst
;
; smv (count)         ->  [mov cx,count]
;                         shr cx,1
;                         rep movsw
;                         adc cx,cx
;                         rep movsb
;
; sst (count)         ->  [mov cx,count]
;                         shr cx,1
;                         rep stosw
;                         adc cx,cx
;                         rep stosb
;
;=======================================================================
; ⥫ 
;=======================================================================
;
; @int (fnc),(num)    -> mov ah,fnc    8bit
;                        int num
;                     -> mov ax,fnc    16bit
;                        int num
;
; @outb (port),(byte) ->     /뢮
; @outw (port),(word) ->  ᫮   /뢮
;
; @inb  (reg),(port)  ->     /뢮
; @inw  (reg),(port)  ->  ᫮   /뢮
;
;=======================================================================

;Ŀ
; 㦥 ६ 
;

;-----------------------;
?long       equ <short> ; ਧ ⨢  @long
;-----------------------;
?comp       equ <>      ; ⢨, ।饥 ஢ ⨭ ᫮
?goTrue     equ <>      ; 室  ⨭ ᫮
?goFals     equ <>      ; 室   ᫮
;-----------------------;
?ifPtr      =   0       ; ⥫ ⥪ @if/@endif
?doPtr      =   0       ; ⥫ ⥪ @do/@enddo
?ifNo       =   0       ;  ।  @if/@endif
?doNo       =   0       ;  ।  @do/@enddo
;-----------------------;
?typeFor    =   0       ; ⨯ 横 @for/@next
?typeDo     =   1       ; ⨯ 横 @dowhile/@enddo
?typeUntil  =   2       ; ⨯ 横 @repeat/@when
?typeCycle  =   3       ; ⨯ 横 @cycle/@endcycle
;-----------------------;

;Ŀ
; 㦥  
;

;; ६  ६ ࠦ
;; -------------------------------/

?inc macro ?exp
  ?exp = ?exp + 1
endm
?dec macro ?exp
  ?exp = ?exp - 1
endm

;; ନ஢ ᪮ ᫮
;; --------------------------------/

?cond macro ?a, ?r, ?b

  ;; ⨬ ଠ:
  ;;
  ;; 䫠:         ZF == 1
  ;;                ZF == 0
  ;;                CF == 1
  ;;                CF == 0
  ;;                SF == 1
  ;;                SF == 0
  ;;
  ;; ࠢ:     a == b     a ࠢ b
  ;;                a #= b       ࠢ b
  ;;                a -- b       b
  ;;                a ++ b     a  b
  ;;                a -= b     a   ࠢ b
  ;;                a += b     a   ࠢ b
  ;;
  ;; ஢:  a && b
  ;;                a #& b

  ;;  䫠  ந  । ⢨,
  ;; ⮫쪮  ६ 室 ?goTrue  ?goFals:

  ?comp equ <>

  ifidni <?a>,<ZF>          ;; Zero 䫠
  ifidni <?r>,<==>
    if ?b eq 0              ;; ZF == 0
       ?goTrue equ <jnz>
       ?goFals equ <jz>
       exitm
    endif
    if ?b eq 1              ;; ZF == 1
       ?goTrue equ <jz>
       ?goFals equ <jnz>
       exitm
    endif
  endif
  endif

  ifidni <?a>,<CF>          ;; Carry 䫠
  ifidni <?r>,<==>
    if ?b eq 0              ;; CF == 0
       ?goTrue equ <jnc>
       ?goFals equ <jc>
       exitm
    endif
    if ?b eq 1              ;; CF == 1
       ?goTrue equ <jc>
       ?goFals equ <jnc>
       exitm
    endif
  endif
  endif

  ifidni <?a>,<SF>          ;; Sign 䫠
  ifidni <?r>,<==>
    if ?b eq 0              ;; SF == 0
       ?goTrue equ <jns>
       ?goFals equ <js>
       exitm
    endif
    if ?b eq 1              ;; SF == 1
       ?goTrue equ <js>
       ?goFals equ <jns>
       exitm
    endif
  endif
  endif

  ;;  権 ࠢ ६ ?comp  
  ;; ࠢ ࠭   ६ 室 ?goTrue
  ;;  ?goFals:

  ?comp equ <cmp ?a,?b>

  ifidn <?r>,<==>               ;; ࠢ

        ;; ⨬ ⢨
        ;;  権 ⨯ ax == 0

        if (.type ?a) and 16
        if (.type ?b) and 4
        if ?b eq 0
           ?comp equ <or ?a,?a>
        endif
        endif
        endif

        ?goTrue equ <je>
        ?goFals equ <jne>
        exitm
  endif
  ifidn <?r>,<#=>               ;;  ࠢ

        ;; ⨬ ⢨
        ;;  権 ⨯ ax #= 0

        if (.type ?a) and 16
        if (.type ?b) and 4
        if ?b eq 0
           ?comp equ <or ?a,?a>
        endif
        endif
        endif

        ?goTrue equ <jne>
        ?goFals equ <je>
        exitm
  endif
  ifidn <?r>,<-->               ;; 
         ?goTrue equ <jb>
         ?goFals equ <jnb>
         exitm
  endif
  ifidn <?r>,<++>               ;; 
         ?goTrue equ <ja>
         ?goFals equ <jna>
         exitm
  endif
  ifidn <?r>,<-=>               ;;   ࠢ
         ?goTrue equ <jbe>
         ?goFals equ <jnbe>
         exitm
  endif
  ifidn <?r>,<+=>               ;;   ࠢ
         ?goTrue equ <jae>
         ?goFals equ <jnae>
         exitm
  endif

  ;;  権 ஢ ६ ?comp  
  ;; ஢ન ⮢   ६ 室 ?goTrue  ?goFals:

  ?comp equ <testflag ?a,?b>    ;; ஢

  ifidn <?r>, <&&&>             ;; and
         ?goTrue equ <jnz>
         ?goFals equ <jz>
         exitm
  endif
  ifidn <?r>, <#&&>             ;; not and
         ?goTrue equ <jz>
         ?goFals equ <jnz>
         exitm
  endif

  .err                          ;; -  稫
endm

;;   ⥪ @if...@endif
;; ----------------------------/

?pushif macro ?exp
        ?inc  ?ifPtr
        ?stack catstr <?ifStack_>,%?ifPtr
      % ?stack = ?exp
endm

?popif macro ?exp
       ?stack catstr <?ifStack_>,%?ifPtr
     % ?exp = ?stack
       ?dec ?ifPtr
endm

?getif macro ?exp
       ?stack catstr <?ifStack_>,%?ifPtr
     % ?exp = ?stack
endm

;;   ⥪ 横
;; ----------------------/

?pushdo macro ?exp
        ?inc  ?doPtr
        ?stack catstr <?doStack_>,%?doPtr
      % ?stack = ?exp
endm

?popdo macro ?exp
       ?stack catstr <?doStack_>,%?doPtr
     % ?exp = ?stack
       ?dec ?doPtr
endm

?getdo macro ?exp
       ?stack catstr <?doStack_>,%?doPtr
     % ?exp = ?stack
endm

;;  ࠦ  ॣ
;; --------------------------/

?mvr macro ?reg, ?exp
  if (.type ?exp) and 4
     if ?exp eq 0
        xor  ?reg,?reg
        exitm
     endif
  endif
  ifdifi <?reg>,<?exp>
    mov   ?reg,?exp
  endif
endm

;Ŀ
; 믮   ᪮쪨   
;

;;  @if
;; ------------/

@if macro ?a, ?r, ?b, ?then, ?label
    local ?true_xx

    ifidni <?then>,<goto>             ;; ॠ @if...goto

      ifidni <?r>,<AND>               ;; ᪮ 
         @if ?a
             @if ?b, goto, ?label
         @endif
         exitm
      endif
      ifidni <?r>,<OR>                ;; ᪮ 
          @if ?a, goto, ?label
          @if ?b, goto, ?label
          exitm
      endif

      ?cond <?a>, <?r>, <?b>          ;;  ⠫쭮
      ?comp
      ?goTrue ?long ?label
      exitm
    endif

    ifnb   <?then>                    ;;    @if...then
    ifdifi <?then>,<THEN>             ;;    THEN, 
      .err                            ;; 祣.
    endif
    endif
                                      ;;  @if...then
    ifidni <?r>,<AND>                 ;; ᪮ 
        @if  ?a
        ?dec ?ifNo
        @if  ?b
        ?ifPtr = ?ifPtr - 2
        exitm
    endif
    ifidni <?r>,<OR>                  ;; ᪮ 
        @if ?a, goto, ?true_xx
        @if ?b, then
    ?true_xx:
        exitm
    endif

    ?cond <?a>, <?r>, <?b>
    ?comp

    ?inc    ?ifNo
    ?pushif ?ifNo
    ?pushif ?ifNo
    ?else   catstr <?else_>, %?ifNo
    ?goFals ?long ?else
endm

;;  @else
;; --------------/

@else macro

    ?inc    ?ifNo
    ?popif  ?elseNo
    ?getif  ?endifNo
    ?pushif ?ifNo
    ?else   catstr <?else_>,  %?elseNo
    ?endif  catstr <?endif_>, %?endifNo
    jmp     ?long ?endif
    ?else   label near
endm

;;  @elseif
;; ----------------/

@elseif macro ?a, ?r, ?b

    @else
    ?dec  ?ifNo
    @if   <?a> <?r> <?b>
    ?ifPtr = ?ifPtr - 2
endm

;;  @endif
;; ---------------/

@endif macro

  ?popif  ?elseNo
  ?popif  ?endifNo
  ?else   catstr <?else_>, %?elseNo
  ?endif  catstr <?endif_>, %?endifNo
  ?endif  label near
  ?else   label near
endm

;Ŀ
;   ࠬ஬ 
;

;;  @for
;; -------------/

@for macro ?cycleCount

        ?mvr  cx,?cycleCount
        ?inc  ?doNo
        ?for  catstr <?for_>, %?doNo
        ?exit catstr <?exit_>, %?doNo
        ife (.type ?cycleCount) and 4
            jcxz ?exit
        endif
?for:   push    cx
        ?pushdo ?doNo
        ?pushdo ?typeFor
endm

;;  @next
;; --------------/

@next macro

        ?dec    ?doPtr
        ?popdo  ?nextNo
        ?for    catstr <?for_> , %?nextNo
        ?loop   catstr <?loop_>, %?nextNo
        ?exit   catstr <?exit_>, %?nextNo
?loop:  pop     cx
        loop    ?for
?exit:  endm

;;  @cycle
;; -------------/

@cycle macro ?cycleCount

        ?mvr  cx,?cycleCount
        ?inc  ?doNo
        ?for  catstr <?for_> , %?doNo
        ?exit catstr <?exit_>, %?doNo
        ife (.type ?cycleCount) and 4
            jcxz ?exit
        endif
?for:   ?pushdo ?doNo
        ?pushdo ?typeCycle
endm

;;  @endcycle
;; -----------------/

@endcycle macro

        ?dec    ?doPtr
        ?popdo  ?nextNo
        ?for    catstr <?for_> , %?nextNo
        ?loop   catstr <?loop_>, %?nextNo
        ?exit   catstr <?exit_>, %?nextNo
?loop:  loop    ?for
?exit:
 endm

;Ŀ
;   ᫮ 
;

;;  @dowhile
;; -----------------/

@dowhile macro ?a, ?r, ?b

        ?inc    ?doNo
        ?pushdo ?doNo
        ?pushdo ?typeDo
        ?loop   catstr <?loop_>, %?doNo
?loop:  @if     <?a>, <?r>, <?b>
endm

;;  @enddo
;; ---------------/

@enddo macro

        ?dec   ?doPtr
        ?popdo ?enddoNo
        ?exit  catstr <?exit_>, %?enddoNo
        ?loop  catstr <?loop_>, %?enddoNo
        jmp    ?loop
        @endif
?exit:  endm

;;  @repeat
;; ----------------/

@repeat macro

        ?inc     ?doNo
        ?pushdo  ?doNo
        ?pushdo  ?typeUntil
        ?rep     catstr <?rep_>, %?doNo
?rep:   endm

;;  @when
;; -------------/

@when macro ?a, ?r, ?b

        ?dec    ?doPtr
        ?popdo  ?untilNo
        ?exit   catstr <?exit_>, %?untilNo
        ?loop   catstr <?loop_>, %?untilNo
        ?rep    catstr <?rep_> , %?untilNo

?loop:  @if <?a>, <?r>, <?b>, goto, ?rep
?exit:  endm

;;  @always
;; ---------------/

@always macro

        ?dec    ?doPtr
        ?popdo  ?untilNo
        ?exit   catstr <?exit_>, %?untilNo
        ?loop   catstr <?loop_>, %?untilNo
        ?rep    catstr <?rep_> , %?untilNo

?loop:  jmp ?rep
?exit:  endm

;Ŀ
; ࣠ ⫨  室  横 
;

;;  @loop
;; -------------/

@loop macro ?a, ?r, ?b

        ?popdo    ?type
        ?getdo    ?loopNo
        ?loop     catstr <?loop_>, %?loopNo
        ?pushdo   ?type

        ifnb <?r>
             @if <?a> <?r> <?b> goto ?loop
        else
             jmp ?long ?loop
        endif
endm

;;  @exit
;; -------------/

@exit macro ?a, ?r, ?b
      local ?cont

      ?popdo    ?type
      ?getdo    ?exitNo
      ?exit     catstr <?exit_>, %?exitNo
      ?pushdo   ?type

      ifnb <?r>
           if ?type eq ?typeFor
              @if <?a> <?r> <?b>
                  pop cx
                  jmp ?long ?exit
              @endif
           else
              @if <?a> <?r> <?b> goto ?exit
           endif
        else
           if ?type eq ?typeFor
              pop cx
           endif
           jmp ?long ?exit
        endif
endm

;Ŀ
;  ⥫ 横  ᫮ ஢ 
;

@long macro ?operator

  jumps
  ?long equ <>
  ?operator
  ?long equ <short>
  nojumps
endm

;Ŀ
; ᥢ  
;

sds macro ?label, ?reg

    mov   word ptr ?label,?reg
    mov   word ptr ?label[2],ds
endm

ses macro ?label, ?reg

    mov   word ptr ?label,?reg
    mov   word ptr ?label[2],es
endm

sdx macro ?label

    mov   word ptr ?label,ax
    mov   word ptr ?label[2],dx
endm

ldx macro ?label

    mov   ax,word ptr ?label
    mov   dx,word ptr ?label[2]
endm

mvx macro ?dst, ?src
    ?mvr  ax,?src
    mov   ?dst,ax
endm

mvd macro ?dst, ?src
    mvx   ?dst, ?src
    mvx   ?dst[2], ?src[2]
endm

mvl macro ?dst, ?src
    ?mvr  al,?src
    mov   ?dst,al
endm

mvs macro ?dst, ?src
    push  ?src
    pop   ?dst
endm

smv macro ?cnt
    ?mvr cx,?cnt
    shr  cx,1
    rep  movsw
    adc  cx,cx
    rep  movsb
endm

sst macro ?cnt
    ?mvr cx,?cnt
    shr  cx,1
    rep  stosw
    adc  cx,cx
    rep  stosb
endm

;Ŀ
; ⥫  
;

@int macro functype, inttype

    if functype lt 100h
       mov  ah,functype
    else
       mov  ax,functype
    endif
    int inttype
endm

@outb macro port, exp

  ?mvr al,exp             ; 祭  ॣ.

  if (.type port) and 4   ;᫨   - ⠭,
     if port lt 100h      ;᫨    100h,
        out port,al       ;ந ।⢥ 뢮
     else                 ; .
        ?mvr dx,port      ; 뢮   ந
        out  dx,al        ;१ ॣ DX.
     endif
  else
     ?mvr dx,port         ;᫨   ⠭, 뢮  
     out  dx,al           ;ᥣ ந १ ॣ DX.
  endif
endm

@outw macro port, exp

  ?mvr ax,exp             ; 祭  ॣ.

  if (.type port) and 4   ;᫨   - ⠭,
     if port lt 100h      ;᫨    100h,
        out port,ax       ;ந ।⢥ 뢮
     else                 ; .
        ?mvr dx,port      ; 뢮   ந
        out  dx,ax        ;१ ॣ DX.
     endif
  else
     ?mvr dx,port         ;᫨   ⠭, 뢮  
     out  dx,ax           ;ᥣ ந १ ॣ DX.
  endif
endm

@inb macro exp,port

  if (.type port) and 4   ;᫨   - ⠭,
     if port lt 100h      ; ᫨    100h,
        in  al,port       ;ந ।⢥ 
     else                 ; .
        ?mvr dx,port      ;    ந
        in   al,dx        ;१ ॣ DX.
     endif
  else
     ?mvr dx,port         ;᫨   ⠭,   
     in   al,dx           ;ᥣ ந १ ॣ DX.
  endif
endm

@inw macro exp,port

  if (.type port) and 4   ;᫨   - ⠭,
     if port lt 100h      ; ᫨    100h,
        in  ax,port       ;ந ।⢥ 
     else                 ; .
        ?mvr dx,port      ;    ந
        in   ax,dx        ;१ ॣ DX.
     endif
  else
     ?mvr dx,port         ;᫨   ⠭,   
     in   ax,dx           ;ᥣ ந १ ॣ DX.
  endif
endm

.list
