;
; 㭪樨 ࠡ  ࠭, (C) .⥪                          
;

        Include Support.inc
        Include Control.inc
        Include Global.inc
        Include Constant.inc
        Include Bios.inc

.Data
;---------------------------;
__scrCRT        DW  0       ;  ॣ ﭨ CRT
__scrSnowNo     DB  FALSE   ;   ᭥
;---------------------------;

.Code
;ͻ
; ⠭ ०  ᭥                                    
;͹
; Call  Assembler                                                     
;͹
; In    AL    ᮤন FALSE, TRUE  NIL                            
;Ķ
; Out   AL    ᮤন ⥪騩 ०                                  
;ͼ
_scrSnow proc near Uses dx es ds

    push cs
    pop  ds
    @if al #= NIL then
        xchg    al,__scrSnowNo
        @if __scrSnowNo == TRUE then
            xor     dx,dx
            mov     es,dx
            mov     dx,es:_bios_CRT ;   CRT 
            add     dx,6            ;᫨  ॣ.
            mov     __scrCRT,dx     ;࠭  ॣ.
        @endif
    @else
        mov     al,__scrSnowNo
    @endif
    ret
endp

;ͻ
;  砫 ⭮ 室  ஢ ࠧ⪨               
;͹
; Call  Assembler                                                     
;ͼ
__scrVRetrace proc near Uses ax dx

        mov     dx,cs:__scrCRT
        @repeat                   ; 
           in al,dx               ;⭮ 室 
        @when al && 8             ;஢ ࠧ⪨ .
        @repeat                   ; 砫
           in al,dx               ;⭮ 室 
        @when al #& 8             ;஢ ࠧ⪨ .
        ret
endp

;ͻ
;  砫 ⭮ 室  筮 ࠧ⪨               
;͹
; Call  Assembler                                                     
;ͼ
__scrHRetrace proc near Uses ax dx

        mov     dx,cs:__scrCRT
        @repeat                   ; 
           in al,dx               ;⭮ 室 
        @when al && 1             ;筮 ࠧ⪨ .
        @repeat                   ; 砫
           in al,dx               ;⭮ 室 
        @when al #& 1             ;筮 ࠧ⪨ .
        ret
endp

;ͻ
;  ᥣ  ᬥ饭                              
;͹
; Call  Assembler                                                     
;͹
; In    DX    ᮤন ᪨ न                          
;Ķ
; Out   ES:DI ᮤন 㪠⥫  ᮮ⢥           
;                                                          
;       AX    ᮤন ਭ ࠭                           
;ͼ
_scrLocate proc near Uses bx dx ds

    xor     ax,ax
    mov     ds,ax               ;DS=> ࠬ஢ BIOS
    mov     bx,_bios_videoWidth ;BX=ਭ ࠭ (ᨬ)
    shl     bx,1                ;BL=ਭ ࠭ ()
    push    bx
    xchg    al,dh
    mul     bl                  ; ᬥ饭 ⥪饩 ப
    shl     dx,1                ; ᬥ饭 ⥪饣 ⮫
    add     ax,dx               ; ᬥ-  ⥪饩 ࠭
    add     ax,_bios_videoOffs  ;ᬥ饭 ⭮⥫쭮 砫
                                ;
    @if _bios_videoMode == 7
        mov     bx,0B000h       ;ᥣ  MDA
    @else
        mov     bx,0B800h       ;ᥣ  CGA
    @endif
    mov     es,bx               ;ES=ᥣ 
    mov     di,ax               ;DI=ᬥ饭 
    pop     ax
    ret
endp

;ͻ
; ࠭  ࠭                                             
;͹
; Call  Assembler                                                     
;͹
; In    CX,DX ᮤঠ ᪨ न                   
;       DS:SI ᮤঠ 㪠⥫                          
;ͼ
_scrSave proc near Uses ax bx cx dx ds si es di

    pushf
    cld

    sub     dx,cx
    add     dx,101h         ;᫨   ਭ .
    xchg    dx,cx
    call    _scrLocate      ;   孥 㣫.
    push    es di ds si     ;⠭ ES:DI  ,
    pop     di es si ds     ; DS:SI   .

    mov     dx,cx
    xor     cx,cx
    mov     cl,dh           ;  CX  .

    @if cs:__scrSnowNo == TRUE then     ;᫨ ⠭ ० 
        call    __scrVRetrace           ;᭥,   室
    @endif                              ; ஢ ࠧ⪨.

@@save:     push    cx si
            mov     cl,dl
            rep     movsw   ;஢ ᮤন ப.
            pop     si cx
            add     si,ax   ;३  ᫥饩 ப.
    loop    @@save
    popf
    ret
endp

;ͻ
; ⠭  ࠭                                          
;͹
; Call  Assembler                                                     
;͹
; In    CX,DX ᮤঠ ᪨ न                   
;       DS:SI ᮤঠ 㪠⥫                          
;ͼ
_scrRest proc near Uses ax bx cx dx ds si es di

    pushf
    cld

    sub     dx,cx
    add     dx,101h         ;᫨   ਭ .
    xchg    dx,cx
    call    _scrLocate      ;   孥 㣫.

    mov     dx,cx
    xor     cx,cx
    mov     cl,dh           ;  CX  .

    @if cs:__scrSnowNo == TRUE then     ;᫨ ⠭ ० 
        call    __scrVRetrace           ;᭥,   室
    @endif                              ; ஢ ࠧ⪨.

@@rest:     push    cx di
            mov     cl,dl
            rep     movsw   ;⠭ ᮤন ப.
            pop     di cx
            add     di,ax   ;३  ᫥饩 ப.
    loop    @@rest
    popf
    ret
endp

;ͻ
; ப⪠  ࠭                                 
;͹
; Call  Assembler                                                     
;͹
; In    CX,DX ᮤঠ ᪨ न                   
;       AL    ᮤন ᫮ ப ப⪨                          
;       BL    ᮤন ਡ 梥                                  
;ͼ
_scrScroll proc near Uses ax bx cx dx di si

    @if al && 80h then      ;᫨ ᫮ ப ப⪨
        neg     al          ;⥫쭮, ⨬ .
        mov     ah,7
    @else
        mov     ah,6        ; ⨬ .
    @endif
    mov bh,bl
    int 10h
    ret
endp

;ͻ
;  ࠧ ࠭                                    
;͹
; Call  Assembler                                                     
;͹
; In    CX,DX ᮤঠ ᪨ न                   
;Ķ
; Out   AX    ᮤন ࠧ 㪠                        
;ͼ
_scrSize proc near Uses dx

    sub     dx,cx
    add     dx,101h
    mov     al,dl
    mul     dh
    shl     ax,1
    ret
endp

;ͻ
;   ⨢ ࠭                                
;͹
; Call  Assembler                                                     
;͹
; Out   BH    ᮤন  ⨢ ࠭                   
;ͼ
_scrPage proc near Uses ax ds

    xor     ax,ax
    mov     ds,ax
    mov     bh,_bios_videoPage
    ret
endp

;ͻ
;                                                  
;͹
; Call  Assembler                                                     
;͹
; Out   AX    ᮤন ⥪                            
;ͼ
_scrGetCursor proc near Uses bx cx dx di si

    call    _scrPage        ;  ⨢ ࠭.
    @int    03h,10h         ; ⥪  .
    mov     ax,cx
    ret
endp

;ͻ
; ⠭                                               
;͹
; Call  Assembler                                                     
;͹
; In    AX    ᮤন                               
;ͼ
_scrSetCursor proc near Uses ax bx cx dx di si

    mov     dx,ax
    call    _scrEquip               ;। 䨣.
    @if ax == SE_MONO then          ;᫨ ⠭ ஬ ,
        mov cx,0C0Ch                ;  ⮨  12 ப.
    @elseif <ax == SE_VGA> or <ax == SE_VGA_MONO>
        mov cx,1010h                ;᫨ ⠭  VGA,  16.
    @elseif <ax == SE_EGA> or <ax == SE_EGA_MONO>
        mov cx,0E0Eh                ;᫨ ⠭  EGA,  14.
    @else                           ;  ⠫ ஢,
        mov cx,0808h                ; ⮨  8 ப.
    @endif

    @if dx == SC_NONE then          ;몫祭   
        mov cx,2000h                ;஢ .
    @elseif dx == SC_NORMAL then    ; ଠ쭮  
        dec ch                      ;࠭    .
    @elseif dx == SC_INSERT         ;  ⠢ 
        shr ch,1                    ;࠭   .
    @elseif dx == SC_BLOCK          ;   
        mov ch,0                    ;࠭ ࠢ .
    @else
        mov cx,dx
    @endif

    call    _scrPage                ;⠭   .
    @int    01h,10h
    ret
endp

;ͻ
;                                                
;͹
; Call  Assembler                                                     
;͹
; Out   DX    ᮤন ⥪                          
;ͼ
_scrGetPos proc near Uses ax bx cx di si

    call    _scrPage        ;  ⨢ ࠭.
    @int    03h,10h         ; ⥪  .
    ret
endp

;ͻ
; ⠭                                             
;͹
; Call  Assembler                                                     
;͹
; In    DX    ᮤন                             
;ͼ
_scrSetPos proc near Uses ax bx cx dx di si

    call    _scrPage        ;  ⨢ ࠭.
    @int    02h,10h         ;⠭   .
    ret
endp

;ͻ
; ⠭     뢮                             
;͹
; Call  Assembler                                                     
;ͼ
__scrPosEnd proc near Uses ax bx cx dx di si ds

    mov     ax,dx
    call    _scrPage
    call    _scrGetPos
    add     al,dl
    adc     ah,0
    xor     dx,dx
    mov     ds,dx
    div     byte ptr ds:[44Ah]
    mov     dl,ah
    add     dh,al
    call    _scrSetPos
    ret
endp

;ͻ
; 뢥 ਭ  ࠭                                              
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫  ਭ                            
;       BL    ᮤন ਡ 梥                                  
;ͼ
_scrWrite proc near Uses ax bx cx dx si di es

    call    _scrGetPos
    call    _scrLocate          ;  ES:DI  .
    mov     ah,bl               ;⮢ ਡ 梥.
    xor     dx,dx
    @dowhile @byte(si) #= 0
        lodsb                               ; ᨬ.
        @if cs:__scrSnowNo == TRUE then     ;᫨ ⠭ ० 
            call    __scrHRetrace           ;᭥,   室
        @endif                              ; 筮 ࠧ⪨.
        stosw                   ; ᨬ  梥⮢ ਡ.
        inc     dx              ;  .
    @enddo
    call    __scrPosEnd         ;⠭  砭 뢮.
    ret
endp

;ͻ
; 뢥 ਭ  ࠭  ᯮ짮 ⥫쭮 梥       
;͹
; Call  Assembler                                                     
;͹
; In    DS:SI ᮤন 㪠⥫  ਭ                            
;       BL    ᮤন ਡ 梥                                  
;       BH    ᮤন ਡ ⥫쭮 梥                  
;ͼ
_scrPut proc near Uses ax bx cx dx si di es

    call    _scrGetPos
    call    _scrLocate          ;  ES:DI  .
    mov     ah,bl               ;⮢ ਡ 梥.
    xor     dx,dx
    @dowhile @byte(si) #= 0
        lodsb                               ; ᨬ.
        @if al == '~' then
            xchg    bh,ah
            @loop
        @endif
        @if cs:__scrSnowNo == TRUE then     ;᫨ ⠭ ० 
            call    __scrHRetrace           ;᭥,   室
        @endif                              ; 筮 ࠧ⪨.
        stosw                   ; ᨬ  梥⮢ ਡ.
        inc     dx              ;  .
    @enddo
    call    __scrPosEnd         ;⠭  砭 뢮.
    ret
endp

;ͻ
; 뢥 ᨬ  ࠭                                              
;͹
; Call  Assembler                                                     
;͹
; In    AL    ᮤন  ᨬ                                    
;       BL    ᮤন ਡ 梥                                  
;       CX    ᮤন ᫮ ७ ᨬ                       
;ͼ
_scrChar proc near Uses ax bx cx dx si di es

    push    ax
    call    _scrGetPos
    call    _scrLocate          ;  ES:DI  .
    pop     ax
    mov     ah,bl               ;⮢ ਡ 梥.
    xor     dx,dx
    @for cx
        @if cs:__scrSnowNo == TRUE then     ;᫨ ⠭ ० 
            call    __scrHRetrace           ;᭥,   室
        @endif                              ; 筮 ࠧ⪨.
        stosw                   ; ᨬ  梥⮢ ਡ.
        inc     dx              ;  .
    @next
    call    __scrPosEnd         ;⠭  砭 뢮.
    ret
endp

;ͻ
; 뢥 ࠬ  ࠭                                               
;͹
; Call  Assembler                                                     
;͹
; In    CX,DX ᮤঠ न ࠬ                               
;       SI    ᮤন ᬥ饭  ᨬ  ஥ ࠬ  
;       BL    ᮤন ਡ 梥                                  
;ͼ
_scrBox proc near Uses ax bx cx dx di si ds es

    pushf
    cld
    push    cs
    pop     ds

    xchg    cx,dx
    sub     ch,dh       ;  ࠬ.
    jbe     @@Exit      ; न.
    sub     cl,dl       ; ਭ ࠬ.
    jbe     @@Exit      ; न.
    sub     cx,0101h    ;४  祭 ࠧ஢ . .

    call    _scrLocate  ; ᬥ饭  .
    add     dx,101h     ;⠭    孨
    call    _scrSetPos  ;㣮  ࠬ.
    xchg    ax,bx       ;  BX ਭ ࠭, 
    xchg    ah,al       ;AH - 梥⮢ ਡ.
    mov     dx,cx       ;DH - ᫮ ப, DL - ᫮ ⮫殢 ७
    xor     cx,cx       ; ࠬ.

    @if __scrSnowNo == TRUE then        ;᫨ ⠭ ० 
        call    __scrVRetrace           ;᭥,   室
    @endif                              ; ஢ ࠧ⪨.

    push    di
    mov     al,[si]     ;뢥 ᨬ  孥 㣫.
    stosw
    mov     al,[si+1]   ; ᨬ 孥 ப.
    mov     cl,dl
    rep     stosw
    mov     al,[si+2]   ;뢥 ᨬ ࠢ 孥 㣫.
    stosw
    pop     di

    mov     cl,dh
    @for    cx
        add     di,bx           ;३  ᫥饩 ப.
        push    di
        mov     al,[si][7]      ;뢥 ᨬ  ⮫.
        stosw
        mov     al,[si][8]      ;㧨 ᨬ .
        mov     cl,dl
        @if al #= 0 then        ;᫨   㫥,
            rep  stosw          ;뢥 .
        @else                   ;  
            shl  cx,1           ;ᬥ饭 뢮.
            add  di,cx
        @endif
        mov     al,[si][3]      ;뢥 ᨬ ࠢ ⮫.
        stosw
        pop     di
    @next

    add     di,bx           ;३  ᫥饩 (᫥) ப.
    mov     al,[si][6]      ;뢥 ᨬ   㣫.
    stosw
    mov     al,[si][5]      ;뢥 ᨬ  ப.
    mov     cl,dl
    rep     stosw
    mov     al,[si][4]      ;뢥 ᨬ ࠢ  㣫.
    stosw

@@Exit: popf
        ret
endp

;ͻ
; । ⨯ ⠭                         
;͹
; Call  Assembler                                                     
;Ķ
; Out   AX = ⠭                                
;ͼ
_scrEquip proc near Uses bx cx dx di si ds

; ।  CM 1910 --> FFFF:0008 = 0F0F 0333

        mov     ax,0FFFFh
        mov     ds,ax
        @if ds:[08] == 0F0Fh then
            @if ds:[10] == 0333h then
                 mov    ax,SE_CM1910
                 jmp    @@Exit
            @endif
        @endif

; ।  VGA -->  DCC ( F:1A INT:10 ) --> AL = 1A,
; ᫨  㭪 ন

        @int    1A00h,10h
        @if al == 1Ah then
            @if bl -= 1 then
                mov ax,SE_MONO
            @elseif bl == 2 then
                mov ax,SE_CGA
            @elseif bl == 4 then
                mov ax,SE_EGA
            @elseif bl == 5 then
                mov ax,SE_EGA_MONO
            @elseif bl == 6 then
                mov ax,SE_PGA
            @elseif bl == 7 then
                mov ax,SE_VGA_MONO
            @elseif bl == 8 then
                mov ax,SE_VGA
            @elseif bl == 10 then
                mov ax,SE_MCGA_DIGIT
            @elseif bl == 11 then
                mov ax,SE_MCGA_MONO
            @elseif bl == 12 then
                mov ax,SE_MCGA
            @else
                mov ax,SE_UNDEF
            @endif
        @else

; ।  EGA -->  F:12 INT:10 --> CX = ﭨ EGA

            mov     bl,10h
            xor     cx,cx
            @int    12h,10h
            @if cx #= 0 then
                @if bh == 0 then
                    mov ax,SE_EGA
                @else
                    mov ax,SE_EGA_MONO
                @endif
            @else

; ।  CGA -->  ᯨ᮪ 㤮 ( INT:11 ),
; ᫨  5  4 = 1,  MONO

                int     11h
                and     al,30h
                @if al == 30h then
                    mov ax,SE_MONO
                @else
                    mov ax,SE_CGA
                @endif
            @endif
        @endif
@@Exit: ret
endp

;ͻ
; । ࠭ 䨧᪮ ࠭                                
;͹
; Call  Assembler                                                     
;Ķ
; Out   CX     孨 㣮                                      
;       DX    ࠢ  㣮                                      
;ͼ
_scrFrame proc near Uses ax ds

    xor     ax,ax
    mov     ds,ax
    mov     dx,_bios_videoWidth         ; ਭ ࠭.
    dec     dx                          ; ࠢ ⮫.
    xor     cx,cx                       ; 孨 㣮.
    mov     dh,24                       ; ப  CGA  MDA.
    call    _scrEquip                   ; 䨣.
    @if ax += SE_EGA_MONO then
                                        ;  ᫥ ப
        mov     dh,_bios_videoBottom    ; EGA, VGA, PGA  MCGA.
    @endif
    ret
endp
end

