/*
 ******************************************************************************
 ******************************************************************************
 *
 *  Licensed Materials - Property of IBM
 *
 *  IBM TCP/IP for DOS.
 *  Copyright (c) IBM Corp. 1992.  All rights reserved.
 *  US Government Users Restricted Rights - Use, duplication or
 *  disclosure restricted by GSA ADP Schedule contract with IBM Corp.
 *
 ******************************************************************************
 ******************************************************************************
 *
 *  $Author:   Bob_Pombrio  $
 *  $Revision:   1.4  $
 *  $Modtime:   26 Mar 1993 11:41:06  $
 *
 *  $Header:   L:/INCLUDE/RSA/RPC/CLNT.H_V   1.4   26 Mar 1993 11:41:12   Bob_Pombrio  $
 *
 *  $Log:   L:/INCLUDE/RSA/RPC/CLNT.H_V  $
 * 
 *    Rev 1.4   26 Mar 1993 11:41:12   Bob_Pombrio
 * 
 *    Rev 1.1   13 Oct 1992 14:30:08   R_Kania
 * Microsoft C 7.00 changes
 *
 *    Rev 1.0   07 Oct 1992 12:09:54   RKania
 * Initial revision.
 *
 ******************************************************************************
 ******************************************************************************
 *
 * Copyright (c) 1990 by Sun Microsystems, Inc.
 *      @(#)clnt.h      1.31 88/02/08 SMI
 *      @(#)clnt.h      1.3  90/07/19 4.1NFSSRC SMI
 *
 ******************************************************************************
 ******************************************************************************
 */

/*
 ******************************************************************************
 * clnt.h
 * Client side remote procedure call interface.
 ******************************************************************************
 */
#ifndef _rpc_clnt_h
#define _rpc_clnt_h

/*
 ******************************************************************************
 * RPC calls return enum clnt_stat information to indicate the outcome of
 * the call.
 ******************************************************************************
 */
enum clnt_stat
  {
  /* No error */
  RPC_SUCCESS=0,                        /* Call succeeded                     */

  /* Local errors */
  RPC_CANTENCODEARGS=1,                 /* Can't encode arguments             */
  RPC_CANTDECODERES=2,                  /* Can't decode results               */
  RPC_CANTSEND=3,                       /* Failure in sending call            */
  RPC_CANTRECV=4,                       /* Failure in receiving result        */
  RPC_TIMEDOUT=5,                       /* Call timed out                     */
  RPC_INTR=18,                          /* Call interrupted                   */

  /* Remote errors */
  RPC_VERSMISMATCH=6,                   /* RPC versions not compatible        */
  RPC_AUTHERROR=7,                      /* Authentication error               */
  RPC_PROGUNAVAIL=8,                    /* Program not available              */
  RPC_PROGVERSMISMATCH=9,               /* Program version mismatched         */
  RPC_PROCUNAVAIL=10,                   /* Procedure unavailable              */
  RPC_CANTDECODEARGS=11,                /* Decode arguments error             */
  RPC_SYSTEMERROR=12,                   /* Generic "other problem"            */

  /* Callrpc and clnt_create errors */
  RPC_UNKNOWNHOST=13,                   /* Unknown host name                  */
  RPC_UNKNOWNPROTO=17,                  /* Unkown protocol                    */

  /* Create errors */
  RPC_PMAPFAILURE=14,                   /* The pmapper failed in its call     */
  RPC_PROGNOTREGISTERED=15,             /* Remote program is not registered   */

  /* Unknown error */
  RPC_FAILED=16                         /* Unspecified error                  */
  };

/*
 ******************************************************************************
 * Error information structure
 ******************************************************************************
 */
struct rpc_err
  {
  enum clnt_stat re_status;
  union
    {
    int RE_errno;                       /* Related system error               */
    enum auth_stat RE_why;              /* Why the auth error occurred        */
    struct
      {
      u_long low;                       /* Lowest version supported           */
      u_long high;                      /* Highest version supported          */
      } RE_vers;
    struct                              /* May be meaningful if RPC_FAILED    */
      {
      long s1;
      long s2;
      } RE_lb;                          /* Live boot & debugging only         */
    } ru;
  #define re_errno ru.RE_errno
  #define re_why ru.RE_why
  #define re_vers ru.RE_vers
  #define re_lb ru.RE_lb
  };

/*
 ******************************************************************************
 * Client RPC handle.
 * Created by individual implementations, see e.g. rpc_udp.c.
 * Client is responsible for initializing auth, see e.g. auth_none.c.
 ******************************************************************************
 */
typedef struct CLIENT CLIENT;
struct CLIENT
  {
  AUTH    *cl_auth;                     /* Authenticator                      */
  struct clnt_ops
    {
    enum clnt_stat (*cl_call)(CLIENT *,
                              u_long,
                              xdrproc_t,
                              char *,
                              xdrproc_t,
                              char *,
                              struct timeval);
    void (*cl_abort)(CLIENT *);
    void (*cl_geterr)(CLIENT *,
                      struct rpc_err*);
    bool_t (*cl_freeres)(CLIENT *,
                         xdrproc_t,
                         char *);
    void (*cl_destroy)(CLIENT *);
    bool_t (*cl_control)(CLIENT *,
                         u_int,
                         char *);
    } *cl_ops;
  char *cl_private;                     /* Private stuff                      */
  };

/*
 ******************************************************************************
 * Client side RPC interface ops
 *
 * Parameter types are:
 *
 * enum clnt_stat
 *
 * CLNT_CALL(rh,
 *           proc,
 *           xargs,
 *           argsp,
 *           xres,
 *           resp,
 *           timeout);
 *
 * CLIENT *rh;
 * u_long proc;
 * xdrproc_t xargs;
 * caddr_t argsp;
 * xdrproc_t xres;
 * caddr_t resp;
 * struct timeval timeout;
 *
 * Calls the remote procedure associated with the client handle
 ******************************************************************************
 */
#define CLNT_CALL(rh, proc, xargs, argsp, xres, resp, secs) \
        ((*(rh)->cl_ops->cl_call)(rh, proc, xargs, (char *) argsp, xres, (char *) resp, secs))
#define clnt_call(rh, proc, xargs, argsp, xres, resp, secs) \
        ((*(rh)->cl_ops->cl_call)(rh, proc, xargs, (char *) argsp, xres, (char *) resp, secs))

/*
 ******************************************************************************
 * void
 *
 * CLNT_ABORT(rh);
 *
 * CLIENT *rh;
 ******************************************************************************
 */
#define CLNT_ABORT(rh) \
        ((*(rh)->cl_ops->cl_abort)(rh))
#define clnt_abort(rh) \
        ((*(rh)->cl_ops->cl_abort)(rh))

/*
 ******************************************************************************
 * struct rpc_err
 *
 * CLNT_GETERR(rh);
 *
 * CLIENT *rh;
 *
 * Copies the error structure from a client's handle to the local address.
 ******************************************************************************
 */
#define CLNT_GETERR(rh, errp) \
        ((*(rh)->cl_ops->cl_geterr)(rh, errp))
#define clnt_geterr(rh,errp) \
        ((*(rh)->cl_ops->cl_geterr)(rh, errp))

/*
 ******************************************************************************
 * bool_t
 *
 * CLNT_FREERES(rh,
 *              xres,
 *              resp);
 *
 * CLIENT *rh;
 * xdrproc_t xres;
 * caddr_t resp;
 *
 * De-allocates resources assigned for decoding RPC.
 ******************************************************************************
 */
#define CLNT_FREERES(rh,xres,resp) \
        ((*(rh)->cl_ops->cl_freeres)(rh,xres,resp))
#define clnt_freeres(rh,xres,resp) \
        ((*(rh)->cl_ops->cl_freeres)(rh,xres,resp))

/*
 ******************************************************************************
 * bool_t
 *
 * CLNT_CONTROL(cl,
 *              request,
 *              info);
 *
 * CLIENT *cl;
 * u_int request;
 * char *info;
 ******************************************************************************
 */
#define CLNT_CONTROL(cl,rq,in) \
        ((*(cl)->cl_ops->cl_control)(cl,rq,(char *)in))
#define clnt_control(cl,rq,in) \
        ((*(cl)->cl_ops->cl_control)(cl,rq,(char *)in))

/*
 ******************************************************************************
 * Control operations that apply to both UDP and TCP transports
 ******************************************************************************
 */
#define CLSET_TIMEOUT           1       /* Set timeout (timeval)              */
#define CLGET_TIMEOUT           2        /* Get timeout (timeval)             */
#define CLGET_SERVER_ADDR       3       /* Get server's address (sockaddr)    */
#define CLGET_FD                6       /* Get connections file descriptor    */
#define CLSET_FD_CLOSE          8       /* Close fd while clnt_destroy        */
#define CLSET_FD_NCLOSE         9       /* Do not close fd while clnt_destroy */

/*
 ******************************************************************************
 * UDP only control operations
 ******************************************************************************
 */
#define CLSET_RETRY_TIMEOUT     4       /* Set retry timeout (timeval)        */
#define CLGET_RETRY_TIMEOUT     5       /* Get retry timeout (timeval)        */

/*
 ******************************************************************************
 * void
 *
 * CLNT_DESTROY(rh);
 *
 * CLIENT *rh;
 *
 * Destroys client's RPC handle
 ******************************************************************************
 */
#define CLNT_DESTROY(rh) \
        ((*(rh)->cl_ops->cl_destroy)(rh))
#define clnt_destroy(rh) \
        ((*(rh)->cl_ops->cl_destroy)(rh))

/*
 ******************************************************************************
 * RPCTEST is a test program which is accessable on every RPC
 * transport/port.  It is used for testing, performance evaluation,
 * and network administration.
 ******************************************************************************
 */
#define RPCTEST_PROGRAM         ((u_long)1)
#define RPCTEST_VERSION         ((u_long)1)
#define RPCTEST_NULL_PROC       ((u_long)2)
#define RPCTEST_NULL_BATCH_PROC ((u_long)3)

/*
 ******************************************************************************
 * By convention, procedure 0 takes null arguments and returns them
 ******************************************************************************
 */
#define NULLPROC                ((u_long)0)

/*
 ******************************************************************************
 * Below are the client handle creation routines for the various
 * implementations of client side RPC.  They can return NULL if a
 * creation failure occurs.
 ******************************************************************************
 */

/*
 ******************************************************************************
 * Memory based RPC (for speed check and testing)
 *
 * CLIENT *
 *
 * clntraw_create(prog,
 *                vers);
 *
 * u_long prog;
 * u_long vers;
 ******************************************************************************
 */
extern CLIENT *clntraw_create(u_long,
                              u_long);

/*
 ******************************************************************************
 * Generic client creation routine. Supported protocols are "UDP" and "TCP"
 ******************************************************************************
 */
extern CLIENT *
clnt_create(char *,
            u_long,
            u_long,
            char *);

/*
 ******************************************************************************
 * Generic client creation routine. Supported protocols are "UDP" and "TCP"
 ******************************************************************************
 */
extern CLIENT *
clnt_create_vers(char *,
                 u_long,
                 u_long *,
                 u_long,
                 u_long,
                 char *);

/*
 ******************************************************************************
 * TCP based RPC
 *
 * CLIENT *
 *
 * clnttcp_create(raddr,
 *                prog,
 *                vers,
 *                sockp,
 *                sendsz,
 *                recvsz);
 *
 *      struct sockaddr_in *raddr;
 *      u_long prog;
 *      u_long version;
 *      register int *sockp;
 *      u_int sendsz;
 *      u_int recvsz;
 *
 * Creates an RPC client for the remote program using TCP transport.
 ******************************************************************************
 */
extern CLIENT *clnttcp_create();

/*
 ******************************************************************************
 * UDP based RPC
 *
 * CLIENT *
 *
 * clntudp_create(raddr,
 *                program,
 *                version,
 *                wait,
 *                sockp);
 *
 * struct sockaddr_in *raddr;
 * u_long program;
 * u_long version;
 * struct timeval wait;
 * int *sockp;
 *
 * Creates an RPC client for the remote program using UDP transport.
 ******************************************************************************
 */
extern CLIENT *clntudp_create(struct sockaddr_in *,
                              u_long,
                              u_long,
                              struct timeval,
                              int *);

/*
 ******************************************************************************
 * Same as above, but you specify max packet sizes.
 *
 * CLIENT *
 *
 * clntudp_bufcreate(raddr,
 *                   program,
 *                   version,
 *                   wait,
 *                   sockp,
 *                   sendsz,
 *                   recvsz);
 *
 * struct sockaddr_in *raddr;
 * u_long program;
 * u_long version;
 * struct timeval wait;
 * int *sockp;
 * u_int sendsz;
 * u_int recvsz;
 ******************************************************************************
 */
extern CLIENT *clntudp_bufcreate(struct sockaddr_in*,
                                 u_long,
                                 u_long,
                                 struct timeval,
                                 int*,
                                 u_int,
                                 u_int);

/*
 ******************************************************************************
 * Indicates why a client handle cannot be created.
 ******************************************************************************
 */
void clnt_pcreateerror(char *);         /* Stderr                             */
char *clnt_spcreateerror(char *);       /* String                             */

/*
 ******************************************************************************
 * Writes error message indicating why RPC failed.
 ******************************************************************************
 */
void clnt_perrno(enum clnt_stat);       /* Stderr                             */

/*
 ******************************************************************************
 * Writes error message indicating why RPC failed.
 ******************************************************************************
 */
void clnt_perror(CLIENT *,
                 char *);               /* Stderr                             */

char *clnt_sperror(CLIENT *,
                   char *);             /* String                             */

/*
 ******************************************************************************
 * If a creation fails, the following allows the user to determine why.
 *
 * Global variable set when any RPC client creation routine fails.
 ******************************************************************************
 */
struct rpc_createerr
  {
  enum clnt_stat cf_stat;
  struct rpc_err cf_error;              /* Valid if cf_stat = RPC_PMAPFAILURE */
  };

extern struct rpc_createerr rpc_createerr;

/*
 ******************************************************************************
 * Copy error message to buffer.
 ******************************************************************************
 */
char *clnt_sperrno(enum clnt_stat);     /* String                             */

/*
 ******************************************************************************
 * Timers used for the pseudo-transport protocol when using datagrams.
 ******************************************************************************
 */
struct rpc_timers
  {
  u_short rt_srtt;                      /* Smoothed round-trip time           */
  u_short rt_deviate;                   /* Estimated deviation                */
  u_long rt_rtxcur;                     /* Current (backed-off) rto           */
  };

/*
 ******************************************************************************
 * Feedback values used for possible congestion and rate control.
 ******************************************************************************
 */
#define FEEDBACK_REXMIT1        1       /* First retransmit                   */
#define FEEDBACK_OK             2       /* No retransmits                     */
#define UDPMSGSIZE              8800    /* RPC imposed limit on UDP msg size  */
#define RPCSMALLMSGSIZE         400     /* A more reasonable packet size      */

#endif
