/*
 ******************************************************************************
 ******************************************************************************
 *
 *  Licensed Materials - Property of IBM
 *
 *  IBM TCP/IP for DOS.
 *  Copyright (c) IBM Corp. 1992.  All rights reserved.
 *  US Government Users Restricted Rights - Use, duplication or
 *  disclosure restricted by GSA ADP Schedule contract with IBM Corp.
 *
 ******************************************************************************
 ******************************************************************************
 *
 *  $Author:   Build_Coordinator  $
 *  $Revision:   1.5  $
 *  $Modtime:   11 Feb 1993 14:56:10  $
 *
 *  $Header:   L:/INCLUDE/RSA/SYS/TCPTYPES.H_V   1.5   11 Feb 1993 14:56:18   Build_Coordinator  $
 *
 *  $Log:   L:/INCLUDE/RSA/SYS/TCPTYPES.H_V  $
 * 
 *    Rev 1.5   11 Feb 1993 14:56:18   Build_Coordinator
 * Fixed shift left to shift 32 bits instead of 16 bits.
 *
 *    Rev 1.4   11 Feb 1993 14:17:40   Build_Coordinator
 * Fixed FD_* macros so that sockets greater than 16 can be used.  This was
 * a integer 16 bit vs 32 bit port issue that was missed.
 *
 *    Rev 1.3   06 Oct 1992 13:02:50   Build_Coordinator
 * Standardized the file headers.
 *
 *    Rev 1.2   09 Sep 1992 14:02:34   Jonathan_Rosen
 * Whoops meant #ifndef __STDC__ to fix __far problem
 *
 *    Rev 1.1   09 Sep 1992 13:48:02   Jonathan_Rosen
 * Fix __far to support both MSC6.0 & 7.0
 * Fix prototypes for bswap & lswap
 *
 *    Rev 1.0   01 Sep 1992 16:11:48   Jonathan_Rosen
 * Initial revision.
 *
 ******************************************************************************
 ******************************************************************************
 */

/*-
 * Copyright (c) 1982, 1986, 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)types.h     7.17 (Berkeley) 5/6/91
 */

#ifndef _TCPTYPES_H_
#define _TCPTYPES_H_

#ifndef __STDC__
#define __far   _far
#endif

/* Some standard Unix utility routes for ease of porting */
#define index(string,c)    _fstrchr((char __far *)(string),(int)(c))
#define rindex(string,c)   _fstrrchr((char __far *)(string),(int)(c))
#define bzero(x,y)         _fmemset((void __far *)(x),(int)0,(int)(y))
#define bcopy(x,y,z)       _fmemcpy((void __far *)(y),(void __far *)(x),(int)(z))
#define bcmp(x,y,z)        _fmemcmp((void __far *)(y),(void __far *)(x),(int)(z))

#define TRUE 1
#define FALSE 0


#include <machine\endian.h>

typedef unsigned char   u_char;
typedef unsigned short  u_short;
typedef unsigned int    u_int;
typedef unsigned long   u_long;
typedef unsigned short  ushort;         /* Sys V compatibility */

typedef char __far *  caddr_t;          /* core address */
typedef short   pid_t;                  /* process id */

#define FD_READ         0x0001
#define FD_WRITE        0x0002
#define FD_OOB          0x0004
#define FD_ACCEPT       0x0008
#define FD_CONNECT      0x0010
#define FD_CLOSE        0x0020


#define NBBY    8               /* number of bits in a byte */

/*
 * Select uses bit masks of file descriptors in longs.  These macros
 * manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here should
 * be enough for most uses.
 */
#ifndef FD_SETSIZE
#define FD_SETSIZE      256
#endif

typedef long    fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask */

#ifndef howmany
#define howmany(x, y)   (((x)+((y)-1))/(y))
#endif

struct timeval {
   unsigned long tv_sec;
   unsigned long tv_usec;
};

typedef struct fd_set {
        fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1L << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1L << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1L << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#else /* _WINSOCK_API_ */
#define BSD_NBBY    8               /* number of bits in a byte */
#define BSD_FD_SETSIZE      256
typedef long    bsd_fd_mask;
#define BSD_NFDBITS (sizeof(bsd_fd_mask) * BSD_NBBY)        /* bits per mask */
#define bsd_howmany(x, y)   (((x)+((y)-1))/(y))

 typedef struct bsd_fd_set {
         bsd_fd_mask bsd_fds_bits[bsd_howmany(BSD_FD_SETSIZE, BSD_NFDBITS)];
 } bsd_fd_set;

#define BSD_FD_SET(n, p)    (((bsd_fd_set *)(p))->bsd_fds_bits[(n)/BSD_NFDBITS] |= (1L << ((n) % BSD_NFDBITS)))
#define BSD_FD_CLR(n, p)    (((bsd_fd_set *)(p))->bsd_fds_bits[(n)/BSD_NFDBITS] &= ~(1L << ((n) % BSD_NFDBITS)))
#define BSD_FD_ISSET(n, p)  (((bsd_fd_set *)(p))->bsd_fds_bits[(n)/BSD_NFDBITS] & (1L << ((n) % BSD_NFDBITS)))
#define BSD_FD_ZERO(p)      memset((char *)(p), 0, sizeof(bsd_fd_set))

#endif /* !_TCPTYPES_H_ */
