/************************************************************************
 *
 *
 *   Licensed Materials - Property of IBM
 *
 *   IBM DOS TCP/IP (C) Copyright IBM Corp. 1991. All rights reserved.
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *
 ************************************************************************/


/* GENERIC SERVER      */
/* RECEIVE AN INTEGER OR FLOAT AND RETURN THEM RESPECTIVELY */
/* PORTMAPPER MUST BE RUNNING */

#include <stdio.h>
#include <rpc/rpc.h>

#define intrcvprog ((u_long)150000)
#define fltrcvprog ((u_long)150102)
#define intvers    ((u_long)1)
#define intrcvproc ((u_long)1)
#define fltrcvproc ((u_long)1)
#define fltvers    ((u_long)1)

main()
{
   int *intrcv();
   float *floatrcv();

  /*REGISTER PROG, VERS AND PROC WITH THE PORTMAPPER*/
      /*FIRST PROGRAM*/
   registerrpc(intrcvprog,intvers,intrcvproc,intrcv,xdr_int,xdr_int);
   printf("Intrcv Registration with Port Mapper completed\n");
      /*OR MULTIPLE PROGRAMS*/
   registerrpc(fltrcvprog,fltvers,fltrcvproc,floatrcv,xdr_float,xdr_float);
   printf("Floatrcv Registration with Port Mapper completed\n");

   svc_run();
   printf("Error:svc_run returned!\n");
   exit(1);
}

int *
intrcv(in)
   int *in;
{
   int *out;

   printf("integer received: %d\n",*in);
   out = in;
   printf("integer being returned: %d\n",*out);
   return (out);
}


float *
floatrcv(in)
   float *in;
{
   float *out;

   printf("float received: %e\n",*in);
   out=in;
   printf("float being returned: %e\n",*out);
   return(out);
}

