/********************************************************copyrite.xic***/
/*                                                                     */
/*   Licensed Materials - Property of IBM                              */
/*                                                                     */
/*   This product contains "Restricted Materials of IBM":              */
/*      Program Number:   5798RXW                                      */
/*      Program Name:     IBM TCP/IP Version 1.2 for OS/2              */
/*   (C) Copyright IBM Corporation. 1990, 1993.                        */
/*                                                                     */
/*   All rights reserved.                                              */
/*                                                                     */
/*   US Government Users Restricted Rights -                           */
/*   Use, duplication or disclosure restricted by GSA ADP Schedule     */
/*   Contract with IBM Corp.                                           */
/*                                                                     */
/*   See IBM Copyright Instructions.                                   */
/*                                                                     */
/*   SENDMSG is a UDP client that sends a message to SELECTS, the      */
/*   UDP server.  SENDMSG repeats this process 30 times.               */
/*                                                                     */
/********************************************************copyrite.xic***/
/*  $Author:   Build_Coordinator  $                                                     */
/*  $Revision:   1.0  $                                                     */
/*  $Modtime:   30 Jan 1993 14:24:26  $                                                     */
/*                                                                     */
/*  $Header:   L:/samples/sockets/sendmsg.c_v   1.0   30 Jan 1993 14:28:50   Build_Coordinator  $                                                     */
/*                                                                     */
/*  $Log:   L:/samples/sockets/sendmsg.c_v  $                                                     */
 * 
 *    Rev 1.0   30 Jan 1993 14:28:50   Build_Coordinator
 * Initial revision.
/*                                                                     */
/*                                                                     */
/***********************************************************************/
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>

#include <sys\tcptypes.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa\inet.h>
#include <sys\errno.h>

char *spin[] = {"<-        |\r",
                "| \\       |\r",
                "|  |      |\r",
                "|   /     |\r",
                "|    -    |\r",
                "|     \\   |\r",
                "|      |  |\r",
                "|       / |\r",
                "|        ->\r",
                "|       \\ |\r",
                "|      |  |\r",
                "|     /   |\r",
                "|    -    |\r",
                "|   \\     |\r",
                "|  |      |\r",
                "| /       |\r",
                0};


main(argc, argv)
int argc;
char **argv;
{


   int s;
   int z = 10;
   unsigned short port;
   struct sockaddr_in server;
   int server_address_size;
   char buf[82];
   char **ch = spin;

   /* argv[1] is internet address of server argv[2] is port of server.
    * Convert the port from ascii to integer and then from host byte
    * order to network byte order.
    */
   if(argc < 3)
   {
      printf("Usage: %s host address port <\"message\"> \n",argv[0]);
      exit(1);
   }
   if (argc==4) {
      strcpy(buf,argv[3]);
      strcat(buf,"\n");
   } else {
      strcpy(buf,"Hello!\n");
   } /* endif */
   port = htons(atoi(argv[2]));

    /*
     * Check if INET running.
     */
    if (sock_init())
    {
       printf("TCPIP is not running!\n");
       exit(1);
    }

   /* Create a datagram socket in the internet domain and use the
    * default protocol (UDP).
    */
   if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
       perror("socket()");
       exit(1);
   }

   /* Set up the server name */
   server.sin_family      = AF_INET;            /* Internet Domain    */
   server.sin_port        = port;               /* Server Port        */
   server.sin_addr.s_addr = inet_addr(argv[1]); /* Server's Address   */

   for (z=30; z; z--) {
      if(!*(++ch)) ch = spin;
      printf("%s", *ch );

      /* Send the message in buf to the server */
      if (sendto(s, &buf, (strlen(buf)+1), 0, (struct sockaddr far *)&server, sizeof(server)) < 0)
      {
          perror("sendto()");
          exit(2);
      }

      /*
       * Receive a message on socket s in buf  of maximum size 32
       * from a server. Because the last two paramters
       * are not null, the name of the server will be placed into the
       * server data structure and the size of the server address will
       * be placed into server_address_size.
       */
      server_address_size = sizeof(server);

      if(recvfrom(s, buf, sizeof(buf), 0, (struct sockaddr *) &server,
               &server_address_size) <0)
      {
          perror("recvfrom()");
          exit(3);
      }

   } /* endfor */

   /* Deallocate the socket */
   soclose(s);
   return(0);
}
