/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator;

import com.fx702p.Fx702pFullParser;
import com.fx702p.debug.WatchedVariableHelper;
import com.fx702p.emulator.Fx702pBasicSourceCode;
import com.fx702p.emulator.Fx702pDisplay;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Fx702pMemory;
import com.fx702p.emulator.Variable;
import com.fx702p.emulator.exceptions.Fx702pLoadingException;
import com.fx702p.interpreters.BasicInstructionIndex;
import com.fx702p.interpreters.Fx702pAbstractParserVisitor;
import com.fx702p.interpreters.Fx702pCalculator;
import com.fx702p.interpreters.Fx702pException;
import com.fx702p.interpreters.Fx702pInternalError;
import com.fx702p.interpreters.Fx702pListVisitor;
import com.fx702p.parser.ASTAssignment;
import com.fx702p.parser.ASTBreakpoint;
import com.fx702p.parser.ASTClear;
import com.fx702p.parser.ASTComment;
import com.fx702p.parser.ASTDMS;
import com.fx702p.parser.ASTDeg;
import com.fx702p.parser.ASTEnd;
import com.fx702p.parser.ASTFloat;
import com.fx702p.parser.ASTFor;
import com.fx702p.parser.ASTGet;
import com.fx702p.parser.ASTGoto;
import com.fx702p.parser.ASTGotoProgram;
import com.fx702p.parser.ASTGreaterOrEqual;
import com.fx702p.parser.ASTGsb;
import com.fx702p.parser.ASTGsbProgram;
import com.fx702p.parser.ASTIf;
import com.fx702p.parser.ASTInput;
import com.fx702p.parser.ASTKey;
import com.fx702p.parser.ASTLesserOrEqual;
import com.fx702p.parser.ASTLine;
import com.fx702p.parser.ASTLoad;
import com.fx702p.parser.ASTMode;
import com.fx702p.parser.ASTNext;
import com.fx702p.parser.ASTNotEqual;
import com.fx702p.parser.ASTPRC;
import com.fx702p.parser.ASTPi;
import com.fx702p.parser.ASTPrint;
import com.fx702p.parser.ASTProgram;
import com.fx702p.parser.ASTProgramSignature;
import com.fx702p.parser.ASTPut;
import com.fx702p.parser.ASTRPC;
import com.fx702p.parser.ASTReturn;
import com.fx702p.parser.ASTRom;
import com.fx702p.parser.ASTSac;
import com.fx702p.parser.ASTSet;
import com.fx702p.parser.ASTSingleProgram;
import com.fx702p.parser.ASTStat;
import com.fx702p.parser.ASTStatWatchpoint;
import com.fx702p.parser.ASTStop;
import com.fx702p.parser.ASTString;
import com.fx702p.parser.ASTVac;
import com.fx702p.parser.ASTVariablesAndProgram;
import com.fx702p.parser.ASTWait;
import com.fx702p.parser.ASTWatch;
import com.fx702p.parser.ASTWatchpoint;
import com.fx702p.parser.Fx702pParserVisitor;
import com.fx702p.parser.Node;
import com.fx702p.parser.ParseException;
import com.fx702p.parser.SimpleNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fx702pBasicProgram {
    protected ASTProgram parsedProgram = null;
    protected Fx702pBasicSourceCode basicSourceCode = null;
    protected String name;
    protected String password;
    protected boolean empty = true;
    protected HashSet<BasicInstructionIndex> breakpoints = new HashSet();
    protected boolean modified = false;
    protected File programFile;
    protected Vector<Fx702pMemory.WatchedVariable> watchedVariables = new Vector();
    protected boolean suspendOnStatVariables = false;
    protected boolean hasComments = false;
    protected boolean saveVariables = false;
    protected boolean saveBreakpoints = false;
    public static final String SIGNATURE_TEXT = "SIGNATURE";
    public static final String BREAKPOINT_TEXT = "BREAKPOINT";
    public static final String WATCH_TEXT = "WATCH";
    public static final String WATCHPOINT_TEXT = "WATCHPOINT";
    public static final String STATWATCHPOINT_TEXT = "STATWATCHPOINT";

    public Fx702pBasicProgram(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    public boolean isEmpty() {
        return this.parsedProgram == null || this.empty;
    }

    public String getProgramFileName() {
        return this.programFile == null ? "" : this.programFile.getName();
    }

    public boolean canBeLoaded() {
        return this.programFile != null;
    }

    public boolean canBeSaved(Fx702pMemory aMemory) {
        return this.programFile != null && this.isModified();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isSavingVariables() {
        return this.saveVariables;
    }

    public boolean isSavingBreakpoints() {
        return this.saveBreakpoints;
    }

    public void load(File aProgramFile, Fx702pCalculator aCalculator, Fx702pDisplay aDisplay) throws FileNotFoundException, UnsupportedEncodingException, ParseException {
        Fx702pFullParser parser = new Fx702pFullParser(new FileInputStream(aProgramFile));
        ASTVariablesAndProgram variablesAndProgram = parser.VariablesAndProgram();
        this.load(aProgramFile, variablesAndProgram, parser.getBasicSourceCode(), aCalculator, aDisplay);
    }

    public void load(File aProgramFile, ASTVariablesAndProgram theVariablesAndProgram, Fx702pBasicSourceCode aBasicSourceCode, Fx702pCalculator aCalculator, Fx702pDisplay aDisplay) throws UnsupportedEncodingException, ParseException {
        this.programFile = aProgramFile;
        this.modified = false;
        this.saveVariables = false;
        this.saveBreakpoints = false;
        this.empty = true;
        this.breakpoints.clear();
        this.setName(aProgramFile.getName());
        this.basicSourceCode = aBasicSourceCode;
        BasicProgramVisitor basicProgramVisitor = new BasicProgramVisitor(aCalculator);
        theVariablesAndProgram.jjtAccept(basicProgramVisitor, null);
        this.loadBreakpoints(basicProgramVisitor.getProgramSignature(), basicProgramVisitor.getLoadedBreakpoints(), aDisplay);
        this.buildWatchedVariablesIndex();
        aCalculator.getMemory().markAsModified();
    }

    public void load(String aName, ASTSingleProgram aSingleProgram, Fx702pBasicSourceCode aBasicSourceCode, String aPassword, Fx702pCalculator aCalculator, Fx702pDisplay aDisplay) throws UnsupportedEncodingException, ParseException {
        this.empty = true;
        this.saveVariables = false;
        this.saveBreakpoints = false;
        this.breakpoints.clear();
        this.setName(aName);
        this.setPassword(aPassword);
        this.basicSourceCode = aBasicSourceCode;
        BasicProgramVisitor basicProgramVisitor = new BasicProgramVisitor(aCalculator);
        aSingleProgram.jjtAccept(basicProgramVisitor, null);
        this.loadBreakpoints(basicProgramVisitor.getProgramSignature(), basicProgramVisitor.getLoadedBreakpoints(), aDisplay);
        this.buildWatchedVariablesIndex();
    }

    protected void loadBreakpoints(String aProgramSignature, Collection<BasicInstructionIndex> theBreakpoints, Fx702pDisplay aDisplay) {
        boolean signatureMatch = aProgramSignature == null || aProgramSignature.equalsIgnoreCase(this.getStringSignature());
        boolean breakpointsValid = true;
        for (BasicInstructionIndex breakpoint : theBreakpoints) {
            if (breakpoint.isValid()) continue;
            breakpointsValid = false;
            break;
        }
        String detailedMessage = null;
        if (!signatureMatch) {
            detailedMessage = breakpointsValid ? "Program signature does not match. Try to load breakpoints anyway?" : "Program signature does not match and some breakpoints are not valid. Try to load them anyway?";
        } else if (!breakpointsValid) {
            detailedMessage = "Some breakpoints are not valid. Try to load them anyway?";
        }
        if (detailedMessage != null && !aDisplay.askConfirmation("Confirm breakpoints loading", detailedMessage)) {
            return;
        }
        this.reallyloadBreakpoints(theBreakpoints);
    }

    protected void reallyloadBreakpoints(Collection<BasicInstructionIndex> theBreakpoints) {
        for (BasicInstructionIndex breakpoint : theBreakpoints) {
            this.toggleBreakpoint(breakpoint);
        }
    }

    public void reload(Fx702pCalculator aCalculator, Fx702pDisplay aDisplay) throws FileNotFoundException, UnsupportedEncodingException, ParseException {
        if (this.programFile != null) {
            this.load(this.programFile, aCalculator, aDisplay);
        }
    }

    public void save(Fx702pEmulator anEmulator) throws IOException {
        boolean confirmed = true;
        if (this.hasComments) {
            confirmed = anEmulator.getDisplay().askConfirmation("Confirm Save", "Comments will be lost. Save anyway?");
        }
        if (confirmed) {
            this.saveAs(anEmulator, null, this.saveVariables, this.saveBreakpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(Fx702pEmulator anEmulator, File aProgramFile, boolean aSaveVariablesFlag, boolean aSaveBreakpointsFlag) throws IOException {
        block5: {
            if (aProgramFile == null) {
                aProgramFile = this.programFile;
            }
            File tempFile = File.createTempFile('_' + aProgramFile.getName(), null, aProgramFile.getAbsoluteFile().getParentFile());
            try {
                FileOutputStream outputStream = new FileOutputStream(tempFile);
                this.save(anEmulator.getMemory(), outputStream, aSaveVariablesFlag, aSaveBreakpointsFlag);
                if (tempFile.renameTo(aProgramFile)) {
                    this.programFile = aProgramFile;
                    this.saveVariables = aSaveVariablesFlag;
                    this.saveBreakpoints = aSaveBreakpointsFlag;
                    this.modified = false;
                    break block5;
                }
                throw new IOException("Cannot rename temporary file " + tempFile.getPath() + " to " + this.programFile.getPath());
            }
            finally {
                tempFile.delete();
            }
        }
    }

    public void write(Fx702pMemory aMemory, PrintWriter aWriter, boolean aSaveVariablesFlag, boolean aSaveBreakpointsFlag) {
        if (aSaveVariablesFlag) {
            this.saveVariables(aMemory, aWriter);
        }
        this.saveProgram(aWriter);
        if (aSaveBreakpointsFlag) {
            this.saveBreakpoints(aWriter);
            this.saveWatchpoints(aWriter);
        }
    }

    protected void save(Fx702pMemory aMemory, OutputStream anOutputStream, boolean aSaveVariablesFlag, boolean aSaveBreakpointsFlag) {
        PrintWriter writer = new PrintWriter(anOutputStream);
        this.write(aMemory, writer, aSaveVariablesFlag, aSaveBreakpointsFlag);
        writer.flush();
        writer.close();
    }

    protected void saveVariables(Fx702pMemory aMemory, PrintWriter aPrintWriter) {
        aMemory.saveVariables(aPrintWriter);
    }

    protected void saveProgram(PrintWriter aPrintWriter) {
        this.parsedProgram.jjtAccept(new Fx702pListVisitor(aPrintWriter), null);
        aPrintWriter.println();
    }

    protected void saveBreakpoints(PrintWriter aPrintWriter) {
        if (!this.breakpoints.isEmpty()) {
            aPrintWriter.println("SIGNATURE \"" + this.getStringSignature() + '\"');
            aPrintWriter.println();
            Vector<BasicInstructionIndex> sortedBreakpoints = new Vector<BasicInstructionIndex>();
            for (BasicInstructionIndex basicInstructionIndex : this.breakpoints) {
                int lineNumber = this.parsedProgram.getLine(basicInstructionIndex.getLineIndex()).getLine();
                BasicInstructionIndex breakpoint = new BasicInstructionIndex(lineNumber, basicInstructionIndex.getInstructionIndex());
                sortedBreakpoints.add(breakpoint);
            }
            Collections.sort(sortedBreakpoints);
            for (BasicInstructionIndex breakpoint : sortedBreakpoints) {
                aPrintWriter.println("BREAKPOINT " + breakpoint.getLineIndex() + ", " + breakpoint.getInstructionIndex());
            }
            aPrintWriter.println();
        }
    }

    protected void saveWatchpoints(PrintWriter aPrintWriter) {
        for (Fx702pMemory.WatchedVariable watchedVariable : this.watchedVariables) {
            String keyword = watchedVariable.isWatchoint() ? WATCHPOINT_TEXT : WATCH_TEXT;
            aPrintWriter.println(keyword + " " + watchedVariable.getAlias());
        }
        if (this.suspendOnStatVariables) {
            aPrintWriter.println(STATWATCHPOINT_TEXT);
        }
    }

    public ASTProgram getParsedProgram() {
        return this.parsedProgram;
    }

    public Fx702pBasicSourceCode getBasicSourceCode() {
        return this.basicSourceCode;
    }

    public void clear() {
        this.parsedProgram = null;
        this.empty = true;
        this.breakpoints.clear();
        this.watchedVariables.clear();
        this.buildWatchedVariablesIndex();
    }

    public void toggleBreakpoint(BasicInstructionIndex aBasicInstructionIndex) {
        if (this.breakpoints.contains(aBasicInstructionIndex)) {
            this.breakpoints.remove(aBasicInstructionIndex);
        } else {
            this.breakpoints.add(aBasicInstructionIndex);
        }
        this.modified = true;
    }

    public void addWatchVariables(Collection<Fx702pMemory.WatchedVariable> theWatchedVariables) {
        this.watchedVariables.addAll(theWatchedVariables);
        this.buildWatchedVariablesIndex();
        this.modified = true;
    }

    public Fx702pMemory.WatchedVariable addWatchVariable(String anAlias, Variable aVariable) {
        Fx702pMemory.WatchedVariable watchedVariable = this.buildWatchVariable(anAlias, aVariable);
        this.watchedVariables.add(watchedVariable);
        this.buildWatchedVariablesIndex();
        this.modified = true;
        return watchedVariable;
    }

    public Fx702pMemory.WatchedVariable buildWatchVariable(String anAlias, Variable aVariable) {
        return new DefaultWatchedVariable(anAlias, aVariable);
    }

    public void removeWatchVariable(Fx702pMemory.WatchedVariable aWatchedVariable) {
        this.watchedVariables.remove(aWatchedVariable.getIndex());
        this.buildWatchedVariablesIndex();
        this.modified = true;
    }

    public void removeWatchVariables(Collection<Fx702pMemory.WatchedVariable> theWatchedVariables) {
        this.watchedVariables.removeAll(theWatchedVariables);
        this.buildWatchedVariablesIndex();
        this.modified = true;
    }

    protected void buildWatchedVariablesIndex() {
        Collections.sort(this.watchedVariables);
        for (int i = 0; i < this.getWatchedVariables().size(); ++i) {
            this.getWatchedVariables().get(i).setIndex(i);
        }
    }

    public boolean containsBreakpoint(BasicInstructionIndex aBasicInstructionIndex) {
        return this.breakpoints.contains(aBasicInstructionIndex);
    }

    public Collection<BasicInstructionIndex> getBreakpoints() {
        return Collections.unmodifiableCollection(this.breakpoints);
    }

    public List<Fx702pMemory.WatchedVariable> getWatchedVariables() {
        return this.watchedVariables;
    }

    public boolean isSuspendOnStatVariables() {
        return this.suspendOnStatVariables;
    }

    public void setSuspendOnStatVariables(boolean aSuspendOnStatVariables) {
        this.suspendOnStatVariables = aSuspendOnStatVariables;
    }

    public void removeAllBreakpoints() {
        if (!this.breakpoints.isEmpty()) {
            this.breakpoints.clear();
            this.modified = true;
        }
    }

    protected byte[] getSignature() {
        try {
            MessageDigest signature = MessageDigest.getInstance("MD5");
            this.parsedProgram.jjtAccept(new SignatureVisitor(), signature);
            return signature.digest();
        }
        catch (NoSuchAlgorithmException exception) {
            return null;
        }
    }

    protected String getStringSignature() {
        return new BigInteger(this.getSignature()).toString(16).toUpperCase();
    }

    public class DefaultWatchedVariable
    implements Fx702pMemory.WatchedVariable {
        protected String name;
        protected TreeSet<String> aliases = new TreeSet();
        protected Variable variable;
        protected int index;
        protected boolean watchpoint;

        public DefaultWatchedVariable(String anAlias, Variable aVariable) {
            this.addAlias(anAlias);
            this.variable = aVariable;
            this.watchpoint = false;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            if (this.aliases.isEmpty()) {
                return null;
            }
            return this.aliases.first();
        }

        public Variable getVariable() {
            return this.variable;
        }

        public boolean isWatchoint() {
            return this.watchpoint;
        }

        public void setWatchpoint(boolean aWatchpoint) {
            Fx702pBasicProgram.this.modified = this.watchpoint != aWatchpoint;
            this.watchpoint = aWatchpoint;
        }

        public boolean isEmpty() {
            return this.aliases.isEmpty();
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int anIndex) {
            this.index = anIndex;
        }

        public void addAlias(String anAlias) {
            if (this.aliases.add(anAlias)) {
                this.buildName();
                Fx702pBasicProgram.this.modified = true;
            }
        }

        public void removeAlias(String anAlias) {
            if (this.aliases.remove(anAlias)) {
                this.buildName();
                Fx702pBasicProgram.this.modified = true;
            }
        }

        public int compareTo(Fx702pMemory.WatchedVariable aWatchedVariable) {
            return this.variable.compareTo(aWatchedVariable.getVariable());
        }

        protected void buildName() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String alias : this.aliases) {
                if (first) {
                    first = false;
                } else {
                    builder.append("; ");
                }
                builder.append(alias);
            }
            this.name = builder.toString();
        }
    }

    protected class SignatureVisitor
    extends Fx702pAbstractParserVisitor {
        protected SignatureVisitor() {
        }

        protected void visitDigest(SimpleNode aNode, Object aData) {
            ((MessageDigest)aData).update(aNode.getClass().getSimpleName().getBytes());
        }

        public Object visit(ASTMode aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTRom aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTClear aNode, Object aData) {
            aNode.childrenAccept(this, aData);
            return null;
        }

        public Object visit(ASTAssignment aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTKey aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTGoto aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTGotoProgram aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTGsb aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTGsbProgram aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTReturn aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTPrint aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTInput aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTSet aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTVac aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTSac aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTStop aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTEnd aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTWait aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTStat aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTRPC aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTPRC aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTDMS aNode, Object aData) {
            aNode.childrenAccept(this, aData);
            return null;
        }

        public Object visit(ASTDeg aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTLoad aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTGet aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTPut aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTIf aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTFor aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }

        public Object visit(ASTNext aNode, Object aData) {
            this.visitDigest(aNode, aData);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BasicProgramVisitor
    extends LineVisitor {
        protected Fx702pParserVisitor lineVisitor;
        protected Fx702pCalculator calculator;
        protected String programSignature;
        protected Vector<BasicInstructionIndex> loadedBreakpoints;

        public BasicProgramVisitor(Fx702pCalculator aCalculator) {
            this.loadedBreakpoints = new Vector();
            this.calculator = aCalculator;
            this.lineVisitor = new LineVisitor();
        }

        @Override
        public Object visit(ASTLine aLine, Object aData) {
            aLine.jjtAccept(this.lineVisitor, aData);
            Fx702pBasicProgram.this.empty = false;
            return null;
        }

        @Override
        public Object visit(ASTAssignment anAssignment, Object aData) {
            try {
                this.calculator.visit(anAssignment, aData);
                Fx702pBasicProgram.this.saveVariables = true;
                return null;
            }
            catch (Fx702pException exception) {
                exception.setLine((Integer)anAssignment.jjtGetValue());
                throw exception;
            }
        }

        @Override
        public Object visit(ASTProgramSignature aNode, Object aData) {
            this.programSignature = aNode.signature;
            Fx702pBasicProgram.this.saveBreakpoints = true;
            return null;
        }

        @Override
        public Object visit(ASTBreakpoint aNode, Object aData) {
            ASTBreakpoint astBreakpoint = aNode;
            int lineIndex = Fx702pBasicProgram.this.parsedProgram.getLineIndexByLineNumberAndCheckInstructionIndex(astBreakpoint.line, astBreakpoint.instructionIndex);
            BasicInstructionIndex breakpoint = new BasicInstructionIndex(lineIndex, astBreakpoint.instructionIndex);
            this.loadedBreakpoints.add(breakpoint);
            Fx702pBasicProgram.this.saveBreakpoints = true;
            return null;
        }

        @Override
        public Object visit(ASTWatch aNode, Object aData) {
            Fx702pBasicProgram.this.watchedVariables.add(this.buildWatchedVariable(aNode));
            Fx702pBasicProgram.this.saveBreakpoints = true;
            return null;
        }

        @Override
        public Object visit(ASTWatchpoint aNode, Object aData) {
            Fx702pMemory.WatchedVariable watchedVariable = this.buildWatchedVariable(aNode);
            watchedVariable.setWatchpoint(true);
            Fx702pBasicProgram.this.watchedVariables.add(watchedVariable);
            Fx702pBasicProgram.this.saveBreakpoints = true;
            return null;
        }

        protected Fx702pMemory.WatchedVariable buildWatchedVariable(SimpleNode aNode) {
            if (aNode.jjtGetNumChildren() != 1) {
                throw new Fx702pInternalError("Invalid syntax for WATCH, line " + aNode.jjtGetValue());
            }
            Variable variable = WatchedVariableHelper.getVariable(aNode.jjtGetChild(0), this.calculator.getMemory());
            if (variable == null) {
                throw new Fx702pInternalError("Invalid variable in WATCH, line " + aNode.jjtGetValue());
            }
            return new DefaultWatchedVariable(WatchedVariableHelper.getAlias(aNode.jjtGetChild(0)), variable);
        }

        @Override
        public Object visit(ASTStatWatchpoint aNode, Object aData) {
            Fx702pBasicProgram.this.suspendOnStatVariables = true;
            Fx702pBasicProgram.this.saveBreakpoints = true;
            return null;
        }

        public String getProgramSignature() {
            return this.programSignature;
        }

        public Collection<BasicInstructionIndex> getLoadedBreakpoints() {
            return this.loadedBreakpoints;
        }
    }

    protected class LineVisitor
    extends Fx702pAbstractParserVisitor {
        protected int lastLine = -1;

        protected LineVisitor() {
        }

        public Object visit(ASTVariablesAndProgram aNode, Object aData) {
            aNode.childrenAccept(this, aData);
            return null;
        }

        public Object visit(ASTProgram aProgram, Object aData) {
            Fx702pBasicProgram.this.parsedProgram = aProgram;
            Fx702pBasicProgram.this.parsedProgram.childrenAccept(this, aData);
            int last = aProgram.jjtGetNumChildren();
            for (int i = 0; i < last; ++i) {
                Node node = aProgram.jjtGetChild(i);
                if (!(node instanceof ASTLine)) continue;
                ((ASTLine)node).setLineIndexInProgram(i);
            }
            return null;
        }

        public Object visit(ASTLine aLine, Object aData) {
            if (aLine.getLine() <= this.lastLine) {
                throw new Fx702pLoadingException("Invalid line number " + aLine.getLine() + ": should be greater than the previous one.\nSee line " + aLine.getLineIndexInSourceCode() + " in " + Fx702pBasicProgram.this.getName());
            }
            this.lastLine = aLine.getLine();
            ASTLine.LineInfos lineInfos = new ASTLine.LineInfos();
            int last = aLine.jjtGetNumChildren();
            for (int i = 0; i < last; ++i) {
                aLine.visitAndResynchronize(i, this, lineInfos);
            }
            aLine.resynchronizePositions(Fx702pBasicProgram.this.basicSourceCode);
            this.fixBoundaries(aLine, lineInfos);
            Fx702pBasicProgram.this.basicSourceCode.getLine(aLine.getLineIndexInSourceCode()).setParsedLine(aLine);
            return null;
        }

        protected void fixBoundaries(ASTLine aLine, ASTLine.LineInfos theLineInfos) {
            int last = aLine.jjtGetNumChildren();
            for (int i = 0; i < last; ++i) {
                Node node = aLine.jjtGetChild(i);
                if (!theLineInfos.boundariesToFix.containsKey(node)) continue;
                theLineInfos.boundariesToFix.get((Object)node).end = aLine.getInstructionBoundary((int)i).end;
            }
        }

        public Object visit(ASTPrint aPrint, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                aPrint.visitAndResynchronize(this, (ASTLine.LineInfos)aData);
                aPrint.resynchronizePositions(Fx702pBasicProgram.this.basicSourceCode, (ASTLine.LineInfos)aData);
            } else {
                aPrint.childrenAccept(this, aData);
                aPrint.resynchronizePositions(Fx702pBasicProgram.this.basicSourceCode, null);
            }
            return null;
        }

        public Object visit(ASTInput anInput, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                anInput.visitAndResynchronize(this, (ASTLine.LineInfos)aData);
                anInput.resynchronizePositions(Fx702pBasicProgram.this.basicSourceCode, (ASTLine.LineInfos)aData);
            } else {
                anInput.childrenAccept(this, aData);
                anInput.resynchronizePositions(Fx702pBasicProgram.this.basicSourceCode, null);
            }
            return null;
        }

        public Object visit(ASTString aString, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                ((ASTLine.LineInfos)aData).columnDelta += aString.delta;
            }
            return null;
        }

        public Object visit(ASTFloat aFloat, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                ((ASTLine.LineInfos)aData).columnDelta += aFloat.delta;
            }
            return null;
        }

        public Object visit(ASTPi aPi, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                ((ASTLine.LineInfos)aData).columnDelta += aPi.delta;
            }
            return null;
        }

        public Object visit(ASTNotEqual aNotEqual, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                ((ASTLine.LineInfos)aData).columnDelta += aNotEqual.delta;
            }
            return null;
        }

        public Object visit(ASTLesserOrEqual aLesserOrEqual, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                ((ASTLine.LineInfos)aData).columnDelta += aLesserOrEqual.delta;
            }
            return null;
        }

        public Object visit(ASTGreaterOrEqual aGreaterOrEqual, Object aData) {
            if (aData instanceof ASTLine.LineInfos) {
                ((ASTLine.LineInfos)aData).columnDelta += aGreaterOrEqual.delta;
            }
            return null;
        }

        public Object visit(ASTComment aNode, Object aData) {
            Fx702pBasicProgram.this.hasComments = true;
            return null;
        }
    }
}

