/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.emulator.Characters;
import com.fx702p.emulator.Fx702pBasicLine;
import com.fx702p.emulator.Fx702pBasicProgram;
import com.fx702p.emulator.InstructionBoundary;
import com.fx702p.interpreters.BasicInstructionIndex;
import com.fx702p.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;

public class Fx702pLinePanel
extends JPanel {
    protected char[] display;
    protected int displaySize;
    protected int printedSize;
    protected int sizeX;
    protected int sizeY;
    protected int boxSpace;
    protected int characterSpace;
    protected Dimension preferredSize;
    protected Image image = null;
    protected int imageWidth;
    protected boolean refreshNeeded = false;
    protected int cursorToRefresh = -1;
    protected List<InstructionBoundary> instructionBoundaries;
    protected List<InstructionBoundary> breakpointInstructionBoundaries = new Vector<InstructionBoundary>();
    protected Fx702pBasicProgram basicProgram = null;
    protected Fx702pBasicLine basicLine = null;
    protected Color fontForeground;
    protected Color breakpointFontForeground;
    protected Color selectedBreakpointFontForeground;
    protected Color fontBackground;
    protected Color selectedFondBackground;
    protected Color subSelectedFondBackground;
    protected int selectionStart = -1;
    protected int selectionEnd = -1;
    protected boolean breakpointSelected = false;
    public int subSelectionStart = -1;
    public int subSelectionEnd = -1;
    public static final int NO_SELECTION = -1;
    public static final int DEFAULT_DISPLAY_SIZE = 20;
    public static final Color DEFAULT_FONT_FOREGROUND = new Color(0, 0, 0);
    public static final Color DEFAULT_BREAKPOINT_FONT_FOREGROUND = new Color(225, 0, 0);
    public static final Color DEFAULT_SELECTED_BREAKPOINT_FONT_FOREGROUND = new Color(9, 0, 196);
    public static final Color DEFAULT_FONT_BACKGROUND = new Color(117, 134, 126);
    public static final Color DEFAULT_SELECTED_FONT_BACKGROUND = SwingUtils.DEFAULT_SELECTION_COLOR;
    public static final Color DEFAULT_SUBSELECTED_FONT_BACKGROUND = SwingUtils.DEFAULT_SUBSELECTION_COLOR;

    public Fx702pLinePanel(int aSizeX, int aSizeY, int aBoxSpace, int aCharacterSpace) {
        this(20, aSizeX, aSizeY, aBoxSpace, aCharacterSpace);
        this.setDefaultColors();
    }

    public Fx702pLinePanel(int aDisplaySize, Color aFontForeground, Color aFontBackGround, int aSizeX, int aSizeY, int aBoxSpace, int aCharacterSpace) {
        this(aDisplaySize, aSizeX, aSizeY, aBoxSpace, aCharacterSpace);
        this.fontForeground = aFontForeground;
        this.fontBackground = aFontBackGround;
        this.setDefaultColors();
    }

    private Fx702pLinePanel(int aDisplaySize, int aSizeX, int aSizeY, int aBoxSpace, int aCharacterSpace) {
        this.displaySize = aDisplaySize;
        this.display = new char[this.displaySize];
        this.printedSize = 0;
        this.sizeX = aSizeX;
        this.sizeY = aSizeY;
        this.boxSpace = aBoxSpace;
        this.characterSpace = aCharacterSpace;
        Dimension characterDimension = Fx702pLinePanel.getCharacterDimension(aSizeX, aSizeY, aBoxSpace);
        this.preferredSize = new Dimension(this.displaySize * (characterDimension.width + this.characterSpace), characterDimension.height);
    }

    public Fx702pBasicLine getBasicLine() {
        return this.basicLine;
    }

    public static Dimension getCharacterDimension(int aSizeX, int aSizeY, int aBoxSpace) {
        return new Dimension((aSizeX + aBoxSpace) * 5, (aSizeY + aBoxSpace) * 7);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public int getPrintedSize() {
        return this.printedSize;
    }

    protected void setDefaultColors() {
        this.fontForeground = this.getDefaultColor(this.fontForeground, DEFAULT_FONT_FOREGROUND);
        this.breakpointFontForeground = this.getDefaultColor(this.breakpointFontForeground, DEFAULT_BREAKPOINT_FONT_FOREGROUND);
        this.selectedBreakpointFontForeground = this.getDefaultColor(this.selectedBreakpointFontForeground, DEFAULT_SELECTED_BREAKPOINT_FONT_FOREGROUND);
        this.fontBackground = this.getDefaultColor(this.fontBackground, DEFAULT_FONT_BACKGROUND);
        this.selectedFondBackground = this.getDefaultColor(this.selectedFondBackground, DEFAULT_SELECTED_FONT_BACKGROUND);
        this.subSelectedFondBackground = this.getDefaultColor(this.subSelectedFondBackground, DEFAULT_SUBSELECTED_FONT_BACKGROUND);
    }

    protected Color getDefaultColor(Color aColor, Color aDefaultColor) {
        if (aColor != null) {
            return aColor;
        }
        return aDefaultColor;
    }

    public void print(char[] theCharacters) {
        this.setLine(theCharacters);
        this.repaint();
    }

    public void setLine(char[] theCharacters) {
        this.printedSize = theCharacters.length;
        System.arraycopy(theCharacters, 0, this.display, 0, Math.min(this.displaySize, this.printedSize));
        for (int i = this.printedSize; i < this.displaySize; ++i) {
            this.display[i] = 32;
        }
        this.setRefreshNeeded();
    }

    public void setLine(String aString) {
        this.setLine(aString.toCharArray());
    }

    public void setBasicInformations(Fx702pBasicProgram aBasicProgram, Fx702pBasicLine aBasicLine) {
        this.basicProgram = aBasicProgram;
        this.basicLine = aBasicLine;
        this.instructionBoundaries = this.basicLine.getParsedLine().getInstructionBoundaries();
    }

    public char getCharAt(int anIndex) {
        return this.display[anIndex];
    }

    public void setCharAt(int anIndex, char aChar) {
        this.display[anIndex] = aChar;
        this.setRefreshNeeded();
    }

    public void setCursorAt(int anIndex, char aChar) {
        this.display[anIndex] = aChar;
        this.cursorToRefresh = anIndex;
        this.repaint(this.getCharacterBounds(this.cursorToRefresh));
    }

    protected Rectangle getCharacterBounds(int aPosition) {
        int width = 5 * (this.sizeX + this.boxSpace) + this.characterSpace;
        int x = aPosition * width;
        return new Rectangle(x, 0, width, this.getSize().height);
    }

    public boolean isEmpty() {
        for (char c : this.display) {
            if (c == ' ') continue;
            return false;
        }
        return true;
    }

    public int getInstructionIndex(int x) {
        int index = this.getCharacterIndex(x);
        if (this.instructionBoundaries == null || this.instructionBoundaries.isEmpty() || index < 0 || index >= this.instructionBoundaries.get((int)(this.instructionBoundaries.size() - 1)).end) {
            return -1;
        }
        int first = 0;
        int last = this.instructionBoundaries.size() - 1;
        int middle = -1;
        while (middle != first || last > first + 1) {
            middle = first + (last - first) / 2;
            if (index >= this.instructionBoundaries.get((int)middle).begin) {
                first = middle;
                continue;
            }
            last = middle;
        }
        if (index >= this.instructionBoundaries.get((int)first).begin && index < this.instructionBoundaries.get((int)first).end) {
            return first;
        }
        if (index >= this.instructionBoundaries.get((int)last).begin && index < this.instructionBoundaries.get((int)last).end) {
            return last;
        }
        return -1;
    }

    public void select(int aSelectionStart, int aSelectionEnd, boolean aBreakpointSelected) {
        this.selectionStart = aSelectionStart;
        this.selectionEnd = aSelectionEnd;
        this.breakpointSelected = aBreakpointSelected;
        this.setRefreshNeeded();
        this.repaint();
    }

    public void subSelect(int aSubSelectionStart, int aSubSelectionEnd) {
        this.subSelectionStart = aSubSelectionStart;
        this.subSelectionEnd = aSubSelectionEnd;
        this.setRefreshNeeded();
        this.repaint();
    }

    public void clearSelection() {
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.subSelectionStart = -1;
        this.subSelectionEnd = -1;
        this.breakpointSelected = false;
        this.setRefreshNeeded();
        this.repaint();
    }

    protected int getCharacterIndex(int x) {
        return x / (5 * (this.sizeX + this.boxSpace) + this.characterSpace);
    }

    protected void clear() {
        Arrays.fill(this.display, ' ');
        this.setRefreshNeeded();
    }

    public void paintComponent(Graphics aGraphics) {
        boolean refreshed = false;
        if (this.isRefreshNeeded()) {
            int lastX;
            int firstX;
            refreshed = true;
            this.refreshNeeded = false;
            this.imageWidth = this.getSize().width;
            this.image = this.createImage(this.imageWidth, this.getSize().height);
            this.refreshNeeded = false;
            Graphics imageGraphics = this.image.getGraphics();
            imageGraphics.setColor(this.fontBackground);
            imageGraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (this.selectionStart != -1) {
                firstX = this.selectionStart * (5 * (this.sizeX + this.boxSpace) + this.characterSpace);
                lastX = this.selectionEnd * (5 * (this.sizeX + this.boxSpace) + this.characterSpace) - this.characterSpace;
                imageGraphics.setColor(this.selectedFondBackground);
                imageGraphics.fillRect(firstX, 0, lastX - firstX, this.getSize().height);
            }
            if (this.subSelectionStart != -1) {
                firstX = this.subSelectionStart * (5 * (this.sizeX + this.boxSpace) + this.characterSpace);
                lastX = this.subSelectionEnd * (5 * (this.sizeX + this.boxSpace) + this.characterSpace) - this.characterSpace;
                imageGraphics.setColor(this.subSelectedFondBackground);
                imageGraphics.fillRect(firstX, 0, lastX - firstX, this.getSize().height);
            }
            this.buildBreakpointsBoundaries();
            for (int i = 0; i < this.displaySize; ++i) {
                this.paintCharacterDrawings(imageGraphics, Characters.getCharacterDrawings(this.display[i]), i);
            }
        } else if (this.cursorToRefresh >= 0) {
            Graphics imageGraphics = this.image.getGraphics();
            this.paintCharacterDrawings(imageGraphics, Characters.getCharacterDrawings(this.display[this.cursorToRefresh]), this.cursorToRefresh);
        }
        aGraphics.drawImage(this.image, 0, 0, null);
        if (this.getSize() != null && (refreshed || this.cursorToRefresh < 0)) {
            aGraphics.setColor(this.fontBackground);
            aGraphics.fillRect(this.imageWidth, 0, this.getSize().width, this.getSize().height);
        }
        this.cursorToRefresh = -1;
    }

    protected void buildBreakpointsBoundaries() {
        this.breakpointInstructionBoundaries.clear();
        if (this.basicProgram != null && this.basicLine != null && this.instructionBoundaries != null) {
            for (int i = 0; i < this.instructionBoundaries.size(); ++i) {
                BasicInstructionIndex basicInstructionIndex = new BasicInstructionIndex(this.basicLine.getParsedLine().getLineIndexInProgram(), i);
                if (!this.basicProgram.containsBreakpoint(basicInstructionIndex)) continue;
                this.breakpointInstructionBoundaries.add(this.instructionBoundaries.get(i));
            }
        }
    }

    public synchronized boolean isRefreshNeeded() {
        return this.image == null || this.refreshNeeded;
    }

    public synchronized void setRefreshNeeded() {
        this.refreshNeeded = true;
    }

    protected void paintCharacterDrawings(Graphics aGraphics, String[] theDrawings, int aPosition) {
        int width = theDrawings[0].length();
        int height = theDrawings.length;
        Color characterForeground = this.fontForeground;
        for (InstructionBoundary instructionBoundary : this.breakpointInstructionBoundaries) {
            if (aPosition < instructionBoundary.begin || aPosition >= instructionBoundary.end) continue;
            if (this.breakpointSelected) {
                characterForeground = this.selectedBreakpointFontForeground;
                break;
            }
            characterForeground = this.breakpointFontForeground;
            break;
        }
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                if (theDrawings[i].charAt(j) == ' ') {
                    if (aPosition >= this.subSelectionStart && aPosition < this.subSelectionEnd) {
                        aGraphics.setColor(this.subSelectedFondBackground);
                    } else if (aPosition >= this.selectionStart && aPosition < this.selectionEnd) {
                        aGraphics.setColor(this.selectedFondBackground);
                    } else {
                        aGraphics.setColor(this.fontBackground);
                    }
                } else {
                    aGraphics.setColor(characterForeground);
                }
                aGraphics.fillRect(aPosition * (width * (this.sizeX + this.boxSpace) + this.characterSpace) + j * (this.sizeX + this.boxSpace), i * (this.sizeY + this.boxSpace), this.sizeX, this.sizeY);
            }
        }
    }
}

