/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.swing.Fx702pLinePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class Fx702pProgramStepsPanel
extends JPanel {
    protected boolean showBusy = false;
    protected boolean showSteps = false;
    protected Polygon[][] segments = new Polygon[4][7];
    protected int steps = 0;
    public static final int BUSY_CHARACTER_INDEX = 3;
    public static final int BUSY_CHARACTER_SEGMENT_INDEX = 3;
    public static final Point[][] SEGMENT_POINTS = new Point[][]{{new Point(4, 1), new Point(11, 1), new Point(9, 3), new Point(6, 3)}, {new Point(3, 3), new Point(5, 4), new Point(4, 7), new Point(2, 9)}, {new Point(12, 2), new Point(11, 9), new Point(9, 7), new Point(10, 4)}, {new Point(4, 9), new Point(5, 8), new Point(8, 8), new Point(9, 9), new Point(8, 10), new Point(5, 10)}, {new Point(2, 10), new Point(4, 11), new Point(3, 14), new Point(1, 16)}, {new Point(11, 9), new Point(10, 17), new Point(8, 15), new Point(9, 11)}, {new Point(2, 16), new Point(7, 16), new Point(8, 18), new Point(3, 18), new Point(2, 17)}};
    public static final boolean[][] NUMBER_SEGMENTS = new boolean[][]{{true, true, true, false, true, true, true}, {false, false, true, false, false, true, false}, {true, false, true, true, true, false, true}, {true, false, true, true, false, true, true}, {false, true, true, true, false, true, false}, {true, true, false, true, false, true, true}, {true, true, false, true, true, true, true}, {true, false, true, false, false, true, false}, {true, true, true, true, true, true, true}, {true, true, true, true, false, true, true}};
    public static final int CHARACTERS_COUNT = 4;
    public static final int SEGMENTS_COUNT = 7;
    public static final int ADVANCE = 14;
    public static final Color SEGMENT_COLOR = new Color(0, 0, 0, 180);

    public Fx702pProgramStepsPanel(Rectangle theBounds) {
        this.setBounds(theBounds);
        this.buildSegments();
    }

    public void setSteps(int aSteps) {
        this.steps = aSteps;
    }

    public void showBusy(boolean aShowBusy) {
        if (aShowBusy != this.showBusy) {
            this.repaint();
        }
        this.showBusy = aShowBusy;
    }

    public void showSteps(boolean aShowSteps) {
        if (aShowSteps != this.showSteps) {
            this.repaint();
        }
        this.showSteps = aShowSteps;
    }

    protected void buildSegments() {
        int xOffset = 0;
        for (int characterIndex = 0; characterIndex < 4; ++characterIndex) {
            for (int segmentIndex = 0; segmentIndex < SEGMENT_POINTS.length; ++segmentIndex) {
                int[] x = new int[SEGMENT_POINTS[segmentIndex].length];
                int[] y = new int[SEGMENT_POINTS[segmentIndex].length];
                for (int pointIndex = 0; pointIndex < SEGMENT_POINTS[segmentIndex].length; ++pointIndex) {
                    x[pointIndex] = Fx702pProgramStepsPanel.SEGMENT_POINTS[segmentIndex][pointIndex].x + xOffset;
                    y[pointIndex] = Fx702pProgramStepsPanel.SEGMENT_POINTS[segmentIndex][pointIndex].y;
                }
                this.segments[characterIndex][segmentIndex] = new Polygon(x, y, SEGMENT_POINTS[segmentIndex].length);
            }
            xOffset += 14;
        }
    }

    public void paintComponent(Graphics aGraphics) {
        aGraphics.setColor(Fx702pLinePanel.DEFAULT_FONT_BACKGROUND);
        aGraphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        aGraphics.setColor(SEGMENT_COLOR);
        if (this.showBusy) {
            aGraphics.fillPolygon(this.segments[3][3]);
        } else if (this.showSteps) {
            if (aGraphics instanceof Graphics2D) {
                ((Graphics2D)aGraphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int currentSteps = this.steps;
            for (int i = 3; i >= 0; --i) {
                int digit = currentSteps % 10;
                currentSteps /= 10;
                for (int j = 0; j < this.segments[i].length; ++j) {
                    if (!NUMBER_SEGMENTS[digit][j]) continue;
                    aGraphics.fillPolygon(this.segments[i][j]);
                }
            }
        }
    }
}

