/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.Fx702pFullParser;
import com.fx702p.debug.WatchedVariableHelper;
import com.fx702p.emulator.Fx702pBasicProgram;
import com.fx702p.emulator.Fx702pConstants;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Fx702pMemory;
import com.fx702p.emulator.Variable;
import com.fx702p.parser.Node;
import com.fx702p.swing.FormLayout;
import com.fx702p.swing.Fx702pSwingKeyboardAndDisplay;
import com.fx702p.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchPanel
extends JSplitPane
implements Fx702pMemory.Watcher,
ListSelectionListener {
    protected Fx702pSwingKeyboardAndDisplay fx702pSwingKeyboardAndDisplay;
    protected Fx702pBasicProgram basicProgram;
    protected Fx702pEmulator emulator;
    protected Fx702pMemory memory;
    protected HashMap<Variable, Fx702pMemory.WatchedVariable> watchedVariablesByVariable = new HashMap();
    protected JTextField watchedVariableTextField;
    protected JTable watchedVariablesTable;
    protected Variable lastModifiedVariable = null;
    protected Color validWatchedVariableTextFieldForeground;
    protected Variable variableJustWatched = null;
    protected JButton watchButton;
    protected JButton removeButton;
    protected int tableFontHeight;
    protected Component tableExtraVerticalBox;
    protected JScrollPane statVariablesScrollPane;
    protected boolean ignoreSelectionChanges = false;
    protected boolean userSelectionChange = false;
    protected Vector<JTextField> statValuesTextFields = new Vector();
    protected Color defaultStatValueBackground;
    protected static final LastModifiedCellRenderer LAST_MODIFIED_CELL_RENDERER = new LastModifiedCellRenderer();
    protected static final WatchpointCellRenderer WATCHPOINT_CELL_RENDERER = new WatchpointCellRenderer();
    protected static final String STAT_VALUE_GETTER_PROPERTY = "com.fx702p.StatValueGetter";
    public static final Color LAST_CHANGED_COLOR = SwingUtils.DEFAULT_SELECTION_COLOR;
    public static final Color WATCHPOINT_COLOR = SwingUtils.DEFAULT_SUBSELECTION_COLOR;
    public static final Color INVALID_WATCHED_VARIABLE_TEXT_FIELD_FOREGROUND = new Color(255, 0, 0);
    public static final int WATCH_VARIABLE_NAME_COLUMNS = 20;
    public static final String[] WATCHED_VARIABLES_COLUMNS_NAMES = new String[]{"Name", "Number", "String", "Watchpoint"};
    public static final int NAME_COLUMN_INDEX = 0;
    public static final int NUMBER_COLUMN_INDEX = 1;
    public static final int STRING_COLUMN_INDEX = 2;
    public static final int WATCHPOINT_COLUMN_INDEX = 3;
    public static final int NAME_WIDTH = 8;
    public static final int NUMBER_WIDTH = 15;
    public static final int STRING_WIDTH = 21;

    public WatchPanel(Fx702pSwingKeyboardAndDisplay anFx702pSwingKeyboardAndDisplay, Fx702pBasicProgram aBasicProgram) {
        super(0);
        this.fx702pSwingKeyboardAndDisplay = anFx702pSwingKeyboardAndDisplay;
        this.emulator = this.fx702pSwingKeyboardAndDisplay.getEmulator();
        this.memory = this.emulator.getMemory();
        this.setActiveProgram(aBasicProgram);
        this.setTopComponent(this.buildNormalVariablesPanel());
        this.setBottomComponent(this.buildStatVariablesPanel());
        this.setResizeWeight(1.0);
    }

    public void setActiveProgram(Fx702pBasicProgram aBasicProgram) {
        this.basicProgram = aBasicProgram;
        this.buildWatchVariablesByVariable();
        this.fireWatchedVariablesTableModelModified();
    }

    protected void buildWatchVariablesByVariable() {
        this.watchedVariablesByVariable.clear();
        for (Fx702pMemory.WatchedVariable watchedVariable : this.getWatchedVariables()) {
            this.watchedVariablesByVariable.put(watchedVariable.getVariable(), watchedVariable);
        }
    }

    public void setInitialDividerLocation() {
        int scrollBarHeight = this.statVariablesScrollPane.getHorizontalScrollBar().getHeight();
        this.setDividerLocation(this.getSize().height - this.getBottomComponent().getMinimumSize().height - this.getInsets().bottom - this.getDividerSize() - scrollBarHeight);
    }

    protected List<Fx702pMemory.WatchedVariable> getWatchedVariables() {
        return this.basicProgram.getWatchedVariables();
    }

    protected JPanel buildNormalVariablesPanel() {
        JPanel normalVariablesPanel = new JPanel();
        normalVariablesPanel.setLayout(new BoxLayout(normalVariablesPanel, 1));
        JPanel watchSelectionPanel = new JPanel();
        watchSelectionPanel.setLayout(new BoxLayout(watchSelectionPanel, 0));
        this.watchedVariableTextField = new JTextField(20);
        this.watchedVariableTextField.setMinimumSize(this.watchedVariableTextField.getPreferredSize());
        this.watchedVariableTextField.setMaximumSize(this.watchedVariableTextField.getPreferredSize());
        this.validWatchedVariableTextFieldForeground = this.watchedVariableTextField.getForeground();
        this.watchedVariableTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent aDocumentEvent) {
                WatchPanel.this.validateTextField();
            }

            public void removeUpdate(DocumentEvent aDocumentEvent) {
                WatchPanel.this.validateTextField();
            }

            public void changedUpdate(DocumentEvent aDocumentEvent) {
                WatchPanel.this.validateTextField();
            }
        });
        this.watchedVariableTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                WatchPanel.this.addWatchedVariable();
            }
        });
        ((AbstractDocument)this.watchedVariableTextField.getDocument()).setDocumentFilter(new UppercaseDocumentFilter());
        watchSelectionPanel.add(this.watchedVariableTextField);
        this.watchButton = new JButton("Watch");
        this.watchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                WatchPanel.this.addWatchedVariable();
            }
        });
        watchSelectionPanel.add(this.watchButton);
        JButton watchAtoZButton = new JButton("Watch A to Z and $");
        watchAtoZButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                WatchPanel.this.watchedNormalVariables();
            }
        });
        watchSelectionPanel.add(watchAtoZButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                WatchPanel.this.removeWatchedVariable();
            }
        });
        watchSelectionPanel.add(this.removeButton);
        watchSelectionPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, watchSelectionPanel.getPreferredSize().height));
        watchSelectionPanel.setMinimumSize(watchSelectionPanel.getPreferredSize());
        watchSelectionPanel.setAlignmentX(0.0f);
        normalVariablesPanel.add(watchSelectionPanel);
        this.watchedVariablesTable = new JTable(new WatchedVariablesTableModel()){

            public TableCellRenderer getCellRenderer(int aRow, int aColumn) {
                if (WatchPanel.this.isLastModified(aRow, aColumn)) {
                    if (WatchPanel.this.getWatchedVariables().get(aRow).isWatchoint()) {
                        return WATCHPOINT_CELL_RENDERER;
                    }
                    return LAST_MODIFIED_CELL_RENDERER;
                }
                return super.getCellRenderer(aRow, aColumn);
            }
        };
        ((JComponent)((Object)this.watchedVariablesTable.getDefaultRenderer(Boolean.class))).setOpaque(true);
        this.watchedVariablesTable.setCellSelectionEnabled(false);
        this.watchedVariablesTable.setRowSelectionAllowed(true);
        this.watchedVariablesTable.setSelectionMode(2);
        this.setColumnSizes();
        this.watchedVariablesTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane watchedVariablesTableScrollPanel = new JScrollPane(this.watchedVariablesTable, 20, 30);
        this.watchedVariablesTable.setPreferredScrollableViewportSize(this.watchedVariablesTable.getPreferredSize());
        watchedVariablesTableScrollPanel.setAlignmentX(0.0f);
        watchedVariablesTableScrollPanel.setMinimumSize(watchedVariablesTableScrollPanel.getPreferredSize());
        normalVariablesPanel.add(watchedVariablesTableScrollPanel);
        this.tableExtraVerticalBox = Box.createVerticalStrut(this.tableFontHeight * 2);
        normalVariablesPanel.add(this.tableExtraVerticalBox);
        this.allowNothing();
        return normalVariablesPanel;
    }

    protected JScrollPane buildStatVariablesPanel() {
        JPanel statVariablesPanel = new JPanel();
        statVariablesPanel.setLayout(new BoxLayout(statVariablesPanel, 1));
        JCheckBox suspendOnStatModifiedCheckBox = new JCheckBox("Stat Watchpoint");
        suspendOnStatModifiedCheckBox.setSelected(this.basicProgram.isSuspendOnStatVariables());
        suspendOnStatModifiedCheckBox.setAlignmentX(0.0f);
        suspendOnStatModifiedCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent anItemEvent) {
                WatchPanel.this.basicProgram.setSuspendOnStatVariables(anItemEvent.getStateChange() == 1);
            }
        });
        statVariablesPanel.add(suspendOnStatModifiedCheckBox);
        JPanel valuesPanel = new JPanel();
        valuesPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        valuesPanel.setLayout(new FormLayout(3, false));
        valuesPanel.setAlignmentX(0.0f);
        this.buildStatVariableValuePanel(valuesPanel, "CNT", new StatValueGetter(){

            public BigDecimal getValue() {
                return WatchPanel.this.memory.getStatCounter();
            }
        });
        this.buildStatVariableValuePanel(valuesPanel, "MX", new StatValueGetter(){

            public BigDecimal getValue() {
                if (WatchPanel.this.memory.getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
                    return null;
                }
                return WatchPanel.this.memory.getSumX().divide(WatchPanel.this.memory.getStatCounter(), Fx702pConstants.MATH_CONTEXT);
            }
        });
        this.buildStatVariableValuePanel(valuesPanel, "MY", new StatValueGetter(){

            public BigDecimal getValue() {
                if (WatchPanel.this.memory.getStatCounter().compareTo(BigDecimal.ZERO) == 0) {
                    return null;
                }
                return WatchPanel.this.memory.getSumY().divide(WatchPanel.this.memory.getStatCounter(), Fx702pConstants.MATH_CONTEXT);
            }
        });
        this.buildStatVariableValuePanel(valuesPanel, "SX", new StatValueGetter(){

            public BigDecimal getValue() {
                return WatchPanel.this.memory.getSumX();
            }
        });
        this.buildStatVariableValuePanel(valuesPanel, "SY", new StatValueGetter(){

            public BigDecimal getValue() {
                return WatchPanel.this.memory.getSumY();
            }
        });
        this.buildStatVariableValuePanel(valuesPanel, "SX2", new StatValueGetter(){

            public BigDecimal getValue() {
                return WatchPanel.this.memory.getSumX2();
            }
        });
        this.buildStatVariableValuePanel(valuesPanel, "SY2", new StatValueGetter(){

            public BigDecimal getValue() {
                return WatchPanel.this.memory.getSumY2();
            }
        });
        this.buildStatVariableValuePanel(valuesPanel, "SXY", new StatValueGetter(){

            public BigDecimal getValue() {
                return WatchPanel.this.memory.getSumXY();
            }
        });
        this.defaultStatValueBackground = this.statValuesTextFields.get(0).getBackground();
        statVariablesPanel.add(valuesPanel);
        this.statVariablesScrollPane = new JScrollPane(statVariablesPanel, 22, 32);
        this.statVariablesScrollPane.setMinimumSize(new Dimension(this.statVariablesScrollPane.getPreferredSize().width, suspendOnStatModifiedCheckBox.getPreferredSize().height));
        this.setStatValues();
        return this.statVariablesScrollPane;
    }

    protected void buildStatVariableValuePanel(Container aContainer, String aStatVariableName, StatValueGetter aStatValueGetter) {
        JLabel valueLabel = new JLabel(aStatVariableName);
        aContainer.add(valueLabel);
        JTextField valueTextField = new JTextField(15);
        valueTextField.setEditable(false);
        valueTextField.putClientProperty(STAT_VALUE_GETTER_PROPERTY, aStatValueGetter);
        this.statValuesTextFields.add(valueTextField);
        aContainer.add(valueTextField);
    }

    protected void allowNothing() {
        this.watchButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    protected void allowWatch() {
        this.watchButton.setEnabled(true);
        this.removeButton.setEnabled(false);
    }

    protected void allowRemove() {
        this.watchButton.setEnabled(false);
        this.removeButton.setEnabled(true);
    }

    protected void addWatchedVariable() {
        Variable variable = this.getValidatedTextFieldVariable();
        if (variable != null) {
            this.variableJustWatched = variable;
            this.watchVariable(this.watchedVariableTextField.getText(), variable);
            this.watchedVariableTextField.selectAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent aListSelectionEvent) {
        if (!this.ignoreSelectionChanges) {
            int[] selectedRows = this.watchedVariablesTable.getSelectedRows();
            if (selectedRows.length == 1) {
                Fx702pMemory.WatchedVariable watchedVariable = this.getWatchedVariables().get(selectedRows[0]);
                if (watchedVariable.getVariable() != this.variableJustWatched) {
                    this.userSelectionChange = true;
                    try {
                        this.watchedVariableTextField.setText(watchedVariable.getAlias());
                    }
                    finally {
                        this.userSelectionChange = false;
                    }
                }
                this.allowRemove();
            } else {
                if (selectedRows.length > 0) {
                    this.allowRemove();
                }
                this.userSelectionChange = true;
                try {
                    this.watchedVariableTextField.setText("");
                }
                finally {
                    this.userSelectionChange = false;
                }
            }
        }
    }

    protected void setColumnSizes() {
        this.watchedVariablesTable.setAutoResizeMode(0);
        Font font = this.watchedVariablesTable.getCellRenderer(0, 0).getTableCellRendererComponent(this.watchedVariablesTable, "A", false, false, 0, 0).getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int xWidth = fontMetrics.charWidth('X');
        this.watchedVariablesTable.getColumnModel().getColumn(0).setPreferredWidth(xWidth * 8);
        this.watchedVariablesTable.getColumnModel().getColumn(1).setPreferredWidth(xWidth * 15);
        this.watchedVariablesTable.getColumnModel().getColumn(2).setPreferredWidth(xWidth * 21);
        this.tableFontHeight = fontMetrics.getHeight();
    }

    protected boolean isLastModified(int aRow, int aColumn) {
        if (this.getWatchedVariables().isEmpty()) {
            return false;
        }
        Fx702pMemory.WatchedVariable watchedVariable = this.getWatchedVariables().get(aRow);
        if (watchedVariable.getVariable() == this.lastModifiedVariable) {
            switch (aColumn) {
                case 0: {
                    return false;
                }
                case 1: {
                    return !watchedVariable.getVariable().isStringVariable();
                }
                case 2: {
                    return watchedVariable.getVariable().isStringVariable();
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateTextField() {
        Variable variable = this.getValidatedTextFieldVariable();
        this.variableJustWatched = null;
        if (!this.userSelectionChange) {
            this.ignoreSelectionChanges = true;
            try {
                this.watchedVariablesTable.getSelectionModel().clearSelection();
            }
            finally {
                this.ignoreSelectionChanges = false;
            }
        }
        if (variable != null) {
            if (this.watchedVariablesByVariable.containsKey(variable)) {
                this.allowRemove();
            } else {
                this.allowWatch();
            }
        } else {
            this.allowNothing();
        }
    }

    protected Variable getValidatedTextFieldVariable() {
        String variableName = this.watchedVariableTextField.getText();
        if (variableName == null || variableName.length() == 0) {
            this.watchedVariableTextField.setForeground(this.validWatchedVariableTextFieldForeground);
            return null;
        }
        Variable variable = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(variableName.getBytes());
            Fx702pFullParser parser = new Fx702pFullParser(inputStream);
            Node node = parser.WatchedVariable();
            if (node != null) {
                variable = WatchedVariableHelper.getVariable(node, this.memory);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (variable != null) {
            this.watchedVariableTextField.setForeground(this.validWatchedVariableTextFieldForeground);
        } else {
            this.watchedVariableTextField.setForeground(INVALID_WATCHED_VARIABLE_TEXT_FIELD_FOREGROUND);
        }
        return variable;
    }

    @Override
    public void allCleared() {
        this.lastModifiedVariable = null;
        this.fireWatchedVariablesTableModelModified();
    }

    @Override
    public void variableModified(Variable aVariable) {
        this.lastModifiedVariable = aVariable;
        Fx702pMemory.WatchedVariable watchedVariable = this.watchedVariablesByVariable.get(aVariable);
        if (watchedVariable != null) {
            int row = watchedVariable.getIndex();
            int column = aVariable.isStringVariable() ? 2 : 1;
            this.watchedVariablesTable.scrollRectToVisible(this.watchedVariablesTable.getCellRect(row, column, false));
            this.fireWatchedVariablesTableModelModified();
            if (watchedVariable.isWatchoint() && this.fx702pSwingKeyboardAndDisplay.isProgramRunning()) {
                this.emulator.suspendProgram();
            }
        }
    }

    @Override
    public void statVariablesCleared() {
        this.statVariablesModified();
    }

    @Override
    public void statVariablesModified() {
        if (this.basicProgram.isSuspendOnStatVariables() && this.fx702pSwingKeyboardAndDisplay.isProgramRunning()) {
            this.emulator.suspendProgram();
            for (JTextField statValueTextField : this.statValuesTextFields) {
                statValueTextField.setBackground(WATCHPOINT_COLOR);
            }
        }
        this.setStatValues();
    }

    protected void setStatValues() {
        for (JTextField statValueTextField : this.statValuesTextFields) {
            StatValueGetter statValueGetter = (StatValueGetter)statValueTextField.getClientProperty(STAT_VALUE_GETTER_PROPERTY);
            if (statValueGetter == null) continue;
            BigDecimal value = statValueGetter.getValue();
            if (value != null) {
                String valueAsString = Fx702pConstants.NORMAL_FORMATTER.format(value);
                statValueTextField.setText(valueAsString);
                continue;
            }
            statValueTextField.setText("");
        }
    }

    protected void watchedNormalVariables() {
        Vector<Fx702pMemory.WatchedVariable> normalVariables = new Vector<Fx702pMemory.WatchedVariable>();
        normalVariables.add(this.basicProgram.buildWatchVariable("$", this.memory.getDollarVariable()));
        for (int i = 0; i < 26; ++i) {
            char[] letter = new char[]{(char)(65 + i)};
            normalVariables.add(this.basicProgram.buildWatchVariable(new String(letter), this.memory.getVariable(i)));
        }
        this.basicProgram.addWatchVariables(normalVariables);
        for (Fx702pMemory.WatchedVariable watchedVariable : normalVariables) {
            this.watchedVariablesByVariable.put(watchedVariable.getVariable(), watchedVariable);
        }
        this.lastModifiedVariable = null;
        this.fireWatchedVariablesTableModelModified();
        this.tableExtraVerticalBox.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void watchVariable(String aName, Variable aVariable) {
        Fx702pMemory.WatchedVariable watchVariable = this.watchedVariablesByVariable.get(aVariable);
        if (watchVariable == null) {
            watchVariable = this.basicProgram.addWatchVariable(aName, aVariable);
            this.watchedVariablesByVariable.put(aVariable, watchVariable);
        } else {
            watchVariable.addAlias(aName);
        }
        int index = this.watchedVariablesByVariable.get(aVariable).getIndex();
        this.lastModifiedVariable = null;
        this.ignoreSelectionChanges = true;
        try {
            this.fireWatchedVariablesTableModelModified();
            this.watchedVariablesTable.getSelectionModel().setSelectionInterval(index, index);
            this.allowRemove();
        }
        finally {
            this.ignoreSelectionChanges = false;
        }
        this.watchedVariablesTable.scrollRectToVisible(this.watchedVariablesTable.getCellRect(index, 0, false));
        this.tableExtraVerticalBox.setVisible(false);
    }

    protected void removeWatchedVariable() {
        boolean removed = false;
        Variable variable = this.getValidatedTextFieldVariable();
        if (variable != null) {
            Fx702pMemory.WatchedVariable watchVariable = this.watchedVariablesByVariable.get(variable);
            if (watchVariable != null) {
                this.basicProgram.removeWatchVariable(watchVariable);
                this.watchedVariablesByVariable.remove(variable);
                removed = true;
            }
        } else {
            int[] indexes = this.watchedVariablesTable.getSelectedRows();
            if (indexes.length > 0) {
                Vector<Fx702pMemory.WatchedVariable> removedWatchVariables = new Vector<Fx702pMemory.WatchedVariable>();
                for (int i = indexes.length - 1; i >= 0; --i) {
                    Fx702pMemory.WatchedVariable watchedVariable = this.getWatchedVariables().get(i);
                    this.watchedVariablesByVariable.remove(watchedVariable.getVariable());
                    removedWatchVariables.add(watchedVariable);
                }
                this.basicProgram.removeWatchVariables(removedWatchVariables);
                removed = true;
            }
        }
        if (removed) {
            this.lastModifiedVariable = null;
            this.fireWatchedVariablesTableModelModified();
            this.watchedVariableTextField.setText("");
            this.validateTextField();
            if (this.getWatchedVariables().isEmpty()) {
                this.tableExtraVerticalBox.setVisible(true);
            }
        }
    }

    protected void fireWatchedVariablesTableModelModified() {
        if (this.watchedVariablesTable != null && this.watchedVariablesTable.getModel() != null) {
            ((AbstractTableModel)this.watchedVariablesTable.getModel()).fireTableDataChanged();
        }
    }

    protected void resetStatValuesBackground() {
        for (JTextField statValueTextField : this.statValuesTextFields) {
            statValueTextField.setBackground(this.defaultStatValueBackground);
        }
    }

    public void setRunMode() {
        this.resetStatValuesBackground();
    }

    public void setWrtMode() {
        this.resetStatValuesBackground();
    }

    public void runProgram() {
        this.resetStatValuesBackground();
    }

    public void endProgram() {
        this.resetStatValuesBackground();
    }

    public void contProgram() {
        this.resetStatValuesBackground();
    }

    public void resumeProgram() {
        this.resetStatValuesBackground();
    }

    public void stepInProgram() {
        this.resetStatValuesBackground();
    }

    public void debugAndStepActiveProgram() {
        this.resetStatValuesBackground();
    }

    protected static interface StatValueGetter {
        public BigDecimal getValue();
    }

    protected static class UppercaseDocumentFilter
    extends DocumentFilter {
        protected UppercaseDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass aFilterBypass, int anOffset, String aText, AttributeSet anAttributeSet) throws BadLocationException {
            if (aText != null) {
                aFilterBypass.insertString(anOffset, aText.toUpperCase(), anAttributeSet);
            }
        }

        public void replace(DocumentFilter.FilterBypass aFilterBypass, int anOffset, int aLength, String aText, AttributeSet anAttributeSet) throws BadLocationException {
            if (aText != null) {
                aFilterBypass.replace(anOffset, aLength, aText.toUpperCase(), anAttributeSet);
            }
        }
    }

    protected static class WatchpointCellRenderer
    extends DefaultTableCellRenderer {
        protected WatchpointCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable aTable, Object aValue, boolean aSelectedFlag, boolean aFocusFlag, int aRow, int aColumn) {
            Component rendererComponent = super.getTableCellRendererComponent(aTable, aValue, aSelectedFlag, aFocusFlag, aRow, aColumn);
            rendererComponent.setBackground(WATCHPOINT_COLOR);
            return rendererComponent;
        }
    }

    protected static class LastModifiedCellRenderer
    extends DefaultTableCellRenderer {
        protected LastModifiedCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable aTable, Object aValue, boolean aSelectedFlag, boolean aFocusFlag, int aRow, int aColumn) {
            Component rendererComponent = super.getTableCellRendererComponent(aTable, aValue, aSelectedFlag, aFocusFlag, aRow, aColumn);
            rendererComponent.setBackground(LAST_CHANGED_COLOR);
            return rendererComponent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WatchedVariablesTableModel
    extends AbstractTableModel {
        protected WatchedVariablesTableModel() {
        }

        @Override
        public String getColumnName(int aColumn) {
            return WATCHED_VARIABLES_COLUMNS_NAMES[aColumn];
        }

        @Override
        public int getRowCount() {
            return WatchPanel.this.getWatchedVariables().size();
        }

        @Override
        public int getColumnCount() {
            return WATCHED_VARIABLES_COLUMNS_NAMES.length;
        }

        public Class<? extends Object> getColumnClass(int aColumn) {
            switch (aColumn) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int aRow, int aColumn) {
            if (WatchPanel.this.getWatchedVariables().isEmpty()) {
                return null;
            }
            Fx702pMemory.WatchedVariable watchedVariable = WatchPanel.this.getWatchedVariables().get(aRow);
            switch (aColumn) {
                case 0: {
                    return watchedVariable.getName();
                }
                case 1: {
                    if (!watchedVariable.getVariable().isStringVariable()) {
                        return Fx702pConstants.NORMAL_FORMATTER.format((BigDecimal)watchedVariable.getVariable().getValue());
                    }
                    return null;
                }
                case 2: {
                    if (watchedVariable.getVariable().isStringVariable()) {
                        return watchedVariable.getVariable().getValue().toString();
                    }
                    return null;
                }
                case 3: {
                    return watchedVariable.isWatchoint();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int aRow, int aColumn) {
            return aColumn == 3;
        }

        @Override
        public void setValueAt(Object aValue, int aRow, int aColumn) {
            WatchPanel.this.getWatchedVariables().get(aRow).setWatchpoint((Boolean)aValue);
        }
    }
}

