/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation;

import com.edsdev.jconvert.domain.Conversion;
import com.edsdev.jconvert.presentation.ConversionsChangedListener;
import com.edsdev.jconvert.util.Logger;
import com.edsdev.jconvert.util.Messages;
import com.edsdev.jconvert.util.ResourceManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class AddCustomConversionDlg
extends JDialog {
    private final int WIDTH = 400;
    private final int HEIGHT = 450;
    private final String FILE_NAME = "convert_custom.dat";
    private JTextField txtConversionType = new JTextField();
    private JTextField txtFrom = new JTextField();
    private JTextField txtFromAbbrev = new JTextField();
    private JTextField txtTo = new JTextField();
    private JTextField txtToAbbrev = new JTextField();
    private JTextField txtFactor = new JTextField();
    private JTextField txtOffset = new JTextField();
    private JLabel lblFormula = new JLabel(Messages.getResource("conversionFormula"));
    private JLabel lblExample = new JLabel();
    private JButton okButton = new JButton(Messages.getResource("addButton"));
    private JButton cancelButton = new JButton(Messages.getResource("closeButton"));
    private ArrayList listeners = new ArrayList();
    private JTextArea txtData = new JTextArea();
    private JScrollPane scrollData = new JScrollPane();
    private static final Logger log = Logger.getInstance(class$com$edsdev$jconvert$presentation$AddCustomConversionDlg == null ? (class$com$edsdev$jconvert$presentation$AddCustomConversionDlg = AddCustomConversionDlg.class$("com.edsdev.jconvert.presentation.AddCustomConversionDlg")) : class$com$edsdev$jconvert$presentation$AddCustomConversionDlg);
    static /* synthetic */ Class class$com$edsdev$jconvert$presentation$AddCustomConversionDlg;

    public AddCustomConversionDlg(Frame frame) {
        super(frame);
        this.setTitle(Messages.getResource("addCustomTitle"));
        if (frame != null) {
            int n = frame.getX() + (frame.getWidth() - 400) / 2;
            int n2 = frame.getY() + (frame.getHeight() - 450) / 2;
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.setBounds(n, n2, 400, 450);
        } else {
            this.setBounds(10, 10, 400, 450);
        }
        this.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddCustomConversionDlg.this.saveData();
            }
        });
    }

    private void init() {
        this.getContentPane().setLayout(null);
        this.addLabel(Messages.getResource("conversionTypeLabel"), 5, 5, 100, 22);
        this.addComponent(this.txtConversionType, 110, 5, 200, 22);
        this.getContentPane().add(this.txtConversionType);
        this.addLabel(Messages.getResource("fromUnitLabel"), 5, 30, 100, 22);
        this.addComponent(this.txtFrom, 110, 30, 150, 22);
        this.addLabel(Messages.getResource("abbrevLabel"), 270, 30, 50, 22);
        this.addComponent(this.txtFromAbbrev, 330, 30, 50, 22);
        this.addLabel(Messages.getResource("toUnitLabel"), 5, 55, 100, 22);
        this.addComponent(this.txtTo, 110, 55, 150, 22);
        this.addLabel(Messages.getResource("abbrevLabel"), 270, 55, 50, 22);
        this.addComponent(this.txtToAbbrev, 330, 55, 50, 22);
        this.addLabel(Messages.getResource("factorLabel"), 5, 80, 100, 22);
        this.addComponent(this.txtFactor, 110, 80, 150, 22);
        this.addLabel(Messages.getResource("offsetLabel"), 5, 105, 100, 22);
        this.addComponent(this.txtOffset, 110, 105, 150, 22);
        this.txtOffset.setText("0");
        this.addComponent(this.okButton, 5, 180, 100, 25);
        this.addComponent(this.cancelButton, 110, 180, 100, 25);
        this.addComponent(this.lblFormula, 5, 130, 380, 22);
        this.addComponent(this.lblExample, 5, 155, 380, 22);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddCustomConversionDlg.this.addConversion();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddCustomConversionDlg.this.closeDialog();
            }
        });
        this.scrollData.getViewport().add(this.txtData);
        this.scrollData.setVerticalScrollBarPolicy(20);
        this.addComponent(this.scrollData, 5, 210, 380, 200);
        this.initializeData();
    }

    private void addKeyListenerToTextField(Component component) {
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    AddCustomConversionDlg.this.updateExample();
                }
            });
        }
    }

    private void updateExample() {
        String string = Messages.getResource("questionMark");
        double d = 0.0;
        try {
            d = new Double(this.txtOffset.getText());
            Conversion conversion = Conversion.createInstance(this.txtFrom.getText(), "", this.txtTo.getText(), "", this.txtFactor.getText(), d);
            string = new Double(conversion.convertValue(10.0, this.txtFrom.getText())).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblExample.setText("10 " + this.txtFrom.getText() + " " + Messages.getResource("multiplySymbol") + " " + this.txtFactor.getText() + " " + Messages.getResource("plusSign") + " " + this.txtOffset.getText() + " " + Messages.getResource("equalsSign") + " " + string + " " + this.txtTo.getText());
    }

    private String getFilePath() {
        String string = ResourceManager.getJarPath();
        log.debug("Here is the jar path: " + string);
        return string + "convert_custom.dat";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initializeData() {
        StringBuffer stringBuffer;
        block12: {
            stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(this.getFilePath()));
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
            }
            Object var5_5 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block12;
            }
            catch (Exception exception) {
                log.error("Failed to close the datafile after reading.", exception);
            }
            break block12;
            {
                catch (Exception exception) {
                    log.warn("No custom data file found here:" + this.getFilePath());
                    Object var5_6 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block12;
                    }
                    catch (Exception exception2) {
                        log.error("Failed to close the datafile after reading.", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    log.error("Failed to close the datafile after reading.", exception);
                }
                throw throwable;
            }
        }
        this.txtData.setText(stringBuffer.toString());
        this.scrollData.scrollRectToVisible(new Rectangle(0, this.txtData.getHeight()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void saveData() {
        block11: {
            var1_1 = null;
            try {
                var1_1 = new BufferedWriter(new FileWriter(this.getFilePath(), false));
                var1_1.write(this.txtData.getText());
                var1_1.flush();
                var4_2 = null;
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (Throwable var3_9) {
                var4_4 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (Exception var5_7) {
                        AddCustomConversionDlg.log.error("Failed to close the file", var5_7);
                    }
                }
                throw var3_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var1_1.close();
                }
                catch (Exception var5_5) {
                    AddCustomConversionDlg.log.error("Failed to close the file", var5_5);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (Exception var2_8) {
                    AddCustomConversionDlg.log.error("Failed to write the custom conversion.", var2_8);
                    var4_3 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (Exception var5_6) {
                            AddCustomConversionDlg.log.error("Failed to close the file", var5_6);
                        }
                    }
                }
            }
        }
        this.fireConversionsChanged();
    }

    private void closeDialog() {
        this.saveData();
        this.dispose();
    }

    public void addConversionsChangedListener(ConversionsChangedListener conversionsChangedListener) {
        this.listeners.add(conversionsChangedListener);
    }

    public void removeConversionsChangedListener(ConversionsChangedListener conversionsChangedListener) {
        this.listeners.remove(conversionsChangedListener);
    }

    private void fireConversionsChanged() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConversionsChangedListener conversionsChangedListener = (ConversionsChangedListener)iterator.next();
            conversionsChangedListener.conversionsUpdated();
        }
    }

    private boolean isEmpty(JTextComponent jTextComponent) {
        String string = jTextComponent.getText();
        return string == null || string.trim().equals("");
    }

    private void displayRequiredError(String string) {
        JOptionPane.showConfirmDialog(this, Messages.getResource("fieldIsRequired", string), Messages.getResource("fieldRequiredTitle"), -1, 0);
    }

    private boolean validComponent(JTextComponent jTextComponent, String string) {
        if (this.isEmpty(jTextComponent)) {
            this.displayRequiredError(string);
            jTextComponent.grabFocus();
            return false;
        }
        return true;
    }

    private void addConversion() {
        if (!this.validComponent(this.txtConversionType, Messages.getResource("conversionTypeLabel"))) {
            return;
        }
        if (!this.validComponent(this.txtFrom, Messages.getResource("fromUnitLabel"))) {
            return;
        }
        if (!this.validComponent(this.txtTo, Messages.getResource("toUnitLabel"))) {
            return;
        }
        if (!this.validComponent(this.txtFactor, Messages.getResource("factorLabel"))) {
            return;
        }
        if (!this.validComponent(this.txtOffset, Messages.getResource("offsetLabel"))) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n").append(Messages.getReverseLookup(this.txtConversionType.getText())).append(",").append(Messages.getReverseLookup(this.txtFrom.getText())).append(",").append(this.txtFromAbbrev.getText()).append(",").append(Messages.getReverseLookup(this.txtTo.getText())).append(",").append(this.txtToAbbrev.getText()).append(",").append(this.txtFactor.getText()).append(",").append(this.txtOffset.getText());
        this.txtData.setText(this.txtData.getText() + stringBuffer.toString());
        this.scrollData.scrollRectToVisible(new Rectangle(0, this.txtData.getHeight()));
    }

    private void addLabel(String string, int n, int n2, int n3, int n4) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBounds(n, n2, n3, n4);
        this.getContentPane().add(jLabel);
    }

    private void addComponent(Component component, int n, int n2, int n3, int n4) {
        component.setBounds(n, n2, n3, n4);
        this.getContentPane().add(component);
        this.addKeyListenerToTextField(component);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

