/*
 * Decompiled with CFR 0.152.
 */
package connection.socket;

import connection.socket.IConnection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;

public abstract class Connection
implements IConnection {
    protected Socket m_socket;
    protected ObjectOutputStream m_out;
    protected ObjectInputStream m_in;
    protected OutputStreamWriter m_outLog;
    protected int m_status;
    protected boolean m_debug;

    public void setIO() {
        if (this.m_socket == null) {
            this.m_status = 0;
            return;
        }
        try {
            if (this.m_debug) {
                System.out.println("Getting communication channels");
            }
            this.m_out = new ObjectOutputStream(this.m_socket.getOutputStream());
            if (this.m_debug) {
                System.out.println("Got output channel");
            }
            this.m_in = new ObjectInputStream(this.m_socket.getInputStream());
            if (this.m_debug) {
                System.out.println("Got input channel");
            }
            this.m_status = 1;
            return;
        }
        catch (IOException iOException) {
            this.output("Connect to client failed");
            this.m_status = 0;
            return;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public boolean wasLost() {
        return this.m_status == 2;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public void close() {
        try {
            if (this.m_in != null) {
                this.m_in.close();
            }
            if (this.m_out != null) {
                this.m_out.close();
            }
            if (this.m_socket != null) {
                this.m_socket.close();
            }
            this.m_status = 0;
            return;
        }
        catch (IOException iOException) {
            this.output("Cannot close");
            this.m_status = 2;
            return;
        }
    }

    void output(String string) {
        System.out.println(string);
    }

    void output(String[] stringArray) {
        if (stringArray == null) {
            System.out.println("ss = null");
            return;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.println("ss [" + n2 + "] = " + stringArray[n2]);
            ++n2;
        }
    }

    void output(double[] dArray) {
        if (dArray == null) {
            System.out.println("ss = null");
            return;
        }
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.println("ss [" + n2 + "] = " + dArray[n2]);
            ++n2;
        }
    }

    public String read() {
        if (this.m_status != 1) {
            return null;
        }
        try {
            String string = (String)this.m_in.readObject();
            if (this.m_debug) {
                this.output("Reading string");
                this.output(string);
            }
            return string;
        }
        catch (IOException iOException) {
            this.output("Error reading string");
            this.m_status = 2;
            this.lostConnection();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String[] readArray() {
        if (this.m_status != 1) {
            return null;
        }
        try {
            String[] stringArray = (String[])this.m_in.readObject();
            if (this.m_debug) {
                this.output("Reading array");
                this.output(stringArray);
            }
            return stringArray;
        }
        catch (IOException iOException) {
            this.output("Error reading strings");
            this.m_status = 2;
            this.lostConnection();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public double[] readDoubleArray() {
        if (this.m_status != 1) {
            return null;
        }
        try {
            double[] dArray = (double[])this.m_in.readObject();
            if (this.m_debug) {
                this.output("Reading double array");
                this.output(dArray);
            }
            return dArray;
        }
        catch (IOException iOException) {
            this.output("Error reading doubles");
            this.m_status = 2;
            this.lostConnection();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void write(String string) {
        if (this.m_status != 1) {
            return;
        }
        String string2 = null;
        if (string != null) {
            string2 = new String(string);
        }
        try {
            if (this.m_debug) {
                this.output("Writing string");
                this.output(string2);
            }
            this.m_out.writeObject(string2);
            this.m_out.flush();
            return;
        }
        catch (IOException iOException) {
            this.m_status = 2;
            this.lostConnection();
            return;
        }
    }

    public void writeArray(String[] stringArray) {
        if (this.m_status != 1) {
            return;
        }
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n = stringArray.length;
            stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray2[n2] = new String(stringArray[n2]);
                ++n2;
            }
        }
        try {
            if (this.m_debug) {
                this.output("Writing array");
                this.output(stringArray2);
            }
            this.m_out.writeObject(stringArray2);
            this.m_out.flush();
            return;
        }
        catch (IOException iOException) {
            this.m_status = 2;
            this.lostConnection();
            return;
        }
    }

    public void writeDoubleArray(double[] dArray) {
        if (this.m_status != 1) {
            return;
        }
        try {
            if (this.m_debug) {
                this.output("Writing double array");
                this.output(dArray);
            }
            this.m_out.writeObject(dArray);
            this.m_out.flush();
            return;
        }
        catch (IOException iOException) {
            this.m_status = 2;
            this.lostConnection();
            return;
        }
    }

    public void setOutLog(OutputStreamWriter outputStreamWriter) {
        this.m_outLog = outputStreamWriter;
    }

    protected abstract void lostConnection();

    public void connect(String string) {
    }
}

