/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.util.Locale;
import java.util.ResourceBundle;
import mathlib.DoubleFormat;
import mmguiclient.IParameters;
import structures.ParameterList;

class MMhistoryList
extends ParameterList
implements IParameters {
    int m_precision;
    String m_variable;

    public MMhistoryList() {
        super("X");
        this.m_value = new Double(0.0);
        this.m_precision = 15;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("mmguiclient.Resource", Locale.getDefault());
        this.m_variable = resourceBundle.getString("variable");
    }

    public MMhistoryList(MMhistoryList mMhistoryList, String string) {
        super(mMhistoryList, string);
    }

    public MMhistoryList next(MMhistoryList mMhistoryList) {
        return (MMhistoryList)super.next(mMhistoryList);
    }

    public MMhistoryList hlNext() {
        return this.next(this);
    }

    String getValue(String string) {
        MMhistoryList mMhistoryList = this.lookup(string);
        if (mMhistoryList == null) {
            return "";
        }
        if (mMhistoryList.m_isVariable) {
            return this.m_variable;
        }
        if (mMhistoryList.m_value == null) {
            return "";
        }
        return DoubleFormat.represent(mMhistoryList.m_value, this.m_precision);
    }

    void setValue(String string, String string2) {
        Double d;
        MMhistoryList mMhistoryList = this.lookup(string);
        if (mMhistoryList == null) {
            return;
        }
        if (string2.equals(this.m_variable)) {
            this.setVariable(mMhistoryList);
            return;
        }
        mMhistoryList.m_value = d = new Double(string2);
        mMhistoryList.m_isVariable = false;
    }

    void setVariable(MMhistoryList mMhistoryList) {
        if (mMhistoryList == null) {
            return;
        }
        MMhistoryList mMhistoryList2 = this;
        while (mMhistoryList2 != null) {
            mMhistoryList2.m_isVariable = false;
            mMhistoryList2 = mMhistoryList2.hlNext();
        }
        mMhistoryList.m_isVariable = true;
    }

    public void resetVariable(String string) {
        MMhistoryList mMhistoryList = this.lookup(string);
        if (mMhistoryList == null) {
            return;
        }
        mMhistoryList.m_isVariable = false;
    }

    void append(String string) {
        MMhistoryList mMhistoryList = this;
        while (mMhistoryList.next() != null) {
            mMhistoryList = mMhistoryList.hlNext();
        }
        mMhistoryList = new MMhistoryList(mMhistoryList, string);
    }

    void resetValue(String string) {
        MMhistoryList mMhistoryList = this.lookup(string);
        if (mMhistoryList == null) {
            return;
        }
        mMhistoryList.m_value = null;
        mMhistoryList.m_isVariable = false;
    }

    MMhistoryList lookup(String string) {
        MMhistoryList mMhistoryList = this;
        while (mMhistoryList != null) {
            if (string.equals(mMhistoryList.m_name)) break;
            mMhistoryList = mMhistoryList.hlNext();
        }
        return mMhistoryList;
    }

    public String queryName(String string) {
        MMhistoryList mMhistoryList = this.lookup(string);
        if (mMhistoryList == null) {
            this.append(string);
        }
        return this.getValue(string);
    }

    void cleanup() {
        MMhistoryList mMhistoryList = this;
        MMhistoryList mMhistoryList2 = mMhistoryList.hlNext();
        while (mMhistoryList2 != null) {
            if (mMhistoryList2.m_isVariable) {
                mMhistoryList2.m_isVariable = false;
            }
            if (mMhistoryList2.m_value == null) {
                mMhistoryList2 = mMhistoryList2.hlNext();
                mMhistoryList.setNext(mMhistoryList2);
                continue;
            }
            mMhistoryList = mMhistoryList2;
            mMhistoryList2 = mMhistoryList.hlNext();
        }
    }
}

