/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;
import mmguiclient.MMfield;
import mmguiclient.MMlist;
import mmguiclient.MMtypeSwitcher;

public class MMrow
extends Panel
implements IParameters,
ActionListener,
FocusListener,
KeyListener,
MouseListener {
    static final int FONT_SIZE = 10;
    static final int HEIGHT = 18;
    static final int NAME_WIDTH = 80;
    static final int EQU_WIDTH = 18;
    static final int VALUE_WIDTH = 140;
    static final int WIDTH = 238;
    public static int m_height;
    static final String EQU = "=";
    static final String V = "v";
    protected TextField m_nameField;
    protected MMtypeSwitcher m_equField;
    MMfield m_valueField;
    MMFrame m_frame;
    String m_variable;
    int m_index;

    static int getRowHeight() {
        int n = 18;
        switch (MMFrame.getOS()) {
            case 4: 
            case 5: 
            case 6: {
                n += 8;
            }
        }
        return n;
    }

    static Font getRowFont() {
        switch (MMFrame.getOS()) {
            case 4: {
                return new Font("Dialog", 0, 10);
            }
            case 5: {
                return new Font("Dialog", 0, 8);
            }
            case 6: {
                return new Font("Dialog", 0, 10);
            }
        }
        return new Font("Dialog", 0, 10);
    }

    public MMrow(MMFrame mMFrame, int n) {
        this.m_frame = mMFrame;
        this.m_index = n;
        Cursor cursor = new Cursor(0);
        this.m_variable = this.m_frame.m_resource.getString("variable");
        this.setLayout(null);
        Font font = MMrow.getRowFont();
        m_height = MMrow.getRowHeight();
        this.m_nameField = new TextField();
        this.m_nameField.setEditable(false);
        ((Component)this.m_nameField).setBackground(IParameters.WHITE);
        this.m_nameField.setCursor(cursor);
        if (font != null) {
            this.m_nameField.setFont(font);
        }
        int n2 = MMFrame.getOS();
        int n3 = 0;
        if (n2 == 6 || n2 == 4 || n2 == 5) {
            n3 = 8;
        }
        this.addit(this.m_nameField, 0, 0, 80 - n3, m_height);
        ((Component)this.m_nameField).getBackground();
        this.m_nameField.addFocusListener(this);
        this.m_valueField = new MMfield(this.m_frame);
        this.m_valueField.setEditable(false);
        ((Component)this.m_valueField).setBackground(IParameters.WHITE);
        if (font != null) {
            this.m_valueField.setFont(font);
        }
        this.addit(this.m_valueField, 98, 0, 140, m_height);
        this.m_equField = new MMtypeSwitcher();
        this.m_equField.setClickable(false);
        this.m_equField.setEditable(false);
        this.m_equField.setCursor(cursor);
        if (font != null && this.m_frame.m_os != 3) {
            this.m_equField.setFont(font);
        }
        this.addit(this.m_equField, 80 - n3, 0, 18 + n3, m_height);
        this.m_equField.addFocusListener(this);
        this.addFocusListener(this);
        this.m_valueField.addFocusListener(this);
        this.m_valueField.addKeyListener(this);
        this.m_nameField.addMouseListener(this);
        this.m_valueField.addMouseListener(this);
        this.m_equField.addMouseListener(this);
    }

    void addit(Component component, int n, int n2, int n3, int n4) {
        component.setBounds(n, n2, n3, n4);
        this.add(component);
    }

    void addListener(ActionListener actionListener) {
        this.m_valueField.addActionListener(actionListener);
    }

    public String getValue() {
        return this.m_valueField.getText();
    }

    public void setValue(String string) {
        ((TextComponent)this.m_valueField).setText(string);
        this.m_valueField.setEditable(true);
        if (string.equals(this.m_variable)) {
            this.m_valueField.setEditable(false);
            this.m_equField.setForeground(IParameters.LABEL_COLOR);
            this.m_equField.setLabel(V);
            return;
        }
        this.m_valueField.setEditable(true);
        this.m_equField.setForeground(IParameters.BLACK);
        this.m_equField.setLabel(EQU);
    }

    public String getName() {
        return this.m_nameField.getText();
    }

    public void setName(String string) {
        if (!this.m_nameField.getText().equals(string)) {
            ((TextComponent)this.m_nameField).setText(string);
        }
        if (!string.equals("")) {
            if (!this.m_equField.getLabel().equals(EQU)) {
                this.m_equField.setLabel(EQU);
            }
            this.m_valueField.setEditable(true);
            return;
        }
        if (!this.m_valueField.getText().equals("")) {
            this.setValue("");
        }
        this.m_valueField.setEditable(false);
        if (!this.m_equField.getLabel().equals("")) {
            this.m_equField.setLabel("");
        }
    }

    public void setBoth(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    public void setEnabled(boolean bl) {
        this.m_equField.setClickable(bl);
    }

    void addItemValue() {
        String string = this.getValue();
        if (string.equals("")) {
            this.resetValue();
            return;
        }
        this.m_frame.m_hList.setValue(this.getName(), this.getValue());
    }

    void resetValue() {
        this.m_frame.m_hList.resetValue(this.getName());
    }

    void resetVariable() {
        this.m_frame.m_hList.resetVariable(this.getName());
    }

    void setVariable() {
        this.m_frame.m_hList.setValue(this.getName(), this.m_variable);
    }

    public void refresh() {
        String string = this.getValue();
        if (string.equals(this.m_variable)) {
            string = this.m_frame.m_hList.queryName(this.getName());
            this.setValue(string);
        }
    }

    public void clear() {
        this.setName("");
    }

    public boolean update(boolean bl) {
        String string = this.getValue();
        if (string.equals(this.m_valueField.m_lastString)) {
            return true;
        }
        if (string.equals(this.m_variable)) {
            return true;
        }
        this.m_valueField.update();
        return this.calculate(bl);
    }

    public boolean calculate(boolean bl) {
        String string = this.m_valueField.m_lastString;
        String string2 = this.m_frame.m_resource.getString("result");
        if (string.equals("")) {
            this.resetValue();
            return false;
        }
        if (string.equals(this.m_variable) && this.m_frame.getOperation() > 0) {
            return true;
        }
        try {
            string = this.m_frame.m_server.calculate(string, this.m_frame.getPrecision());
        }
        catch (Exception exception) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (!string.startsWith(string2)) {
            if (bl) {
                this.m_frame.showWarning(string);
            }
            return false;
        }
        int n = string.indexOf(" (");
        if (n < 0) {
            n = string.length();
        }
        if ((string = string.substring(string2.length(), n)).equals("NaN")) {
            this.resetValue();
            if (bl) {
                this.m_frame.showWarning(this.m_frame.m_resource.getString("init_error"));
            }
            return false;
        }
        this.setValue(string);
        this.addItemValue();
        this.m_valueField.update();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.m_frame.getMode();
        if (n > 0 && n != 6) {
            this.toggle();
            this.m_frame.m_list.update();
        }
    }

    public void toggle() {
        if (this.m_equField.getLabel().equals(EQU)) {
            try {
                this.addItemValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.m_valueField.update();
            }
            this.setVariable();
            this.setValue(this.m_variable);
            return;
        }
        this.resetVariable();
        String string = this.m_frame.m_hList.getValue(this.getName());
        this.setValue(string);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.m_valueField.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            keyEvent.consume();
            if ((keyEvent.getModifiers() & 1) > 0) {
                ((MMlist)this.getParent()).dispatchFocus(this.m_index);
                return;
            }
            this.transferFocus();
            return;
        }
        if (keyEvent.getKeyCode() == 86 && (keyEvent.getModifiers() & 8) > 0) {
            int n = this.m_frame.getMode();
            if (n > 0 && n != 6) {
                this.toggle();
                this.m_frame.m_list.update();
            }
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.m_frame.getMode() == 6 && mouseEvent.getClickCount() > 1) {
            this.macroAction();
        }
    }

    void macroAction() {
        ((TextComponent)this.m_frame.m_upLimit).setText(this.getName());
        ((TextComponent)this.m_frame.m_inputLine).setText(this.getValue());
        this.m_frame.m_inputLine.requestFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

