/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;
import mmguiclient.MMprecisionBox;

public class MMslider
extends Panel
implements IParameters,
MouseListener,
FocusListener,
KeyListener {
    static final Color COLOR1 = IParameters.WHITE;
    static final Color COLOR2 = Color.lightGray;
    static final Color COLOR3 = Color.darkGray;
    static final Color COLOR4 = IParameters.BLACK;
    static final int MARGIN = 4;
    static final int NUM_TICKS = 15;
    static final int TICK_SPACING = 10;
    static final int THUMB_HEIGHT = 15;
    static final int THUMB_WIDTH = 8;
    static final int WIDTH = 157;
    static final int HEIGHT = 23;
    protected int m_value;
    protected boolean m_focus;
    protected MMFrame m_frame;

    public MMslider() {
        this.setBackground(IParameters.BACKGROUND_COLOR);
        this.m_value = 6;
        this.addMouseListener(this);
        this.m_focus = false;
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public MMslider(MMFrame mMFrame) {
        this();
        this.m_frame = mMFrame;
    }

    public int getValue() {
        return this.m_value;
    }

    public void setValue(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 15) {
            n = 15;
        }
        if (n != this.m_value) {
            this.m_value = n;
            this.repaint();
            ((MMprecisionBox)this.getParent()).setPrecision(n);
        }
    }

    public void paint(Graphics graphics) {
        if (this.m_focus) {
            graphics.setColor(COLOR3);
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        int n = 11;
        graphics.setColor(COLOR4);
        graphics.drawLine(5, n, 152, n);
        int n2 = 0;
        while (n2 < 15) {
            graphics.drawLine(9 + n2 * 10, n - 7 + 4, 9 + n2 * 10, n + 7 - 3);
            ++n2;
        }
        graphics.setColor(COLOR1);
        graphics.drawLine(4, n + 2, 153, n + 2);
        graphics.drawLine(153, n + 2, 153, n - 1);
        graphics.setColor(COLOR2);
        graphics.drawLine(5, n + 1, 152, n + 1);
        graphics.setColor(COLOR3);
        graphics.drawLine(4, n - 1, 153, n - 1);
        graphics.drawLine(4, n + 2, 4, n - 1);
        int n3 = (this.m_value - 1) * 10 + 4 + 1;
        graphics.setColor(COLOR2);
        graphics.fill3DRect(n3, n - 7, 8, 15, true);
        graphics.fill3DRect(n3 + 1, n - 7 + 1, 6, 13, true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = (mouseEvent.getX() - 1 - 4) / 10 + 1;
        this.setValue(n);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = (mouseEvent.getX() - 1 - 4) / 10 + 1;
        this.setValue(n);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.m_focus = true;
        if (this.m_frame != null) {
            this.m_frame.m_focusHolder = null;
        }
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.m_focus = false;
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            this.setValue(this.getValue() - 1);
            return;
        }
        if (keyEvent.getKeyCode() == 39) {
            this.setValue(this.getValue() + 1);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

