/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import mmguiclient.IParameters;
import mmguiclient.MMimageResource;
import mmguiclient.MMtoolbar;

public class MMtool
extends Panel
implements IParameters,
MouseListener {
    static final int ICON_HEIGHT = 16;
    static final int ICON_WIDTH = 12;
    static final int HGAP = 3;
    static final int HEIGHT = 22;
    int m_width;
    protected Image m_image;
    protected String m_title;
    int m_id;
    boolean m_selected;
    boolean m_highlighted;
    int m_x;

    public MMtool(int n, String string, int n2) {
        this.m_id = n;
        this.setLayout(null);
        this.setBackground(IParameters.BACKGROUND_COLOR);
        this.display(string);
        this.addMouseListener(this);
        this.m_selected = false;
        this.m_highlighted = false;
        this.m_width = 0;
        this.m_x = n2;
    }

    public void display(String string) {
        try {
            this.m_image = new MMimageResource().getImage(string);
        }
        catch (Exception exception) {}
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.m_image == null) {
            return;
        }
        graphics.getFontMetrics();
        int n = this.m_x;
        if (this.m_selected) {
            graphics.setColor(IParameters.BACKGROUND_COLOR);
            graphics.fill3DRect(2, 0, n - 2, 22, false);
            graphics.fillRect(3, 1, n - 5, 20);
        } else if (this.m_highlighted) {
            graphics.setColor(IParameters.BACKGROUND_COLOR);
            graphics.fill3DRect(1, 0, n - 1, 22, true);
        }
        this.m_width = n;
        int n2 = this.m_selected ? 1 : 0;
        graphics.drawImage(this.m_image, 6 + n2, 3 + n2, this);
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean bl) {
        if (this.m_selected == bl) {
            return;
        }
        this.m_selected = bl;
        ((MMtoolbar)this.getParent()).setMode(this.m_id);
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.setSelected(true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setSelected(true);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_highlighted = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_highlighted = false;
        this.repaint();
    }
}

