/*
 * Decompiled with CFR 0.152.
 */
package structures;

import eserver.IEngineServer;
import structures.LinkedList;
import structures.TokenList;
import tokens.Macro;

public final class MacroList
extends LinkedList {
    Macro m_macro;

    public MacroList(Macro macro) {
        this.m_macro = macro;
    }

    public MacroList(MacroList macroList, Macro macro) {
        super(macroList);
        this.m_macro = macro;
    }

    public MacroList(Macro[] macroArray) {
        MacroList macroList = this;
        if (macroArray != null) {
            int n = macroArray.length;
            if (n < 1) {
                return;
            }
            this.m_macro = macroArray[0];
            int n2 = 1;
            while (n2 < n) {
                if (macroArray[n2] != null) {
                    macroList = new MacroList(macroList, macroArray[n2]);
                }
                ++n2;
            }
        }
    }

    public MacroList(String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            if (n < 1) {
                return;
            }
            this.m_macro = new Macro(stringArray[0]);
            int n2 = 1;
            while (n2 < n) {
                this.addMacro(new Macro(stringArray[n2]));
                ++n2;
            }
        }
    }

    public MacroList(TokenList tokenList) {
        if (tokenList == null) {
            return;
        }
        tokenList.length();
        TokenList tokenList2 = tokenList;
        this.m_macro = new Macro(tokenList.getToken());
        while (tokenList2 != null) {
            this.addMacro(new Macro(tokenList2.getToken()));
            tokenList2 = tokenList2.next();
        }
    }

    public MacroList next(MacroList macroList) {
        return (MacroList)super.next(macroList);
    }

    public MacroList next(MacroList macroList, int n) {
        return (MacroList)super.next(macroList, n);
    }

    public MacroList next() {
        return this.next(this);
    }

    public MacroList next(int n) {
        return this.next(this, n);
    }

    Macro macroAt(int n) {
        MacroList macroList = this.next(n);
        if (macroList == null) {
            return null;
        }
        return macroList.m_macro;
    }

    void setMacroAt(int n, Macro macro) {
        MacroList macroList = this.next(n);
        if (macroList != null) {
            macroList.m_macro = macro;
        }
    }

    int getMacroIndex(String string) {
        MacroList macroList = this;
        int n = 0;
        while (macroList != null) {
            if (macroList.m_macro.m_name.equals(string.trim())) {
                return n;
            }
            macroList = macroList.next();
            ++n;
        }
        return -1;
    }

    public boolean macroExists(String string) {
        return this.getMacroIndex(string) > -1;
    }

    /*
     * Unable to fully structure code
     */
    public MacroList removeMacro(String var1_1) {
        var2_2 = this;
        var3_3 = this.next();
        if (!this.m_macro.m_name.equals(var1_1.trim())) ** GOTO lbl11
        return this.next();
lbl-1000:
        // 1 sources

        {
            if (var3_3.m_macro.m_name.equals(var1_1.trim())) {
                var2_2.m_next = var3_3.m_next;
                var3_3.m_macro = null;
                return this;
            }
            var2_2 = var3_3;
            var3_3 = var2_2.next();
lbl11:
            // 2 sources

            ** while (var3_3 != null)
        }
lbl12:
        // 1 sources

        return this;
    }

    public MacroList addMacro(Macro macro) {
        if (macro == null) {
            return this;
        }
        MacroList macroList = this;
        int n = this.getMacroIndex(macro.m_name);
        if (n > -1) {
            if (macro.m_definition.trim().equals("")) {
                return this.removeMacro(macro.m_name);
            }
            this.setMacroAt(n, macro);
            return this;
        }
        MacroList macroList2 = this.next();
        while (macroList2 != null) {
            macroList = macroList2;
            macroList2 = macroList.next();
        }
        macroList2 = new MacroList(macroList, macro);
        return this;
    }

    public Macro getMacro() {
        return this.m_macro;
    }

    public String[] toStrings() {
        int n = this.length();
        if (n == 1 && this.m_macro == null) {
            n = 0;
        }
        String[] stringArray = new String[n];
        MacroList macroList = this;
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = macroList.m_macro.toString();
            macroList = macroList.next();
            ++n2;
        }
        return stringArray;
    }

    public MacroList verifyMacros(IEngineServer iEngineServer) {
        MacroList macroList = this.next();
        MacroList macroList2 = null;
        MacroList macroList3 = null;
        iEngineServer.setMacros(null);
        if (this.m_macro.verify(iEngineServer)) {
            macroList3 = macroList2 = new MacroList(this.m_macro);
        }
        while (macroList != null) {
            if (macroList2 != null) {
                iEngineServer.setMacros(macroList2.toStrings());
            }
            if (macroList.m_macro.verify(iEngineServer)) {
                macroList3 = macroList3 == null ? (macroList2 = new MacroList(macroList.m_macro)) : new MacroList(macroList3, macroList.m_macro);
            }
            macroList = macroList.next();
        }
        return macroList2;
    }

    public int params(IEngineServer iEngineServer) {
        return this.m_macro.params(iEngineServer);
    }
}

