/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.gui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class PropertiesMetalTheme
extends DefaultMetalTheme {
    private String name = "Custom Theme";
    private ColorUIResource primary1;
    private ColorUIResource primary2;
    private ColorUIResource primary3;
    private ColorUIResource secondary1;
    private ColorUIResource secondary2;
    private ColorUIResource secondary3;
    private ColorUIResource black;
    private ColorUIResource white;
    private ColorUIResource menuBackground;
    private FontUIResource controlTextFont;
    private FontUIResource systemTextFont;
    private FontUIResource userTextFont;
    private FontUIResource menuTextFont;
    private FontUIResource windowTitleFont;
    private FontUIResource subTextFont;

    public PropertiesMetalTheme(InputStream stream) {
        this.initColors();
        this.loadProperties(stream);
    }

    private void initColors() {
        this.primary1 = super.getPrimary1();
        this.primary2 = super.getPrimary2();
        this.primary3 = super.getPrimary3();
        this.secondary1 = super.getSecondary1();
        this.secondary2 = super.getSecondary2();
        this.secondary3 = super.getSecondary3();
        this.black = super.getBlack();
        this.white = super.getWhite();
        this.menuBackground = super.getMenuBackground();
        this.controlTextFont = super.getControlTextFont();
        this.systemTextFont = super.getSystemTextFont();
        this.userTextFont = super.getUserTextFont();
        this.menuTextFont = super.getMenuTextFont();
        this.windowTitleFont = super.getWindowTitleFont();
        this.subTextFont = super.getSubTextFont();
    }

    private void loadProperties(InputStream stream) {
        this.initColors();
        Properties prop = new Properties();
        try {
            prop.load(stream);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        Object tempName = prop.get("name");
        if (tempName != null) {
            this.name = tempName.toString();
        }
        Object colorString = null;
        colorString = prop.get("primary1");
        if (colorString != null) {
            this.primary1 = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("primary2")) != null) {
            this.primary2 = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("primary3")) != null) {
            this.primary3 = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("secondary1")) != null) {
            this.secondary1 = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("secondary2")) != null) {
            this.secondary2 = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("secondary3")) != null) {
            this.secondary3 = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("black")) != null) {
            this.black = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        if ((colorString = prop.get("white")) != null) {
            this.white = PropertiesMetalTheme.parseColor(colorString.toString());
        }
        this.menuBackground = (colorString = prop.get("MenuBackground")) != null ? PropertiesMetalTheme.parseColor(colorString.toString()) : this.secondary3;
        Object fontString = null;
        fontString = prop.get("ControlTextFont");
        if (fontString != null) {
            this.controlTextFont = PropertiesMetalTheme.parseFont(fontString.toString());
        }
        if ((fontString = prop.get("SystemTextFont")) != null) {
            this.systemTextFont = PropertiesMetalTheme.parseFont(fontString.toString());
        }
        if ((fontString = prop.get("UserTextFont")) != null) {
            this.userTextFont = PropertiesMetalTheme.parseFont(fontString.toString());
        }
        if ((fontString = prop.get("MenuTextFont")) != null) {
            this.menuTextFont = PropertiesMetalTheme.parseFont(fontString.toString());
        }
        if ((fontString = prop.get("WindowTitleFont")) != null) {
            this.windowTitleFont = PropertiesMetalTheme.parseFont(fontString.toString());
        }
        if ((fontString = prop.get("SubTextFont")) != null) {
            this.subTextFont = PropertiesMetalTheme.parseFont(fontString.toString());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    public ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    public ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    public ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    public ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    public ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    @Override
    protected ColorUIResource getBlack() {
        return this.black;
    }

    @Override
    protected ColorUIResource getWhite() {
        return this.white;
    }

    @Override
    public ColorUIResource getMenuBackground() {
        return this.menuBackground;
    }

    @Override
    public FontUIResource getControlTextFont() {
        return this.controlTextFont;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return this.systemTextFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return this.userTextFont;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return this.menuTextFont;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return this.windowTitleFont;
    }

    @Override
    public FontUIResource getSubTextFont() {
        return this.subTextFont;
    }

    private static ColorUIResource parseColor(String s) {
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            StringTokenizer st = new StringTokenizer(s, ",");
            red = Integer.parseInt(st.nextToken());
            green = Integer.parseInt(st.nextToken());
            blue = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Couldn't parse color :" + s);
        }
        return new ColorUIResource(red, green, blue);
    }

    private static FontUIResource parseFont(String s) {
        String name = "Dialog";
        String temp = null;
        int style = 0;
        int size = 12;
        try {
            StringTokenizer st = new StringTokenizer(s, ",");
            name = st.nextToken();
            temp = st.nextToken();
            if (temp.equals("bold")) {
                style = 1;
            } else if (temp.equals("plain")) {
                style = 0;
            } else if (temp.equals("italic")) {
                style = 2;
            }
            size = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            System.out.println("Couldn't parse font:" + s);
        }
        return new FontUIResource(name, style, size);
    }
}

