/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import jonelo.sugar.gui.GeneralGUI;

public class SplashScreen
extends JWindow {
    JLabel statusBar;

    public SplashScreen(ImageIcon icon) {
        this.setVisible(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SplashScreen.this.setVisible(false);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.statusBar = new JLabel(" ", 0);
        this.statusBar.setFont(new Font("Dialog", 0, 12));
        this.statusBar.setForeground(Color.white);
        panel.setBackground(Color.black);
        panel.add((Component)label, "Center");
        panel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        GeneralGUI.centerComponent(this);
        this.setVisible(true);
        this.toFront();
    }

    public void showStatus(String currentStatus) {
        try {
            SwingUtilities.invokeLater(new UpdateStatus(currentStatus));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            SwingUtilities.invokeLater(new CloseSplashScreen());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class CloseSplashScreen
    implements Runnable {
        CloseSplashScreen() {
        }

        @Override
        public void run() {
            SplashScreen.this.setVisible(false);
            SplashScreen.this.dispose();
        }
    }

    class UpdateStatus
    implements Runnable {
        String newStatus;

        public UpdateStatus(String status) {
            this.newStatus = status;
        }

        @Override
        public void run() {
            SplashScreen.this.statusBar.setText(this.newStatus);
        }
    }
}

