/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jonelo.sugar.math.GeneralMath;

public class Rational {
    private BigInteger zaehler;
    private BigInteger nenner;
    static final String POSINT = "(\\d+)";
    static final String BLANK = " ";
    public static final int EMPTY = 0;
    public static final int NORMAL = 1;
    public static final int MIXED = 2;
    public static final int DECIMAL = 3;

    public Rational() {
        this.zaehler = BigInteger.ZERO;
        this.nenner = BigInteger.ONE;
    }

    public Rational(BigInteger zaehler) {
        this.zaehler = zaehler;
        this.nenner = BigInteger.ONE;
    }

    public Rational(int zaehler, int nenner) {
        this((long)zaehler, (long)nenner);
    }

    public Rational(long zaehler, long nenner) {
        this.zaehler = BigInteger.valueOf(zaehler);
        this.nenner = BigInteger.valueOf(nenner);
    }

    public Rational(BigInteger zaehler, BigInteger nenner) {
        if (nenner.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("division by 0");
        }
        this.zaehler = zaehler;
        this.nenner = nenner;
        this.kuerzen();
    }

    public Rational(BigDecimal decimal) {
        int signum = decimal.signum();
        BigDecimal ganze = BigDecimal.ZERO;
        BigDecimal rest = decimal;
        if (decimal.compareTo(BigDecimal.ONE) >= 0) {
            ganze = decimal.setScale(0, RoundingMode.DOWN);
            rest = decimal.subtract(ganze);
        }
        int scale = rest.scale();
        this.zaehler = rest.abs().movePointRight(scale).toBigInteger();
        this.nenner = BigDecimal.ONE.movePointRight(scale).toBigInteger();
        this.zaehler = ganze.toBigIntegerExact().multiply(this.nenner).add(this.zaehler).multiply(BigInteger.valueOf(signum));
        this.kuerzen();
    }

    public void signBeautyfuling() {
        int signum = this.zaehler.signum() * this.nenner.signum();
        this.zaehler = this.zaehler.abs();
        this.nenner = this.nenner.abs();
        if (signum == -1) {
            this.zaehler = this.zaehler.multiply(BigInteger.valueOf(signum));
        }
    }

    private boolean checkNormalInput(String input) {
        Pattern pattern1 = Pattern.compile("^\\s*([-]??)\\s*(\\d+)\\s*/\\s*(\\d+)\\s*$");
        Matcher matcher = pattern1.matcher(input);
        boolean negative = false;
        if (matcher.find()) {
            negative = matcher.group(1).equals("-");
            this.zaehler = new BigInteger(matcher.group(2));
            this.nenner = new BigInteger(matcher.group(3));
            if (this.nenner.equals(BigInteger.ZERO)) {
                throw new ArithmeticException("division by 0");
            }
            if (negative) {
                this.zaehler = this.zaehler.multiply(BigInteger.valueOf(-1L));
            }
            return true;
        }
        return false;
    }

    private boolean checkEmptyInput(String input) {
        if (input.length() == 0) {
            this.zaehler = BigInteger.ZERO;
            this.nenner = BigInteger.ONE;
            return true;
        }
        return false;
    }

    private boolean checkMixedInput(String input) {
        String INT = "([-]??\\d+)";
        Pattern pattern2 = Pattern.compile("^\\s*([-]??\\d+) \\s*(\\d+)\\s*/\\s*(\\d+)\\s*$");
        Matcher matcher = pattern2.matcher(input);
        if (matcher.find()) {
            BigInteger ganze = new BigInteger(matcher.group(1));
            int signum = ganze.signum();
            ganze = ganze.abs();
            this.zaehler = new BigInteger(matcher.group(2));
            this.nenner = new BigInteger(matcher.group(3));
            if (this.nenner.equals(BigInteger.ZERO)) {
                throw new ArithmeticException("division by 0");
            }
            this.zaehler = ganze.multiply(this.nenner).add(this.zaehler);
            if (signum == -1) {
                this.zaehler = this.zaehler.multiply(BigInteger.valueOf(signum));
            }
            return true;
        }
        return false;
    }

    private boolean checkDecimalInput(String input) {
        String periodDelimiters = "[\\~_pP\u00af]{1}";
        Pattern patternExact = Pattern.compile("^([-]??\\d+)(\\.\\d*([\\~_pP\u00af]{1}\\d+)??)??$");
        Matcher matcher = patternExact.matcher(input);
        if (matcher.find()) {
            Pattern patternPeriod;
            Pattern patternNoPeriod;
            Rational result = new Rational();
            boolean negative = false;
            Pattern patternInteger = Pattern.compile("^([-]??\\d+)$");
            matcher = patternInteger.matcher(input);
            if (matcher.find()) {
                this.zaehler = new BigInteger(input);
                this.nenner = BigInteger.ONE;
                return true;
            }
            String afterTheComma = null;
            Pattern patternDecimal = Pattern.compile("^([-]??)(\\d+)\\.(.+)$");
            matcher = patternDecimal.matcher(input);
            if (matcher.find()) {
                negative = matcher.group(1).equals("-");
                result.setZaehler(new BigInteger(matcher.group(2)).abs());
                result.setNenner(BigInteger.ONE);
                afterTheComma = matcher.group(3);
            }
            if ((matcher = (patternNoPeriod = Pattern.compile("^(\\d+)$")).matcher(afterTheComma)).find()) {
                String nonPeriodicPart = matcher.group(1);
                result = result.add(this.nonPeriodicRational(nonPeriodicPart));
            }
            if ((matcher = (patternPeriod = Pattern.compile("^(\\d*)([\\~_pP\u00af]{1})(\\d+)$")).matcher(afterTheComma)).find()) {
                String nonPeriodicPart = matcher.group(1);
                if (nonPeriodicPart.length() > 0) {
                    result = result.add(this.nonPeriodicRational(nonPeriodicPart));
                }
                String periodicPart = matcher.group(3);
                result = result.add(this.periodicRational(nonPeriodicPart, periodicPart));
            }
            this.nenner = result.getNenner();
            if (this.nenner.equals(BigInteger.ZERO)) {
                throw new ArithmeticException("division by 0");
            }
            this.zaehler = result.getZaehler();
            if (negative) {
                this.zaehler = this.zaehler.multiply(BigInteger.valueOf(-1L));
            }
            return true;
        }
        return false;
    }

    private Rational periodicRational(String nonPeriodicPart, String periodicPart) {
        BigInteger z2 = new BigInteger(periodicPart);
        BigInteger n2 = BigDecimal.ONE.movePointRight(periodicPart.length()).subtract(BigDecimal.ONE).movePointRight(nonPeriodicPart.length()).toBigInteger();
        System.out.println(z2 + "/" + n2);
        return new Rational(z2, n2);
    }

    private Rational nonPeriodicRational(String nonPeriodicPart) {
        BigInteger z = new BigInteger(nonPeriodicPart);
        BigInteger n = BigDecimal.ONE.movePointRight(nonPeriodicPart.length()).toBigInteger();
        return new Rational(z, n);
    }

    public Rational(String input, int type) {
        boolean success = false;
        switch (type) {
            case 0: {
                success = this.checkEmptyInput(input);
                break;
            }
            case 2: {
                success = this.checkMixedInput(input);
                break;
            }
            case 3: {
                success = this.checkDecimalInput(input);
                break;
            }
            default: {
                success = this.checkNormalInput(input);
            }
        }
        if (!success) {
            throw new IllegalArgumentException("invalid");
        }
        this.kuerzen();
    }

    public Rational(String input) {
        boolean validInput = false;
        validInput = this.checkEmptyInput(input);
        if (!validInput) {
            validInput = this.checkNormalInput(input);
        }
        if (!validInput) {
            validInput = this.checkMixedInput(input);
        }
        if (!validInput) {
            validInput = this.checkDecimalInput(input);
        }
        if (!validInput) {
            throw new IllegalArgumentException("invalid");
        }
        this.kuerzen();
    }

    public BigInteger getZaehler() {
        return this.zaehler;
    }

    public BigInteger getNenner() {
        return this.nenner;
    }

    public boolean isNegative() {
        int signum = this.zaehler.signum() * this.nenner.signum();
        return signum == -1;
    }

    public Rational add(Rational rational) {
        Rational ret = new Rational();
        Rational temp = rational;
        temp.signBeautyfuling();
        this.signBeautyfuling();
        ret.setZaehler(this.getZaehler().multiply(rational.getNenner()).add(this.getNenner().multiply(rational.getZaehler())));
        ret.setNenner(this.getNenner().multiply(rational.getNenner()));
        ret.signBeautyfuling();
        ret.kuerzen();
        return ret;
    }

    public Rational multiply(Rational rational) {
        Rational ret = new Rational();
        Rational temp = rational;
        temp.signBeautyfuling();
        this.signBeautyfuling();
        ret.setZaehler(this.getZaehler().multiply(rational.getZaehler()));
        ret.setNenner(this.getNenner().multiply(rational.getNenner()));
        ret.signBeautyfuling();
        ret.kuerzen();
        return ret;
    }

    public void setZaehler(BigInteger zaehler) {
        this.zaehler = zaehler;
    }

    public void setNenner(BigInteger nenner) {
        this.nenner = nenner;
    }

    private void kuerzen() {
        BigInteger gcd = this.zaehler.gcd(this.nenner);
        this.zaehler = this.zaehler.divide(gcd);
        this.nenner = this.nenner.divide(gcd);
    }

    public String toDecStringRounded(int scale) {
        BigDecimal ret = new BigDecimal(this.zaehler).divide(new BigDecimal(this.nenner), scale, 4);
        return ret.toString();
    }

    public String toSciStringRounded(int precision) {
        BigDecimal result = new BigDecimal(this.zaehler).divide(new BigDecimal(this.nenner), precision, 4);
        return GeneralMath.decimal2Scientific(result.toPlainString(), precision);
    }

    public String toDecStringExact() {
        StringBuilder sb = new StringBuilder();
        BigInteger[] value = this.zaehler.abs().divideAndRemainder(this.nenner);
        if (this.zaehler.compareTo(BigInteger.ZERO) < 0) {
            sb.append("-");
        }
        sb.append(value[0]);
        if (value[1].compareTo(BigInteger.ZERO) > 0) {
            sb.append(Rational.asComma(value[1], this.nenner));
        }
        return sb.toString();
    }

    public String toString() {
        return this.zaehler + "/" + this.nenner;
    }

    public String toMixedString() {
        StringBuilder sb = new StringBuilder();
        BigInteger[] value = this.zaehler.abs().divideAndRemainder(this.nenner);
        if (this.zaehler.compareTo(BigInteger.ZERO) < 0) {
            sb.append("-");
        }
        if (value[0].compareTo(BigInteger.ZERO) > 0) {
            sb.append(value[0]);
            sb.append(BLANK);
        }
        sb.append(value[1]);
        sb.append("/");
        sb.append(this.nenner);
        return sb.toString();
    }

    public static String asComma(BigInteger dividend, BigInteger divisor) {
        BigInteger TEN = BigInteger.valueOf(10L);
        StringBuilder sb = new StringBuilder();
        BigInteger ganz = BigInteger.ZERO;
        BigInteger rest = BigInteger.valueOf(-1L);
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>();
        boolean ende = false;
        int i = 0;
        while (BigInteger.valueOf(i).compareTo(divisor) < 0 && !rest.equals(BigInteger.ZERO)) {
            dividend = dividend.multiply(TEN);
            for (int k = 0; k < arrayList.size(); ++k) {
                if (!((BigInteger)arrayList.get(k)).equals(dividend)) continue;
                sb.insert(k, "\u00af");
                ende = true;
                break;
            }
            if (ende) break;
            arrayList.add(dividend);
            while (dividend.compareTo(divisor) < 0) {
                sb.append("0");
                dividend = dividend.multiply(TEN);
                arrayList.add(dividend);
            }
            ganz = dividend.divide(divisor);
            sb.append(ganz.toString());
            dividend = rest = dividend.mod(divisor);
            ++i;
        }
        sb.insert(0, ".");
        return sb.toString();
    }
}

