/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.util;

import java.util.StringTokenizer;

public class Version
implements Comparable {
    private int major;
    private int sub;
    private int minor;

    public Version(int major, int sub) {
        this(major, sub, 0);
    }

    public Version(int major, int sub, int minor) {
        this.major = major;
        this.sub = sub;
        this.minor = minor;
    }

    public Version(String version) {
        this.major = 0;
        this.sub = 0;
        this.minor = 0;
        StringTokenizer st = new StringTokenizer(version, ".");
        if (st.hasMoreTokens()) {
            this.major = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.sub = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            this.minor = Integer.parseInt(st.nextToken());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(8);
        sb.append(this.major);
        sb.append('.');
        sb.append(this.sub);
        sb.append('.');
        sb.append(this.minor);
        return sb.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getSub() {
        return this.sub;
    }

    public int getMinor() {
        return this.minor;
    }

    public int compareTo(Object o) {
        Version v = (Version)o;
        if (this.equals(v)) {
            return 0;
        }
        if (this.major > v.getMajor() || this.major == v.getMajor() && this.sub > v.getSub() || this.major == v.getMajor() && this.sub == v.getSub() && this.minor > v.getMinor()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        return this.major == v.getMajor() && this.sub == v.getSub() && this.minor == v.getMinor();
    }

    public int hashCode() {
        return this.major * 10000 + this.sub * 100 + this.minor;
    }
}

