/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryDialCodes
extends CategoryObject {
    private ArrayList<Unit> units;
    private HashMap<String, String> hashtableFrom;
    private HashMap<String, String> hashtableTo;
    private Unit defaultSourceUnit;
    private Unit defaultTargetUnit;
    private ResourceBundle iso3166;

    public CategoryDialCodes(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        this.iso3166 = categoryInterface.getISO3166ResourceBundle();
        this.units = new ArrayList();
        this.hashtableFrom = new HashMap();
        this.hashtableTo = new HashMap();
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream("/data/lists/intphone.list");
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
            int id = 0;
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.startsWith("#") || thisLine.equals("")) continue;
                StringTokenizer st = new StringTokenizer(thisLine, ":");
                String countrycode = st.nextToken().toLowerCase(Locale.US);
                Unit unit = new Unit(id, this.iso3166.getString(countrycode), countrycode);
                this.units.add(unit);
                if (countrycode.equals("de")) {
                    this.defaultSourceUnit = unit;
                }
                if (countrycode.equals("us")) {
                    this.defaultTargetUnit = unit;
                }
                String to = st.hasMoreTokens() ? st.nextToken() : "";
                String from = st.hasMoreTokens() ? st.nextToken() : "";
                this.hashtableFrom.put(countrycode, from);
                this.hashtableTo.put(countrycode, to);
                ++id;
            }
            br.close();
            Collections.sort(this.units, new Comparator<Unit>(){

                @Override
                public int compare(Unit u1, Unit u2) {
                    return u1.getString().compareTo(u2.getString());
                }
            });
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return this.units.indexOf(this.defaultSourceUnit);
    }

    @Override
    public int getTargetDefault() {
        return this.units.indexOf(this.defaultTargetUnit);
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public int getPreferredPrecision() {
        return -1;
    }

    @Override
    public boolean acceptEmptyStrings() {
        return true;
    }

    @Override
    public boolean isPlusMinusSupported() {
        return false;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        String codeTarget;
        String codeSource = sourceUnit.getIcon();
        if (codeSource.equals(codeTarget = targetUnit.getIcon())) {
            return "";
        }
        return String.format("%s %s", this.hashtableFrom.get(codeSource), this.hashtableTo.get(codeTarget));
    }

    @Override
    public String getInitialValue() {
        return "";
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String setValue(BigDecimal big, int sourceindex) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTransferValue(int s) throws Exception {
        return null;
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return null;
    }

    @Override
    public String getCard() {
        return "emptyCard";
    }
}

