/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import jonelo.sugar.math.GeneralMath;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategorySlope
extends CategoryObject {
    private static final int _STEIGUNG = 0;
    private static final int _STEIGUNG_PROMILLE = 1;
    private static final int _NEIGUNGSWINKEL = 2;
    private static final int _VERHAELTNIS = 3;
    private static final BigDecimal _180 = BigDecimal.valueOf(180L);
    private static final BigDecimal _PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632788");
    private static final String UNENDLICH = "\u221e";
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;

    public CategorySlope(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.units = new ArrayList();
        this.units.add(new Unit(0, this.localize("Slope.slope", "Steigung in Prozent (%)"), "int"));
        this.units.add(new Unit(1, this.localize("Slope.slopePromille", "Steigung in Promille (\u2030)"), "int"));
        this.units.add(new Unit(2, this.localize("Slope.angle", "Neigungswinkel in \u00b0"), "int"));
        this.units.add(new Unit(3, this.localize("Slope.1tox", "Verh\u00e4ltnis (1:x)"), "int"));
        this.defaultSourceUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(2);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    @Override
    public int getTargetDefault() {
        return 2;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    public boolean isSpecialDefaultValue() {
        return false;
    }

    @Override
    public boolean isScientificSupported() {
        return true;
    }

    @Override
    public int getPreferredPrecision() {
        return 12;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        BigDecimal x = BigDecimal.ZERO;
        boolean unendlich = false;
        boolean minusUnendlich = false;
        double d = 0.0;
        switch (sid) {
            case 0: {
                if (this.input.equals(UNENDLICH)) {
                    unendlich = true;
                    break;
                }
                if (this.input.equals("-\u221e")) {
                    minusUnendlich = true;
                    break;
                }
                try {
                    x = new BigDecimal(this.input.replace(decsep, '.'));
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
            case 1: {
                if (this.input.equals(UNENDLICH)) {
                    unendlich = true;
                    break;
                }
                if (this.input.equals("-\u221e")) {
                    minusUnendlich = true;
                    break;
                }
                try {
                    x = new BigDecimal(this.input.replace(decsep, '.')).divide(BigDecimal.TEN);
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
            case 3: {
                if (this.input.equals(UNENDLICH) || this.input.equals("-\u221e")) {
                    x = BigDecimal.ZERO;
                    break;
                }
                x = BigDecimal.ONE.divide(new BigDecimal(this.input.replace(decsep, '.')).divide(BigDecimal.valueOf(100L), this.getPrecision() + 1000, 4), this.getPrecision() + 1000, 4);
                break;
            }
            case 2: {
                try {
                    x = new BigDecimal(this.input.replace(decsep, '.'));
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
                if (x.abs().compareTo(BigDecimal.valueOf(90L)) > 0) {
                    throw new Exception(INVALID);
                }
                if (x.abs().compareTo(BigDecimal.valueOf(90L)) == 0) {
                    if (x.signum() == -1) {
                        return "-\u221e";
                    }
                    return UNENDLICH;
                }
                if (x.equals(BigDecimal.ZERO.setScale(x.scale()))) break;
                x = _PI.divide(_180, this.getPrecision() + 1000, 4).multiply(x);
                d = x.doubleValue();
                d = Math.tan(d) * 100.0;
                x = BigDecimal.valueOf(d);
            }
        }
        switch (tid) {
            case 0: {
                break;
            }
            case 1: {
                x = BigDecimal.TEN.multiply(x);
                break;
            }
            case 3: {
                if (x.equals(BigDecimal.ZERO.setScale(x.scale()))) {
                    return UNENDLICH;
                }
                x = BigDecimal.ONE.divide(x.divide(BigDecimal.valueOf(100L), this.getPrecision() + 1000, 4), this.getPrecision() + 1000, 4);
                break;
            }
            case 2: {
                if (unendlich) {
                    return "90";
                }
                if (minusUnendlich) {
                    return "-90";
                }
                d = x.doubleValue();
                d = Math.atan(d / 100.0);
                x = BigDecimal.valueOf(d);
                x = _180.divide(_PI, this.getPrecision() + 1000, 4).multiply(x);
            }
        }
        if (this.getScientific()) {
            return GeneralMath.decimal2Scientific(x.toPlainString(), this.getPrecision()).replace('.', decsep);
        }
        return x.setScale(this.getPrecision(), 4).toPlainString().replace('.', decsep);
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.units.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
        }
        BigDecimal big = new BigDecimal(this.input.replace(decsep, '.'));
        big = big.add(plus);
        return big.toPlainString().replace('.', decsep);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.input.replace('.', decsep);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, sourceUnit).replace(decsep, '.');
    }

    @Override
    public String getCard() {
        return "sciCard";
    }
}

