/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryUnicode
extends CategoryObject {
    private static final int _DEC = 0;
    private static final int _HEX = 1;
    private static final int _UNI = 2;
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;

    public CategoryUnicode(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "source invalid");
        this.units = new ArrayList();
        this.units.add(new Unit(0, this.localize("Moduls.decimalName", "Decimal"), "int"));
        this.units.add(new Unit(1, this.localize("Moduls.hexadecimal", "Hexadecimal"), "int"));
        this.units.add(new Unit(2, this.localize("Moduls.unicodeCharacter", "Unicode\u00ae Character"), "int"));
        this.transferUnit = this.units.get(0);
        this.defaultSourceUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(2);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 2;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public int getPreferredPrecision() {
        return -1;
    }

    @Override
    public String getInitialValue() {
        return "169";
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        long[] longArray = null;
        switch (sid) {
            case 1: {
                int i;
                if (this.input.length() > 4 && this.input.length() % 4 != 0) {
                    throw new Exception(INVALID);
                }
                try {
                    if (this.input.length() <= 4) {
                        longArray = new long[]{Long.valueOf(this.input, 16)};
                        if (longArray[0] >= 0L) break;
                        throw new Exception();
                    }
                    longArray = new long[this.input.length() / 4];
                    for (i = 0; i < longArray.length; ++i) {
                        longArray[i] = Long.valueOf(this.input.substring(i * 4, (i + 1) * 4), 16);
                    }
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
            case 2: {
                int i;
                if (this.input.length() == 0) {
                    return "";
                }
                longArray = new long[this.input.length()];
                for (i = 0; i < this.input.length(); ++i) {
                    longArray[i] = this.input.charAt(i);
                }
                break;
            }
            case 0: {
                try {
                    if (this.input.length() == 0) {
                        return "";
                    }
                    int count = GeneralString.countChar(this.input, ',');
                    if (count == 0) {
                        long l = Integer.valueOf(this.input, 10).longValue();
                        if (l < 0L || l > 65535L) {
                            throw new Exception();
                        }
                        longArray = new long[]{l};
                        break;
                    }
                    longArray = new long[count + 1];
                    StringTokenizer st = new StringTokenizer(this.input, ",");
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (token.equals("")) {
                            longArray[i] = 0L;
                        } else {
                            long l = Integer.valueOf(token, 10).longValue();
                            if (l < 0L || l > 65535L) {
                                throw new Exception();
                            }
                            longArray[i] = l;
                        }
                        ++i;
                    }
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
        }
        switch (tid) {
            case 1: {
                if (longArray.length == 1) {
                    return Long.toString(longArray[0], 16).toUpperCase();
                }
                StringBuilder sb = new StringBuilder(longArray.length * 4);
                for (int i = 0; i < longArray.length; ++i) {
                    sb.append(CategoryUnicode.hexformat(longArray[i], 4).toUpperCase());
                }
                return sb.toString();
            }
            case 2: {
                StringBuilder sb = new StringBuilder(longArray.length);
                for (int i = 0; i < longArray.length; ++i) {
                    sb.append((char)longArray[i]);
                }
                return sb.toString();
            }
            case 0: {
                StringBuilder sb = new StringBuilder(longArray.length * 4);
                for (int i = 0; i < longArray.length; ++i) {
                    sb.append(longArray[i]);
                    sb.append(",");
                }
                sb.deleteCharAt(sb.toString().length() - 1);
                return sb.toString();
            }
        }
        return null;
    }

    private static String hexformat(long value, int nibbles) {
        StringBuilder sb = new StringBuilder(Long.toHexString(value));
        while (sb.length() < nibbles) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    @Override
    public String addValue(BigDecimal plus, int sourceIndex) throws Exception {
        String temp;
        if (this.input == null || this.input.equals("")) {
            this.input = "0";
            this.input = this.getOutput(0, sourceIndex);
        }
        if (!(temp = this.getTransferValue(sourceIndex)).contains(",")) {
            BigDecimal big = new BigDecimal(temp);
            big = big.add(plus);
            return this.setValue(big, sourceIndex);
        }
        return this.input;
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        String temp;
        if (this.input == null || this.input.equals("")) {
            this.input = "0";
            this.input = this.getOutput(this.transferUnit, sourceUnit);
        }
        if (!(temp = this.getTransferValue(sourceUnit)).contains(",")) {
            BigDecimal big = new BigDecimal(temp);
            big = big.add(plus);
            return this.setValue(big, sourceUnit);
        }
        return this.input;
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        this.setInput(big.toString());
        return this.getOutput(this.getSourceDefault(), sourceIndex);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int s) throws Exception {
        return this.getOutput(s, this.getSourceDefault());
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "unicodeCard";
    }
}

