/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.data.i18n;

import java.net.URL;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.numericalchameleon.data.i18n.ResBundleAuthor;

public class ResBundleRecord {
    private String language;
    private ResBundleAuthor[] authors;
    private String country;
    private String help;
    private String description;
    private String version;
    public static final String DELIM = ";";

    public ResBundleRecord() {
    }

    public ResBundleRecord(String parseThis) {
        StringTokenizer st = new StringTokenizer(parseThis, DELIM);
        this.version = st.nextToken();
        String[] authorsToken = st.nextToken().split("&");
        this.authors = new ResBundleAuthor[authorsToken.length];
        int i = 0;
        for (String authorToken : authorsToken) {
            String[] tuple = authorToken.split(":");
            this.authors[i] = new ResBundleAuthor(tuple[1], tuple[0].trim().toLowerCase());
            ++i;
        }
        this.language = st.nextToken();
        this.country = st.nextToken();
        this.help = st.nextToken();
        this.description = st.nextToken();
    }

    public String toString() {
        return this.version + DELIM + Arrays.toString(this.getAuthors()) + DELIM + this.language + DELIM + this.country + DELIM + this.help + DELIM + this.description;
    }

    public String getHTML() {
        return "<html><body><b>Version:</b>&nbsp;<br>" + this.version + "<br><br><b>Translators:</b>&nbsp;<br>" + this.getAuthorsAsHTML() + "</body></html>";
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResBundleAuthor[] getAuthors() {
        return this.authors;
    }

    public static String getImgTag(String country) {
        URL url = ResBundleRecord.class.getResource("/data/icons/flags/" + country.toLowerCase() + ".png");
        return "<img src=\"" + url + "\">";
    }

    public String getAuthorsAsHTML() {
        StringBuilder sb = new StringBuilder();
        for (ResBundleAuthor author : this.authors) {
            sb.append(author.getName());
            sb.append("&nbsp;");
            sb.append(ResBundleRecord.getImgTag(author.getCountry()));
            sb.append("<br>");
        }
        return sb.toString();
    }

    public void setAuthors(ResBundleAuthor[] authors) {
        this.authors = authors;
    }
}

