/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.exchangerates;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jonelo.sugar.gui.GUIHelper;
import jonelo.sugar.gui.GeneralGUI;
import jonelo.sugar.io.ExampleFileFilter;
import jonelo.sugar.io.GeneralIO;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;
import net.numericalchameleon.gui.dialogs.exchangerates.ExchangeRatesFilter;
import net.numericalchameleon.gui.dialogs.exchangerates.ExchangeRatesUpdateTask;
import net.numericalchameleon.util.exchangerates.ExchangeRates;

public class ExchangeRatesDialog
extends JDialog
implements PropertyChangeListener {
    private Vector exchangeRatesUpdateVector = null;
    private String filenameDefinition;
    private Timer timer;
    private ExchangeRatesUpdateTask task;
    private static boolean debug = false;
    private ResourceBundle rb;
    private JFileChooser openChooser;
    private ExchangeRates exchangeRates;
    private ExchangeRatesFilter filter;
    private ResourceBundle iso3166;
    private DownloadTask downloadTask;
    private JCheckBox appendCheckBox;
    private JButton cancelButton;
    private JButton copyButton;
    private JMenuItem copyMenuItem;
    private JTextArea descriptionTextArea;
    private JPanel dialogPanel;
    private JButton downloadButton;
    private JProgressBar downloadProgressBar;
    private JButton filechooseButton;
    private JTextField filenameTextField;
    private JTextArea instructionTextArea;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton leftButton;
    private JLabel logLabel;
    private JTextArea logTextArea;
    private JButton okButton;
    private JComboBox pageComboBox;
    private JProgressBar progressBar;
    private JComboBox rateServiceComboBox;
    private JButton rightButton;
    private JButton startButton;
    private JTabbedPane stepsTabbedPane;
    private JButton toStep1Button;
    private JButton toStep2Button;
    private JButton toStep2ButtonB;
    private JButton toStep3Button;
    private JPopupMenu visitPopupMenu;
    private JTextField visitTextField;

    public ExchangeRatesDialog(DialogInterface dialogInterface, ExchangeRates exchangeRates, ResourceBundle iso3166) {
        super(dialogInterface.getFrame(), true);
        this.exchangeRates = exchangeRates;
        this.rb = dialogInterface.getResourceBundle();
        this.iso3166 = iso3166;
        if (dialogInterface.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.setVisible(false);
        this.openChooser = new JFileChooser();
        this.task = new ExchangeRatesUpdateTask(exchangeRates);
        this.task.setISO3166ResourceBundle(iso3166);
        this.initComponents();
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(this.task.getLengthOfTask());
        this.progressBar.setStringPainted(true);
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int here = ExchangeRatesDialog.this.task.getCurrent();
                ExchangeRatesDialog.this.progressBar.setValue(here);
                ExchangeRatesDialog.this.progressBar.setString(here * 100 / ExchangeRatesDialog.this.task.getLengthOfTask() + " %");
                if (ExchangeRatesDialog.this.task.done()) {
                    ExchangeRatesDialog.this.timer.stop();
                    ExchangeRatesDialog.this.startButton.setEnabled(true);
                    ExchangeRatesDialog.this.logLabel.setIcon(null);
                    ExchangeRatesDialog.this.progressBar.setValue(ExchangeRatesDialog.this.progressBar.getMinimum());
                    ExchangeRatesDialog.this.progressBar.setString("0 %");
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.prepareExchangeRateUpdateList();
        this.setLocationRelativeTo(dialogInterface.getFrame());
        ComponentOrientation ce = ComponentOrientation.getOrientation(Locale.getDefault());
        if (!ce.isLeftToRight()) {
            GeneralGUI.applyOrientation(this.dialogPanel, ce);
        }
        this.setVisible(true);
    }

    public static void setDebug(boolean flag) {
        debug = flag;
    }

    private void initComponents() {
        this.visitPopupMenu = new JPopupMenu();
        this.copyMenuItem = new JMenuItem();
        this.dialogPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.appendCheckBox = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.stepsTabbedPane = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel7 = new JPanel();
        this.rateServiceComboBox = new JComboBox();
        this.jPanel6 = new JPanel();
        this.leftButton = new JButton();
        this.rightButton = new JButton();
        this.jLabel9 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.toStep2Button = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.visitTextField = new JTextField();
        this.copyButton = new JButton();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.instructionTextArea = new JTextArea();
        this.toStep1Button = new JButton();
        this.toStep3Button = new JButton();
        this.downloadProgressBar = new JProgressBar();
        this.downloadButton = new JButton();
        this.pageComboBox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.filenameTextField = new JTextField();
        this.filechooseButton = new JButton();
        this.startButton = new JButton();
        this.progressBar = new JProgressBar();
        this.jScrollPane2 = new JScrollPane();
        this.logTextArea = new JTextArea();
        this.logLabel = new JLabel();
        this.toStep2ButtonB = new JButton();
        this.copyMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.copyMenuItem.setText(this.rb.getString("GUI.General.Copy"));
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.visitPopupMenu.add(this.copyMenuItem);
        this.setTitle(this.rb.getString("GUI.Menu.Main.UpdateExchangeRates"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExchangeRatesDialog.this.closeDialog(evt);
            }
        });
        this.dialogPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dialogPanel.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.appendCheckBox.setText(this.rb.getString("GUI.Rates.Append"));
        this.appendCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.appendCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.appendCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExchangeRatesDialog.this.appendCheckBoxItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel5.add((Component)this.appendCheckBox, gridBagConstraints);
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/update.png")));
        this.okButton.setText(this.rb.getString("GUI.General.Update"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel5.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.jPanel5.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 15, 15);
        this.dialogPanel.add((Component)this.jPanel5, gridBagConstraints);
        this.stepsTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ExchangeRatesDialog.this.stepsTabbedPaneStateChanged(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setText(this.rb.getString("GUI.Rates.Service.Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.rateServiceComboBox.setMaximumRowCount(25);
        this.rateServiceComboBox.setMinimumSize(new Dimension(320, 26));
        this.rateServiceComboBox.setOpaque(false);
        this.rateServiceComboBox.setPreferredSize(new Dimension(320, 26));
        this.rateServiceComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExchangeRatesDialog.this.rateServiceComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.rateServiceComboBox, gridBagConstraints);
        this.jPanel6.setLayout(new GridLayout(2, 0));
        this.leftButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/up.png")));
        this.leftButton.setMargin(new Insets(1, 1, 1, 1));
        this.leftButton.setMaximumSize(new Dimension(21, 21));
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.leftButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.leftButton);
        this.rightButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/down.png")));
        this.rightButton.setMargin(new Insets(1, 1, 1, 1));
        this.rightButton.setMaximumSize(new Dimension(21, 21));
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.rightButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.rightButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel7.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel7, gridBagConstraints);
        this.jLabel9.setText(this.rb.getString("GUI.Rates.Service.Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.descriptionTextArea.setColumns(60);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(new Font("Courier", 0, 12));
        this.descriptionTextArea.setRows(10);
        this.jScrollPane3.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane3, gridBagConstraints);
        this.toStep2Button.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-next.png")));
        this.toStep2Button.setText(this.rb.getString("GUI.Rates.Continue.Button"));
        this.toStep2Button.setHorizontalTextPosition(2);
        this.toStep2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.toStep2ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanel2.add((Component)this.toStep2Button, gridBagConstraints);
        this.stepsTabbedPane.addTab("1.", new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/currency.png")), this.jPanel2);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel5.setText(this.rb.getString("GUI.Rates.Visit.Label"));
        this.jLabel5.setPreferredSize(new Dimension(320, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.visitTextField.setEditable(false);
        this.visitTextField.setMinimumSize(new Dimension(290, 21));
        this.visitTextField.setPreferredSize(new Dimension(290, 21));
        this.visitTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExchangeRatesDialog.this.visitTextFieldMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ExchangeRatesDialog.this.visitTextFieldMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ExchangeRatesDialog.this.visitTextFieldMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.visitTextField, gridBagConstraints);
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/earth.png")));
        this.copyButton.setText(this.rb.getString("GUI.General.Go"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.copyButton, gridBagConstraints);
        this.jLabel7.setText(this.rb.getString("GUI.Rates.Visit.Instructions.Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanel3.add((Component)this.jLabel7, gridBagConstraints);
        this.instructionTextArea.setColumns(60);
        this.instructionTextArea.setEditable(false);
        this.instructionTextArea.setFont(new Font("Courier", 0, 12));
        this.instructionTextArea.setRows(10);
        this.jScrollPane1.setViewportView(this.instructionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.toStep1Button.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-previous.png")));
        this.toStep1Button.setText(this.rb.getString("GUI.Rates.Back.Button"));
        this.toStep1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.toStep1ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanel3.add((Component)this.toStep1Button, gridBagConstraints);
        this.toStep3Button.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-next.png")));
        this.toStep3Button.setText(this.rb.getString("GUI.Rates.Continue.Button"));
        this.toStep3Button.setHorizontalTextPosition(2);
        this.toStep3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.toStep3ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanel3.add((Component)this.toStep3Button, gridBagConstraints);
        this.downloadProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.downloadProgressBar, gridBagConstraints);
        this.downloadButton.setText("Download");
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.downloadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.downloadButton, gridBagConstraints);
        this.pageComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExchangeRatesDialog.this.pageComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.pageComboBox, gridBagConstraints);
        this.stepsTabbedPane.addTab("2.", new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/earth.png")), this.jPanel3);
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel6.setText(this.rb.getString("GUI.Rates.Include.Label"));
        this.jLabel6.setPreferredSize(new Dimension(320, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.jLabel6, gridBagConstraints);
        this.filenameTextField.setMinimumSize(new Dimension(250, 21));
        this.filenameTextField.setPreferredSize(new Dimension(250, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.filenameTextField, gridBagConstraints);
        this.filechooseButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/document-open.png")));
        this.filechooseButton.setText(this.rb.getString("GUI.General.SelectFile"));
        this.filechooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.filechooseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.filechooseButton, gridBagConstraints);
        this.startButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.startButton.setText(this.rb.getString("GUI.Rates.Include.Start"));
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.startButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.startButton, gridBagConstraints);
        this.progressBar.setMinimumSize(new Dimension(250, 14));
        this.progressBar.setName("progressBar");
        this.progressBar.setPreferredSize(new Dimension(250, 14));
        this.progressBar.setString("0 %");
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.progressBar, gridBagConstraints);
        this.logTextArea.setColumns(60);
        this.logTextArea.setEditable(false);
        this.logTextArea.setFont(new Font("Courier", 0, 12));
        this.logTextArea.setRows(10);
        this.jScrollPane2.setViewportView(this.logTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane2, gridBagConstraints);
        this.logLabel.setText(this.rb.getString("GUI.Rates.Include.Log"));
        this.logLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.logLabel, gridBagConstraints);
        this.toStep2ButtonB.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-previous.png")));
        this.toStep2ButtonB.setText(this.rb.getString("GUI.Rates.Back.Button"));
        this.toStep2ButtonB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExchangeRatesDialog.this.toStep2ButtonBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanel4.add((Component)this.toStep2ButtonB, gridBagConstraints);
        this.stepsTabbedPane.addTab("3.", new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/magnifier-left.png")), this.jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 5, 15);
        this.dialogPanel.add((Component)this.stepsTabbedPane, gridBagConstraints);
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.pack();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        GeneralIO.setClipboard(this.visitTextField.getText());
    }

    private void visitTextFieldMouseReleased(MouseEvent evt) {
        this.checkPopupMenu(evt, this.visitPopupMenu);
    }

    private void visitTextFieldMousePressed(MouseEvent evt) {
        this.checkPopupMenu(evt, this.visitPopupMenu);
    }

    private void visitTextFieldMouseClicked(MouseEvent evt) {
        this.checkPopupMenu(evt, this.visitPopupMenu);
    }

    private void checkPopupMenu(MouseEvent event, JPopupMenu popupMenu) {
        if (event.isPopupTrigger()) {
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private void toStep2ButtonBActionPerformed(ActionEvent evt) {
        this.stepsTabbedPane.setSelectedIndex(1);
    }

    private void appendCheckBoxItemStateChanged(ItemEvent evt) {
        int change = evt.getStateChange();
        if (change == 1) {
            this.exchangeRates.setAppend(true);
        } else if (change == 2) {
            this.exchangeRates.setAppend(false);
        }
    }

    private void toStep1ButtonActionPerformed(ActionEvent evt) {
        this.stepsTabbedPane.setSelectedIndex(0);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeWindow();
    }

    private void rightButtonActionPerformed(ActionEvent evt) {
        int all;
        int now = this.rateServiceComboBox.getSelectedIndex();
        if (now + 1 < (all = this.rateServiceComboBox.getItemCount())) {
            this.rateServiceComboBox.setSelectedIndex(now + 1);
        } else {
            this.rateServiceComboBox.setSelectedIndex(0);
        }
    }

    private void leftButtonActionPerformed(ActionEvent evt) {
        int now = this.rateServiceComboBox.getSelectedIndex();
        int all = this.rateServiceComboBox.getItemCount();
        if (now > 0) {
            this.rateServiceComboBox.setSelectedIndex(now - 1);
        } else {
            this.rateServiceComboBox.setSelectedIndex(all - 1);
        }
    }

    private void stepsTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.stepsTabbedPane.getSelectedIndex() == 2) {
            this.appendCheckBox.setVisible(this.filter.isAllowAppend());
        } else {
            this.appendCheckBox.setVisible(false);
        }
        this.visitTextField.setCaretPosition(0);
    }

    private void toStep2ButtonActionPerformed(ActionEvent evt) {
        this.stepsTabbedPane.setSelectedIndex(1);
    }

    private void toStep3ButtonActionPerformed(ActionEvent evt) {
        this.stepsTabbedPane.setSelectedIndex(2);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancel();
        this.closeWindow();
    }

    private void filechooseButtonActionPerformed(ActionEvent evt) {
        this.pressOpen();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        for (String address : this.filter.getWebsites()) {
            try {
                GUIHelper.openInBrowser(address);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void checkFileForInput(String filename) throws Exception {
        if (filename == null) {
            throw new Exception(this.rb.getString("Error.FileNotSpecified"));
        }
        if (filename.equals("")) {
            throw new Exception(this.rb.getString("Error.FileNotSpecified"));
        }
        File file = new File(this.filenameTextField.getText());
        if (!file.exists()) {
            throw new Exception(GeneralString.message(this.rb.getString("Error.FileDoesNotExist"), filename));
        }
        if (!file.isFile()) {
            throw new Exception(GeneralString.message(this.rb.getString("Error.NotAFile"), filename));
        }
        if (!file.canRead()) {
            throw new Exception(GeneralString.message(this.rb.getString("Error.ReadProblem"), filename));
        }
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        try {
            this.startButton.setEnabled(false);
            this.okButton.setEnabled(false);
            this.checkFileForInput(this.filenameTextField.getText());
            this.exchangeRates.clear();
            this.task.setRatesFilename("/data/rates/" + this.filenameDefinition);
            this.task.setIncludeFilename(this.filenameTextField.getText());
            this.task.setTextArea(this.logTextArea);
            this.task.setButton(this.okButton);
            this.logTextArea.append("");
            this.task.go();
            this.timer.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), this.rb.getString("Error.errorname"), 0);
            this.startButton.setEnabled(true);
        }
    }

    private void rateServiceComboBoxItemStateChanged(ItemEvent evt) {
        this.rateServiceComboBoxItemStateChanged();
    }

    private void closeDialog(WindowEvent evt) {
        this.cancel();
        this.closeWindow();
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        if (!this.filter.isDirectDownloadAllowed()) {
            JOptionPane.showMessageDialog(this, this.rb.getString("GUI.Rates.DirectDownloadHasBeenDisabled"));
        } else {
            try {
                File localFile = ExchangeRatesDialog.createTempFile("rates", "html");
                this.downloadTask = new DownloadTask(this.filter.getWebsites(), localFile, this.filter.getUseragent());
                this.downloadTask.addPropertyChangeListener(this);
                this.downloadTask.execute();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, this.rb.getString("Error.DownloadError"));
            }
        }
    }

    private void pageComboBoxItemStateChanged(ItemEvent evt) {
        String selected = (String)this.pageComboBox.getSelectedItem();
        GeneralIO.setClipboard(selected);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            this.downloadProgressBar.setValue(progress);
        }
    }

    private String getRandomUserAgent() {
        String[] realUserAgents = new String[]{"Mozilla/5.0 (Windows NT 5.1; rv:11.0) Gecko/20100101 Firefox/11.0", "Mozilla/5.0 (compatible; MSIE 8.0; Windows NT 6.0; Trident/4.0; WOW64; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET CLR 1.0.3705; .NET CLR 1.1.4322)", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6_6; en-us) AppleWebKit/533.20.25 (KHTML, like Gecko) Version/5.0.4 Safari/533.20.27"};
        Random randomGenerator = new Random();
        return realUserAgents[randomGenerator.nextInt(realUserAgents.length)];
    }

    public static File createTempFile(String name, String suffix) throws IOException {
        File temp = File.createTempFile(name, "." + suffix);
        temp.deleteOnExit();
        return temp;
    }

    private void cancel() {
        this.task.stop();
        this.exchangeRates.clear();
    }

    private void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    private void rateServiceComboBoxItemStateChanged() {
        this.logTextArea.setText("");
        try {
            this.exchangeRates.setPreferredFilter((String)this.rateServiceComboBox.getSelectedItem());
            this.filenameDefinition = (String)this.exchangeRatesUpdateVector.get(this.rateServiceComboBox.getSelectedIndex()) + ".filter";
            this.filter = new ExchangeRatesFilter(this.filenameDefinition);
            this.openChooser.resetChoosableFileFilters();
            String[] filetypes = this.filter.getFiletypes();
            if (filetypes != null) {
                ExampleFileFilter eff = new ExampleFileFilter(filetypes);
                this.openChooser.addChoosableFileFilter(eff);
                this.openChooser.setFileFilter(eff);
            }
            this.descriptionTextArea.setText(this.filter.getDescription());
            this.descriptionTextArea.setCaretPosition(0);
            this.instructionTextArea.setText(this.filter.getInstruction());
            this.instructionTextArea.setCaretPosition(0);
            this.appendCheckBox.setVisible(false);
            if (this.filter.getWebsites().length > 1) {
                this.pageComboBox.setVisible(true);
                this.pageComboBox.setModel(GeneralGUI.getComboBoxModel(this.filter.getWebsites()));
                this.visitTextField.setVisible(false);
            } else {
                this.pageComboBox.setVisible(false);
                this.visitTextField.setVisible(true);
                this.visitTextField.setText(this.filter.getWebsites()[0]);
                GeneralIO.setClipboard(this.filter.getWebsites()[0]);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    private void prepareExchangeRateUpdateList() {
        if (debug) {
            System.out.print("Loading exchange rates update filter ... ");
        }
        try {
            String myHome = "../data/rates/";
            String suffix = ".filter";
            this.exchangeRatesUpdateVector = GeneralIO.ls(myHome, suffix, false);
            ArrayList deadlist = new ArrayList();
            for (Object o : this.exchangeRatesUpdateVector) {
                ExchangeRatesFilter myfilter = new ExchangeRatesFilter(o + suffix);
                if (myfilter.isEnabled()) continue;
                deadlist.add(o);
            }
            for (Object o : deadlist) {
                this.exchangeRatesUpdateVector.remove(o);
            }
            if (this.exchangeRatesUpdateVector == null) {
                throw new Exception(this.rb.getString("GUI.Rates.NoFilter"));
            }
            this.rateServiceComboBox.setModel(this.getComboBoxModel(this.exchangeRatesUpdateVector));
            if (!this.exchangeRates.getPreferredFilter().equals("")) {
                this.rateServiceComboBox.setSelectedItem(this.exchangeRates.getPreferredFilter());
            }
            this.rateServiceComboBoxItemStateChanged();
            if (debug) {
                System.out.println("OK.");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }

    private ComboBoxModel getComboBoxModel(Vector data) {
        JComboBox cb = new JComboBox(data);
        return cb.getModel();
    }

    private void pressOpen() {
        String temp = this.exchangeRates.getPreferredDirectory();
        if (temp != null) {
            this.openChooser.setCurrentDirectory(new File(temp));
        }
        int state = this.openChooser.showOpenDialog(this);
        File sourceFile = this.openChooser.getSelectedFile();
        if (sourceFile != null && state == 0) {
            this.filenameTextField.setText(sourceFile.getPath());
            this.exchangeRates.setPreferredDirectory(sourceFile.getAbsolutePath());
        }
    }

    class DownloadTask
    extends SwingWorker<Boolean, Void> {
        private String[] addresses;
        private File localFile;
        private Boolean success;
        private String userAgent;

        public DownloadTask(String address, File localFile, String userAgent) {
            this.addresses = new String[1];
            this.addresses[0] = address;
            this.localFile = localFile;
            this.userAgent = userAgent;
        }

        public DownloadTask(String[] addresses, File localFile, String userAgent) {
            this.addresses = addresses;
            this.localFile = localFile;
            this.userAgent = userAgent;
        }

        public DownloadTask(String address, File localFile) {
            this(address, localFile, null);
        }

        public DownloadTask(String[] addresses, File localFile) {
            this(addresses, localFile, null);
        }

        @Override
        public Boolean doInBackground() {
            this.setProgress(0);
            int files = this.addresses.length;
            ExchangeRatesDialog.this.downloadButton.setEnabled(false);
            int pieceInPercent = 100 / files;
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.localFile));
                int filesDone = 0;
                String actualUserAgent = null;
                if (this.userAgent != null) {
                    actualUserAgent = this.userAgent.equals("random") ? ExchangeRatesDialog.this.getRandomUserAgent() : this.userAgent;
                }
                for (String address : this.addresses) {
                    String line;
                    int contentLength;
                    URL url = new URL(address);
                    URLConnection connection = url.openConnection();
                    if (actualUserAgent != null) {
                        System.out.println("Using user-agent: " + actualUserAgent);
                        connection.setRequestProperty("User-Agent", actualUserAgent);
                    }
                    if ((contentLength = connection.getContentLength()) < 0) {
                        contentLength = 4096;
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    int sum = 0;
                    while ((line = in.readLine()) != null) {
                        out.write(line);
                        out.write("\n");
                        sum = sum + line.length() + 1;
                        int percent = sum * 100 / contentLength;
                        if (percent > 100) {
                            percent = 100;
                        }
                        this.setProgress(filesDone * pieceInPercent + pieceInPercent * percent / 100);
                    }
                    ++filesDone;
                    in.close();
                }
                out.close();
                this.setProgress(0);
                this.success = Boolean.TRUE;
            }
            catch (Exception e) {
                this.success = Boolean.FALSE;
                System.out.println(e);
            }
            return Boolean.TRUE;
        }

        @Override
        public void done() {
            ExchangeRatesDialog.this.downloadButton.setEnabled(true);
            if (this.success.booleanValue()) {
                ExchangeRatesDialog.this.filenameTextField.setText(this.localFile.toString());
                ExchangeRatesDialog.this.stepsTabbedPane.setSelectedIndex(2);
            } else {
                JOptionPane.showMessageDialog(null, ExchangeRatesDialog.this.rb.getString("Error.DownloadError"));
            }
        }
    }
}

