/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.timechooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.numericalchameleon.beans.AnalogClockBean;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;
import net.numericalchameleon.gui.dialogs.timechooser.TimeChooserInterface;

public class TimeChooserDialog
extends JDialog {
    private ResourceBundle rb;
    private TimeChooserInterface timeChooserInterface;
    private AnalogClockBean analogClock;
    private JButton cancelButton;
    private JPanel clockPanel;
    private JSpinner hourSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JCheckBox manualInput;
    private JSpinner minuteSpinner;
    private JButton okButton;
    private JCheckBox realTimeOutput;
    private JSpinner secondSpinner;
    private JSlider slider;

    public TimeChooserDialog(DialogInterface dialogInterface, TimeChooserInterface timeChooserInterface) {
        super(dialogInterface.getFrame(), true);
        this.rb = dialogInterface.getResourceBundle();
        this.timeChooserInterface = timeChooserInterface;
        if (dialogInterface.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.initComponents();
        this.analogClock.setBackground(this.clockPanel.getBackground());
        this.setLocationRelativeTo(dialogInterface.getFrame());
        this.analogClock.setIntervalInMillis(1000);
        this.analogClock.start();
        this.setVisible(true);
    }

    private void initComponents() {
        this.hourSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.minuteSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.secondSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.slider = new JSlider();
        this.manualInput = new JCheckBox();
        this.realTimeOutput = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.clockPanel = new JPanel();
        this.analogClock = new AnalogClockBean();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rb.getString("GUI.General.TimePicker"));
        this.setMinimumSize(new Dimension(400, 250));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TimeChooserDialog.this.closeDialog(evt);
            }
        });
        this.hourSpinner.setEnabled(false);
        this.hourSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimeChooserDialog.this.hourSpinnerStateChanged(evt);
            }
        });
        this.jLabel1.setText(":");
        this.minuteSpinner.setEnabled(false);
        this.minuteSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimeChooserDialog.this.minuteSpinnerStateChanged(evt);
            }
        });
        this.jLabel2.setText(":");
        this.secondSpinner.setEnabled(false);
        this.secondSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimeChooserDialog.this.secondSpinnerStateChanged(evt);
            }
        });
        this.jLabel3.setText(this.rb.getString("TimeChooser.Hour"));
        this.jLabel4.setText(this.rb.getString("TimeChooser.Minute"));
        this.jLabel5.setText(this.rb.getString("TimeChooser.Second"));
        this.slider.setMajorTickSpacing(43200);
        this.slider.setMaximum(86399);
        this.slider.setMinorTickSpacing(3600);
        this.slider.setPaintTicks(true);
        this.slider.setEnabled(false);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimeChooserDialog.this.sliderStateChanged(evt);
            }
        });
        this.manualInput.setText(this.rb.getString("TimeChooser.ManualInput"));
        this.manualInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeChooserDialog.this.manualInputActionPerformed(evt);
            }
        });
        this.realTimeOutput.setText(this.rb.getString("TimeChooser.RealTimeOutput"));
        this.realTimeOutput.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TimeChooserDialog.this.realTimeOutputStateChanged(evt);
            }
        });
        this.realTimeOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeChooserDialog.this.realTimeOutputActionPerformed(evt);
            }
        });
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Close"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeChooserDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/ok.png")));
        this.okButton.setText(this.rb.getString("GUI.General.OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeChooserDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.analogClock.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TimeChooserDialog.this.analogClockMouseClicked(evt);
            }
        });
        this.analogClock.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TimeChooserDialog.this.analogClockPropertyChange(evt);
            }
        });
        GroupLayout analogClockLayout = new GroupLayout((Container)this.analogClock);
        this.analogClock.setLayout((LayoutManager)analogClockLayout);
        analogClockLayout.setHorizontalGroup(analogClockLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 368, Short.MAX_VALUE));
        analogClockLayout.setVerticalGroup(analogClockLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 204, Short.MAX_VALUE));
        GroupLayout clockPanelLayout = new GroupLayout(this.clockPanel);
        this.clockPanel.setLayout(clockPanelLayout);
        clockPanelLayout.setHorizontalGroup(clockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 181, Short.MAX_VALUE).addGroup(clockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(clockPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.analogClock, -1, 161, Short.MAX_VALUE).addContainerGap())));
        clockPanelLayout.setVerticalGroup(clockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(clockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(clockPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.analogClock, -1, 175, Short.MAX_VALUE).addContainerGap())));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hourSpinner, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.minuteSpinner, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.secondSpinner, -2, 59, -2))).addComponent(this.slider, -2, 196, -2).addComponent(this.manualInput).addComponent(this.realTimeOutput)).addGap(18, 18, 18).addComponent(this.clockPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.clockPanel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.secondSpinner).addComponent(this.jLabel2).addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minuteSpinner).addComponent(this.hourSpinner))).addGap(18, 18, 18).addComponent(this.slider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.manualInput).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.realTimeOutput).addGap(0, 91, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void sliderStateChanged(ChangeEvent evt) {
        int t = this.slider.getValue();
        int s = 0;
        int m = 0;
        int h = 0;
        if (t > 0) {
            s = t % 60;
            t /= 60;
        }
        if (t > 0) {
            m = t % 60;
            t /= 60;
        }
        if (t > 0) {
            h = t % 24;
            t /= 24;
        }
        this.secondSpinner.setValue(s);
        this.minuteSpinner.setValue(m);
        this.hourSpinner.setValue(h);
        this.analogClock.setSeconds(Integer.valueOf(s).intValue());
        this.analogClock.setMinutes(Integer.valueOf(m).intValue());
        this.analogClock.setHours(Integer.valueOf(h).intValue());
        this.analogClock.repaint();
    }

    private void secondSpinnerStateChanged(ChangeEvent evt) {
        int s = Integer.parseInt(this.secondSpinner.getValue() + "");
        int m = Integer.parseInt(this.minuteSpinner.getValue() + "");
        int h = Integer.parseInt(this.hourSpinner.getValue() + "");
        if (s > 59) {
            if (h == 23 && m == 59) {
                this.secondSpinner.setValue(59);
            } else {
                this.secondSpinner.setValue(0);
                this.minuteSpinner.setValue(Integer.parseInt(this.minuteSpinner.getValue() + "") + 1);
            }
        }
        if (s < 0) {
            if (h == 0 && m == 0) {
                this.secondSpinner.setValue(0);
            } else {
                this.secondSpinner.setValue(59);
                this.minuteSpinner.setValue(Integer.parseInt(this.minuteSpinner.getValue() + "") - 1);
            }
        }
        this.updateSliderValue();
    }

    private void minuteSpinnerStateChanged(ChangeEvent evt) {
        int m = Integer.parseInt(this.minuteSpinner.getValue() + "");
        int h = Integer.parseInt(this.hourSpinner.getValue() + "");
        if (m > 59) {
            if (h == 23) {
                this.minuteSpinner.setValue(59);
            } else {
                this.minuteSpinner.setValue(0);
                this.hourSpinner.setValue(Integer.parseInt(this.hourSpinner.getValue() + "") + 1);
            }
        }
        if (m < 0) {
            if (h == 0) {
                this.minuteSpinner.setValue(0);
            } else {
                this.minuteSpinner.setValue(59);
                this.hourSpinner.setValue(Integer.parseInt(this.hourSpinner.getValue() + "") - 1);
            }
        }
        this.updateSliderValue();
    }

    private void hourSpinnerStateChanged(ChangeEvent evt) {
        int i = Integer.parseInt(this.hourSpinner.getValue() + "");
        if (i > 23) {
            this.hourSpinner.setValue(23);
        }
        if (i < 0) {
            this.hourSpinner.setValue(0);
        }
        this.updateSliderValue();
    }

    private void updateSliderValue() {
        int m = Integer.parseInt(this.minuteSpinner.getValue() + "");
        int s = Integer.parseInt(this.secondSpinner.getValue() + "");
        int h = Integer.parseInt(this.hourSpinner.getValue() + "");
        this.slider.setValue(h * 3600 + m * 60 + s);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.analogClock.stop();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.timeChooserInterface.setCancelled(true);
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.timeChooserInterface.setCancelled(false);
        Calendar calendar = this.timeChooserInterface.getCalcandar();
        calendar.set(11, Integer.parseInt(String.valueOf(this.hourSpinner.getValue())));
        calendar.set(12, Integer.parseInt(String.valueOf(this.minuteSpinner.getValue())));
        calendar.set(13, Integer.parseInt(String.valueOf(this.secondSpinner.getValue())));
        this.closeDialog(null);
    }

    public void closeDialog() {
        this.closeDialog(null);
    }

    private void realTimeOutputStateChanged(ChangeEvent evt) {
    }

    private void realTimeOutputActionPerformed(ActionEvent evt) {
        if (this.realTimeOutput.isSelected()) {
            this.analogClock.setIntervalInMillis(10);
        } else {
            this.analogClock.setIntervalInMillis(1000);
        }
    }

    private void manualInputActionPerformed(ActionEvent evt) {
        if (this.manualInput.isSelected()) {
            this.realTimeOutput.setEnabled(false);
            this.analogClock.stop();
            this.slider.setValue(this.analogClock.getHours() * 3600 + this.analogClock.getMinutes() * 60 + this.analogClock.getSeconds());
            this.slider.setEnabled(true);
            this.hourSpinner.setEnabled(true);
            this.minuteSpinner.setEnabled(true);
            this.secondSpinner.setEnabled(true);
        } else {
            this.realTimeOutput.setEnabled(true);
            this.slider.setEnabled(false);
            this.hourSpinner.setEnabled(false);
            this.minuteSpinner.setEnabled(false);
            this.secondSpinner.setEnabled(false);
            this.analogClock.start();
        }
    }

    private void analogClockPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("millis")) {
            this.slider.setValue(this.analogClock.getHours() * 3600 + this.analogClock.getMinutes() * 60 + this.analogClock.getSeconds());
        }
    }

    private void analogClockMouseClicked(MouseEvent evt) {
        if (this.manualInput.isSelected()) {
            int t = this.slider.getValue();
            this.slider.setValue(t + 1);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

