/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.main;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoManager;
import jonelo.sugar.gui.AboutDialog;
import jonelo.sugar.gui.GeneralGUI;
import jonelo.sugar.gui.SplashScreen;
import jonelo.sugar.io.ExampleFileFilter;
import jonelo.sugar.io.GeneralIO;
import jonelo.sugar.util.ExtendedGregorianCalendar;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.MainPortable;
import net.numericalchameleon.categories.CategoryAlphaPhone;
import net.numericalchameleon.categories.CategoryAngle;
import net.numericalchameleon.categories.CategoryBases35;
import net.numericalchameleon.categories.CategoryCalendarSystems;
import net.numericalchameleon.categories.CategoryColor;
import net.numericalchameleon.categories.CategoryCoordinates;
import net.numericalchameleon.categories.CategoryDateFormats;
import net.numericalchameleon.categories.CategoryDateQueries;
import net.numericalchameleon.categories.CategoryDialCodes;
import net.numericalchameleon.categories.CategoryDigitalFingerprints;
import net.numericalchameleon.categories.CategoryGeneric;
import net.numericalchameleon.categories.CategoryHolidays;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.categories.CategoryRationalNumbers;
import net.numericalchameleon.categories.CategoryRomanNumerals;
import net.numericalchameleon.categories.CategorySlope;
import net.numericalchameleon.categories.CategorySpokenNumbers;
import net.numericalchameleon.categories.CategorySpokenTime;
import net.numericalchameleon.categories.CategoryTemperatures;
import net.numericalchameleon.categories.CategoryTimezones;
import net.numericalchameleon.categories.CategoryUnicode;
import net.numericalchameleon.cli.CLI;
import net.numericalchameleon.data.Bookmark;
import net.numericalchameleon.data.Category;
import net.numericalchameleon.data.Group;
import net.numericalchameleon.data.Summary;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.data.i18n.ResBundleRecord;
import net.numericalchameleon.data.i18n.ResBundles;
import net.numericalchameleon.gui.common.LookAndFeel;
import net.numericalchameleon.gui.common.LookAndFeelProperties;
import net.numericalchameleon.gui.dialogs.bookmarks.BookmarksDialog;
import net.numericalchameleon.gui.dialogs.bookmarks.BookmarksModel;
import net.numericalchameleon.gui.dialogs.calendarchooser.CalendarChooserDialog;
import net.numericalchameleon.gui.dialogs.calendarchooser.CalendarChooserPayload;
import net.numericalchameleon.gui.dialogs.config.ConfigDialog;
import net.numericalchameleon.gui.dialogs.datediff.DateDiffDialog;
import net.numericalchameleon.gui.dialogs.editunits.EditUnits;
import net.numericalchameleon.gui.dialogs.exchangerates.ExchangeRatesDialog;
import net.numericalchameleon.gui.dialogs.find.FindDialog;
import net.numericalchameleon.gui.dialogs.listgenerator.ListGeneratorCluster;
import net.numericalchameleon.gui.dialogs.listgenerator.ListGeneratorDialog;
import net.numericalchameleon.gui.dialogs.phoneticalphabet.PhoneticAlphabetDialog;
import net.numericalchameleon.gui.dialogs.ramdomgenerator.RandomGeneratorDialog;
import net.numericalchameleon.gui.dialogs.summary.SummaryDialog;
import net.numericalchameleon.gui.dialogs.timechooser.TimeChooserDialog;
import net.numericalchameleon.gui.dialogs.timechooser.TimeChooserPayload;
import net.numericalchameleon.gui.dialogs.updateapplication.AppUpdateDialog;
import net.numericalchameleon.gui.dialogs.updatecenter.UpdateCenterDialog;
import net.numericalchameleon.gui.main.MainInterface;
import net.numericalchameleon.gui.renderer.CategoryCellRenderer;
import net.numericalchameleon.gui.renderer.EncodingCellRenderer;
import net.numericalchameleon.gui.renderer.GroupCellRenderer;
import net.numericalchameleon.gui.renderer.UnitRecordCellRenderer;
import net.numericalchameleon.info.ProgInfo;
import net.numericalchameleon.update.UpdateRecord;
import net.numericalchameleon.util.exchangerates.ExchangeRates;
import net.numericalchameleon.util.misc.GUIHelper;
import net.numericalchameleon.util.misc.Gimmicks;
import net.numericalchameleon.util.misc.IOHelper;
import net.numericalchameleon.util.misc.ModelHelperNC;
import net.numericalchameleon.util.misc.ProcessHelper;
import net.numericalchameleon.util.misc.RandomGenerator;
import net.numericalchameleon.util.misc.Support;
import net.numericalchameleon.util.misc.SupportNC;
import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class Main
extends JFrame
implements MainInterface {
    private int latestCount;
    private UnitRecordCellRenderer unitRecordCellRenderer;
    private CategoryCellRenderer categoryCellRenderer;
    private GroupCellRenderer groupCellRenderer;
    private CategoryObject categoryObject;
    private String transferValue;
    private boolean precisionerror;
    private ResourceBundle rb;
    private ResourceBundle iso3166;
    private Properties propertiesForAllUsers;
    private Properties userProps;
    private Properties updateProps;
    private String exchange_rates_description = null;
    private int view;
    private ListGeneratorCluster multipleNoticeCluster = null;
    private String notice_form = "$SVALUE [$SUNIT] = $TVALUE [$TUNIT]";
    private JFileChooser fc_save;
    private JFileChooser fc_load;
    private ExampleFileFilter utf16be;
    private ExampleFileFilter utf16le;
    private ExampleFileFilter utf16;
    private ExampleFileFilter utf8;
    private ExampleFileFilter html;
    private ExampleFileFilter iso8859;
    private ExampleFileFilter vcs;
    private ExampleFileFilter ics;
    private ExampleFileFilter xcs;
    private ArrayList<String> groupCurrentSelection;
    private ArrayList<String> groupAllCategories;
    private int lastTypeBoxSelectedIndex = -1;
    private BookmarksModel bookmarks = null;
    private BookmarksDialog bookmarksDialog = null;
    private long rates_updated_ms = 0L;
    private boolean updatePropertiesLoaded = false;
    private UpdateRecord updateRecord = null;
    private boolean resizeComboBoxPopups = true;
    private UndoManager historyUndoManager;
    private UndoManager sourceUndoManager;
    private HashSet<String> groupHashSet;
    private HashMap<String, Category> categoryHashMap;
    private ComponentOrientation appComponentOrientation;
    public static final Color GREEN;
    public static final Color RED;
    private static final int NOCOUNT = -1;
    private static final BigDecimal MINUS_ONE;
    private static final String DEFAULT_NOTICE_FORM = "$SVALUE [$SUNIT] = $TVALUE [$TUNIT]";
    private static final String MAC_OS_X = "Mac OS X";
    private static final String ERROR_GUI_PRECISION = "Error.GUI.Precision";
    private static final String MESSAGE_GUI_PROMPT = "Message.GUI.Prompt";
    private static final String HTML_HEADER;
    private static final String HTML_FOOTER = "</table>\n\n</body>\n</html>";
    private final CLI cli;
    private boolean isNCAdmin;
    private HashMap<String, Class> classMap;
    private HashMap<String, CategoryObject> cacheMap;
    private CardLayout cardLayout;
    private JMenu ToolsMenu;
    private JMenuItem addFavoriteMenuItem;
    private JButton addFavoritesButton;
    private JPanel bottomPanel;
    private JPanel calPanel;
    private JButton calculatorButton;
    private JMenuItem calculatorMenuItem;
    private JButton calendarButton;
    private JPanel cardPanel;
    private JMenu categoriesMenu;
    private JComboBox categoryBox;
    private JButton categoryDownButton;
    private JButton categoryHelpButton;
    private JButton categoryUpButton;
    private JPanel colPanel;
    private JButton colorButton;
    private JButton colorToolbarButton;
    private JLabel conversionLabel;
    private JPanel converterPanel;
    private JMenuItem countUnitsMenuItem;
    private JButton currencyUpdateButton;
    private JButton datatablesButton;
    private JMenuItem dateDiffMenuItem;
    private JComboBox dateFormatComboBox;
    private JPanel datePanel;
    private JButton datetimeDiffButton;
    private JLabel deltaLabel;
    private JRadioButtonMenuItem economicalRadioButtonMenuItem;
    private JMenuItem editCategoriesMenuItem;
    private JButton editFavoritesjButton;
    private JMenu editMenu;
    private JToggleButton editToggleButton;
    private JPanel editTogglePanel;
    private JMenuItem editUnitsMenuItem;
    private JButton editorNoticeButton;
    private JPanel emptyPanel;
    private JMenuItem exitItem;
    private JMenu favoritesMenu;
    private JLabel filterCatIndicatorLabel;
    private JMenuItem filterMenuItem;
    private JButton findSourceButton;
    private JButton findTargetButton;
    private JComboBox fingerprintComboBox;
    private JPanel fingerprintPanel;
    private ButtonGroup frameButtonGroup;
    private JMenu frameMenu;
    private JButton googleMapsButton;
    private JPanel googleMapsPanel;
    private JComboBox groupComboBox;
    private JLabel groupLabel;
    private JPanel headerPanel;
    private JMenuItem helpIndexMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpMenuItemAbout;
    private JPanel historyButtonPanel;
    private JButton historyClearButton;
    private JButton historyCopyButton;
    private JMenuItem historyMenuFontSize;
    private JMenuItem historyMenuItemCopy;
    private JMenuItem historyMenuItemCut;
    private JMenuItem historyMenuItemLoad;
    private JMenuItem historyMenuItemPaste;
    private JMenuItem historyMenuItemRedo;
    private JMenuItem historyMenuItemSave;
    private JMenuItem historyMenuItemUndo;
    private JScrollPane historyPane;
    private JButton historyPasteButton;
    private JPopupMenu historyPopupMenu;
    private JMenuItem historyPopupMenuItemHTML;
    private JMenuItem historyPopupMenuItemMakeList;
    private JMenuItem historyPopupMenuItemNew;
    private JMenuItem historyPopupMenuenuItemFormat;
    private JTextArea historyTextArea;
    private JMenuItem homepageMenuItem;
    private JMenuItem htmlMenuItem;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JSeparator jSeparator16;
    private JPopupMenu.Separator jSeparator18;
    private JSeparator jSeparator2;
    private JSeparator jSeparator21;
    private JSeparator jSeparator22;
    private JSeparator jSeparator24;
    private JSeparator jSeparator25;
    private JSeparator jSeparator26;
    private JSeparator jSeparator29;
    private JSeparator jSeparator3;
    private JSeparator jSeparator30;
    private JSeparator jSeparator31;
    private JSeparator jSeparator32;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JToolBar jToolBar1;
    private JMenuItem loadMenuItem;
    private JRadioButtonMenuItem luxuryRadioButtonMenuItem;
    private JPanel mainPanel;
    private JButton makeListButton;
    private JMenuItem manageFavoritesMenuItem;
    private JRadioButtonMenuItem maximumRadioButtonMenuItem;
    private JTextField messageTextField;
    private JRadioButtonMenuItem miserlyRadioButtonMenuItem;
    private JMenu navigationMenu;
    private JPanel navigationPanel;
    private JMenuBar ncMenuBar;
    private JComboBox numberTypeComboBox;
    private JButton phoneticAlphabetButton;
    private JButton playButton;
    private JButton playTimeButton;
    private JLabel precisionLabel;
    private JTextField precisionTextField;
    private JMenu programMenu;
    private JMenuItem programMenuItemSwap;
    private JMenuItem propsMenuItem;
    private JButton randomButton;
    private JMenuItem randomNumbersMenuItem;
    private JMenu recordMenu;
    private JMenuItem recordMenuItemClear;
    private JMenuItem recordMenuItemCopy;
    private JMenuItem recordMenuItemFontsize;
    private JMenuItem recordMenuItemFormat;
    private JMenuItem recordMenuItemMakeList;
    private JMenuItem recordMenuItemNew;
    private JMenuItem recordMenuItemPaste;
    private JPanel recordPanel;
    private JMenuItem redoMenuItem;
    private JMenuItem reloadCategoriesMenuItem;
    private JMenuItem reloadUnitsItem;
    private JMenuItem restartItem;
    private JButton saveButton;
    private JMenuItem saveMenuItem;
    private JCheckBox sciCheckBox;
    private JPanel sciPanel;
    private JMenuItem searchCategoriesMenuItem;
    private JButton searchCategoryButton;
    private JMenu searchMenu;
    private JMenuItem searchSourceMenuItem;
    private JMenuItem searchTargetMenuItem;
    private JPanel soundPanel;
    private JButton sourceBackButton;
    private JComboBox sourceBox;
    private JPanel sourceButtonPanel;
    private JButton sourceClearButton;
    private JButton sourceCopyButton;
    private JPanel sourceHeaderPanel;
    private JMenu sourceMenu;
    private JMenuItem sourceMenuItemCalendar;
    private JMenuItem sourceMenuItemClear;
    private JMenuItem sourceMenuItemColor;
    private JMenuItem sourceMenuItemCopy;
    private JMenuItem sourceMenuItemDefault;
    private JMenuItem sourceMenuItemDefaultValue;
    private JMenuItem sourceMenuItemFindUnit;
    private JMenuItem sourceMenuItemMinus;
    private JMenuItem sourceMenuItemPaste;
    private JMenuItem sourceMenuItemPlus;
    private JMenuItem sourceMenuItemRedo;
    private JMenuItem sourceMenuItemUndo;
    private JButton sourceMinusButton;
    private JButton sourceNextButton;
    private JPanel sourcePanel;
    private JButton sourcePasteButton;
    private JButton sourcePlusButton;
    private JPopupMenu sourcePopupMenu;
    private JMenuItem sourcePopupMenuDefaultValue;
    private JMenuItem sourcePopupMenuItemCopy;
    private JMenuItem sourcePopupMenuItemCut;
    private JMenuItem sourcePopupMenuItemDefault;
    private JMenuItem sourcePopupMenuItemFindUnit;
    private JMenuItem sourcePopupMenuItemMinus;
    private JMenuItem sourcePopupMenuItemPaste;
    private JMenuItem sourcePopupMenuItemPlus;
    private JMenuItem sourcePopupMenuItemRedo;
    private JMenuItem sourcePopupMenuItemUndo;
    private JScrollPane sourceScrollPane;
    private JTextArea sourceTextArea;
    private JMenuItem spellMenuItem;
    private JRadioButtonMenuItem standardRadioButtonMenuItem;
    private JButton stopButton;
    private JButton stopPlayingTimeButton;
    private JMenuItem supportMenuItem;
    private JButton swapButton;
    private JButton swapToolbarButton;
    private JMenuItem tablesMenuItem;
    private JButton targetBackButton;
    private JComboBox targetBox;
    private JPanel targetButtonPanel;
    private JButton targetCopyButton;
    private JPanel targetHeaderPanel;
    private JMenu targetMenu;
    private JMenuItem targetMenuItemCopy;
    private JMenuItem targetMenuItemDecimals;
    private JMenuItem targetMenuItemDefault;
    private JMenuItem targetMenuItemFigures;
    private JMenuItem targetMenuItemFindUnit;
    private JMenuItem targetMenuItemPlay;
    private JMenuItem targetMenuItemStopPlaying;
    private JButton targetNextButton;
    private JPanel targetPanel;
    private JPopupMenu targetPopupMenu;
    private JMenuItem targetPopupMenuItemCopy;
    private JMenuItem targetPopupMenuItemDefault;
    private JMenuItem targetPopupMenuItemFindUnit;
    private JMenuItem targetPopupMenuItemPlay;
    private JMenuItem targetPopupMenuItemStopPlaying;
    private JScrollPane targetScrollPane;
    private JTextArea targetTextArea;
    private JButton timeDialogButton;
    private JMenuItem timeDialogMenuItem;
    private JPanel timePanel;
    private JButton timePanelTimeChooserButton;
    private JMenuItem tutorialMenuItem;
    private JButton tzLocationsButton;
    private JPanel tzPanel;
    private JMenuItem undoMenuItem;
    private JButton unicodeButton;
    private JPanel unicodePanel;
    private JMenu unitsMenu;
    private JMenuItem updateCenterMenuItem;
    private JMenuItem updateExchangeRatesMenuItem;
    private JLabel warnLabel;

    public static void main(String[] args) {
        Main main = new Main(args);
    }

    public Main(String[] args) {
        this.cli = new CLI(args, this);
        if (this.cli.isRemoveUserPropsWanted()) {
            this.cli.removeUserProps();
        }
        if (this.cli.isUpdateRatesWanted()) {
            this.cli.updateRates();
        }
        if (this.cli.isContinuingFlowWanted()) {
            this.init();
        }
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public ComponentOrientation getAppComponentOrientation() {
        return this.appComponentOrientation;
    }

    @Override
    public void visitBookmark(Bookmark bookmark, boolean takeUnitsIntoAccount) throws Exception {
        int found;
        if (!this.groupHashSet.contains(bookmark.getCategory())) {
            this.clickOnFilterCategoryIndicator();
        }
        if ((found = this.findCategoryWithCode(bookmark.getCategory())) == -1) {
            JOptionPane.showMessageDialog(this, this.rb.getString("Message.CategoryNotFound"), this.rb.getString("Message.CategoryNotFound"), 0);
        } else {
            this.categoryBox.setSelectedIndex(found);
            if (takeUnitsIntoAccount) {
                int foundS = this.findUnitExact(this.sourceBox, bookmark.getSourceDescription(), 0, true);
                int foundT = this.findUnitExact(this.targetBox, bookmark.getTargetDescription(), 0, true);
                if (foundS > -1 && foundT > -1) {
                    this.sourceBox.setSelectedIndex(foundS);
                    this.targetBox.setSelectedIndex(foundT);
                    this.sourceTextArea.setText(bookmark.getValue());
                    this.process(-1);
                } else {
                    throw new Exception("Lesezeichen veraltet");
                }
            }
        }
    }

    @Override
    public void visitBookmark(Bookmark bookmark) throws Exception {
        this.visitBookmark(bookmark, true);
    }

    @Override
    public void updateGUI() {
        SwingUtilities.updateComponentTreeUI(this.getRootPane());
        if (this.view > -1) {
            this.pack();
        }
    }

    @Override
    public boolean isJavaWebStart() {
        return this.cli.isJnlpWanted();
    }

    @Override
    public Properties getUserProps() {
        return this.userProps;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.rb;
    }

    @Override
    public ResourceBundle getISO3166ResourceBundle() {
        if (this.iso3166 == null) {
            this.iso3166 = ResourceBundle.getBundle("data.lang.iso3166");
        }
        return this.iso3166;
    }

    @Override
    public void appUpdateDialog() {
        System.out.println("calling appUpdateDialog");
        AppUpdateDialog appUpdateDialog = new AppUpdateDialog(this);
    }

    @Override
    public UpdateRecord getUpdateRecord() {
        if (this.updateRecord == null) {
            this.updateRecord = new UpdateRecord();
        }
        return this.updateRecord;
    }

    @Override
    public Properties getUpdateProps() {
        if (this.updateProps == null) {
            this.loadUpdateProperties();
        }
        return this.updateProps;
    }

    @Override
    public void saveUpdateProperties() {
        if (this.isDebug()) {
            System.out.print("Saving update properties...");
        }
        try {
            FileOutputStream out = new FileOutputStream("../data/.nc.update.properties");
            this.updateProps.store(out, "/* properties updated */");
            if (this.isDebug()) {
                System.out.println("OK.");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    @Override
    public void releaseDateDiffDialog(boolean[] status, long[] seconds) {
        if (status[0]) {
            if (this.categoryBox.getSelectedItem() != this.categoryHashMap.get("zeit")) {
                this.categoryBox.setSelectedItem(this.categoryHashMap.get("zeit"));
                this.categoryBoxItemStateChanged();
            } else {
                int found = this.findUnitExact(this.sourceBox, "second (s)", 0, true);
                if (found > -1) {
                    this.sourceBox.setSelectedIndex(found);
                }
            }
            try {
                this.setValue(new BigDecimal(String.valueOf(seconds[0])));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    @Override
    public void releaseBookmarksDialog() {
        this.bookmarksDialog = null;
    }

    @Override
    public BookmarksModel getBookmarks() {
        return this.bookmarks;
    }

    @Override
    public HashMap<String, Category> getCategoryHashMap() {
        return this.categoryHashMap;
    }

    @Override
    public int findEntry(Class myCast, JComboBox box, String find, int begin, boolean matchCase) {
        return this.findEntry(myCast, box, find, begin, matchCase, false);
    }

    @Override
    public JComboBox getComboBox(int type) {
        switch (type) {
            case 0: {
                return this.categoryBox;
            }
            case 1: {
                return this.sourceBox;
            }
            case 2: {
                return this.targetBox;
            }
        }
        return null;
    }

    @Override
    public void updateExchangeRates() {
        this.updateExchangeRatesMenuItemActionPerformed(null);
    }

    @Override
    public void dontPanic() {
        JOptionPane.showMessageDialog(this, this.rb.getString("Message.GUI.DontPanic"), this.rb.getString("GUI.Menu.Main.Restart"), 1, new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix48x48/dontpanic.png")));
    }

    @Override
    public void goToWebPage(String path) {
        try {
            String websiteLanguage = this.userProps.getProperty("help", "en").equals("de") ? "de" : "en";
            String url = ProgInfo.getInstance().getFullHomepage().toLowerCase(Locale.US) + "/" + websiteLanguage + "/" + path;
            jonelo.sugar.gui.GUIHelper.openInBrowser(url);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (URISyntaxException e) {
            System.err.println(e);
        }
    }

    @Override
    public void saveWork() {
        this.setBoundsForUserProps();
        if (this.userProps.getProperty("backupCatAndUnit", "false").equals("true")) {
            Bookmark b = this.getCurrentSelectionAsBookmark();
            this.userProps.setProperty("lastCatAndUnit", b.getBookmarkAsString());
        }
        this.saveUserProperties();
    }

    @Override
    public void prepareHardExit() {
        if (this.userProps.getProperty("exitAnimation", "false").equals("true")) {
            Gimmicks.doExitAnimation(this);
        }
        this.setVisible(false);
    }

    @Override
    public void hardExit() {
        this.dispose();
        System.exit(0);
    }

    @Override
    public void updatePropertiesForAllUsers(Properties props) {
        if (this.propertiesForAllUsers == null) {
            this.loadAllUsersProperties();
        }
        this.propertiesForAllUsers.setProperty("rates_date", props.getProperty("rates_date"));
        this.propertiesForAllUsers.setProperty("rates_logic", props.getProperty("rates_logic"));
        this.savePropertiesForAllUsers();
    }

    @Override
    public boolean isResizeComboBoxPopups() {
        return this.resizeComboBoxPopups;
    }

    private boolean isDebug() {
        return this.cli.isDebugWanted();
    }

    private void printRuntimeProperties() {
        for (String entry : this.getRuntimePropertiesAsList()) {
            System.out.println(entry);
        }
    }

    private void teeBothStdoutStderr() {
        try {
            String filePrefix = "nc" + ProgInfo.getInstance().getVersion();
            IOHelper.teeBothStdoutStderr(filePrefix + "_out.log", filePrefix + "_err.log");
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
    }

    private void init() {
        if (this.cli.isLogfileWanted()) {
            this.teeBothStdoutStderr();
        }
        if (this.isDebug()) {
            this.printRuntimeProperties();
        }
        this.initClassMap();
        this.initCacheMap();
        this.loadAllUsersProperties();
        this.loadUserProperties();
        this.resizeComboBoxPopups = this.determineResizeComboBoxPopups();
        this.lastTypeBoxSelectedIndex = -1;
        boolean splash = this.userProps.getProperty("splashScreen", "true").equals("true");
        SplashScreen splashScreen = null;
        if (splash) {
            splashScreen = new SplashScreen(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/images/logo.jpg")));
            splashScreen.setAlwaysOnTop(true);
        }
        LookAndFeelProperties lnfProps = new LookAndFeelProperties();
        lnfProps.setPreferredLnF(this.userProps.getProperty("lnf", "metal_ocean"));
        lnfProps.setPreferredTheme(this.userProps.getProperty("theme", "Default.theme"));
        lnfProps.setJavaFrameDecorationWanted(this.userProps.getProperty("decoration", "native").equals("java"));
        lnfProps.setBoldFont(this.userProps.getProperty("boldFont", "false").equals("true"));
        lnfProps.setAudioFeedback(this.userProps.getProperty("audioNotification", "false").equals("true"));
        if (this.userProps.getProperty("tooltips", "").length() > 0) {
            this.setToolTips(!this.userProps.getProperty("tooltips", "false").equals("false"));
        }
        if (splash) {
            splashScreen.showStatus("Loading language resource bundle ...");
        }
        this.loadResourceBundle();
        this.iso3166 = this.getISO3166ResourceBundle();
        CategoryObject.setDecSep(((DecimalFormat)NumberFormat.getInstance()).getDecimalFormatSymbols().getDecimalSeparator());
        if (splash) {
            splashScreen.showStatus(this.rb.getString("SplashScreen.InitThemes"));
        }
        this.appComponentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        LookAndFeel.setLookAndFeelBasedOnPreferences(lnfProps);
        if (lnfProps.isJavaFrameDecorationWanted() && lnfProps.isJavaFrameDecorationSupported()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        this.updateGUI();
        if (splash) {
            splashScreen.showStatus(this.rb.getString("SplashScreen.CreateGUI"));
        }
        this.initComponents();
        this.isNCAdmin = this.propertiesForAllUsersWritable();
        if (!this.isNCAdmin) {
            this.editUnitsMenuItem.setEnabled(false);
            this.updateCenterMenuItem.setEnabled(false);
            this.currencyUpdateButton.setEnabled(false);
            this.updateExchangeRatesMenuItem.setEnabled(false);
        }
        this.setRenderers();
        this.historyUndoManager = new UndoManager();
        GUIHelper.setUndoRedoFor(this.historyTextArea, this.historyUndoManager);
        this.sourceUndoManager = new UndoManager();
        GUIHelper.setUndoRedoFor(this.sourceTextArea, this.sourceUndoManager);
        this.multipleNoticeCluster = new ListGeneratorCluster();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Main.this.saveExit();
            }
        });
        if (this.cli.isJnlpWanted()) {
            this.updateExchangeRatesMenuItem.setEnabled(false);
        }
        Font font = this.historyTextArea.getFont();
        try {
            this.historyTextArea.setFont(font.deriveFont(Float.valueOf((String)this.userProps.get("fontsize")).floatValue()));
        }
        catch (NumberFormatException e) {
            System.err.println(e.toString());
        }
        if (splash) {
            splashScreen.showStatus(this.rb.getString("SplashScreen.SettingView"));
        }
        this.frameButtonGroup.add(this.luxuryRadioButtonMenuItem);
        this.frameButtonGroup.add(this.standardRadioButtonMenuItem);
        this.frameButtonGroup.add(this.economicalRadioButtonMenuItem);
        this.frameButtonGroup.add(this.miserlyRadioButtonMenuItem);
        this.frameButtonGroup.add(this.maximumRadioButtonMenuItem);
        this.view = 0;
        try {
            this.view = Integer.parseInt((String)this.userProps.get("view"));
            if (this.view < -1 || this.view > 3) {
                this.view = 0;
            }
        }
        catch (NumberFormatException e) {
            System.err.println(e.toString());
        }
        switch (this.view) {
            case -1: {
                this.maximumRadioButtonMenuItem.setSelected(true);
                break;
            }
            case 0: {
                this.luxuryRadioButtonMenuItem.setSelected(true);
                break;
            }
            case 1: {
                this.standardRadioButtonMenuItem.setSelected(true);
                break;
            }
            case 2: {
                this.economicalRadioButtonMenuItem.setSelected(true);
                break;
            }
            case 3: {
                this.miserlyRadioButtonMenuItem.setSelected(true);
            }
        }
        if (splash) {
            splashScreen.showStatus(this.rb.getString("SplashScreen.PrepareGroupsList"));
        }
        this.groupHashSet = new HashSet();
        this.groupCurrentSelection = new ArrayList();
        this.initGroupsList();
        if (splash) {
            splashScreen.showStatus(this.rb.getString("SplashScreen.RegisterCategories"));
        }
        this.registerCategories();
        if (splash) {
            splashScreen.showStatus(this.rb.getString("SplashScreen.Starting"));
        }
        this.luxuryFrame(this.view);
        try {
            this.setLocation(Integer.parseInt(this.userProps.getProperty("locationX")), Integer.parseInt(this.userProps.getProperty("locationY")));
            this.setSize(Integer.parseInt(this.userProps.getProperty("width")), Integer.parseInt(this.userProps.getProperty("heigth")));
        }
        catch (NumberFormatException e) {
            GeneralGUI.centerComponent(this);
        }
        if (!this.appComponentOrientation.isLeftToRight()) {
            GeneralGUI.applyOrientation(this.ncMenuBar, this.appComponentOrientation);
            GeneralGUI.applyOrientation(this.converterPanel, this.appComponentOrientation);
            GeneralGUI.applyOrientation(this.sourcePopupMenu, this.appComponentOrientation);
            GeneralGUI.applyOrientation(this.targetPopupMenu, this.appComponentOrientation);
            GeneralGUI.applyOrientation(this.historyPopupMenu, this.appComponentOrientation);
        }
        if (splash) {
            splashScreen.close();
            splashScreen = null;
        }
        if (this.userProps.getProperty("restoreCatAndUnit", "false").equals("true") && this.userProps.getProperty("lastCatAndUnit", null) != null) {
            try {
                this.visitBookmark(new Bookmark(this.userProps.getProperty("lastCatAndUnit")));
            }
            catch (Exception e) {
                System.err.println(e);
            }
        } else {
            this.categoryBoxItemStateChanged();
        }
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        SwingUtilities.updateComponentTreeUI(this.getRootPane());
        this.setAlwaysOnTop(this.userProps.getProperty("alwaysOnTop", "false").equals("true"));
        this.setVisible(true);
        this.requestFocus();
        this.toFront();
    }

    private void setToolTips(boolean status) {
        ToolTipManager.sharedInstance().setEnabled(status);
    }

    private boolean determineResizeComboBoxPopups() {
        String os = System.getProperty("os.name").toLowerCase(Locale.US);
        return !os.equalsIgnoreCase(MAC_OS_X) || !this.userProps.getProperty("lnf", "").equals("aqua") && !this.userProps.getProperty("lnf", "").equals("system");
    }

    private void loadAllUsersProperties() {
        if (this.isDebug()) {
            System.out.print("Loading system properties ... ");
        }
        this.propertiesForAllUsers = new Properties();
        this.propertiesForAllUsers.setProperty("rates_date", "not defined");
        this.propertiesForAllUsers.setProperty("rates_logic", "false");
        this.propertiesForAllUsers.setProperty("rates_preferred", "fx.sauder.ubc.ca.filter");
        try {
            this.propertiesForAllUsers.load(this.getClass().getResourceAsStream("/data/.nc.properties"));
            if (this.isDebug()) {
                System.out.print("data" + File.separator + ".nc.properties");
            }
            if (this.isDebug()) {
                System.out.println(" OK.");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void loadUserProperties() {
        if (this.isDebug()) {
            System.out.print("Loading user properties ... ");
        }
        this.userProps = new Properties();
        try {
            File f = new File(System.getProperty("user.home") + File.separator + ".NumericalChameleon");
            if (!f.exists()) {
                f.mkdir();
            }
            this.userProps.load(new FileInputStream(System.getProperty("user.home") + File.separator + ".NumericalChameleon/.nc.properties"));
        }
        catch (IOException e) {
            System.err.println(e);
        }
        if (!this.userProps.getProperty("props.version", "0").equals("3")) {
            Locale defaultLocale = Locale.getDefault();
            String deflang = defaultLocale.getLanguage();
            String defcountry = defaultLocale.getCountry();
            String defhelp = "en";
            ResBundles languages = new ResBundles();
            ResBundleRecord language = null;
            try {
                language = languages.getSupportedResBundleByLanguageID(deflang);
                defhelp = language.getHelp();
            }
            catch (Exception e) {
                deflang = "en";
                defhelp = "en";
            }
            this.userProps.setProperty("view", "0");
            this.userProps.setProperty("language", deflang);
            this.userProps.setProperty("help", defhelp);
            this.userProps.setProperty("country", defcountry);
            this.userProps.setProperty("theme", "Default.theme");
            this.userProps.setProperty("fontsize", "12.0");
            this.userProps.setProperty("props.version", "1");
            try {
                File f = new File(System.getProperty("user.home") + File.separator + ".NumericalChameleon");
                if (!f.exists()) {
                    f.mkdir();
                }
                try {
                    this.userProps.load(new FileInputStream(System.getProperty("user.home") + File.separator + ".NumericalChameleon/.nc.properties"));
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println(fnfe);
                }
                if (this.userProps.getProperty("props.version").equals("1")) {
                    this.userProps.setProperty("language", deflang);
                    this.userProps.setProperty("categories", deflang);
                    this.userProps.setProperty("country", defcountry);
                    this.userProps.setProperty("props.version", "2");
                }
                if (this.userProps.getProperty("props.version").equals("2")) {
                    this.userProps.setProperty("help", defhelp);
                    this.userProps.remove("locationX");
                    this.userProps.remove("locationY");
                    this.userProps.remove("width");
                    this.userProps.remove("height");
                    if (System.getProperty("os.name").equals(MAC_OS_X)) {
                        this.userProps.setProperty("lnf", "system");
                    }
                    this.userProps.setProperty("props.version", "3");
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        if (this.isDebug()) {
            System.out.print(System.getProperty("user.home") + File.separator + ".NumericalChameleon/.nc.properties");
        }
        Locale.setDefault(new Locale(this.userProps.getProperty("language"), this.userProps.getProperty("country")));
        if (this.isDebug()) {
            System.out.println(" OK.");
        }
    }

    private void showAboutDialog() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        AboutDialog dialog = new AboutDialog((Frame)this, false);
        dialog.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/images/logo.jpg")));
        if (this.isUndecorated()) {
            dialog.setUndecorated(true);
            dialog.getRootPane().setWindowDecorationStyle(1);
        }
        try {
            dialog.setLicense(this.readFromJar("/net/numericalchameleon/docs/license.html"));
        }
        catch (Exception e) {
            dialog.setLicense(GeneralString.message(this.rb.getString("Error.FileDoesNotExist"), "license.html"));
        }
        try {
            dialog.setCopyright(this.readFromJar("/net/numericalchameleon/docs/copyright.html"));
        }
        catch (Exception e) {
            dialog.setCopyright(GeneralString.message(this.rb.getString("Error.FileDoesNotExist"), "copyright.html"));
        }
        try {
            dialog.setThanks(this.readFromJar("/net/numericalchameleon/docs/thanks.html"));
        }
        catch (Exception e) {
            dialog.setThanks(GeneralString.message(this.rb.getString("Error.FileDoesNotExist"), "thanks.html"));
        }
        StringBuilder sb = new StringBuilder();
        for (String entry : this.getRuntimePropertiesAsList()) {
            sb.append(entry);
            sb.append("\n");
        }
        dialog.setSysProps(sb.toString());
        dialog.setTitle(this.rb.getString("GUI.Menu.Help.About"));
        dialog.setAboutTab(this.rb.getString("GUI.Menu.Help.About"));
        dialog.setLicenseTab(this.rb.getString("GUI.General.License"));
        dialog.setCopyrightTab("Copyright");
        dialog.setThanksTab(this.rb.getString("GUI.General.Thanks"));
        dialog.setSysPropsTab(this.rb.getString("GUI.General.SysProps"));
        dialog.create();
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        dialog = null;
        this.sourceTextArea.requestFocus();
    }

    private void loadResourceBundle() {
        if (this.isDebug()) {
            System.out.print("Loading resource bundle ... ");
        }
        try {
            this.rb = ResourceBundle.getBundle("data.lang.resource");
            UIManager.put("OptionPane.yesButtonText", this.rb.getString("GUI.General.Yes"));
            UIManager.put("OptionPane.noButtonText", this.rb.getString("GUI.General.No"));
            UIManager.put("OptionPane.cancelButtonText", this.rb.getString("GUI.General.Cancel"));
            UIManager.put("OptionPane.okButtonText", this.rb.getString("GUI.General.OK"));
            AboutDialog.OK = this.rb.getString("GUI.General.OK");
            AboutDialog.THANKS = this.rb.getString("GUI.General.Thanks");
            AboutDialog.LICENSE = this.rb.getString("GUI.General.License");
            AboutDialog.ABOUT = this.rb.getString("GUI.Menu.Help.About");
            ExtendedGregorianCalendar.ERROR_1583 = this.rb.getString("Message.GUI.Year1583");
            SpokenNumber.ERROR_TOOBIG = this.rb.getString("SpokenNumber.toobig");
            SpokenNumber.ERROR_TOOSMALL = this.rb.getString("SpokenNumber.toosmall");
            CategoryHolidays.INVALID = this.rb.getString("Moduls.sourceInvalid");
            CategoryHolidays.YES = this.rb.getString("GUI.General.Yes");
            CategoryHolidays.NO = this.rb.getString("GUI.General.No");
            CategoryHolidays.YEAR = this.rb.getString("Calendar.year");
            if (this.isDebug()) {
                System.out.println("OK.");
            }
        }
        catch (MissingResourceException ex) {
            this.error(ex.getMessage() + "\nExit.");
            System.exit(1);
        }
    }

    private void error(String error) {
        System.err.println(error);
        JOptionPane.showMessageDialog(this, error, this.rb.getString("Error.errorname"), 0);
    }

    private void setRenderers() {
        this.categoryCellRenderer = new CategoryCellRenderer();
        GeneralGUI.applyOrientation(this.categoryCellRenderer, this.appComponentOrientation);
        this.categoryBox.setRenderer(this.categoryCellRenderer);
        this.unitRecordCellRenderer = new UnitRecordCellRenderer(this.getISO3166ResourceBundle());
        GeneralGUI.applyOrientation(this.unitRecordCellRenderer, this.appComponentOrientation);
        this.sourceBox.setRenderer(this.unitRecordCellRenderer);
        this.targetBox.setRenderer(this.unitRecordCellRenderer);
        this.groupCellRenderer = new GroupCellRenderer(this);
        GeneralGUI.applyOrientation(this.groupCellRenderer, this.appComponentOrientation);
        this.groupComboBox.setRenderer(this.groupCellRenderer);
    }

    private void registerCategories() {
        if (this.isDebug()) {
            System.out.print("Loading categories.list ... ");
        }
        try {
            this.readCategoriesFromJar();
            if (this.isDebug()) {
                System.out.println("OK.");
            }
        }
        catch (Exception e) {
            this.error("data/lists/categories.list not found. Exit.");
            System.exit(1);
        }
        this.fillCategoryModel(this.groupAllCategories);
        this.transferValue = "";
    }

    private void fillCategoryModel(ArrayList list) {
        DefaultComboBoxModel<Category> catModel = new DefaultComboBoxModel<Category>();
        for (int i = 0; i < list.size(); ++i) {
            catModel.addElement(this.categoryHashMap.get(list.get(i)));
        }
        this.categoryBox.setModel(catModel);
        if (!this.groupHashSet.isEmpty()) {
            this.sourceMenuItemColor.setEnabled(this.groupHashSet.contains("COLOR"));
            this.colorToolbarButton.setEnabled(this.groupHashSet.contains("COLOR"));
            this.sourceMenuItemCalendar.setEnabled(this.groupHashSet.contains("CALENDAR"));
            this.calendarButton.setEnabled(this.groupHashSet.contains("CALENDAR"));
            this.dateDiffMenuItem.setEnabled(this.groupHashSet.contains("zeit"));
            this.datetimeDiffButton.setEnabled(this.groupHashSet.contains("zeit"));
        } else {
            this.sourceMenuItemColor.setEnabled(true);
            this.colorToolbarButton.setEnabled(true);
            this.sourceMenuItemCalendar.setEnabled(true);
            this.calendarButton.setEnabled(true);
            this.dateDiffMenuItem.setEnabled(true);
            this.datetimeDiffButton.setEnabled(true);
        }
    }

    private void initGroupsList() {
        if (this.isDebug()) {
            System.out.print("Loading groups ... ");
        }
        Vector groupsVector = null;
        try {
            String myHome = "../data/groups/";
            groupsVector = this.cli.isJnlpWanted() ? GeneralIO.readFromJarInVector(Main.class, "/data/groups/javawebstart.list") : GeneralIO.ls(myHome, ".group", false);
            if (groupsVector == null) {
                throw new Exception("No group files found in " + myHome);
            }
            groupsVector.insertElementAt("all", 0);
            myHome = System.getProperty("user.home") + File.separator + ".NumericalChameleon" + File.separator;
            Vector v2 = GeneralIO.ls(myHome, ".group", false);
            if (v2 != null) {
                groupsVector.addAll(v2);
            }
            groupsVector.add("random");
            Vector<Group> v3 = new Vector<Group>();
            for (Object name : groupsVector) {
                v3.add(new Group((String)name, (String)name, (String)name));
            }
            this.groupComboBox.setModel(GeneralGUI.getComboBoxModel(v3));
            if (groupsVector.size() < 20) {
                this.groupComboBox.setMaximumRowCount(groupsVector.size());
            } else {
                this.groupComboBox.setMaximumRowCount(20);
            }
            if (this.isDebug()) {
                System.out.println("OK.");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }

    private String readFromJar(String filename) throws Exception {
        String thisLine;
        InputStream is = this.getClass().getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        StringBuilder sb = new StringBuilder();
        while ((thisLine = br.readLine()) != null) {
            sb.append(thisLine);
            sb.append("\n");
        }
        br.close();
        return sb.toString();
    }

    private String getPropertyDefault(Properties properties, String code, String defaultString) {
        if (properties.containsKey(code)) {
            return properties.getProperty(code);
        }
        return defaultString;
    }

    private void readCategoriesFromJar() throws Exception {
        String thisLine;
        InputStream is;
        this.categoryHashMap = new HashMap();
        this.groupAllCategories = new ArrayList();
        Properties cat = new Properties();
        Properties catDefault = new Properties();
        try {
            is = this.getClass().getResourceAsStream("/data/lang/categories.properties");
            catDefault.load(is);
            is.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        try {
            String lang = this.userProps.getProperty("language", "en");
            InputStream is2 = this.getClass().getResourceAsStream("/data/lang/categories_" + lang + "_" + this.userProps.getProperty("country", "") + ".properties");
            if (is2 == null && (is2 = this.getClass().getResourceAsStream("/data/lang/categories_" + lang + ".properties")) == null) {
                is2 = this.getClass().getResourceAsStream("/data/lang/categories.properties");
            }
            cat.load(is2);
            is2.close();
            if (this.isDebug()) {
                System.out.println(" OK.");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        is = this.getClass().getResourceAsStream("/data/lists/categories.list");
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        StringTokenizer st = null;
        String description = null;
        while ((thisLine = br.readLine()) != null) {
            if (thisLine.startsWith("#") || thisLine.equals("")) continue;
            st = new StringTokenizer(thisLine, ":");
            String code = st.nextToken();
            if (!this.groupHashSet.isEmpty() && !this.groupHashSet.contains(code)) continue;
            Category category = new Category();
            category.setName(code);
            category.setIcon("/data/icons/categories/" + code.toLowerCase(Locale.US) + ".png");
            String helplang = this.userProps.getProperty("help", "en");
            String filename = System.getProperty("user.dir") + "/../help/" + helplang + "/categories/" + code.toLowerCase(Locale.US) + ".html";
            category.setHasHelp(new File(filename).exists());
            description = cat.getProperty("Category." + code, this.getPropertyDefault(catDefault, "Category." + code, "NOT TRANSLATED"));
            if (code.equals("exchange_rates")) {
                this.exchange_rates_description = description;
                description = GeneralString.replaceString(description, "$RATES_DATE", this.propertiesForAllUsers.getProperty("rates_date", "n/a"));
            }
            category.setString(description);
            boolean cont = false;
            String figures = "-1";
            if (st.hasMoreTokens()) {
                figures = st.nextToken();
                cont = true;
            } else {
                figures = "12";
            }
            if (figures.equals("-")) {
                figures = "-1";
            }
            int fig = -1;
            try {
                fig = Integer.parseInt(figures);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            category.setPreferredPrecision(fig);
            boolean b = true;
            if (cont && st.hasMoreTokens()) {
                try {
                    String token = st.nextToken();
                    if (code.equals("exchange_rates")) {
                        token = GeneralString.replaceString(token, "$RATES_LOGIC", this.propertiesForAllUsers.getProperty("rates_logic", "false"));
                    }
                    b = token.equals("true") || token.equals("1");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            category.setLogic(b);
            this.groupAllCategories.add(code);
            this.categoryHashMap.put(code, category);
        }
        br.close();
    }

    private void categoryBoxItemStateChanged() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Category category = (Category)this.categoryBox.getSelectedItem();
        if (category == null) {
            category = (Category)this.categoryBox.getItemAt(0);
        }
        this.categoryHelpButton.setEnabled(category.hasHelp());
        String code = category.getName();
        if (!category.hasHelp()) {
            System.out.println("Help for " + code + " is missing");
        }
        this.categoryObject = this.constructCategoryObjectFromCategory(category);
        if (code.equals("SPOKENNUMBERS")) {
            this.targetMenuItemPlay.setEnabled(true);
            this.targetMenuItemStopPlaying.setEnabled(true);
            this.targetPopupMenuItemPlay.setEnabled(true);
            this.targetPopupMenuItemStopPlaying.setEnabled(true);
        } else if (code.equals("CALENDARYEAR")) {
            this.dateFormatComboBox.setSelectedIndex(3);
            this.categoryObject.setNumberType(this.dateFormatComboBox.getSelectedIndex());
        } else if (code.equals("TIMEZONES")) {
            this.warnLabel.setVisible(this.getUpdateRecord().getTzdataModule().isItOutdated());
        } else if (code.equals("CALENDARFORMATS")) {
            this.dateFormatComboBox.setSelectedIndex(1);
            this.categoryObject.setNumberType(this.dateFormatComboBox.getSelectedIndex());
        } else if (code.equalsIgnoreCase("exchange_rates")) {
            this.warnLabel.setVisible(this.isExchangeRatesOutdated());
        }
        boolean plusMinusSupported = this.categoryObject.isPlusMinusSupported();
        this.sourceMinusButton.setEnabled(plusMinusSupported);
        this.sourcePlusButton.setEnabled(plusMinusSupported);
        this.sourceMenuItemPlus.setEnabled(plusMinusSupported);
        this.sourceMenuItemMinus.setEnabled(plusMinusSupported);
        this.sourcePopupMenuItemPlus.setEnabled(plusMinusSupported);
        this.sourcePopupMenuItemMinus.setEnabled(plusMinusSupported);
        this.makeListButton.setEnabled(plusMinusSupported);
        this.recordMenuItemMakeList.setEnabled(plusMinusSupported);
        this.historyPopupMenuItemMakeList.setEnabled(plusMinusSupported);
        this.cardLayout.show(this.cardPanel, this.categoryObject.getCard());
        this.sourceBox.setModel(ModelHelperNC.getComboBoxModel(this.categoryObject.getSourceUnits()));
        this.sourceBox.setSelectedIndex(this.categoryObject.getSourceDefault());
        this.targetBox.setModel(ModelHelperNC.getComboBoxModel(this.categoryObject.getTargetUnits()));
        this.targetBox.setSelectedIndex(this.categoryObject.getTargetDefault());
        if (this.resizeComboBoxPopups) {
            GeneralGUI.resizeComboBoxPopup(this.sourceBox);
            GeneralGUI.resizeComboBoxPopup(this.targetBox);
        }
        if (!code.equals("SPOKENNUMBERS")) {
            this.targetMenuItemPlay.setEnabled(false);
            this.targetMenuItemStopPlaying.setEnabled(false);
            this.targetPopupMenuItemPlay.setEnabled(false);
            this.targetPopupMenuItemStopPlaying.setEnabled(false);
        }
        if (!code.equals("TIMEZONES") && !code.equalsIgnoreCase("exchange_rates")) {
            this.warnLabel.setVisible(false);
        }
        boolean enable = !this.categoryObject.isOneway();
        this.swapButton.setEnabled(enable);
        this.programMenuItemSwap.setEnabled(enable);
        this.swapToolbarButton.setEnabled(enable);
        this.enableNavigationDependentOnEntryCount();
        String initValue = this.categoryObject.getInitialValue();
        this.sourceTextArea.setText(initValue == null ? this.transferValue : initValue);
        this.precisionerror = false;
        if (this.categoryObject.getPreferredPrecision() == -1) {
            this.precisionTextField.setText("0");
            this.precisionTextField.setEditable(false);
            this.precisionTextField.setEnabled(false);
            this.precisionLabel.setEnabled(false);
            this.targetMenuItemFigures.setEnabled(false);
            this.targetMenuItemDecimals.setEnabled(false);
        } else {
            int preferredPrecision = this.categoryObject.getPreferredPrecision();
            this.precisionTextField.setText(Integer.toString(preferredPrecision));
            this.categoryObject.setPrecision(preferredPrecision);
            this.precisionTextField.setEditable(true);
            this.precisionTextField.setEnabled(true);
            this.precisionLabel.setEnabled(true);
            this.targetMenuItemFigures.setEnabled(true);
            this.targetMenuItemDecimals.setEnabled(true);
        }
        this.sciCheckBox.setEnabled(this.categoryObject.isScientificSupported());
        this.categoryObject.setScientific(this.sciCheckBox.isSelected());
        this.latestCount = Math.max(this.sourceBox.getItemCount(), this.targetBox.getItemCount());
        this.editUnitsMenuItem.setEnabled(this.categoryObject instanceof CategoryGeneric && this.isNCAdmin);
        this.process(this.latestCount);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.sourceTextArea.requestFocus();
    }

    private int findEntry(Class myCast, JComboBox box, String find, int begin, boolean matchCase, boolean exact) {
        if (find != null && !find.equals("")) {
            for (int i = begin; i < box.getItemCount(); ++i) {
                String name = null;
                name = myCast == Unit.class ? ((Unit)box.getItemAt(i)).getString() : ((Category)box.getItemAt(i)).getString();
                if (!(matchCase ? (exact ? name.equals(find) : name.contains(find)) : (exact ? name.toLowerCase().equals(find.toLowerCase()) : name.toLowerCase().contains(find.toLowerCase())))) continue;
                return i;
            }
        }
        return -1;
    }

    private void enableNavigationDependentOnEntryCount() {
        boolean moreThanOneEntry = this.sourceBox.getItemCount() > 1;
        this.findSourceButton.setEnabled(moreThanOneEntry);
        this.sourceMenuItemFindUnit.setEnabled(moreThanOneEntry);
        this.sourcePopupMenuItemFindUnit.setEnabled(moreThanOneEntry);
        this.sourceMenuItemDefault.setEnabled(moreThanOneEntry);
        this.sourcePopupMenuItemDefault.setEnabled(moreThanOneEntry);
        this.sourceBackButton.setEnabled(moreThanOneEntry);
        this.sourceNextButton.setEnabled(moreThanOneEntry);
        this.searchSourceMenuItem.setEnabled(moreThanOneEntry);
        moreThanOneEntry = this.targetBox.getItemCount() > 1;
        this.findTargetButton.setEnabled(moreThanOneEntry);
        this.targetMenuItemFindUnit.setEnabled(moreThanOneEntry);
        this.targetPopupMenuItemFindUnit.setEnabled(moreThanOneEntry);
        this.targetMenuItemDefault.setEnabled(moreThanOneEntry);
        this.targetPopupMenuItemDefault.setEnabled(moreThanOneEntry);
        this.targetBackButton.setEnabled(moreThanOneEntry);
        this.targetNextButton.setEnabled(moreThanOneEntry);
        this.searchTargetMenuItem.setEnabled(moreThanOneEntry);
    }

    private void process(int support) {
        if (this.precisionerror) {
            this.messageError(this.rb.getString(ERROR_GUI_PRECISION));
        } else if (!this.categoryObject.acceptEmptyStrings() && this.sourceTextArea.getText().length() == 0) {
            this.targetTextArea.setText("");
            if (support == -1) {
                this.messageOk(this.rb.getString(MESSAGE_GUI_PROMPT), false);
            } else {
                this.messageOk(GeneralString.message(this.rb.getString("Message.GUI.Support"), support) + " " + this.rb.getString(MESSAGE_GUI_PROMPT), false);
            }
        } else {
            this.categoryObject.setInput(this.sourceTextArea.getText());
            try {
                this.targetTextArea.setText(this.categoryObject.getOutput((Unit)this.sourceBox.getSelectedItem(), (Unit)this.targetBox.getSelectedItem()));
                if (this.categoryObject instanceof CategoryTimezones) {
                    this.deltaLabel.setText(this.categoryObject.getInfoConversion());
                }
                if (support == -1) {
                    this.messageOk("ok.", true);
                } else {
                    this.messageOk(GeneralString.message(this.rb.getString("Message.GUI.Support"), support), true);
                }
            }
            catch (Exception e) {
                this.messageError(e.getMessage());
            }
        }
    }

    private void addValue(BigDecimal plus) throws Exception {
        this.categoryObject.setInput(this.sourceTextArea.getText());
        String temp = this.categoryObject.addValue(plus, this.sourceBox.getSelectedIndex());
        this.sourceTextArea.setText(temp);
        this.process(-1);
    }

    private void setValue(BigDecimal big) throws Exception {
        String temp = this.categoryObject.setValue(big, this.sourceBox.getSelectedIndex());
        this.sourceTextArea.setText(temp);
        this.process(-1);
    }

    private void messageLightError(String s) {
        this.messageTextField.setText(s);
        this.messageTextField.setBackground(RED);
        this.messageTextField.setForeground(Color.BLACK);
    }

    private void messageError(String s) {
        this.messageLightError(s);
        this.targetTextArea.setText("");
        this.editorNoticeButton.setEnabled(false);
        this.recordMenuItemNew.setEnabled(false);
        this.historyPopupMenuItemNew.setEnabled(false);
    }

    private void messageOk(String s) {
        this.messageTextField.setText(s);
        this.messageTextField.setBackground(GREEN);
        this.messageTextField.setForeground(Color.black);
    }

    private void messageOk(String s, boolean b) {
        this.messageOk(s);
        this.editorNoticeButton.setEnabled(b);
        this.recordMenuItemNew.setEnabled(b);
        this.historyPopupMenuItemNew.setEnabled(b);
    }

    private void checkPopupMenu(MouseEvent event, JPopupMenu popupMenu) {
        if (event.isPopupTrigger()) {
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private void textAreaClear(JTextArea textArea) {
        int end;
        int start = textArea.getSelectionStart();
        if (start == (end = textArea.getSelectionEnd())) {
            textArea.setText("");
            this.categoryObject.setInput("");
        } else {
            StringBuilder sb = new StringBuilder(textArea.getText());
            sb = sb.delete(start, end);
            textArea.setText(sb.toString());
            textArea.setCaretPosition(start);
            if (textArea.getText().equals("")) {
                this.categoryObject.setInput("");
            }
        }
        this.process(-1);
        textArea.requestFocus();
    }

    private void sourceTextAreaInsert(char c) {
        StringBuilder sb = new StringBuilder(this.sourceTextArea.getText());
        int i = this.sourceTextArea.getCaretPosition();
        sb.insert(i, c);
        this.sourceTextArea.setText(sb.toString());
        this.sourceTextArea.setCaretPosition(i + 1);
        this.process(-1);
        this.sourceTextArea.requestFocus();
    }

    private void textAreaCopy(JTextArea textArea) {
        String s = textArea.getSelectedText();
        if (s == null) {
            textArea.selectAll();
            s = textArea.getText();
        }
        GeneralIO.setClipboard(s);
        textArea.requestFocus();
    }

    private void sourceTextAreaPaste() {
        try {
            int start = this.sourceTextArea.getSelectionStart();
            int end = this.sourceTextArea.getSelectionEnd();
            StringBuilder sb = new StringBuilder(this.sourceTextArea.getText());
            if (start == end) {
                start = this.sourceTextArea.getCaretPosition();
            } else {
                sb = sb.delete(start, end);
            }
            String s = GeneralIO.getClipboard().replace('\n', ' ').replace('\r', ' ').trim();
            sb = sb.insert(start, s);
            this.sourceTextArea.setText(sb.toString());
            this.sourceTextArea.setCaretPosition(start + s.length());
            this.process(-1);
            this.sourceTextArea.requestFocusInWindow();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Clipboard Info", 2);
        }
    }

    private void historyTextAreaPaste() {
        try {
            int start = this.historyTextArea.getSelectionStart();
            int end = this.historyTextArea.getSelectionEnd();
            StringBuilder sb = new StringBuilder(this.historyTextArea.getText());
            if (start == end) {
                start = this.historyTextArea.getCaretPosition();
            } else {
                sb = sb.delete(start, end);
            }
            String s = GeneralIO.getClipboard();
            sb = sb.insert(start, GeneralIO.getClipboard());
            this.historyTextArea.setText(sb.toString());
            this.historyTextArea.setCaretPosition(start + s.length());
            this.historyTextArea.requestFocus();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Clipboard Info", 2);
        }
    }

    private void luxuryFrame(int i) {
        this.view = i;
        this.navigationPanel.setVisible(i < 2);
        this.recordPanel.setVisible(i < 1);
        this.editTogglePanel.setVisible(i < 1);
        this.sourceButtonPanel.setVisible(i < 2);
        this.targetButtonPanel.setVisible(i < 2);
        this.headerPanel.setVisible(i < 3);
        this.userProps.setProperty("view", Integer.toString(i));
        this.saveUserProperties();
        if (i > -1) {
            this.pack();
            GeneralGUI.centerComponent(this);
        } else {
            GeneralGUI.maximizeComponent(this);
        }
    }

    private int whatDateFormat() {
        int index = this.dateFormatComboBox.getSelectedIndex();
        if (index == 0) {
            return 3;
        }
        if (index == 1) {
            return 2;
        }
        if (index == 2) {
            return 1;
        }
        if (index == 3) {
            return 0;
        }
        return 2;
    }

    private void performNotice() {
        if (this.multipleNoticeCluster.getListFormat() != null) {
            this.notice_form = this.multipleNoticeCluster.getListFormat().getFormat();
            try {
                String result = this.multipleNoticeCluster.getListFormat().reformatDate(this.whatDateFormat(), this.targetTextArea.getText());
                this.notice_form = GeneralString.replaceString(this.notice_form, "$TVALUE", result);
                result = this.multipleNoticeCluster.getListFormat().reformatUnit(((Unit)this.targetBox.getSelectedItem()).getString());
                this.notice_form = GeneralString.replaceString(this.notice_form, "$TUNIT", result);
                this.notice_form = GeneralString.replaceString(this.notice_form, "$TFLAG", ((Unit)this.targetBox.getSelectedItem()).getIcon());
                this.historyTextArea.insert(this.notice_form + "\n", this.historyTextArea.getCaretPosition());
            }
            catch (ParseException pe) {
                System.err.println(pe);
            }
        } else {
            this.notice_form = this.userProps.getProperty("notice_form", DEFAULT_NOTICE_FORM);
            this.notice_form = GeneralString.replaceString(this.notice_form, "$SVALUE", this.sourceTextArea.getText());
            this.notice_form = GeneralString.replaceString(this.notice_form, "$SUNIT", ((Unit)this.sourceBox.getSelectedItem()).getString());
            this.notice_form = GeneralString.replaceString(this.notice_form, "$TVALUE", this.targetTextArea.getText());
            this.notice_form = GeneralString.replaceString(this.notice_form, "$TUNIT", ((Unit)this.targetBox.getSelectedItem()).getString());
            this.notice_form = GeneralString.replaceString(this.notice_form, "$SFLAG", ((Unit)this.sourceBox.getSelectedItem()).getIcon());
            this.notice_form = GeneralString.replaceString(this.notice_form, "$TFLAG", ((Unit)this.targetBox.getSelectedItem()).getIcon());
            this.historyTextArea.insert(this.notice_form + "\n", this.historyTextArea.getCaretPosition());
        }
    }

    private void updateCenter() {
        UpdateCenterDialog updateCenterDialog = new UpdateCenterDialog(this, this);
    }

    private boolean isExchangeRatesOutdated() {
        String updated = this.getUpdateProps().getProperty("rates_updated");
        if (updated == null) {
            return false;
        }
        this.rates_updated_ms = Long.parseLong(updated);
        return System.currentTimeMillis() - this.rates_updated_ms >= 86400000L;
    }

    private void loadUpdateProperties() {
        if (!this.updatePropertiesLoaded) {
            if (this.isDebug()) {
                System.out.print("Loading update properties ... ");
            }
            this.updateProps = new Properties();
            this.updateProps.setProperty("latest_update_check", "");
            this.updateProps.setProperty("latest_known_tzdata", "tzdata2016j");
            try {
                this.updateProps.load(this.getClass().getResourceAsStream("/data/.nc.update.properties"));
                if (this.isDebug()) {
                    System.out.print("data" + File.separator + ".nc.update.properties");
                }
                if (this.isDebug()) {
                    System.out.println(" OK.");
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        this.updatePropertiesLoaded = true;
    }

    private void manageFavorites() {
        if (this.bookmarks == null) {
            this.bookmarks = BookmarksModel.loadBookmarks();
        }
        if (this.bookmarksDialog == null) {
            this.bookmarksDialog = new BookmarksDialog(this);
        }
    }

    private Bookmark getCurrentSelectionAsBookmark() {
        Bookmark bookmark = new Bookmark((Category)this.categoryBox.getSelectedItem(), (Unit)this.sourceBox.getSelectedItem(), (Unit)this.targetBox.getSelectedItem());
        bookmark.setLanguage(this.userProps.getProperty("language"));
        bookmark.setCountry(this.userProps.getProperty("country"));
        bookmark.setValue(this.sourceTextArea.getText());
        return bookmark;
    }

    private void addFavorite() {
        Bookmark bookmark = this.getCurrentSelectionAsBookmark();
        if (this.bookmarks == null) {
            this.bookmarks = BookmarksModel.loadBookmarks();
        }
        this.bookmarks.addElement(bookmark);
        if (this.bookmarksDialog != null) {
            this.bookmarksDialog.updateCountLabel();
            this.bookmarksDialog.updateList();
        }
    }

    private String websiteLanguage() {
        return this.userProps.getProperty("help", "en").equals("de") ? "de" : "en";
    }

    private void defaultValuePressed() {
        this.sourceBox.setSelectedIndex(this.categoryObject.getSourceDefault());
        String initValue = this.categoryObject.getInitialValue();
        this.sourceTextArea.setText(initValue == null ? "1" : initValue);
        this.process(-1);
    }

    private void menuItemCalendarPressed() {
        GregorianCalendar calendar = new GregorianCalendar();
        CalendarChooserPayload payload = new CalendarChooserPayload(calendar, TimeZone.getDefault());
        new CalendarChooserDialog(this, payload);
        if (!payload.isCancelled()) {
            if (this.categoryBox.getSelectedItem() != this.categoryHashMap.get("CALENDAR")) {
                this.categoryBox.setSelectedItem(this.categoryHashMap.get("CALENDAR"));
                this.categoryBoxItemStateChanged();
            }
            try {
                String value = String.format("%04d%02d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                this.setValue(new BigDecimal(value));
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
    }

    private void clickOnFilterCategoryIndicator() {
        this.groupHashSet.clear();
        this.fillCategoryModel(this.groupAllCategories);
        this.lastTypeBoxSelectedIndex = -1;
        this.filterCatIndicatorLabel.setVisible(false);
        this.groupComboBox.setSelectedIndex(0);
        this.categoryBoxItemStateChanged();
    }

    private int findCategoryWithCode(String code) {
        for (int i = 0; i < this.categoryBox.getItemCount(); ++i) {
            String name = ((Category)this.categoryBox.getItemAt(i)).getName();
            if (!code.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void findSourceUnit() {
        FindDialog findDialog = new FindDialog(this, 1);
    }

    private int findUnit(JComboBox box, String find, int begin, boolean matchCase) {
        return this.findEntry(Unit.class, box, find, begin, matchCase, false);
    }

    private int findUnitExact(JComboBox box, String find, int begin, boolean matchCase) {
        return this.findEntry(Unit.class, box, find, begin, matchCase, true);
    }

    private int findCategory(JComboBox box, String find, int begin, boolean matchCase) {
        return this.findEntry(Category.class, box, find, begin, matchCase, false);
    }

    private int findCategoryExact(JComboBox box, String find, int begin, boolean matchCase) {
        return this.findEntry(Category.class, box, find, begin, matchCase, true);
    }

    private void findTargetUnit() {
        FindDialog findDialog = new FindDialog(this, 2);
    }

    private void menuItemColorPressed() {
        BigInteger bigi;
        BigDecimal big = null;
        try {
            big = new BigDecimal(this.categoryObject.getTransferValue(this.sourceBox.getSelectedIndex()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Color color = Color.black;
        if (big != null && (bigi = big.toBigInteger()).compareTo(new BigInteger("FFFFFF", 16)) <= 0 && bigi.compareTo(new BigInteger("0")) > 0) {
            color = new Color(bigi.intValue());
        }
        JColorChooser.setDefaultLocale(Locale.getDefault());
        Color newColor = JColorChooser.showDialog(this, this.rb.getString("GUI.General.ColorPicker"), color);
        if (newColor != null) {
            this.categoryBox.setSelectedItem(this.categoryHashMap.get("COLOR"));
            try {
                this.setValue(new BigDecimal(Integer.toString(newColor.getRGB() & 0xFFFFFF)));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    private JFileChooser newSingleton_JFileChooserSave() {
        if (this.fc_save == null) {
            this.fc_save = new JFileChooser();
            this.fc_save.removeChoosableFileFilter(this.fc_save.getAcceptAllFileFilter());
            if (this.html == null) {
                this.html = new ExampleFileFilter("html", "HTML, UTF-8");
            }
            if (this.vcs == null) {
                this.vcs = new ExampleFileFilter("vcs", "vCalendar");
            }
            if (this.ics == null) {
                this.ics = new ExampleFileFilter("ics", "iCalendar");
            }
            if (this.xcs == null) {
                this.xcs = new ExampleFileFilter("xcs", "xCal");
            }
            if (this.utf8 == null) {
                this.utf8 = new ExampleFileFilter("txt", "Unicode text, UTF-8");
            }
            if (this.iso8859 == null) {
                this.iso8859 = new ExampleFileFilter("txt", "Text, ISO8859_1");
            }
            if (this.utf16le == null) {
                this.utf16le = new ExampleFileFilter("txt", "Unicode text, UTF-16 little-endian");
            }
            if (this.utf16be == null) {
                this.utf16be = new ExampleFileFilter("txt", "Unicode text, UTF-16 big-endian");
            }
            this.fc_save.addChoosableFileFilter(this.html);
            this.fc_save.addChoosableFileFilter(this.vcs);
            this.fc_save.addChoosableFileFilter(this.ics);
            this.fc_save.addChoosableFileFilter(this.xcs);
            this.fc_save.addChoosableFileFilter(this.utf8);
            this.fc_save.addChoosableFileFilter(this.iso8859);
            this.fc_save.addChoosableFileFilter(this.utf16le);
            this.fc_save.addChoosableFileFilter(this.utf16be);
            this.fc_save.setFileFilter(this.utf8);
        }
        return this.fc_save;
    }

    private String encodingFromFileFilter(ExampleFileFilter ff) {
        String encoding = null;
        if (ff.equals(this.utf16be)) {
            encoding = "UnicodeBig";
        } else if (ff.equals(this.utf16le)) {
            encoding = "UnicodeLittle";
        } else if (ff.equals(this.utf8)) {
            encoding = "UTF-8";
        } else if (ff.equals(this.iso8859) || ff.equals(this.vcs)) {
            encoding = "ISO8859_1";
        } else if (ff.equals(this.html)) {
            encoding = "UTF-8";
        } else if (ff.equals(this.ics) || ff.equals(this.xcs)) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private int processList(ListGeneratorCluster generator) {
        int i;
        block7: {
            i = 0;
            BigDecimal runValue = generator.getStartValue();
            boolean firstRun = true;
            try {
                if (generator.getStartValue().equals(generator.getEndValue())) {
                    this.setValue(runValue);
                    ++i;
                    this.performNotice();
                    break block7;
                }
                while (runValue.add(generator.getStepValue()).compareTo(generator.getEndValue()) <= 0) {
                    if (firstRun) {
                        this.setValue(runValue);
                        firstRun = false;
                    } else {
                        this.addValue(generator.getStepValue());
                    }
                    if (this.editorNoticeButton.isEnabled()) {
                        ++i;
                        this.performNotice();
                        runValue = new BigDecimal(this.categoryObject.getTransferValue(this.sourceBox.getSelectedIndex()));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.messageError(e.getMessage());
                this.categoryObject.setInput(this.sourceTextArea.getText());
            }
        }
        return i;
    }

    private Map getCategoryMapping() {
        LinkedHashMap map = new LinkedHashMap(128);
        return map;
    }

    private CategoryObject newInstanceOf(String name) {
        try {
            return this.newInstanceOf(Class.forName("net.numericalchameleon.categories." + name));
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            return null;
        }
    }

    private CategoryObject newInstanceOf(Class clazz) {
        try {
            Class[] argTypes = new Class[]{CategoryInterface.class};
            Constructor constructor = clazz.getDeclaredConstructor(argTypes);
            Object[] arguments = new Object[]{this};
            return (CategoryObject)constructor.newInstance(arguments);
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    private void initClassMap() {
        this.classMap = new HashMap();
        this.classMap.put("ALPHAPHONE", CategoryAlphaPhone.class);
        this.classMap.put("ANGLE", CategoryAngle.class);
        this.classMap.put("RADIX35", CategoryBases35.class);
        this.classMap.put("CALENDARS", CategoryCalendarSystems.class);
        this.classMap.put("COLOR", CategoryColor.class);
        this.classMap.put("COORD", CategoryCoordinates.class);
        this.classMap.put("CALENDARFORMATS", CategoryDateFormats.class);
        this.classMap.put("CALENDAR", CategoryDateQueries.class);
        this.classMap.put("DIALCODE", CategoryDialCodes.class);
        this.classMap.put("FINGERPRINTS", CategoryDigitalFingerprints.class);
        this.classMap.put("CALENDARYEAR", CategoryHolidays.class);
        this.classMap.put("FRACTIONS", CategoryRationalNumbers.class);
        this.classMap.put("ROMAN", CategoryRomanNumerals.class);
        this.classMap.put("STEIGUNG", CategorySlope.class);
        this.classMap.put("SPOKENNUMBERS", CategorySpokenNumbers.class);
        this.classMap.put("SPOKENTIME", CategorySpokenTime.class);
        this.classMap.put("TEMPERATURE", CategoryTemperatures.class);
        this.classMap.put("TIMEZONES", CategoryTimezones.class);
        this.classMap.put("UNICODE", CategoryUnicode.class);
    }

    private void initCacheMap() {
        this.cacheMap = new HashMap();
    }

    private CategoryObject constructCategoryObjectFromCategory(Category category) {
        CategoryObject co;
        String code = category.getName();
        if (this.classMap.containsKey(code)) {
            if (this.cacheMap.containsKey(code)) {
                co = this.cacheMap.get(code);
            } else {
                co = this.newInstanceOf(this.classMap.get(code));
                this.cacheMap.put(code, co);
            }
        } else {
            co = new CategoryGeneric(code, category.getLogic(), this);
        }
        co.setPreferredPrecision(category.getPreferredPrecision());
        return co;
    }

    private void playNumber() {
        try {
            this.categoryObject.play((Unit)this.targetBox.getSelectedItem());
        }
        catch (Exception e) {
            this.messageLightError(this.rb.getString("Message.GUI.SoundsNotFound"));
        }
    }

    private boolean propertiesForAllUsersWritable() {
        try {
            File.createTempFile(".check", null, new File("../data/")).delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void savePropertiesForAllUsers() {
        if (this.isDebug()) {
            System.out.println("Saving properties for all users ...");
        }
        try {
            FileOutputStream out = new FileOutputStream("../data/.nc.properties");
            this.propertiesForAllUsers.store(out, "/* properties updated */");
            if (this.isDebug()) {
                System.out.println("OK.");
            }
        }
        catch (IOException e) {
            try {
                FileOutputStream out = new FileOutputStream("../../data/.nc.properties");
                this.propertiesForAllUsers.store(out, "/* properties updated */");
                if (this.isDebug()) {
                    System.out.println("OK.");
                }
            }
            catch (IOException e2) {
                System.err.println(e2.toString());
            }
        }
    }

    private void saveUserProperties() {
        if (this.isDebug()) {
            System.out.print("Saving user properties ...");
        }
        try {
            FileOutputStream out = new FileOutputStream(System.getProperty("user.home") + File.separator + ".NumericalChameleon/.nc.properties");
            this.userProps.store(out, "/* properties updated */");
            if (this.isDebug()) {
                System.out.println("OK.");
            }
        }
        catch (IOException e3) {
            System.err.println(e3.toString());
        }
    }

    private void setBoundsForUserProps() {
        this.userProps.setProperty("width", Integer.toString(this.getWidth()));
        this.userProps.setProperty("heigth", Integer.toString(this.getHeight()));
        this.userProps.setProperty("locationX", Integer.toString(this.getX()));
        this.userProps.setProperty("locationY", Integer.toString(this.getY()));
    }

    private boolean isPortable() {
        return System.getProperty("user.home").equals(".");
    }

    private void restart() {
        this.saveWork();
        this.dontPanic();
        this.prepareHardExit();
        try {
            String[] JVMoptions = System.getProperty("os.name").equalsIgnoreCase(MAC_OS_X) ? new String[]{"-Dapple.laf.useScreenMenuBar=true", "-Dcom.apple.macos.useScreenMenuBar=true", "-Dcom.apple.macos.use-file-dialog-packages=true", "-Dcom.apple.mrj.application.apple.menu.about.name=NumericalChameleon", "-Xdock:name=NumericalChameleon", "-Xdock:icon=./unix-like/nc.icns", "-DwaitBeforeStart=1000"} : new String[]{"-DwaitBeforeStart=1000"};
            String[] args = null;
            Class clazz = this.isPortable() ? MainPortable.class : net.numericalchameleon.Main.class;
            ProcessHelper.startJarApplication(JVMoptions, clazz, args);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.hardExit();
    }

    private void openTimeChooserDialog() {
        TimeChooserPayload payload = new TimeChooserPayload();
        payload.setCalendar(new GregorianCalendar());
        TimeChooserDialog timeChooserDialog = new TimeChooserDialog(this, payload);
        if (!payload.isCancelled()) {
            if (this.categoryBox.getSelectedItem() != this.categoryHashMap.get("SPOKENTIME")) {
                this.categoryBox.setSelectedItem(this.categoryHashMap.get("SPOKENTIME"));
                this.categoryBoxItemStateChanged();
            }
            try {
                int value = payload.getCalcandar().get(11) * 100 + payload.getCalcandar().get(12);
                this.setValue(BigDecimal.valueOf(value));
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
    }

    private void groupComboBoxItemSelected(Object obj) {
        Group groupRecord = (Group)obj;
        if (groupRecord.getId().equals("all")) {
            this.clickOnFilterCategoryIndicator();
            return;
        }
        if (groupRecord.getId().equals("random")) {
            int[] array;
            this.groupCurrentSelection.clear();
            this.groupHashSet.clear();
            int count = RandomGenerator.getRandom(1, Math.min(7, this.groupAllCategories.size()));
            for (int i : array = RandomGenerator.generate(count, 0, this.groupAllCategories.size() - 1, false, true)) {
                this.groupHashSet.add(this.groupAllCategories.get(i));
                this.groupCurrentSelection.add(this.groupAllCategories.get(i));
            }
            this.filterCatIndicatorLabel.setToolTipText(GeneralString.message(this.rb.getString("GUI.Area.NoFilter"), groupRecord.getDescription()));
            this.filterCatIndicatorLabel.setVisible(true);
            this.fillCategoryModel(this.groupCurrentSelection);
            this.categoryBoxItemStateChanged();
            return;
        }
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream("/data/groups/" + groupRecord.getId() + ".group");
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            this.groupCurrentSelection.clear();
            this.groupHashSet.clear();
            while ((thisLine = br.readLine()) != null) {
                if (thisLine.length() == 0 || thisLine.startsWith("#")) continue;
                this.groupHashSet.add(thisLine);
                this.groupCurrentSelection.add(thisLine);
            }
            br.close();
            is.close();
            this.filterCatIndicatorLabel.setToolTipText(GeneralString.message(this.rb.getString("GUI.Area.NoFilter"), groupRecord.getDescription()));
            this.filterCatIndicatorLabel.setVisible(true);
            this.fillCategoryModel(this.groupCurrentSelection);
            this.categoryBoxItemStateChanged();
        }
        catch (IOException e) {
            System.err.println(e);
            this.error("ERROR: group file corrupted.");
        }
    }

    private boolean reallyExit() {
        int result = 0;
        if (this.userProps.getProperty("askBeforeExit", "true").equals("true")) {
            result = JOptionPane.showConfirmDialog(this, this.rb.getString("Message.GUI.ReallyQuit"), this.rb.getString("GUI.Menu.Main.Exit"), 1, 3, new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix48x48/quit.png")));
        }
        return result == 0;
    }

    private void saveExit() {
        if (this.reallyExit()) {
            this.saveWork();
            this.prepareHardExit();
            this.hardExit();
        }
    }

    private List<String> getRuntimePropertiesAsList() {
        HashMap<String, String> map = new HashMap<String, String>(128);
        SupportNC.addProgramPropertiesToMap(map);
        Support.addSystemPropertiesToMap(map);
        return Support.getMapAsList(map);
    }

    private static void googleMaps(String latlong) throws Exception {
        latlong = latlong.replace(' ', '+');
        String address = "http://maps.google.com/maps?q=" + latlong + "&iwloc=A";
        jonelo.sugar.gui.GUIHelper.openInBrowser(address);
    }

    private void initComponents() {
        this.sourcePopupMenu = new JPopupMenu();
        this.sourcePopupMenuItemUndo = new JMenuItem();
        this.sourcePopupMenuItemRedo = new JMenuItem();
        this.jSeparator26 = new JSeparator();
        this.sourcePopupMenuItemCut = new JMenuItem();
        this.sourcePopupMenuItemCopy = new JMenuItem();
        this.sourcePopupMenuItemPaste = new JMenuItem();
        this.jSeparator16 = new JSeparator();
        this.sourcePopupMenuItemFindUnit = new JMenuItem();
        this.sourcePopupMenuItemDefault = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.sourcePopupMenuItemPlus = new JMenuItem();
        this.sourcePopupMenuItemMinus = new JMenuItem();
        this.sourcePopupMenuDefaultValue = new JMenuItem();
        this.targetPopupMenu = new JPopupMenu();
        this.targetPopupMenuItemCopy = new JMenuItem();
        this.jSeparator11 = new JSeparator();
        this.targetPopupMenuItemFindUnit = new JMenuItem();
        this.targetPopupMenuItemDefault = new JMenuItem();
        this.jSeparator14 = new JSeparator();
        this.targetPopupMenuItemPlay = new JMenuItem();
        this.targetPopupMenuItemStopPlaying = new JMenuItem();
        this.historyPopupMenu = new JPopupMenu();
        this.historyMenuItemUndo = new JMenuItem();
        this.historyMenuItemRedo = new JMenuItem();
        this.jSeparator24 = new JSeparator();
        this.historyMenuItemCut = new JMenuItem();
        this.historyMenuItemCopy = new JMenuItem();
        this.historyMenuItemPaste = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.historyPopupMenuItemNew = new JMenuItem();
        this.historyPopupMenuItemMakeList = new JMenuItem();
        this.historyPopupMenuenuItemFormat = new JMenuItem();
        this.historyMenuFontSize = new JMenuItem();
        this.historyPopupMenuItemHTML = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.historyMenuItemLoad = new JMenuItem();
        this.historyMenuItemSave = new JMenuItem();
        this.frameButtonGroup = new ButtonGroup();
        this.converterPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.headerPanel = new JPanel();
        this.categoryBox = new JComboBox();
        this.conversionLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.categoryUpButton = new JButton();
        this.categoryDownButton = new JButton();
        this.searchCategoryButton = new JButton();
        this.categoryHelpButton = new JButton();
        this.groupComboBox = new JComboBox();
        this.groupLabel = new JLabel();
        this.sourcePanel = new JPanel();
        this.sourceHeaderPanel = new JPanel();
        this.sourceBox = new JComboBox();
        this.sourceScrollPane = new JScrollPane();
        this.sourceTextArea = new JTextArea();
        this.findSourceButton = new JButton();
        this.jPanel1 = new JPanel();
        this.sourceBackButton = new JButton();
        this.sourceNextButton = new JButton();
        this.sourceButtonPanel = new JPanel();
        this.sourceClearButton = new JButton();
        this.sourceMinusButton = new JButton();
        this.sourcePlusButton = new JButton();
        this.sourceCopyButton = new JButton();
        this.sourcePasteButton = new JButton();
        this.swapButton = new JButton();
        this.targetPanel = new JPanel();
        this.targetHeaderPanel = new JPanel();
        this.targetBox = new JComboBox();
        this.targetScrollPane = new JScrollPane();
        this.targetTextArea = new JTextArea();
        this.jPanel2 = new JPanel();
        this.targetBackButton = new JButton();
        this.targetNextButton = new JButton();
        this.findTargetButton = new JButton();
        this.targetButtonPanel = new JPanel();
        this.targetCopyButton = new JButton();
        this.cardPanel = new JPanel();
        this.sciPanel = new JPanel();
        this.precisionLabel = new JLabel();
        this.precisionTextField = new JTextField();
        this.sciCheckBox = new JCheckBox();
        this.soundPanel = new JPanel();
        this.numberTypeComboBox = new JComboBox();
        this.playButton = new JButton();
        this.stopButton = new JButton();
        this.timePanel = new JPanel();
        this.playTimeButton = new JButton();
        this.stopPlayingTimeButton = new JButton();
        this.timePanelTimeChooserButton = new JButton();
        this.calPanel = new JPanel();
        this.jButton1 = new JButton();
        this.colPanel = new JPanel();
        this.colorButton = new JButton();
        this.tzPanel = new JPanel();
        this.deltaLabel = new JLabel();
        this.tzLocationsButton = new JButton();
        this.fingerprintPanel = new JPanel();
        this.fingerprintComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.datePanel = new JPanel();
        this.dateFormatComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.googleMapsPanel = new JPanel();
        this.googleMapsButton = new JButton();
        this.unicodePanel = new JPanel();
        this.unicodeButton = new JButton();
        this.emptyPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSeparator29 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSeparator30 = new JSeparator();
        this.recordPanel = new JPanel();
        this.historyPane = new JScrollPane();
        this.historyTextArea = new JTextArea();
        this.historyButtonPanel = new JPanel();
        this.editorNoticeButton = new JButton();
        this.makeListButton = new JButton();
        this.historyClearButton = new JButton();
        this.historyCopyButton = new JButton();
        this.historyPasteButton = new JButton();
        this.saveButton = new JButton();
        this.bottomPanel = new JPanel();
        this.messageTextField = new JTextField();
        this.warnLabel = new JLabel();
        this.warnLabel.setVisible(false);
        this.filterCatIndicatorLabel = new JLabel();
        this.filterCatIndicatorLabel.setVisible(false);
        this.editTogglePanel = new JPanel();
        this.editToggleButton = new JToggleButton();
        this.editToggleButton.setVisible(false);
        this.jLabel4 = new JLabel();
        this.jSeparator31 = new JSeparator();
        this.navigationPanel = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.editFavoritesjButton = new JButton();
        this.addFavoritesButton = new JButton();
        this.swapToolbarButton = new JButton();
        this.datatablesButton = new JButton();
        this.jSeparator32 = new JSeparator();
        this.calculatorButton = new JButton();
        this.calendarButton = new JButton();
        this.timeDialogButton = new JButton();
        this.datetimeDiffButton = new JButton();
        this.randomButton = new JButton();
        this.colorToolbarButton = new JButton();
        this.phoneticAlphabetButton = new JButton();
        this.currencyUpdateButton = new JButton();
        this.ncMenuBar = new JMenuBar();
        this.programMenu = new JMenu();
        this.updateCenterMenuItem = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.restartItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.programMenuItemSwap = new JMenuItem();
        this.sourceMenu = new JMenu();
        this.sourceMenuItemUndo = new JMenuItem();
        this.sourceMenuItemRedo = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.sourceMenuItemClear = new JMenuItem();
        this.sourceMenuItemCopy = new JMenuItem();
        this.sourceMenuItemPaste = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.sourceMenuItemFindUnit = new JMenuItem();
        this.sourceMenuItemDefault = new JMenuItem();
        this.jSeparator25 = new JSeparator();
        this.sourceMenuItemPlus = new JMenuItem();
        this.sourceMenuItemMinus = new JMenuItem();
        this.sourceMenuItemDefaultValue = new JMenuItem();
        this.targetMenu = new JMenu();
        this.targetMenuItemCopy = new JMenuItem();
        this.targetMenuItemFigures = new JMenuItem();
        this.targetMenuItemDecimals = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.targetMenuItemFindUnit = new JMenuItem();
        this.targetMenuItemDefault = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.targetMenuItemPlay = new JMenuItem();
        this.targetMenuItemStopPlaying = new JMenuItem();
        this.recordMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.recordMenuItemClear = new JMenuItem();
        this.recordMenuItemCopy = new JMenuItem();
        this.recordMenuItemPaste = new JMenuItem();
        this.jSeparator22 = new JSeparator();
        this.recordMenuItemNew = new JMenuItem();
        this.recordMenuItemMakeList = new JMenuItem();
        this.recordMenuItemFormat = new JMenuItem();
        this.recordMenuItemFontsize = new JMenuItem();
        this.htmlMenuItem = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.loadMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.countUnitsMenuItem = new JMenuItem();
        this.unitsMenu = new JMenu();
        this.editUnitsMenuItem = new JMenuItem();
        this.reloadUnitsItem = new JMenuItem();
        this.categoriesMenu = new JMenu();
        this.editCategoriesMenuItem = new JMenuItem();
        this.reloadCategoriesMenuItem = new JMenuItem();
        this.jSeparator12 = new JSeparator();
        this.propsMenuItem = new JMenuItem();
        this.frameMenu = new JMenu();
        this.miserlyRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.economicalRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.standardRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.luxuryRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.maximumRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.navigationMenu = new JMenu();
        this.searchMenu = new JMenu();
        this.searchSourceMenuItem = new JMenuItem();
        this.searchTargetMenuItem = new JMenuItem();
        this.jSeparator21 = new JSeparator();
        this.searchCategoriesMenuItem = new JMenuItem();
        this.favoritesMenu = new JMenu();
        this.addFavoriteMenuItem = new JMenuItem();
        this.manageFavoritesMenuItem = new JMenuItem();
        this.filterMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.tablesMenuItem = new JMenuItem();
        this.ToolsMenu = new JMenu();
        this.calculatorMenuItem = new JMenuItem();
        this.sourceMenuItemCalendar = new JMenuItem();
        this.timeDialogMenuItem = new JMenuItem();
        this.dateDiffMenuItem = new JMenuItem();
        this.randomNumbersMenuItem = new JMenuItem();
        this.sourceMenuItemColor = new JMenuItem();
        this.spellMenuItem = new JMenuItem();
        this.updateExchangeRatesMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpIndexMenuItem = new JMenuItem();
        this.tutorialMenuItem = new JMenuItem();
        this.supportMenuItem = new JMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.homepageMenuItem = new JMenuItem();
        this.helpMenuItemAbout = new JMenuItem();
        this.sourcePopupMenuItemUndo.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/undo.png")));
        this.sourcePopupMenuItemUndo.setText(this.rb.getString("GUI.General.Undo"));
        this.sourcePopupMenuItemUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemUndoActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemUndo);
        this.sourcePopupMenuItemRedo.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/redo.png")));
        this.sourcePopupMenuItemRedo.setText(this.rb.getString("GUI.General.Redo"));
        this.sourcePopupMenuItemRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemRedoActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemRedo);
        this.sourcePopupMenu.add(this.jSeparator26);
        this.sourcePopupMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-cut.png")));
        this.sourcePopupMenuItemCut.setText(this.rb.getString("GUI.General.Cut"));
        this.sourcePopupMenuItemCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemCutActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemCut);
        this.sourcePopupMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.sourcePopupMenuItemCopy.setText(this.rb.getString("GUI.General.Copy"));
        this.sourcePopupMenuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemCopyActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemCopy);
        this.sourcePopupMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-paste.png")));
        this.sourcePopupMenuItemPaste.setText(this.rb.getString("GUI.General.Paste"));
        this.sourcePopupMenuItemPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemPasteActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemPaste);
        this.sourcePopupMenu.add(this.jSeparator16);
        this.sourcePopupMenuItemFindUnit.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.sourcePopupMenuItemFindUnit.setText(this.rb.getString("GUI.Menu.Source.FindUnit"));
        this.sourcePopupMenuItemFindUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemFindUnitActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemFindUnit);
        this.sourcePopupMenuItemDefault.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-stop-square.png")));
        this.sourcePopupMenuItemDefault.setText(this.rb.getString("GUI.Menu.Source.Default"));
        this.sourcePopupMenuItemDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemDefaultActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemDefault);
        this.sourcePopupMenu.add(this.jSeparator2);
        this.sourcePopupMenuItemPlus.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-090.png")));
        this.sourcePopupMenuItemPlus.setText("+1");
        this.sourcePopupMenuItemPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemPlusActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemPlus);
        this.sourcePopupMenuItemMinus.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-270.png")));
        this.sourcePopupMenuItemMinus.setText("-1");
        this.sourcePopupMenuItemMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuItemMinusActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuItemMinus);
        this.sourcePopupMenuDefaultValue.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-stop-square.png")));
        this.sourcePopupMenuDefaultValue.setText(this.rb.getString("GUI.Menu.Source.DefaultValue"));
        this.sourcePopupMenuDefaultValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePopupMenuDefaultValueActionPerformed(evt);
            }
        });
        this.sourcePopupMenu.add(this.sourcePopupMenuDefaultValue);
        this.targetPopupMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.targetPopupMenuItemCopy.setText(this.rb.getString("GUI.General.Copy"));
        this.targetPopupMenuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetPopupMenuItemCopyActionPerformed(evt);
            }
        });
        this.targetPopupMenu.add(this.targetPopupMenuItemCopy);
        this.targetPopupMenu.add(this.jSeparator11);
        this.targetPopupMenuItemFindUnit.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.targetPopupMenuItemFindUnit.setText(this.rb.getString("GUI.Menu.Target.FindUnit"));
        this.targetPopupMenuItemFindUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetPopupMenuItemFindUnitActionPerformed(evt);
            }
        });
        this.targetPopupMenu.add(this.targetPopupMenuItemFindUnit);
        this.targetPopupMenuItemDefault.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-stop-square.png")));
        this.targetPopupMenuItemDefault.setText(this.rb.getString("GUI.Menu.Target.Default"));
        this.targetPopupMenuItemDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetPopupMenuItemDefaultActionPerformed(evt);
            }
        });
        this.targetPopupMenu.add(this.targetPopupMenuItemDefault);
        this.targetPopupMenu.add(this.jSeparator14);
        this.targetPopupMenuItemPlay.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-high.png")));
        this.targetPopupMenuItemPlay.setText(this.rb.getString("GUI.Menu.Target.Play"));
        this.targetPopupMenuItemPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetPopupMenuItemPlayActionPerformed(evt);
            }
        });
        this.targetPopupMenu.add(this.targetPopupMenuItemPlay);
        this.targetPopupMenuItemStopPlaying.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-muted.png")));
        this.targetPopupMenuItemStopPlaying.setText(this.rb.getString("GUI.Menu.Target.StopPlaying"));
        this.targetPopupMenuItemStopPlaying.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetPopupMenuItemStopPlayingActionPerformed(evt);
            }
        });
        this.targetPopupMenu.add(this.targetPopupMenuItemStopPlaying);
        this.historyMenuItemUndo.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/undo.png")));
        this.historyMenuItemUndo.setText(this.rb.getString("GUI.General.Undo"));
        this.historyMenuItemUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuItemUndoActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuItemUndo);
        this.historyMenuItemRedo.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/redo.png")));
        this.historyMenuItemRedo.setText(this.rb.getString("GUI.General.Redo"));
        this.historyMenuItemRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuItemRedoActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuItemRedo);
        this.historyPopupMenu.add(this.jSeparator24);
        this.historyMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-cut.png")));
        this.historyMenuItemCut.setText(this.rb.getString("GUI.General.Cut"));
        this.historyMenuItemCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuItemCutActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuItemCut);
        this.historyMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.historyMenuItemCopy.setText(this.rb.getString("GUI.General.Copy"));
        this.historyMenuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuItemCopyActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuItemCopy);
        this.historyMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-paste.png")));
        this.historyMenuItemPaste.setText(this.rb.getString("GUI.General.Paste"));
        this.historyMenuItemPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuItemPasteActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuItemPaste);
        this.historyPopupMenu.add(this.jSeparator3);
        this.historyPopupMenuItemNew.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-down.png")));
        this.historyPopupMenuItemNew.setText(this.rb.getString("GUI.General.Notice"));
        this.historyPopupMenuItemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyPopupMenuItemNewActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyPopupMenuItemNew);
        this.historyPopupMenuItemMakeList.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/script.png")));
        this.historyPopupMenuItemMakeList.setText(this.rb.getString("GUI.General.MakeList"));
        this.historyPopupMenuItemMakeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyPopupMenuItemMakeListActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyPopupMenuItemMakeList);
        this.historyPopupMenuenuItemFormat.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/format.png")));
        this.historyPopupMenuenuItemFormat.setText(this.rb.getString("GUI.Menu.Records.Format"));
        this.historyPopupMenuenuItemFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyPopupMenuenuItemFormatActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyPopupMenuenuItemFormat);
        this.historyMenuFontSize.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/fontsize.png")));
        this.historyMenuFontSize.setText(this.rb.getString("GUI.Menu.Records.Fontsize"));
        this.historyMenuFontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuFontSizeActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuFontSize);
        this.historyPopupMenuItemHTML.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/format-headerfooter.png")));
        this.historyPopupMenuItemHTML.setText(this.rb.getString("GUI.Menu.Records.AddHTML"));
        this.historyPopupMenuItemHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyPopupMenuItemHTMLActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyPopupMenuItemHTML);
        this.historyPopupMenu.add(this.jSeparator8);
        this.historyMenuItemLoad.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/document-open.png")));
        this.historyMenuItemLoad.setText(this.rb.getString("GUI.General.Load"));
        this.historyMenuItemLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuItemLoadActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuItemLoad);
        this.historyMenuItemSave.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/save.png")));
        this.historyMenuItemSave.setText(this.rb.getString("GUI.General.Save"));
        this.historyMenuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyMenuItemSaveActionPerformed(evt);
            }
        });
        this.historyPopupMenu.add(this.historyMenuItemSave);
        this.setDefaultCloseOperation(0);
        this.setTitle(ProgInfo.getInstance().getProgramName() + " " + ProgInfo.getInstance().getVersion() + " - " + ProgInfo.getInstance().getHomepage());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix32x32/chameleon.png")).getImage());
        this.setName("NumericalChameleon");
        this.converterPanel.setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.headerPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 1, 5));
        this.headerPanel.setLayout(new GridBagLayout());
        this.categoryBox.setMaximumRowCount(12);
        this.categoryBox.setToolTipText(this.rb.getString("GUI.Area.Main.Conversion.ToolTip"));
        this.categoryBox.setMinimumSize(new Dimension(25, 51));
        this.categoryBox.setOpaque(false);
        this.categoryBox.setPreferredSize(new Dimension(29, 51));
        this.categoryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.categoryBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.headerPanel.add((Component)this.categoryBox, gridBagConstraints);
        this.conversionLabel.setText(this.rb.getString("GUI.Area.Main.Category.Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.headerPanel.add((Component)this.conversionLabel, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(2, 0));
        this.categoryUpButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/up.png")));
        this.categoryUpButton.setToolTipText(this.rb.getString("GUI.Area.Previous.Category"));
        this.categoryUpButton.setPreferredSize(new Dimension(15, 13));
        this.categoryUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.categoryUpButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.categoryUpButton);
        this.categoryDownButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/down.png")));
        this.categoryDownButton.setToolTipText(this.rb.getString("GUI.Area.Next.Category"));
        this.categoryDownButton.setPreferredSize(new Dimension(15, 13));
        this.categoryDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.categoryDownButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.categoryDownButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.headerPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.searchCategoryButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.searchCategoryButton.setToolTipText(this.rb.getString("GUI.Menu.Find.FindCategory"));
        this.searchCategoryButton.setMargin(new Insets(2, 2, 2, 2));
        this.searchCategoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.searchCategoryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.headerPanel.add((Component)this.searchCategoryButton, gridBagConstraints);
        this.categoryHelpButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/question-white.png")));
        this.categoryHelpButton.setMargin(new Insets(2, 2, 2, 2));
        this.categoryHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.categoryHelpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.headerPanel.add((Component)this.categoryHelpButton, gridBagConstraints);
        this.groupComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Main.this.groupComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.headerPanel.add((Component)this.groupComboBox, gridBagConstraints);
        this.groupLabel.setText(this.rb.getString("GUI.GroupColon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.headerPanel.add((Component)this.groupLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.headerPanel, gridBagConstraints);
        this.sourcePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.sourcePanel.setLayout(new GridBagLayout());
        this.sourceHeaderPanel.setLayout(new GridBagLayout());
        this.sourceBox.setMaximumRowCount(20);
        this.sourceBox.setToolTipText(this.rb.getString("GUI.Area.Source.ComboBox.ToolTip"));
        this.sourceBox.setMinimumSize(new Dimension(260, 25));
        this.sourceBox.setPreferredSize(new Dimension(260, 25));
        this.sourceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceBoxActionPerformed(evt);
            }
        });
        this.sourceBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Main.this.sourceBoxComponentResized(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.sourceHeaderPanel.add((Component)this.sourceBox, gridBagConstraints);
        this.sourceScrollPane.setHorizontalScrollBarPolicy(32);
        this.sourceScrollPane.setVerticalScrollBarPolicy(21);
        this.sourceScrollPane.setMinimumSize(new Dimension(300, 40));
        this.sourceScrollPane.setPreferredSize(new Dimension(300, 40));
        this.sourceTextArea.setFont(new Font("Dialog", 0, 16));
        this.sourceTextArea.setRows(1);
        this.sourceTextArea.setToolTipText(this.rb.getString("GUI.Area.Source.TextField.ToolTip"));
        this.sourceTextArea.setBorder(BorderFactory.createCompoundBorder());
        this.sourceTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.sourceTextAreaMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Main.this.sourceTextAreaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.sourceTextAreaMouseReleased(evt);
            }
        });
        this.sourceTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Main.this.sourceTextAreaKeyReleased(evt);
            }
        });
        this.sourceScrollPane.setViewportView(this.sourceTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.sourceHeaderPanel.add((Component)this.sourceScrollPane, gridBagConstraints);
        this.findSourceButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.findSourceButton.setToolTipText(this.rb.getString("GUI.Menu.Find.FindSourceUnit"));
        this.findSourceButton.setMargin(new Insets(2, 2, 2, 2));
        this.findSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.findSourceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.sourceHeaderPanel.add((Component)this.findSourceButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(2, 0));
        this.sourceBackButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/up.png")));
        this.sourceBackButton.setToolTipText(this.rb.getString("GUI.Area.Back.Button"));
        this.sourceBackButton.setMargin(new Insets(1, 1, 1, 1));
        this.sourceBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceBackButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.sourceBackButton);
        this.sourceNextButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/down.png")));
        this.sourceNextButton.setToolTipText(this.rb.getString("GUI.Area.Next.Button"));
        this.sourceNextButton.setMargin(new Insets(1, 1, 1, 1));
        this.sourceNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceNextButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.sourceNextButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.sourceHeaderPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.sourcePanel.add((Component)this.sourceHeaderPanel, gridBagConstraints);
        this.sourceButtonPanel.setLayout(new GridBagLayout());
        this.sourceClearButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-cut.png")));
        this.sourceClearButton.setToolTipText(this.rb.getString("GUI.Area.Source.Cut.ToolTip"));
        this.sourceClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceClearButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.sourceButtonPanel.add((Component)this.sourceClearButton, gridBagConstraints);
        this.sourceMinusButton.setMnemonic('-');
        this.sourceMinusButton.setText("-1");
        this.sourceMinusButton.setToolTipText(this.rb.getString("GUI.Area.Source.Sub1.ToolTip"));
        this.sourceMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMinusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.sourceButtonPanel.add((Component)this.sourceMinusButton, gridBagConstraints);
        this.sourcePlusButton.setMnemonic('1');
        this.sourcePlusButton.setText("+1");
        this.sourcePlusButton.setToolTipText(this.rb.getString("GUI.Area.Source.Add1.ToolTip"));
        this.sourcePlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePlusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.sourceButtonPanel.add((Component)this.sourcePlusButton, gridBagConstraints);
        this.sourceCopyButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.sourceCopyButton.setToolTipText(this.rb.getString("GUI.Area.Source.Copy.ToolTip"));
        this.sourceCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceCopyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.sourceButtonPanel.add((Component)this.sourceCopyButton, gridBagConstraints);
        this.sourcePasteButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-paste.png")));
        this.sourcePasteButton.setToolTipText(this.rb.getString("GUI.Area.Source.Paste.ToolTip"));
        this.sourcePasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourcePasteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.sourceButtonPanel.add((Component)this.sourcePasteButton, gridBagConstraints);
        this.swapButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/swap.png")));
        this.swapButton.setMnemonic('w');
        this.swapButton.setToolTipText(this.rb.getString("GUI.Menu.Main.Switch"));
        this.swapButton.setMaximumSize(new Dimension(35, 35));
        this.swapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.swapButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.sourceButtonPanel.add((Component)this.swapButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.sourcePanel.add((Component)this.sourceButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        this.mainPanel.add((Component)this.sourcePanel, gridBagConstraints);
        this.targetPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.targetPanel.setLayout(new GridBagLayout());
        this.targetHeaderPanel.setLayout(new GridBagLayout());
        this.targetBox.setMaximumRowCount(20);
        this.targetBox.setToolTipText(this.rb.getString("GUI.Area.Target.ComboBox.ToolTip"));
        this.targetBox.setMinimumSize(new Dimension(260, 25));
        this.targetBox.setPreferredSize(new Dimension(260, 25));
        this.targetBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetBoxActionPerformed(evt);
            }
        });
        this.targetBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Main.this.targetBoxComponentResized(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.targetHeaderPanel.add((Component)this.targetBox, gridBagConstraints);
        this.targetScrollPane.setHorizontalScrollBarPolicy(32);
        this.targetScrollPane.setVerticalScrollBarPolicy(21);
        this.targetScrollPane.setMinimumSize(new Dimension(300, 40));
        this.targetScrollPane.setPreferredSize(new Dimension(300, 40));
        this.targetTextArea.setBackground(new Color(230, 230, 230));
        this.targetTextArea.setEditable(false);
        this.targetTextArea.setFont(new Font("Dialog", 0, 16));
        this.targetTextArea.setRows(1);
        this.targetTextArea.setToolTipText(this.rb.getString("GUI.Area.Target.TextField.ToolTip"));
        this.targetTextArea.setBorder(BorderFactory.createCompoundBorder());
        this.targetTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.targetTextAreaMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Main.this.targetTextAreaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.targetTextAreaMouseReleased(evt);
            }
        });
        this.targetScrollPane.setViewportView(this.targetTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.targetHeaderPanel.add((Component)this.targetScrollPane, gridBagConstraints);
        this.jPanel2.setLayout(new GridLayout(2, 0));
        this.targetBackButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/up.png")));
        this.targetBackButton.setToolTipText(this.rb.getString("GUI.Area.Back.Button"));
        this.targetBackButton.setMargin(new Insets(1, 1, 1, 1));
        this.targetBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetBackButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.targetBackButton);
        this.targetNextButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix6x3/down.png")));
        this.targetNextButton.setToolTipText(this.rb.getString("GUI.Area.Next.Button"));
        this.targetNextButton.setMargin(new Insets(1, 1, 1, 1));
        this.targetNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetNextButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.targetNextButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.targetHeaderPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.findTargetButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.findTargetButton.setToolTipText(this.rb.getString("GUI.Menu.Find.FindTargetUnit"));
        this.findTargetButton.setMargin(new Insets(2, 2, 2, 2));
        this.findTargetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.findTargetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.targetHeaderPanel.add((Component)this.findTargetButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.targetPanel.add((Component)this.targetHeaderPanel, gridBagConstraints);
        this.targetButtonPanel.setLayout(new GridBagLayout());
        this.targetCopyButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.targetCopyButton.setToolTipText(this.rb.getString("GUI.Area.Source.Copy.ToolTip"));
        this.targetCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetCopyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.targetButtonPanel.add((Component)this.targetCopyButton, gridBagConstraints);
        this.cardPanel.setLayout(new CardLayout());
        this.cardLayout = (CardLayout)this.cardPanel.getLayout();
        this.precisionLabel.setText(this.rb.getString("GUI.Menu.Target.PlacesOfDecimals"));
        this.precisionLabel.setToolTipText(this.rb.getString("GUI.Area.Target.PlacesOfDecimals.ToolTip"));
        this.precisionTextField.setText("2");
        this.precisionTextField.setToolTipText(this.rb.getString("GUI.Area.Target.PlacesOfDecimals.ToolTip"));
        this.precisionTextField.setBorder(BorderFactory.createEtchedBorder());
        this.precisionTextField.setMinimumSize(new Dimension(30, 20));
        this.precisionTextField.setPreferredSize(new Dimension(30, 20));
        this.precisionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Main.this.precisionTextFieldKeyReleased(evt);
            }
        });
        this.sciCheckBox.setText("SCI");
        this.sciCheckBox.setToolTipText(this.rb.getString("GUI.Area.Target.SCI"));
        this.sciCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Main.this.sciCheckBoxItemStateChanged(evt);
            }
        });
        this.sciCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sciCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout sciPanelLayout = new GroupLayout(this.sciPanel);
        this.sciPanel.setLayout(sciPanelLayout);
        sciPanelLayout.setHorizontalGroup(sciPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sciPanelLayout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.precisionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.precisionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sciCheckBox).addContainerGap()));
        sciPanelLayout.setVerticalGroup(sciPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sciPanelLayout.createSequentialGroup().addGroup(sciPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.precisionTextField, -2, -1, -2).addComponent(this.sciCheckBox).addComponent(this.precisionLabel)).addContainerGap(13, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.sciPanel, "sciCard");
        this.numberTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this.rb.getString("SpokenNumber.Number"), this.rb.getString("SpokenNumber.Digits")}));
        this.numberTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.numberTypeComboBoxActionPerformed(evt);
            }
        });
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-high.png")));
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.playButtonActionPerformed(evt);
            }
        });
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-muted.png")));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.stopButtonActionPerformed(evt);
            }
        });
        GroupLayout soundPanelLayout = new GroupLayout(this.soundPanel);
        this.soundPanel.setLayout(soundPanelLayout);
        soundPanelLayout.setHorizontalGroup(soundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, soundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.numberTypeComboBox, 0, 70, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.playButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopButton).addContainerGap()));
        soundPanelLayout.setVerticalGroup(soundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(soundPanelLayout.createSequentialGroup().addGroup(soundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stopButton).addComponent(this.playButton).addComponent(this.numberTypeComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.soundPanel, "soundCard");
        this.playTimeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-high.png")));
        this.playTimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.playTimeButtonActionPerformed(evt);
            }
        });
        this.stopPlayingTimeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-muted.png")));
        this.stopPlayingTimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.stopPlayingTimeButtonActionPerformed(evt);
            }
        });
        this.timePanelTimeChooserButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/time.png")));
        this.timePanelTimeChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.timePanelTimeChooserButtonActionPerformed(evt);
            }
        });
        GroupLayout timePanelLayout = new GroupLayout(this.timePanel);
        this.timePanel.setLayout(timePanelLayout);
        timePanelLayout.setHorizontalGroup(timePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.playTimeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopPlayingTimeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timePanelTimeChooserButton).addContainerGap(35, Short.MAX_VALUE)));
        timePanelLayout.setVerticalGroup(timePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timePanelLayout.createSequentialGroup().addGroup(timePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.playTimeButton).addComponent(this.stopPlayingTimeButton).addComponent(this.timePanelTimeChooserButton)).addGap(0, 11, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.timePanel, "timeCard");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/calendar.png")));
        this.jButton1.setText(this.rb.getString("GUI.General.DatePicker"));
        this.jButton1.setToolTipText(this.rb.getString("GUI.General.DatePicker"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout calPanelLayout = new GroupLayout(this.calPanel);
        this.calPanel.setLayout(calPanelLayout);
        calPanelLayout.setHorizontalGroup(calPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jButton1, -1, 184, Short.MAX_VALUE).addContainerGap()));
        calPanelLayout.setVerticalGroup(calPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calPanelLayout.createSequentialGroup().addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.calPanel, "calCard");
        this.colorButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/color.png")));
        this.colorButton.setText(this.rb.getString("GUI.General.ColorPicker"));
        this.colorButton.setToolTipText(this.rb.getString("GUI.General.ColorPicker"));
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.colorButtonActionPerformed(evt);
            }
        });
        GroupLayout colPanelLayout = new GroupLayout(this.colPanel);
        this.colPanel.setLayout(colPanelLayout);
        colPanelLayout.setHorizontalGroup(colPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, colPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.colorButton, -1, 184, Short.MAX_VALUE).addContainerGap()));
        colPanelLayout.setVerticalGroup(colPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(colPanelLayout.createSequentialGroup().addComponent(this.colorButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.colPanel, "colCard");
        this.deltaLabel.setText("delta: 0 hours");
        this.tzLocationsButton.setText("Locations");
        this.tzLocationsButton.setVisible(false);
        GroupLayout tzPanelLayout = new GroupLayout(this.tzPanel);
        this.tzPanel.setLayout(tzPanelLayout);
        tzPanelLayout.setHorizontalGroup(tzPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tzPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tzLocationsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 40, Short.MAX_VALUE).addComponent(this.deltaLabel).addContainerGap()));
        tzPanelLayout.setVerticalGroup(tzPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tzPanelLayout.createSequentialGroup().addGroup(tzPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tzLocationsButton).addComponent(this.deltaLabel)).addGap(0, 13, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.tzPanel, "tzCard");
        this.fingerprintComboBox.setMaximumRowCount(20);
        this.fingerprintComboBox.setModel(GeneralGUI.getComboBoxModel(CategoryDigitalFingerprints.getEncodings()));
        this.fingerprintComboBox.setRenderer(new EncodingCellRenderer());
        this.fingerprintComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.fingerprintComboBoxActionPerformed(evt);
            }
        });
        this.jLabel5.setText(this.rb.getString("General.FormatColon"));
        GroupLayout fingerprintPanelLayout = new GroupLayout(this.fingerprintPanel);
        this.fingerprintPanel.setLayout(fingerprintPanelLayout);
        fingerprintPanelLayout.setHorizontalGroup(fingerprintPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fingerprintPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fingerprintComboBox, 0, 142, Short.MAX_VALUE).addContainerGap()));
        fingerprintPanelLayout.setVerticalGroup(fingerprintPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fingerprintPanelLayout.createSequentialGroup().addGroup(fingerprintPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fingerprintComboBox, -2, -1, -2).addComponent(this.jLabel5)).addContainerGap(16, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.fingerprintPanel, "checksumCard");
        this.dateFormatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this.rb.getString("General.SHORT"), this.rb.getString("General.MEDIUM"), this.rb.getString("General.LONG"), this.rb.getString("General.FULL")}));
        this.dateFormatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.dateFormatComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText(this.rb.getString("General.FormatColon"));
        GroupLayout datePanelLayout = new GroupLayout(this.datePanel);
        this.datePanel.setLayout(datePanelLayout);
        datePanelLayout.setHorizontalGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateFormatComboBox, 0, 142, Short.MAX_VALUE).addContainerGap()));
        datePanelLayout.setVerticalGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datePanelLayout.createSequentialGroup().addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dateFormatComboBox, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(16, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.datePanel, "dateCard");
        this.googleMapsButton.setText("Google Maps");
        this.googleMapsButton.setToolTipText("Google Maps");
        this.googleMapsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.googleMapsButtonActionPerformed(evt);
            }
        });
        GroupLayout googleMapsPanelLayout = new GroupLayout(this.googleMapsPanel);
        this.googleMapsPanel.setLayout(googleMapsPanelLayout);
        googleMapsPanelLayout.setHorizontalGroup(googleMapsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(googleMapsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.googleMapsButton, -1, 184, Short.MAX_VALUE).addContainerGap()));
        googleMapsPanelLayout.setVerticalGroup(googleMapsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(googleMapsPanelLayout.createSequentialGroup().addComponent(this.googleMapsButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.googleMapsPanel, "coordCard");
        this.unicodeButton.setText("www.unicode.org");
        this.unicodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.unicodeButtonActionPerformed(evt);
            }
        });
        GroupLayout unicodePanelLayout = new GroupLayout(this.unicodePanel);
        this.unicodePanel.setLayout(unicodePanelLayout);
        unicodePanelLayout.setHorizontalGroup(unicodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unicodePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.unicodeButton, -1, 184, Short.MAX_VALUE).addContainerGap()));
        unicodePanelLayout.setVerticalGroup(unicodePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unicodePanelLayout.createSequentialGroup().addComponent(this.unicodeButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.cardPanel.add((Component)this.unicodePanel, "unicodeCard");
        GroupLayout emptyPanelLayout = new GroupLayout(this.emptyPanel);
        this.emptyPanel.setLayout(emptyPanelLayout);
        emptyPanelLayout.setHorizontalGroup(emptyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 204, Short.MAX_VALUE));
        emptyPanelLayout.setVerticalGroup(emptyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 36, Short.MAX_VALUE));
        this.cardPanel.add((Component)this.emptyPanel, "emptyCard");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.targetButtonPanel.add((Component)this.cardPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.targetPanel.add((Component)this.targetButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        this.mainPanel.add((Component)this.targetPanel, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.jPanel5.setLayout(new BorderLayout());
        this.jLabel2.setText(this.rb.getString("GUI.Menu.Source"));
        this.jPanel5.add((Component)this.jLabel2, "Center");
        this.jPanel5.add((Component)this.jSeparator29, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.mainPanel.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.jPanel6.setLayout(new BorderLayout());
        this.jLabel3.setText(this.rb.getString("GUI.Menu.Target"));
        this.jPanel6.add((Component)this.jLabel3, "West");
        this.jPanel6.add((Component)this.jSeparator30, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.mainPanel.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.converterPanel.add((Component)this.mainPanel, gridBagConstraints);
        this.recordPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.recordPanel.setMinimumSize(new Dimension(642, 300));
        this.recordPanel.setPreferredSize(new Dimension(642, 300));
        this.recordPanel.setLayout(new GridBagLayout());
        if (System.getProperty("os.name").equals(MAC_OS_X)) {
            this.historyPane.setHorizontalScrollBarPolicy(32);
            this.historyPane.setVerticalScrollBarPolicy(22);
        }
        this.historyTextArea.setRows(10);
        this.historyTextArea.setToolTipText(this.rb.getString("GUI.Area.Records.TextArea.ToolTip"));
        this.historyTextArea.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.historyTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.historyAreaMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                Main.this.historyAreaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.historyAreaMouseReleased(evt);
            }
        });
        this.historyPane.setViewportView(this.historyTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.recordPanel.add((Component)this.historyPane, gridBagConstraints);
        this.historyButtonPanel.setLayout(new GridBagLayout());
        this.editorNoticeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-down.png")));
        this.editorNoticeButton.setText(this.rb.getString("GUI.General.Notice"));
        this.editorNoticeButton.setToolTipText(this.rb.getString("GUI.Area.Records.Notice.ToolTip"));
        this.editorNoticeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.editorNoticeButtonActionPerformed(evt);
            }
        });
        this.historyButtonPanel.add((Component)this.editorNoticeButton, new GridBagConstraints());
        this.makeListButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/script.png")));
        this.makeListButton.setText(this.rb.getString("GUI.General.MakeList.Button"));
        this.makeListButton.setToolTipText(this.rb.getString("GUI.General.MakeList.Button"));
        this.makeListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.makeListButtonActionPerformed(evt);
            }
        });
        this.historyButtonPanel.add((Component)this.makeListButton, new GridBagConstraints());
        this.historyClearButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-cut.png")));
        this.historyClearButton.setText(this.rb.getString("GUI.General.Cut"));
        this.historyClearButton.setToolTipText(this.rb.getString("GUI.Area.Records.Cut.ToolTip"));
        this.historyClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyClearButtonActionPerformed(evt);
            }
        });
        this.historyButtonPanel.add((Component)this.historyClearButton, new GridBagConstraints());
        this.historyCopyButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.historyCopyButton.setText(this.rb.getString("GUI.General.Copy"));
        this.historyCopyButton.setToolTipText(this.rb.getString("GUI.Area.Records.Copy.ToolTip"));
        this.historyCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyCopyButtonActionPerformed(evt);
            }
        });
        this.historyButtonPanel.add((Component)this.historyCopyButton, new GridBagConstraints());
        this.historyPasteButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-paste.png")));
        this.historyPasteButton.setText(this.rb.getString("GUI.General.Paste"));
        this.historyPasteButton.setToolTipText(this.rb.getString("GUI.Area.Records.Paste.ToolTip"));
        this.historyPasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.historyPasteButtonActionPerformed(evt);
            }
        });
        this.historyButtonPanel.add((Component)this.historyPasteButton, new GridBagConstraints());
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/save.png")));
        this.saveButton.setText(this.rb.getString("GUI.General.Save"));
        this.saveButton.setToolTipText(this.rb.getString("GUI.General.Save"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.saveButtonActionPerformed(evt);
            }
        });
        this.historyButtonPanel.add((Component)this.saveButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.recordPanel.add((Component)this.historyButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.converterPanel.add((Component)this.recordPanel, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.messageTextField.setEditable(false);
        this.messageTextField.setToolTipText(this.rb.getString("GUI.Area.Message.ToolTip"));
        this.messageTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.messageTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.bottomPanel.add((Component)this.messageTextField, gridBagConstraints);
        this.warnLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/warning.png")));
        this.warnLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.warnLabelMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.bottomPanel.add((Component)this.warnLabel, gridBagConstraints);
        this.filterCatIndicatorLabel.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/filter.png")));
        this.filterCatIndicatorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Main.this.filterCatIndicatorLabelMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.bottomPanel.add((Component)this.filterCatIndicatorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 5, 5);
        this.converterPanel.add((Component)this.bottomPanel, gridBagConstraints);
        this.editTogglePanel.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.editTogglePanel.setLayout(new BorderLayout());
        this.editToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix10x10/arrow-right.png")));
        this.editToggleButton.setSelected(true);
        this.editToggleButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        this.editToggleButton.setBorderPainted(false);
        this.editToggleButton.setContentAreaFilled(false);
        this.editToggleButton.setFocusPainted(false);
        this.editToggleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix10x10/arrow-down.png")));
        this.editToggleButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Main.this.editToggleButtonStateChanged(evt);
            }
        });
        this.editTogglePanel.add((Component)this.editToggleButton, "West");
        this.jLabel4.setText(this.rb.getString("GUI.General.Editor"));
        this.editTogglePanel.add((Component)this.jLabel4, "Center");
        this.editTogglePanel.add((Component)this.jSeparator31, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.converterPanel.add((Component)this.editTogglePanel, gridBagConstraints);
        this.navigationPanel.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.editFavoritesjButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/bookmarks.png")));
        this.editFavoritesjButton.setToolTipText(this.rb.getString("GUI.Menu.Favorites.Manage"));
        this.editFavoritesjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.editFavoritesjButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.editFavoritesjButton);
        this.addFavoritesButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/bookmarks-plus.png")));
        this.addFavoritesButton.setToolTipText(this.rb.getString("GUI.Menu.Favorites.Add"));
        this.addFavoritesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.addFavoritesButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addFavoritesButton);
        this.swapToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/swap.png")));
        this.swapToolbarButton.setToolTipText(this.rb.getString("GUI.Menu.Main.Switch"));
        this.swapToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.swapToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.swapToolbarButton);
        this.datatablesButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/table.png")));
        this.datatablesButton.setToolTipText(this.rb.getString("GUI.Menu.Service.Tables"));
        this.datatablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.datatablesButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.datatablesButton);
        this.jSeparator32.setOrientation(1);
        this.jSeparator32.setMaximumSize(new Dimension(10, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator32);
        this.calculatorButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/calculator-scientific.png")));
        this.calculatorButton.setToolTipText(this.rb.getString("GUI.Menu.Service.Calculator"));
        this.calculatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.calculatorButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.calculatorButton);
        this.calendarButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/calendar.png")));
        this.calendarButton.setToolTipText(this.rb.getString("GUI.General.DatePicker"));
        this.calendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.calendarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.calendarButton);
        this.timeDialogButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/time.png")));
        this.timeDialogButton.setToolTipText(this.rb.getString("GUI.General.TimePicker"));
        this.timeDialogButton.setFocusable(false);
        this.timeDialogButton.setHorizontalTextPosition(0);
        this.timeDialogButton.setVerticalTextPosition(3);
        this.timeDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.timeDialogButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.timeDialogButton);
        this.datetimeDiffButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/duration.png")));
        this.datetimeDiffButton.setToolTipText(this.rb.getString("DateDiff.CalculateTimeDifference"));
        this.datetimeDiffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.datetimeDiffButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.datetimeDiffButton);
        this.randomButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/dice.png")));
        this.randomButton.setToolTipText(this.rb.getString("GUI.RandomGenerator.DialogTitle"));
        this.randomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.randomButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.randomButton);
        this.colorToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/color.png")));
        this.colorToolbarButton.setToolTipText(this.rb.getString("GUI.General.ColorPicker"));
        this.colorToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.colorToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.colorToolbarButton);
        this.phoneticAlphabetButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/phonetic-alphabet.png")));
        this.phoneticAlphabetButton.setToolTipText(this.rb.getString("GUI.Menu.Service.Spell"));
        this.phoneticAlphabetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.phoneticAlphabetButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.phoneticAlphabetButton);
        this.currencyUpdateButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/currency.png")));
        this.currencyUpdateButton.setToolTipText(this.rb.getString("GUI.Menu.Main.UpdateExchangeRates"));
        this.currencyUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.currencyUpdateButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.currencyUpdateButton);
        this.navigationPanel.add((Component)this.jToolBar1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.converterPanel.add((Component)this.navigationPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.converterPanel, "Center");
        this.programMenu.setText(this.rb.getString("GUI.Menu.Main"));
        this.updateCenterMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/update.png")));
        this.updateCenterMenuItem.setText(this.rb.getString("GUI.General.Update") + " ...");
        this.updateCenterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.updateCenterMenuItemActionPerformed(evt);
            }
        });
        this.programMenu.add(this.updateCenterMenuItem);
        this.programMenu.add(this.jSeparator15);
        this.restartItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/arrow-circle.png")));
        this.restartItem.setText(this.rb.getString("GUI.Menu.Main.Restart"));
        this.restartItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.restartItemActionPerformed(evt);
            }
        });
        this.programMenu.add(this.restartItem);
        this.exitItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.exitItem.setText(this.rb.getString("GUI.Menu.Main.Exit"));
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.exitItemActionPerformed(evt);
            }
        });
        this.programMenu.add(this.exitItem);
        this.ncMenuBar.add(this.programMenu);
        this.editMenu.setText(this.rb.getString("GUI.General.Edit"));
        this.programMenuItemSwap.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/swap.png")));
        this.programMenuItemSwap.setText(this.rb.getString("GUI.Menu.Main.Switch"));
        this.programMenuItemSwap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.programMenuItemSwapActionPerformed(evt);
            }
        });
        this.editMenu.add(this.programMenuItemSwap);
        this.sourceMenu.setText(this.rb.getString("GUI.Menu.Source"));
        this.sourceMenuItemUndo.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/undo.png")));
        this.sourceMenuItemUndo.setText(this.rb.getString("GUI.General.Undo"));
        this.sourceMenuItemUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemUndoActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemUndo);
        this.sourceMenuItemRedo.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/redo.png")));
        this.sourceMenuItemRedo.setText(this.rb.getString("GUI.General.Redo"));
        this.sourceMenuItemRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemRedoActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemRedo);
        this.sourceMenu.add(this.jSeparator9);
        this.sourceMenuItemClear.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-cut.png")));
        this.sourceMenuItemClear.setText(this.rb.getString("GUI.General.Cut"));
        this.sourceMenuItemClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemClearActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemClear);
        this.sourceMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.sourceMenuItemCopy.setText(this.rb.getString("GUI.General.Copy"));
        this.sourceMenuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemCopyActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemCopy);
        this.sourceMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-paste.png")));
        this.sourceMenuItemPaste.setText(this.rb.getString("GUI.General.Paste"));
        this.sourceMenuItemPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemPasteActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemPaste);
        this.sourceMenu.add(this.jSeparator7);
        this.sourceMenuItemFindUnit.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.sourceMenuItemFindUnit.setText(this.rb.getString("GUI.Menu.Source.FindUnit"));
        this.sourceMenuItemFindUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemFindUnitActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemFindUnit);
        this.sourceMenuItemDefault.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-stop-square.png")));
        this.sourceMenuItemDefault.setText(this.rb.getString("GUI.Menu.Source.Default"));
        this.sourceMenuItemDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemDefaultActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemDefault);
        this.sourceMenu.add(this.jSeparator25);
        this.sourceMenuItemPlus.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-090.png")));
        this.sourceMenuItemPlus.setText("+1");
        this.sourceMenuItemPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemPlusActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemPlus);
        this.sourceMenuItemMinus.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-270.png")));
        this.sourceMenuItemMinus.setText("-1");
        this.sourceMenuItemMinus.setPreferredSize(new Dimension(69, 21));
        this.sourceMenuItemMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemMinusActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemMinus);
        this.sourceMenuItemDefaultValue.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-stop-square.png")));
        this.sourceMenuItemDefaultValue.setText(this.rb.getString("GUI.Menu.Source.DefaultValue"));
        this.sourceMenuItemDefaultValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemDefaultValueActionPerformed(evt);
            }
        });
        this.sourceMenu.add(this.sourceMenuItemDefaultValue);
        this.editMenu.add(this.sourceMenu);
        this.targetMenu.setText(this.rb.getString("GUI.Menu.Target"));
        this.targetMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.targetMenuItemCopy.setText(this.rb.getString("GUI.General.Copy"));
        this.targetMenuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetMenuItemCopyActionPerformed(evt);
            }
        });
        this.targetMenu.add(this.targetMenuItemCopy);
        this.targetMenuItemFigures.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/sci.png")));
        this.targetMenuItemFigures.setText(this.rb.getString("GUI.Menu.Target.SignificantFigures"));
        this.targetMenuItemFigures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetMenuItemFiguresActionPerformed(evt);
            }
        });
        this.targetMenu.add(this.targetMenuItemFigures);
        this.targetMenuItemDecimals.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/decimal-places.png")));
        this.targetMenuItemDecimals.setText(this.rb.getString("GUI.Menu.Target.PlacesOfDecimals"));
        this.targetMenuItemDecimals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetMenuItemDecimalsActionPerformed(evt);
            }
        });
        this.targetMenu.add(this.targetMenuItemDecimals);
        this.targetMenu.add(this.jSeparator10);
        this.targetMenuItemFindUnit.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.targetMenuItemFindUnit.setText(this.rb.getString("GUI.Menu.Target.FindUnit"));
        this.targetMenuItemFindUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetMenuItemFindUnitActionPerformed(evt);
            }
        });
        this.targetMenu.add(this.targetMenuItemFindUnit);
        this.targetMenuItemDefault.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/control-stop-square.png")));
        this.targetMenuItemDefault.setText(this.rb.getString("GUI.Menu.Source.Default"));
        this.targetMenuItemDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetMenuItemDefaultActionPerformed(evt);
            }
        });
        this.targetMenu.add(this.targetMenuItemDefault);
        this.targetMenu.add(this.jSeparator13);
        this.targetMenuItemPlay.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-high.png")));
        this.targetMenuItemPlay.setText(this.rb.getString("GUI.Menu.Target.Play"));
        this.targetMenuItemPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetMenuItemPlayActionPerformed(evt);
            }
        });
        this.targetMenu.add(this.targetMenuItemPlay);
        this.targetMenuItemStopPlaying.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/audio-volume-muted.png")));
        this.targetMenuItemStopPlaying.setText(this.rb.getString("GUI.Menu.Target.StopPlaying"));
        this.targetMenuItemStopPlaying.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.targetMenuItemStopPlayingActionPerformed(evt);
            }
        });
        this.targetMenu.add(this.targetMenuItemStopPlaying);
        this.editMenu.add(this.targetMenu);
        this.recordMenu.setText(this.rb.getString("GUI.General.Editor"));
        this.undoMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/undo.png")));
        this.undoMenuItem.setText(this.rb.getString("GUI.General.Undo"));
        this.undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.undoMenuItemActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.undoMenuItem);
        this.redoMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/redo.png")));
        this.redoMenuItem.setText(this.rb.getString("GUI.General.Redo"));
        this.redoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.redoMenuItemActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.redoMenuItem);
        this.recordMenu.add(this.jSeparator1);
        this.recordMenuItemClear.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-cut.png")));
        this.recordMenuItemClear.setText(this.rb.getString("GUI.General.Cut"));
        this.recordMenuItemClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recordMenuItemClearActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.recordMenuItemClear);
        this.recordMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-copy.png")));
        this.recordMenuItemCopy.setText(this.rb.getString("GUI.General.Copy"));
        this.recordMenuItemCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recordMenuItemCopyActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.recordMenuItemCopy);
        this.recordMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/edit-paste.png")));
        this.recordMenuItemPaste.setText(this.rb.getString("GUI.General.Paste"));
        this.recordMenuItemPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recordMenuItemPasteActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.recordMenuItemPaste);
        this.recordMenu.add(this.jSeparator22);
        this.recordMenuItemNew.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-down.png")));
        this.recordMenuItemNew.setText(this.rb.getString("GUI.General.Notice"));
        this.recordMenuItemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recordMenuItemNewActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.recordMenuItemNew);
        this.recordMenuItemMakeList.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/script.png")));
        this.recordMenuItemMakeList.setText(this.rb.getString("GUI.General.MakeList"));
        this.recordMenuItemMakeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recordMenuItemMakeListActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.recordMenuItemMakeList);
        this.recordMenuItemFormat.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/format.png")));
        this.recordMenuItemFormat.setText(this.rb.getString("GUI.Menu.Records.Format"));
        this.recordMenuItemFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recordMenuItemFormatActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.recordMenuItemFormat);
        this.recordMenuItemFontsize.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/fontsize.png")));
        this.recordMenuItemFontsize.setText(this.rb.getString("GUI.Menu.Records.Fontsize"));
        this.recordMenuItemFontsize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.recordMenuItemFontsizeActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.recordMenuItemFontsize);
        this.htmlMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/format-headerfooter.png")));
        this.htmlMenuItem.setText(this.rb.getString("GUI.Menu.Records.AddHTML"));
        this.htmlMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.htmlMenuItemActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.htmlMenuItem);
        this.recordMenu.add(this.jSeparator6);
        this.loadMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/document-open.png")));
        this.loadMenuItem.setText(this.rb.getString("GUI.General.Load"));
        this.loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.loadMenuItemActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.loadMenuItem);
        this.saveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/save.png")));
        this.saveMenuItem.setText(this.rb.getString("GUI.General.Save"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.recordMenu.add(this.saveMenuItem);
        this.editMenu.add(this.recordMenu);
        this.editMenu.add(this.jSeparator5);
        this.countUnitsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/sum.png")));
        this.countUnitsMenuItem.setText(this.rb.getString("GUI.Menu.Count"));
        this.countUnitsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.countUnitsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.countUnitsMenuItem);
        this.unitsMenu.setText(this.rb.getString("GUI.Config.Units"));
        this.editUnitsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/editor.png")));
        this.editUnitsMenuItem.setText(this.rb.getString("GUI.Config.Units.Edit"));
        this.editUnitsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.editUnitsMenuItemActionPerformed(evt);
            }
        });
        this.unitsMenu.add(this.editUnitsMenuItem);
        this.reloadUnitsItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/arrow-circle-135-left.png")));
        this.reloadUnitsItem.setText(this.rb.getString("GUI.Config.Units.Reload"));
        this.reloadUnitsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.reloadUnitsItemActionPerformed(evt);
            }
        });
        this.unitsMenu.add(this.reloadUnitsItem);
        this.editMenu.add(this.unitsMenu);
        this.categoriesMenu.setText(this.rb.getString("GUI.Config.Categories"));
        this.editCategoriesMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/editor.png")));
        this.editCategoriesMenuItem.setText(this.rb.getString("GUI.Config.Category.Edit"));
        this.editCategoriesMenuItem.setEnabled(false);
        this.categoriesMenu.add(this.editCategoriesMenuItem);
        this.reloadCategoriesMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/arrow-circle-135-left.png")));
        this.reloadCategoriesMenuItem.setText(this.rb.getString("GUI.Config.Category.Reload"));
        this.reloadCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.reloadCategoriesMenuItemActionPerformed(evt);
            }
        });
        this.categoriesMenu.add(this.reloadCategoriesMenuItem);
        this.editMenu.add(this.categoriesMenu);
        this.editMenu.add(this.jSeparator12);
        this.propsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/wrench-screwdriver.png")));
        this.propsMenuItem.setText(this.rb.getString("GUI.General.Preferences") + " ...");
        this.propsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.propsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.propsMenuItem);
        this.ncMenuBar.add(this.editMenu);
        this.frameMenu.setText(this.rb.getString("GUI.Menu.Frame"));
        this.miserlyRadioButtonMenuItem.setText(this.rb.getString("GUI.Menu.Frame.Miserly"));
        this.miserlyRadioButtonMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/eye-squint.png")));
        this.miserlyRadioButtonMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Main.this.miserlyRadioButtonMenuItemItemStateChanged(evt);
            }
        });
        this.frameMenu.add(this.miserlyRadioButtonMenuItem);
        this.economicalRadioButtonMenuItem.setText(this.rb.getString("GUI.Menu.Frame.Economical"));
        this.economicalRadioButtonMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/eye-half.png")));
        this.economicalRadioButtonMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Main.this.economicalRadioButtonMenuItemItemStateChanged(evt);
            }
        });
        this.frameMenu.add(this.economicalRadioButtonMenuItem);
        this.standardRadioButtonMenuItem.setText(this.rb.getString("GUI.Menu.Frame.Standard"));
        this.standardRadioButtonMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/eye.png")));
        this.standardRadioButtonMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Main.this.standardRadioButtonMenuItemItemStateChanged(evt);
            }
        });
        this.frameMenu.add(this.standardRadioButtonMenuItem);
        this.luxuryRadioButtonMenuItem.setText(this.rb.getString("GUI.Menu.Frame.Luxury"));
        this.luxuryRadioButtonMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/eye-plus.png")));
        this.luxuryRadioButtonMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Main.this.luxuryRadioButtonMenuItemItemStateChanged(evt);
            }
        });
        this.frameMenu.add(this.luxuryRadioButtonMenuItem);
        this.maximumRadioButtonMenuItem.setText(this.rb.getString("GUI.Menu.Frame.Maximum"));
        this.maximumRadioButtonMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/arrow-out.png")));
        this.maximumRadioButtonMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Main.this.maximumRadioButtonMenuItemItemStateChanged(evt);
            }
        });
        this.frameMenu.add(this.maximumRadioButtonMenuItem);
        this.ncMenuBar.add(this.frameMenu);
        this.navigationMenu.setText(this.rb.getString("GUI.General.Navigate"));
        this.searchMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/magnifier-left.png")));
        this.searchMenu.setText(this.rb.getString("GUI.Menu.Find"));
        this.searchSourceMenuItem.setText(this.rb.getString("GUI.Menu.Find.FindSourceUnit"));
        this.searchSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.searchSourceMenuItemActionPerformed(evt);
            }
        });
        this.searchMenu.add(this.searchSourceMenuItem);
        this.searchTargetMenuItem.setText(this.rb.getString("GUI.Menu.Find.FindTargetUnit"));
        this.searchTargetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.searchTargetMenuItemActionPerformed(evt);
            }
        });
        this.searchMenu.add(this.searchTargetMenuItem);
        this.searchMenu.add(this.jSeparator21);
        this.searchCategoriesMenuItem.setText(this.rb.getString("GUI.Menu.Find.FindCategory"));
        this.searchCategoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.searchCategoriesMenuItemActionPerformed(evt);
            }
        });
        this.searchMenu.add(this.searchCategoriesMenuItem);
        this.navigationMenu.add(this.searchMenu);
        this.favoritesMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/bookmarks.png")));
        this.favoritesMenu.setText(this.rb.getString("GUI.Menu.Favorites"));
        this.addFavoriteMenuItem.setText(this.rb.getString("GUI.Menu.Favorites.Add"));
        this.addFavoriteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.addFavoriteMenuItemActionPerformed(evt);
            }
        });
        this.favoritesMenu.add(this.addFavoriteMenuItem);
        this.manageFavoritesMenuItem.setText(this.rb.getString("GUI.Menu.Favorites.Manage"));
        this.manageFavoritesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.manageFavoritesMenuItemActionPerformed(evt);
            }
        });
        this.favoritesMenu.add(this.manageFavoritesMenuItem);
        this.navigationMenu.add(this.favoritesMenu);
        this.filterMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/filter.png")));
        this.filterMenuItem.setText(this.rb.getString("GUI.Menu.Filter"));
        this.filterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.filterMenuItemActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.filterMenuItem);
        this.navigationMenu.add(this.jSeparator4);
        this.tablesMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/table.png")));
        this.tablesMenuItem.setText(this.rb.getString("GUI.Menu.Service.Tables"));
        this.tablesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.tablesMenuItemActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.tablesMenuItem);
        this.ncMenuBar.add(this.navigationMenu);
        this.ToolsMenu.setText(this.rb.getString("GUI.General.Tools"));
        this.calculatorMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/calculator-scientific.png")));
        this.calculatorMenuItem.setText(this.rb.getString("GUI.Menu.Service.Calculator"));
        this.calculatorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.calculatorMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.calculatorMenuItem);
        this.sourceMenuItemCalendar.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/calendar.png")));
        this.sourceMenuItemCalendar.setText(this.rb.getString("GUI.General.DatePicker"));
        this.sourceMenuItemCalendar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemCalendarActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.sourceMenuItemCalendar);
        this.timeDialogMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/time.png")));
        this.timeDialogMenuItem.setText(this.rb.getString("GUI.General.TimePicker"));
        this.timeDialogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.timeDialogMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.timeDialogMenuItem);
        this.dateDiffMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/duration.png")));
        this.dateDiffMenuItem.setText(this.rb.getString("DateDiff.CalculateTimeDifference"));
        this.dateDiffMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.dateDiffMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.dateDiffMenuItem);
        this.randomNumbersMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/dice.png")));
        this.randomNumbersMenuItem.setText(this.rb.getString("GUI.RandomGenerator.DialogTitle"));
        this.randomNumbersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.randomNumbersMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.randomNumbersMenuItem);
        this.sourceMenuItemColor.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/color.png")));
        this.sourceMenuItemColor.setText(this.rb.getString("GUI.General.ColorPicker"));
        this.sourceMenuItemColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.sourceMenuItemColorActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.sourceMenuItemColor);
        this.spellMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/phonetic-alphabet.png")));
        this.spellMenuItem.setText(this.rb.getString("GUI.Menu.Service.Spell"));
        this.spellMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.spellMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.spellMenuItem);
        this.updateExchangeRatesMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/currency.png")));
        this.updateExchangeRatesMenuItem.setText(this.rb.getString("GUI.Rates.Load"));
        this.updateExchangeRatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.updateExchangeRatesMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.updateExchangeRatesMenuItem);
        this.ncMenuBar.add(this.ToolsMenu);
        this.helpMenu.setText(this.rb.getString("GUI.Menu.Help"));
        this.helpIndexMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/book-open.png")));
        this.helpIndexMenuItem.setText(this.rb.getString("GUI.Menu.Help.Index"));
        this.helpIndexMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.helpIndexMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpIndexMenuItem);
        this.tutorialMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/graduation-hat.png")));
        this.tutorialMenuItem.setText(this.rb.getString("GUI.Menu.Help.Tutorial"));
        this.tutorialMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.tutorialMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.tutorialMenuItem);
        this.supportMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/lifebuoy.png")));
        this.supportMenuItem.setText(this.rb.getString("GUI.Menu.Support"));
        this.supportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.supportMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.supportMenuItem);
        this.helpMenu.add(this.jSeparator18);
        this.homepageMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/home.png")));
        this.homepageMenuItem.setText(this.rb.getString("GUI.General.Homepage"));
        this.homepageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.homepageMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.homepageMenuItem);
        this.helpMenuItemAbout.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/balloon-white-left.png")));
        this.helpMenuItemAbout.setText(this.rb.getString("GUI.Menu.Help.About"));
        this.helpMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.helpMenuItemAboutActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItemAbout);
        this.ncMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.ncMenuBar);
        this.ncMenuBar.getAccessibleContext().setAccessibleName("Menu");
        this.ncMenuBar.getAccessibleContext().setAccessibleDescription("Menu");
        this.getAccessibleContext().setAccessibleName("NC Frame");
        this.getAccessibleContext().setAccessibleDescription("This is the NC");
    }

    private void randomButtonActionPerformed(ActionEvent evt) {
        RandomGeneratorDialog randomGeneratorDialog = new RandomGeneratorDialog(this);
    }

    private void updateCenterMenuItemActionPerformed(ActionEvent evt) {
        this.updateCenter();
    }

    private void warnLabelMouseClicked(MouseEvent evt) {
        String code;
        if (this.categoryObject instanceof CategoryTimezones) {
            JOptionPane.showMessageDialog(this, GeneralString.message(this.rb.getString("Tzdata.Outdated"), this.getUpdateRecord().getTzdataModule().getInstalledVersion(), this.getUpdateRecord().getTzdataModule().getLatestKnownVersion()), this.rb.getString("Tzdata.Title"), 2);
            this.updateCenter();
        } else if (this.categoryObject instanceof CategoryGeneric && (code = ((CategoryGeneric)this.categoryObject).getFilename()).equalsIgnoreCase("exchange_rates")) {
            int fullDays = (int)((System.currentTimeMillis() - this.rates_updated_ms) / 86400000L);
            JOptionPane.showMessageDialog(this, GeneralString.message(this.rb.getString("ExchangeRates.Outdated"), fullDays), this.rb.getString("ExchangeRates.WarningTitle"), 2);
            this.updateExchangeRatesMenuItemActionPerformed(null);
        }
    }

    private void dateFormatComboBoxActionPerformed(ActionEvent evt) {
        this.categoryObject.setNumberType(this.dateFormatComboBox.getSelectedIndex());
        this.process(-1);
    }

    private void targetMenuItemDecimalsActionPerformed(ActionEvent evt) {
        this.sciCheckBox.setSelected(false);
        this.precisionTextField.requestFocus();
    }

    private void editUnitsMenuItemActionPerformed(ActionEvent evt) {
        Bookmark bookmark = this.getCurrentSelectionAsBookmark();
        EditUnits editUnits = new EditUnits(this, false);
        Category category = (Category)this.categoryBox.getSelectedItem();
        editUnits.setHeader(category.getText());
        editUnits.setBookmark(bookmark);
        editUnits.setFilename(((CategoryGeneric)this.categoryObject).getFilename());
        editUnits.setVisible(true);
        editUnits.fill();
    }

    private void phoneticAlphabetButtonActionPerformed(ActionEvent evt) {
        this.spellMenuItemActionPerformed(evt);
    }

    private void swapToolbarButtonActionPerformed(ActionEvent evt) {
        this.swapButtonActionPerformed(evt);
    }

    private void calculatorButtonActionPerformed(ActionEvent evt) {
        jonelo.sugar.gui.GUIHelper.openNativeCalculator();
    }

    private void datatablesButtonActionPerformed(ActionEvent evt) {
        this.tablesMenuItemActionPerformed(null);
    }

    private void datetimeDiffButtonActionPerformed(ActionEvent evt) {
        this.dateDiffMenuItemActionPerformed(null);
    }

    private void currencyUpdateButtonActionPerformed(ActionEvent evt) {
        this.updateExchangeRatesMenuItemActionPerformed(null);
    }

    private void calendarButtonActionPerformed(ActionEvent evt) {
        this.menuItemCalendarPressed();
    }

    private void searchCategoryButtonActionPerformed(ActionEvent evt) {
        this.searchCategoriesMenuItemActionPerformed(null);
    }

    private void colorToolbarButtonActionPerformed(ActionEvent evt) {
        this.menuItemColorPressed();
    }

    private void editFavoritesjButtonActionPerformed(ActionEvent evt) {
        this.manageFavorites();
    }

    private void addFavoritesButtonActionPerformed(ActionEvent evt) {
        this.addFavorite();
        this.manageFavorites();
    }

    private void editToggleButtonStateChanged(ChangeEvent evt) {
        this.recordPanel.setVisible(this.editToggleButton.isSelected());
        this.pack();
    }

    private void dateDiffMenuItemActionPerformed(ActionEvent evt) {
        long[] seconds = new long[]{0L};
        boolean[] status = new boolean[]{false};
        new DateDiffDialog(this, this.unitRecordCellRenderer, seconds, status);
        if (status[0]) {
            if (this.categoryBox.getSelectedItem() != this.categoryHashMap.get("zeit")) {
                this.categoryBox.setSelectedItem(this.categoryHashMap.get("zeit"));
                this.categoryBoxItemStateChanged();
            } else {
                int found = this.findUnitExact(this.sourceBox, "second (s)", 0, true);
                if (found > -1) {
                    this.sourceBox.setSelectedIndex(found);
                }
            }
            try {
                this.setValue(new BigDecimal(String.valueOf(seconds[0])));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    private void categoryDownButtonActionPerformed(ActionEvent evt) {
        int all;
        int now = this.categoryBox.getSelectedIndex();
        if (now + 1 < (all = this.categoryBox.getItemCount())) {
            this.categoryBox.setSelectedIndex(now + 1);
        } else {
            this.categoryBox.setSelectedIndex(0);
        }
    }

    private void categoryUpButtonActionPerformed(ActionEvent evt) {
        int now = this.categoryBox.getSelectedIndex();
        int all = this.categoryBox.getItemCount();
        if (now > 0) {
            this.categoryBox.setSelectedIndex(now - 1);
        } else {
            this.categoryBox.setSelectedIndex(all - 1);
        }
    }

    private void fingerprintComboBoxActionPerformed(ActionEvent evt) {
        ((CategoryDigitalFingerprints)this.categoryObject).setNumberType(this.fingerprintComboBox.getSelectedItem());
        this.process(-1);
    }

    private void numberTypeComboBoxActionPerformed(ActionEvent evt) {
        this.categoryObject.setNumberType(this.numberTypeComboBox.getSelectedIndex());
        this.process(-1);
    }

    private void sourceBoxComponentResized(ComponentEvent evt) {
        GeneralGUI.resizeComboBoxPopup(this.sourceBox);
    }

    private void targetBoxComponentResized(ComponentEvent evt) {
        GeneralGUI.resizeComboBoxPopup(this.targetBox);
    }

    private void sourcePopupMenuItemRedoActionPerformed(ActionEvent evt) {
        GUIHelper.redo(this.sourceUndoManager);
    }

    private void sourcePopupMenuItemUndoActionPerformed(ActionEvent evt) {
        GUIHelper.undo(this.sourceUndoManager);
    }

    private void sourceMenuItemRedoActionPerformed(ActionEvent evt) {
        GUIHelper.redo(this.sourceUndoManager);
    }

    private void sourceMenuItemUndoActionPerformed(ActionEvent evt) {
        GUIHelper.undo(this.sourceUndoManager);
    }

    private void supportMenuItemActionPerformed(ActionEvent evt) {
        this.goToWebPage("support.html");
    }

    private void findTargetButtonActionPerformed(ActionEvent evt) {
        this.findTargetUnit();
    }

    private void findSourceButtonActionPerformed(ActionEvent evt) {
        this.findSourceUnit();
    }

    private void reloadCategoriesMenuItemActionPerformed(ActionEvent evt) {
        this.loadResourceBundle();
        this.registerCategories();
    }

    private void historyMenuItemRedoActionPerformed(ActionEvent evt) {
        this.redoMenuItemActionPerformed(evt);
    }

    private void historyMenuItemUndoActionPerformed(ActionEvent evt) {
        this.undoMenuItemActionPerformed(evt);
    }

    private void historyPopupMenuItemHTMLActionPerformed(ActionEvent evt) {
        this.htmlMenuItemActionPerformed(evt);
    }

    private void redoMenuItemActionPerformed(ActionEvent evt) {
        GUIHelper.redo(this.historyUndoManager);
    }

    private void undoMenuItemActionPerformed(ActionEvent evt) {
        GUIHelper.undo(this.historyUndoManager);
    }

    private void manageFavoritesMenuItemActionPerformed(ActionEvent evt) {
        this.manageFavorites();
    }

    private void htmlMenuItemActionPerformed(ActionEvent evt) {
        boolean add = true;
        if (this.historyTextArea.getText().contains("<html>")) {
            add = GUIHelper.showQuestion(this, "", this.rb.getString("Edit.HTMLTemplateAddAgain"));
        }
        if (add) {
            this.historyTextArea.insert(HTML_HEADER, 0);
            this.historyTextArea.append(HTML_FOOTER);
        }
    }

    private void addFavoriteMenuItemActionPerformed(ActionEvent evt) {
        this.addFavorite();
        this.manageFavorites();
    }

    private void searchCategoriesMenuItemActionPerformed(ActionEvent evt) {
        new FindDialog(this, 0);
    }

    private void searchTargetMenuItemActionPerformed(ActionEvent evt) {
        this.findTargetUnit();
    }

    private void searchSourceMenuItemActionPerformed(ActionEvent evt) {
        this.findSourceUnit();
    }

    private void colorButtonActionPerformed(ActionEvent evt) {
        this.menuItemColorPressed();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.menuItemCalendarPressed();
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.categoryObject.stopPlaying();
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        this.playNumber();
    }

    private void homepageMenuItemActionPerformed(ActionEvent evt) {
        this.goToWebPage("index.html");
    }

    private void tablesMenuItemActionPerformed(ActionEvent evt) {
        String filename = System.getProperty("user.dir") + "/../help/" + this.userProps.getProperty("help", "en") + "/tables.html";
        try {
            jonelo.sugar.gui.GUIHelper.openLocalFileInBrowser(filename);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void spellMenuItemActionPerformed(ActionEvent evt) {
        PhoneticAlphabetDialog phoneticAlphabetDialog = new PhoneticAlphabetDialog(this);
    }

    private void sourceMenuItemDefaultValueActionPerformed(ActionEvent evt) {
        this.defaultValuePressed();
    }

    private void sourcePopupMenuDefaultValueActionPerformed(ActionEvent evt) {
        this.defaultValuePressed();
    }

    private void sourceMenuItemCalendarActionPerformed(ActionEvent evt) {
        this.menuItemCalendarPressed();
    }

    private void filterCatIndicatorLabelMouseClicked(MouseEvent evt) {
        this.clickOnFilterCategoryIndicator();
    }

    private void propsMenuItemActionPerformed(ActionEvent evt) {
        new ConfigDialog(this).setVisible(true);
        if (this.userProps.containsKey("save")) {
            this.userProps.remove("save");
            this.saveUserProperties();
        }
        this.resizeComboBoxPopups = this.determineResizeComboBoxPopups();
        this.setToolTips(this.userProps.getProperty("tooltips", "true").equals("true"));
        try {
            ToolTipManager.sharedInstance().setInitialDelay(Integer.parseInt(this.userProps.getProperty("tooltips.delay", "750")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setAlwaysOnTop(this.userProps.getProperty("alwaysOnTop", "false").equals("true"));
        if (this.userProps.containsKey("restart")) {
            this.userProps.remove("restart");
            this.restart();
        }
    }

    private void targetMenuItemFindUnitActionPerformed(ActionEvent evt) {
        this.findTargetUnit();
    }

    private void targetPopupMenuItemFindUnitActionPerformed(ActionEvent evt) {
        this.findTargetUnit();
    }

    private void sourcePopupMenuItemFindUnitActionPerformed(ActionEvent evt) {
        this.findSourceUnit();
    }

    private void sourceMenuItemFindUnitActionPerformed(ActionEvent evt) {
        this.findSourceUnit();
    }

    private void targetPopupMenuItemStopPlayingActionPerformed(ActionEvent evt) {
        this.categoryObject.stopPlaying();
    }

    private void targetPopupMenuItemPlayActionPerformed(ActionEvent evt) {
        this.playNumber();
    }

    private void targetMenuItemStopPlayingActionPerformed(ActionEvent evt) {
        this.categoryObject.stopPlaying();
    }

    private void targetBoxActionPerformed(ActionEvent evt) {
        this.process(-1);
        this.sourceTextArea.requestFocus();
    }

    private void categoryBoxActionPerformed(ActionEvent evt) {
        if (this.categoryObject != null && this.lastTypeBoxSelectedIndex != this.categoryBox.getSelectedIndex()) {
            this.categoryObject.stopPlaying();
            this.lastTypeBoxSelectedIndex = this.categoryBox.getSelectedIndex();
            this.transferValue = "";
            try {
                this.transferValue = this.categoryObject.getTransferValue(this.sourceBox.getSelectedIndex());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.categoryBoxItemStateChanged();
        }
    }

    private void sourceBoxActionPerformed(ActionEvent evt) {
        this.process(-1);
        this.sourceTextArea.requestFocus();
    }

    private void sciCheckBoxActionPerformed(ActionEvent evt) {
        this.process(-1);
    }

    private void sciCheckBoxItemStateChanged(ItemEvent evt) {
        int change = evt.getStateChange();
        if (change == 1) {
            this.precisionLabel.setText(this.rb.getString("GUI.Menu.Target.SignificantFigures"));
            this.precisionLabel.setToolTipText(this.rb.getString("GUI.Area.Target.SignificantFigures.ToolTip"));
            this.precisionTextField.setToolTipText(this.rb.getString("GUI.Area.Target.SignificantFigures.ToolTip"));
            this.categoryObject.setScientific(true);
        } else if (change == 2) {
            this.precisionLabel.setText(this.rb.getString("GUI.Menu.Target.PlacesOfDecimals"));
            this.precisionLabel.setToolTipText(this.rb.getString("GUI.Area.Target.PlacesOfDecimals.ToolTip"));
            this.precisionTextField.setToolTipText(this.rb.getString("GUI.Area.Target.PlacesOfDecimals.ToolTip"));
            this.categoryObject.setScientific(false);
        }
    }

    private void targetPopupMenuItemDefaultActionPerformed(ActionEvent evt) {
        this.targetBox.setSelectedIndex(this.categoryObject.getTargetDefault());
    }

    private void sourcePopupMenuItemDefaultActionPerformed(ActionEvent evt) {
        this.sourceBox.setSelectedIndex(this.categoryObject.getSourceDefault());
    }

    private void targetMenuItemDefaultActionPerformed(ActionEvent evt) {
        this.targetBox.setSelectedIndex(this.categoryObject.getTargetDefault());
    }

    private void sourceMenuItemDefaultActionPerformed(ActionEvent evt) {
        this.sourceBox.setSelectedIndex(this.categoryObject.getSourceDefault());
    }

    private void recordMenuItemFontsizeActionPerformed(ActionEvent evt) {
        Font font = this.historyTextArea.getFont();
        boolean end = false;
        while (!end) {
            String input = JOptionPane.showInputDialog(this, this.rb.getString("GUI.Menu.Records.Fontsize"), Float.toString(font.getSize2D()));
            if (input != null) {
                try {
                    this.historyTextArea.setFont(font.deriveFont(Float.valueOf(input).floatValue()));
                    end = true;
                    this.userProps.setProperty("fontsize", input);
                }
                catch (NumberFormatException e) {
                    System.err.println(e.toString());
                }
                continue;
            }
            end = true;
        }
    }

    private void historyMenuFontSizeActionPerformed(ActionEvent evt) {
        this.recordMenuItemFontsizeActionPerformed(evt);
    }

    private void historyMenuItemLoadActionPerformed(ActionEvent evt) {
        this.loadMenuItemActionPerformed(evt);
    }

    private void loadMenuItemActionPerformed(ActionEvent evt) {
        boolean error;
        int returnVal;
        if (this.fc_load == null) {
            this.fc_load = new JFileChooser();
            this.fc_load.removeChoosableFileFilter(this.fc_load.getAcceptAllFileFilter());
            if (this.utf8 == null) {
                this.utf8 = new ExampleFileFilter("txt", "Unicode, UTF-8");
            }
            if (this.utf16 == null) {
                this.utf16 = new ExampleFileFilter("txt", "Unicode, UTF-16");
            }
            if (this.iso8859 == null) {
                this.iso8859 = new ExampleFileFilter("txt", "Text, ISO8859_1");
            }
            this.fc_load.addChoosableFileFilter(this.iso8859);
            this.fc_load.addChoosableFileFilter(this.utf8);
            this.fc_load.addChoosableFileFilter(this.utf16);
            this.fc_load.setFileFilter(this.utf8);
        }
        do {
            error = false;
            returnVal = this.fc_load.showOpenDialog(this);
            if (returnVal != 0) continue;
            ExampleFileFilter ff = (ExampleFileFilter)this.fc_load.getFileFilter();
            String encoding = ff.equals(this.utf8) ? "UTF-8" : (ff.equals(this.utf16) ? "UTF-16" : "ISO8859_1");
            File selFile = this.fc_load.getSelectedFile();
            try {
                String thisLine;
                FileInputStream fis = new FileInputStream(selFile);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
                this.historyTextArea.setText("");
                while ((thisLine = br.readLine()) != null) {
                    this.historyTextArea.append(thisLine);
                    this.historyTextArea.append("\n");
                }
                br.close();
                fis.close();
            }
            catch (IOException e) {
                error = true;
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
        } while (returnVal == 0 && error);
    }

    private void targetMenuItemPlayActionPerformed(ActionEvent evt) {
        this.playNumber();
    }

    private void sourceMenuItemColorActionPerformed(ActionEvent evt) {
        this.menuItemColorPressed();
    }

    private void historyMenuItemSaveActionPerformed(ActionEvent evt) {
        this.saveButtonActionPerformed(evt);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        this.saveButtonActionPerformed(evt);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.fc_save = this.newSingleton_JFileChooserSave();
        int returnVal = this.fc_save.showSaveDialog(this);
        if (returnVal == 0) {
            File selFile = this.fc_save.getSelectedFile();
            boolean overwrite = true;
            if (selFile.exists() && selFile.isFile()) {
                overwrite = GUIHelper.showQuestion(this, "", GeneralString.message(this.rb.getString("Error.FileAlreadyExists"), selFile.getPath()));
            }
            if (overwrite) {
                try {
                    FileOutputStream fos = new FileOutputStream(selFile);
                    ExampleFileFilter ff = (ExampleFileFilter)this.fc_save.getFileFilter();
                    String encoding = this.encodingFromFileFilter(ff);
                    BufferedWriter myOutput = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoding));
                    if (ff.equals(this.html)) {
                        boolean add = false;
                        if (!this.historyTextArea.getText().startsWith("<html>")) {
                            add = GUIHelper.showQuestion(this, "", this.rb.getString("Edit.HTMLTemplateNotFound"));
                        }
                        if (add) {
                            this.historyTextArea.insert(HTML_HEADER, 0);
                            this.historyTextArea.append(HTML_FOOTER);
                        }
                    }
                    myOutput.write(this.historyTextArea.getText());
                    myOutput.close();
                    fos.close();
                    this.messageOk(this.rb.getString("Message.GUI.FileWritten"));
                }
                catch (IOException e) {
                    this.messageLightError(e.getMessage());
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                }
            }
        }
    }

    private void recordMenuItemMakeListActionPerformed(ActionEvent evt) {
        this.makeListButtonActionPerformed(evt);
    }

    private void historyPopupMenuItemMakeListActionPerformed(ActionEvent evt) {
        this.makeListButtonActionPerformed(evt);
    }

    private void historyPopupMenuenuItemFormatActionPerformed(ActionEvent evt) {
        this.recordMenuItemFormatActionPerformed(evt);
    }

    private void recordMenuItemFormatActionPerformed(ActionEvent evt) {
        String input = this.userProps.getProperty("notice_form", DEFAULT_NOTICE_FORM);
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (this.propertiesForAllUsers.getProperty("format_" + i) != null) {
            al.add(this.propertiesForAllUsers.getProperty("format_" + i, DEFAULT_NOTICE_FORM));
            ++i;
        }
        i = 0;
        while (this.userProps.getProperty("format_" + i) != null) {
            al.add(this.userProps.getProperty("format_" + i, DEFAULT_NOTICE_FORM));
            ++i;
        }
        String entered = (String)JOptionPane.showInputDialog(this, this.rb.getString("GUI.Menu.Records.Format"), this.rb.getString("GUI.Menu.Records.Format"), 3, null, al.toArray(), input);
        if (entered != null) {
            this.userProps.setProperty("notice_form", entered);
            this.saveUserProperties();
        }
    }

    private void makeListButtonActionPerformed(ActionEvent evt) {
        this.multipleNoticeCluster.reset();
        if (this.categoryObject instanceof CategoryHolidays) {
            this.multipleNoticeCluster.setStartValue(new BigDecimal(this.categoryObject.getInitialValue()));
            this.multipleNoticeCluster.setEndValue(this.multipleNoticeCluster.getStartValue());
            this.multipleNoticeCluster.setListFormatVisible(true);
        }
        if (this.categoryObject instanceof CategoryTimezones) {
            this.multipleNoticeCluster.setStartValue(new BigDecimal(CategoryTimezones.getInternationalTimeValue()));
            this.multipleNoticeCluster.setEndValue(this.multipleNoticeCluster.getStartValue());
        }
        if (this.categoryObject instanceof CategoryCalendarSystems || this.categoryObject instanceof CategoryDateQueries || this.categoryObject instanceof CategoryDateFormats) {
            try {
                this.multipleNoticeCluster.setStartValue(new BigDecimal(this.categoryObject.getTransferValue((Unit)this.sourceBox.getSelectedItem())));
                this.multipleNoticeCluster.setEndValue(this.multipleNoticeCluster.getStartValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        new ListGeneratorDialog(this, true, this.multipleNoticeCluster);
        if (this.multipleNoticeCluster.isSuccess() && this.multipleNoticeCluster.getStartValue().compareTo(this.multipleNoticeCluster.getEndValue()) <= 0 && (this.multipleNoticeCluster.getStartValue().compareTo(this.multipleNoticeCluster.getEndValue()) < 0 && this.multipleNoticeCluster.getStepValue().compareTo(new BigDecimal(BigInteger.ZERO)) > 0 || this.multipleNoticeCluster.getStartValue().compareTo(this.multipleNoticeCluster.getEndValue()) == 0)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean specialFormat = this.multipleNoticeCluster.getListFormat() != null;
            int headerPos = this.historyTextArea.getCaretPosition();
            if (this.multipleNoticeCluster.getTargets() == 2) {
                this.dontPanic();
                this.setState(1);
                int save = this.targetBox.getSelectedIndex();
                for (int i = 0; i < this.targetBox.getItemCount(); ++i) {
                    this.targetBox.setSelectedIndex(i);
                    int count = this.processList(this.multipleNoticeCluster);
                    if (specialFormat || count <= 1) continue;
                    this.historyTextArea.append("\n");
                }
                this.targetBox.setSelectedIndex(save);
                this.setState(0);
            } else if (this.multipleNoticeCluster.getTargets() == 1) {
                int save = this.targetBox.getSelectedIndex();
                String flag = ((Unit)this.targetBox.getSelectedItem()).getIcon();
                for (int i = 0; i < this.targetBox.getItemCount(); ++i) {
                    if (!((Unit)this.targetBox.getItemAt(i)).getIcon().equals(flag)) continue;
                    this.targetBox.setSelectedIndex(i);
                    int count = this.processList(this.multipleNoticeCluster);
                    if (specialFormat || count <= 1) continue;
                    this.historyTextArea.append("\n");
                }
                this.targetBox.setSelectedIndex(save);
            } else {
                this.processList(this.multipleNoticeCluster);
            }
            if (specialFormat) {
                this.historyTextArea.insert(this.multipleNoticeCluster.getListFormat().getHeader(), headerPos);
                this.historyTextArea.append(this.multipleNoticeCluster.getListFormat().getFooter());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void maximumRadioButtonMenuItemItemStateChanged(ItemEvent evt) {
        this.luxuryFrame(-1);
    }

    private void reloadMenuItemActionPerformed(ActionEvent evt) {
        this.categoryBoxItemStateChanged();
    }

    private void reloadUnitsItemActionPerformed(ActionEvent evt) {
        this.categoryBoxItemStateChanged();
    }

    private void countUnitsMenuItemActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String thisLine;
            String filename = "/data/lists/categories.list";
            InputStream is = this.getClass().getResourceAsStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
            Summary summary = new Summary();
            summary.setUnitsSelectable(this.latestCount);
            while ((thisLine = br.readLine()) != null) {
                StringTokenizer st;
                String code;
                Category category;
                CategoryObject co;
                if (thisLine.startsWith("#") || thisLine.equals("") || (co = this.constructCategoryObjectFromCategory(category = this.categoryHashMap.get(code = (st = new StringTokenizer(thisLine, ":")).nextToken()))) == null) continue;
                int supportedUnits = Math.max(co.getSourceUnits().size(), co.getTargetUnits().size());
                summary.addCategoriesComplete(1);
                summary.addUnitsComplete(supportedUnits);
                if (!this.groupHashSet.isEmpty() && !this.groupHashSet.contains(code)) continue;
                summary.addCategoriesFiltered(1);
                summary.addUnitsFiltered(supportedUnits);
            }
            br.close();
            this.setCursor(Cursor.getPredefinedCursor(0));
            new SummaryDialog(this, true, summary);
        }
        catch (IOException e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this, e.toString(), "Error", 0);
        }
    }

    private void helpIndexMenuItemActionPerformed(ActionEvent evt) {
        String filename = System.getProperty("user.dir") + "/../help/" + this.userProps.getProperty("help", "en") + "/index.html";
        try {
            jonelo.sugar.gui.GUIHelper.openLocalFileInBrowser(filename);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void updateExchangeRatesMenuItemActionPerformed(ActionEvent evt) {
        ExchangeRates exchangeRates = new ExchangeRates();
        exchangeRates.setPreferredFilter(this.propertiesForAllUsers.getProperty("rates_preferred", ""));
        exchangeRates.setPreferredDirectory(this.propertiesForAllUsers.getProperty("rates_preferred_dir", null));
        new ExchangeRatesDialog(this, exchangeRates, this.getISO3166ResourceBundle());
        if (exchangeRates.success()) {
            try {
                exchangeRates.writeToDisk();
                this.propertiesForAllUsers.setProperty("rates_date", exchangeRates.getDate());
                this.propertiesForAllUsers.setProperty("rates_logic", exchangeRates.getLogic() ? "true" : "false");
                this.propertiesForAllUsers.setProperty("rates_preferred", exchangeRates.getPreferredFilter());
                this.propertiesForAllUsers.setProperty("rates_preferred_dir", exchangeRates.getPreferredDirectory());
                this.updateProps.setProperty("rates_updated", Long.toString(System.currentTimeMillis()));
                this.updateProps.setProperty("rates_preferred", exchangeRates.getPreferredFilter());
                this.updateProps.setProperty("rates_vendor", exchangeRates.getName());
                this.savePropertiesForAllUsers();
                this.saveUpdateProperties();
            }
            catch (Exception e) {
                System.err.println(e);
            }
            Category category = this.categoryHashMap.get("exchange_rates");
            category.setString(GeneralString.replaceString(this.exchange_rates_description, "$RATES_DATE", exchangeRates.getDate()));
            category.setLogic(exchangeRates.getLogic());
            if (!this.groupHashSet.contains("exchange_rates")) {
                this.clickOnFilterCategoryIndicator();
            }
            this.categoryBox.setSelectedItem(this.categoryHashMap.get("exchange_rates"));
            this.transferValue = "1";
            this.categoryBoxItemStateChanged();
        }
        this.messageOk(GeneralString.message(this.rb.getString("GUI.Rates.count"), exchangeRates.count()), true);
    }

    private void miserlyRadioButtonMenuItemItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.luxuryFrame(3);
        }
    }

    private void economicalRadioButtonMenuItemItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.luxuryFrame(2);
        }
    }

    private void standardRadioButtonMenuItemItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.luxuryFrame(1);
        }
    }

    private void luxuryRadioButtonMenuItemItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.luxuryFrame(0);
        }
    }

    private void targetMenuItemFiguresActionPerformed(ActionEvent evt) {
        this.sciCheckBox.setSelected(true);
        this.precisionTextField.requestFocus();
    }

    private void historyPopupMenuItemNewActionPerformed(ActionEvent evt) {
        this.editorNoticeButtonActionPerformed(evt);
    }

    private void recordMenuItemNewActionPerformed(ActionEvent evt) {
        this.editorNoticeButtonActionPerformed(evt);
    }

    private void editorNoticeButtonActionPerformed(ActionEvent evt) {
        this.performNotice();
        this.sourceTextArea.requestFocus();
    }

    private void recordMenuItemPasteActionPerformed(ActionEvent evt) {
        this.historyPasteButtonActionPerformed(evt);
    }

    private void recordMenuItemCopyActionPerformed(ActionEvent evt) {
        this.historyCopyButtonActionPerformed(evt);
    }

    private void sourceMenuItemPasteActionPerformed(ActionEvent evt) {
        this.sourcePasteButtonActionPerformed(evt);
    }

    private void sourceMenuItemCopyActionPerformed(ActionEvent evt) {
        this.sourceCopyButtonActionPerformed(evt);
    }

    private void sourceMenuItemPlusActionPerformed(ActionEvent evt) {
        this.sourcePlusButtonActionPerformed(evt);
    }

    private void sourceMenuItemMinusActionPerformed(ActionEvent evt) {
        this.sourceMinusButtonActionPerformed(evt);
    }

    private void programMenuItemSwapActionPerformed(ActionEvent evt) {
        this.swapButtonActionPerformed(evt);
    }

    private void recordMenuItemClearActionPerformed(ActionEvent evt) {
        this.historyClearButtonActionPerformed(evt);
    }

    private void targetMenuItemCopyActionPerformed(ActionEvent evt) {
        this.targetCopyButtonActionPerformed(evt);
    }

    private void sourceMenuItemClearActionPerformed(ActionEvent evt) {
        this.sourceClearButtonActionPerformed(evt);
    }

    private void targetCopyButtonActionPerformed(ActionEvent evt) {
        this.textAreaCopy(this.targetTextArea);
    }

    private void historyMenuItemPasteActionPerformed(ActionEvent evt) {
        this.historyPasteButtonActionPerformed(evt);
    }

    private void historyMenuItemCopyActionPerformed(ActionEvent evt) {
        this.historyCopyButtonActionPerformed(evt);
    }

    private void historyAreaMouseClicked(MouseEvent evt) {
        this.checkPopupMenu(evt, this.historyPopupMenu);
    }

    private void historyAreaMouseReleased(MouseEvent evt) {
        this.checkPopupMenu(evt, this.historyPopupMenu);
    }

    private void historyAreaMousePressed(MouseEvent evt) {
        this.checkPopupMenu(evt, this.historyPopupMenu);
    }

    private void historyMenuItemCutActionPerformed(ActionEvent evt) {
        this.historyClearButtonActionPerformed(evt);
    }

    private void sourcePopupMenuItemMinusActionPerformed(ActionEvent evt) {
        this.sourceMinusButtonActionPerformed(evt);
    }

    private void sourcePopupMenuItemPlusActionPerformed(ActionEvent evt) {
        this.sourcePlusButtonActionPerformed(evt);
    }

    private void sourcePasteButtonActionPerformed(ActionEvent evt) {
        this.sourceTextAreaPaste();
    }

    private void sourceCopyButtonActionPerformed(ActionEvent evt) {
        this.textAreaCopy(this.sourceTextArea);
    }

    private void sourceClearButtonActionPerformed(ActionEvent evt) {
        this.textAreaCopy(this.sourceTextArea);
        this.textAreaClear(this.sourceTextArea);
    }

    private void targetTextAreaMouseClicked(MouseEvent evt) {
        this.checkPopupMenu(evt, this.targetPopupMenu);
    }

    private void targetTextAreaMouseReleased(MouseEvent evt) {
        this.checkPopupMenu(evt, this.targetPopupMenu);
    }

    private void targetTextAreaMousePressed(MouseEvent evt) {
        this.checkPopupMenu(evt, this.targetPopupMenu);
    }

    private void targetPopupMenuItemCopyActionPerformed(ActionEvent evt) {
        this.targetCopyButtonActionPerformed(evt);
    }

    private void sourcePopupMenuItemPasteActionPerformed(ActionEvent evt) {
        this.sourcePasteButtonActionPerformed(evt);
    }

    private void sourcePopupMenuItemCutActionPerformed(ActionEvent evt) {
        this.sourceClearButtonActionPerformed(evt);
    }

    private void sourcePopupMenuItemCopyActionPerformed(ActionEvent evt) {
        this.sourceCopyButtonActionPerformed(evt);
    }

    private void sourceTextAreaMouseReleased(MouseEvent evt) {
        this.checkPopupMenu(evt, this.sourcePopupMenu);
    }

    private void sourceTextAreaMousePressed(MouseEvent evt) {
        this.checkPopupMenu(evt, this.sourcePopupMenu);
    }

    private void sourceTextAreaMouseClicked(MouseEvent evt) {
        this.checkPopupMenu(evt, this.sourcePopupMenu);
    }

    private void sourceNextButtonActionPerformed(ActionEvent evt) {
        int all;
        int now = this.sourceBox.getSelectedIndex();
        if (now + 1 < (all = this.sourceBox.getItemCount())) {
            this.sourceBox.setSelectedIndex(now + 1);
        } else {
            this.sourceBox.setSelectedIndex(0);
        }
    }

    private void restartItemActionPerformed(ActionEvent evt) {
        this.restart();
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.saveExit();
    }

    private void helpMenuItemAboutActionPerformed(ActionEvent evt) {
        this.showAboutDialog();
    }

    private void sourceBackButtonActionPerformed(ActionEvent evt) {
        int now = this.sourceBox.getSelectedIndex();
        int all = this.sourceBox.getItemCount();
        if (now > 0) {
            this.sourceBox.setSelectedIndex(now - 1);
        } else {
            this.sourceBox.setSelectedIndex(all - 1);
        }
    }

    private void historyPasteButtonActionPerformed(ActionEvent evt) {
        this.historyTextAreaPaste();
    }

    private void precisionTextFieldKeyReleased(KeyEvent evt) {
        int i;
        int code = evt.getKeyCode();
        boolean bool = true;
        for (i = 0; i < GeneralGUI.noTextChangeKeyEvents.length; ++i) {
            if (code != GeneralGUI.noTextChangeKeyEvents[i]) continue;
            bool = false;
            break;
        }
        if (bool) {
            try {
                if (this.precisionTextField.getText().length() > 4) {
                    throw new Exception();
                }
                i = Integer.parseInt(this.precisionTextField.getText());
                if (i > 1000) {
                    throw new Exception();
                }
                this.categoryObject.setPrecision(i);
                this.precisionerror = false;
                this.process(-1);
            }
            catch (Exception e) {
                this.messageError(this.rb.getString(ERROR_GUI_PRECISION));
                this.precisionerror = true;
            }
        }
    }

    private void historyCopyButtonActionPerformed(ActionEvent evt) {
        this.textAreaCopy(this.historyTextArea);
    }

    private void historyClearButtonActionPerformed(ActionEvent evt) {
        this.textAreaCopy(this.historyTextArea);
        this.textAreaClear(this.historyTextArea);
    }

    private void sourceTextAreaKeyReleased(KeyEvent evt) {
        int code = evt.getKeyCode();
        boolean b = true;
        for (int i = 0; i < GeneralGUI.noTextChangeKeyEvents.length; ++i) {
            if (code != GeneralGUI.noTextChangeKeyEvents[i]) continue;
            b = false;
            break;
        }
        if (code == 10 || code == 17 || code == 65487) {
            this.sourceTextArea.setText(this.sourceTextArea.getText().replace('\n', ' ').replace('\r', ' ').trim());
        }
        if (b) {
            this.process(-1);
        }
    }

    private void sourceMinusButtonActionPerformed(ActionEvent evt) {
        try {
            this.addValue(MINUS_ONE);
        }
        catch (Exception e) {
            this.categoryObject.setInput(this.sourceTextArea.getText());
            this.messageError(e.getMessage());
        }
        this.sourceTextArea.requestFocus();
    }

    private void sourcePlusButtonActionPerformed(ActionEvent evt) {
        try {
            this.addValue(BigDecimal.ONE);
        }
        catch (Exception e) {
            this.categoryObject.setInput(this.sourceTextArea.getText());
            this.messageError(e.getMessage());
        }
        this.sourceTextArea.requestFocus();
    }

    private void targetBackButtonActionPerformed(ActionEvent evt) {
        int now = this.targetBox.getSelectedIndex();
        int all = this.targetBox.getItemCount();
        if (now > 0) {
            this.targetBox.setSelectedIndex(now - 1);
        } else {
            this.targetBox.setSelectedIndex(all - 1);
        }
    }

    private void targetNextButtonActionPerformed(ActionEvent evt) {
        int all;
        int now = this.targetBox.getSelectedIndex();
        if (now + 1 < (all = this.targetBox.getItemCount())) {
            this.targetBox.setSelectedIndex(now + 1);
        } else {
            this.targetBox.setSelectedIndex(0);
        }
    }

    private void swapButtonActionPerformed(ActionEvent evt) {
        if (!this.categoryObject.acceptEmptyStrings()) {
            this.sourceTextArea.setText(this.targetTextArea.getText());
        }
        int indexTemp = this.sourceBox.getSelectedIndex();
        this.sourceBox.setSelectedIndex(this.targetBox.getSelectedIndex());
        this.targetBox.setSelectedIndex(indexTemp);
        this.enableNavigationDependentOnEntryCount();
        this.process(-1);
        this.sourceTextArea.setCaretPosition(0);
        this.targetTextArea.setCaretPosition(0);
        this.sourceTextArea.requestFocus();
    }

    private void calculatorMenuItemActionPerformed(ActionEvent evt) {
        this.calculatorButtonActionPerformed(evt);
    }

    private void googleMapsButtonActionPerformed(ActionEvent evt) {
        try {
            String latlong = this.categoryObject.getOutput((Unit)this.sourceBox.getSelectedItem(), new Unit(0));
            Main.googleMaps(latlong);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void unicodeButtonActionPerformed(ActionEvent evt) {
        try {
            jonelo.sugar.gui.GUIHelper.openInBrowser("http://www.unicode.org/charts/index.html");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void groupComboBoxItemStateChanged(ItemEvent evt) {
        Object item = evt.getItem();
        if (evt.getStateChange() == 1) {
            this.groupComboBoxItemSelected(item);
        }
    }

    private void categoryHelpButtonActionPerformed(ActionEvent evt) {
        String lang = this.userProps.getProperty("help", "en");
        String id = ((Category)this.categoryBox.getSelectedItem()).getName().toLowerCase(Locale.US);
        String filename = System.getProperty("user.dir") + "/../help/" + lang + "/categories/" + id + ".html";
        if (new File(filename).exists()) {
            try {
                jonelo.sugar.gui.GUIHelper.openLocalFileInBrowser(filename);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No Help available for this category in this language.\n" + filename);
        }
    }

    private void randomNumbersMenuItemActionPerformed(ActionEvent evt) {
        new RandomGeneratorDialog(this);
    }

    private void primaryFavoriteMenuItemActionPerformed(ActionEvent evt) {
        Bookmark bookmark = this.getCurrentSelectionAsBookmark();
        this.userProps.setProperty("lastCatAndUnit", bookmark.getBookmarkAsString());
        this.userProps.setProperty("backupCatAndUnit", "false");
        this.saveUserProperties();
    }

    private void filterMenuItemActionPerformed(ActionEvent evt) {
        this.groupComboBox.setPopupVisible(true);
    }

    private void tutorialMenuItemActionPerformed(ActionEvent evt) {
        this.goToWebPage("tutorials.html");
    }

    private void timePanelTimeChooserButtonActionPerformed(ActionEvent evt) {
        this.openTimeChooserDialog();
    }

    private void timeDialogButtonActionPerformed(ActionEvent evt) {
        this.openTimeChooserDialog();
    }

    private void timeDialogMenuItemActionPerformed(ActionEvent evt) {
        this.openTimeChooserDialog();
    }

    private void playTimeButtonActionPerformed(ActionEvent evt) {
        this.playNumber();
    }

    private void stopPlayingTimeButtonActionPerformed(ActionEvent evt) {
        this.categoryObject.stopPlaying();
    }

    static {
        String waitValue = System.getProperty("waitBeforeStart", "0");
        if (!waitValue.equals("0")) {
            try {
                Thread.sleep(Integer.parseInt(waitValue));
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
            catch (NumberFormatException e) {
                System.err.println(e);
            }
        }
        GREEN = new Color(0x99FF99);
        RED = new Color(0xFF6666);
        MINUS_ONE = BigDecimal.valueOf(-1L);
        HTML_HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n \"http://www.w3.org/TR/html4/strict.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n  <title>Generated by " + ProgInfo.getInstance().getProgramName() + " " + ProgInfo.getInstance().getVersion() + "</title>\n  <meta name=\"author\" content=\"" + ProgInfo.getInstance().getProgramName() + " " + ProgInfo.getInstance().getVersion() + "\">\n</head>\n<body>\n\n<table BORDER CELLSPACING=0 CELLPADDING=3>\n";
    }
}

