/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.datediff;

import java.util.Calendar;
import jonelo.sugar.util.CalendarTools;
import net.numericalchameleon.util.datediff.DurationControl;

public class DurationColloquial
implements Cloneable {
    private double months = 0.0;
    private double quarters = 0.0;
    private double years = 0.0;
    private double decades = 0.0;
    private double weeks = 0.0;
    private double days = 0.0;

    public DurationColloquial(int months, int days) {
        this.setMonths(months);
        this.setDays(days);
    }

    public DurationColloquial() {
    }

    public static DurationColloquial getDiff(Calendar start, Calendar end) {
        Calendar tend;
        Calendar tstart;
        int months = 0;
        if (start.before(end)) {
            tstart = (Calendar)start.clone();
            tend = (Calendar)end.clone();
        } else {
            tstart = (Calendar)end.clone();
            tend = (Calendar)start.clone();
        }
        int daysInMonth = CalendarTools.daysInMonth(tstart.get(1), tstart.get(2));
        boolean MMYYYYequal = tstart.get(2) == tend.get(2) && tstart.get(1) == tend.get(1);
        int days = MMYYYYequal ? tend.get(5) - tstart.get(5) : daysInMonth - tstart.get(5) + tend.get(5);
        if (days >= daysInMonth) {
            days -= daysInMonth;
            ++months;
        }
        return new DurationColloquial(months += (tend.get(1) - tstart.get(1)) * 12 + (tend.get(2) + 1) - (tstart.get(2) + 1) - (MMYYYYequal ? 0 : 1), days);
    }

    public void rearrange(DurationControl control) {
        long t = (long)(this.years * 12.0 + this.quarters * 3.0 + this.months);
        if (t > 0L) {
            this.months = t % 3L;
            t /= 3L;
        }
        if (t > 0L) {
            this.setQuarters(t % 4L);
            t /= 4L;
        }
        if (t > 0L) {
            this.years = t % 10L;
            t /= 10L;
        }
        this.decades = t;
        if (!control.isDecadesWanted()) {
            this.years += this.decades * 10.0;
            this.decades = 0.0;
        }
        if (!control.isYearsWanted()) {
            this.setQuarters(this.getQuarters() + this.years * 4.0);
            this.years = 0.0;
        }
        if (!control.isQuartersWanted()) {
            this.months += this.getQuarters() * 3.0;
            this.setQuarters(0.0);
        }
        if (!control.isMonthsWanted()) {
            if (control.isQuartersWanted()) {
                this.setQuarters(this.getQuarters() + this.months / 3.0);
            } else if (control.isYearsWanted()) {
                this.years += this.months / 12.0;
            } else if (control.isDecadesWanted()) {
                this.decades += this.months / 120.0;
            }
            this.months = 0.0;
        }
        if ((t = (long)this.getDays()) > 0L) {
            this.days = t % 7L;
            t /= 7L;
        }
        this.setWeeks(t);
        if (!control.isWeeksWanted()) {
            this.days += this.getWeeks() * 7.0;
            this.weeks = 0.0;
        }
        if (!control.isDaysWanted()) {
            if (control.isWeeksWanted()) {
                this.setWeeks(this.getWeeks() + this.days / 7.0);
            }
            this.days = 0.0;
        }
    }

    public Object clone() {
        DurationColloquial theClone = new DurationColloquial();
        theClone.months = this.months;
        theClone.quarters = this.quarters;
        theClone.years = this.years;
        theClone.decades = this.decades;
        theClone.weeks = this.weeks;
        theClone.days = this.days;
        return theClone;
    }

    public double getYears() {
        return this.years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public long getMonthsOnly() {
        return (long)(this.years * 12.0 + this.quarters * 3.0 + this.months);
    }

    public double getMonths() {
        return this.months;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public double getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public double getQuarters() {
        return this.quarters;
    }

    public void setQuarters(double quarters) {
        this.quarters = quarters;
    }

    public double getWeeks() {
        return this.weeks;
    }

    public void setWeeks(double weeks) {
        this.weeks = weeks;
    }
}

