/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.misc;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateYMD {
    private Calendar cal = new GregorianCalendar();
    private static SimpleDateFormat formatter;

    public DateYMD(String data) throws Exception {
        this();
        this.setTime(formatter.parse(data));
    }

    public DateYMD() {
        if (formatter == null) {
            formatter = new SimpleDateFormat("yyyyMMdd");
        }
    }

    public String toString() {
        return formatter.format(this.cal.getTime());
    }

    public void setTime(Date date) {
        this.cal.setTime(date);
    }

    public void setTime(int year, int month, int day) {
        this.cal.set(year, month, day);
    }

    public void addDays(int days) {
        this.cal.add(5, days);
    }

    public static DateYMD parse(String input) throws Exception {
        DateYMD date = new DateYMD();
        int value = Integer.parseInt(input);
        int year = value / 10000;
        int month = value / 100 - year * 100;
        int day = value % 100;
        date.setTime(year, month - 1, day);
        return date;
    }
}

