/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class ItalianNumber
extends SpokenNumber {
    private static final String[][] field = new String[][]{{"uno", "due", "tre", "quattro", "cinque", "sei", "sette", "otto", "nove"}, {"undici", "dodici", "tredici", "quattordici", "quindici", "sedici", "diciassette", "diciotto", "diciannove"}, {"dieci", "venti", "trenta", "quaranta", "cinquanta", "sessanta", "settanta", "ottanta", "novanta"}};
    private static final String NULL = "zero";
    private static final String MINUS = "meno";
    private static final String TRE_ACCENT = "tr\u00e8";
    private static final String CENTO = "cento";

    public ItalianNumber() {
    }

    public ItalianNumber(long number) throws Exception {
        super(number);
    }

    public ItalianNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 3;
    }

    @Override
    public String getSoundDir() {
        return "italian";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("meno ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field[0]);
            return;
        }
        this.number2digits();
        if (this.number.equalsIgnoreCase("0")) {
            this.syllables.add(NULL);
        } else {
            this.decode(0);
        }
    }

    private void decode(int index) {
        int x = this.digits[index + 2] * 100;
        if (x >= 100) {
            if (x >= 200) {
                this.syllables.add(field[0][this.digits[index + 2] - 1]);
            }
            this.syllables.add(CENTO);
        }
        if ((x = this.digits[index + 1] * 10 + this.digits[index]) == 0) {
            return;
        }
        if (x < 10) {
            this.syllables.add(field[0][x - 1]);
        } else if (x > 10 && x < 20) {
            this.syllables.add(field[1][x - 11]);
        } else {
            if (this.digits[index] != 1 && this.digits[index] != 8) {
                this.syllables.add(field[2][this.digits[index + 1] - 1]);
            } else {
                String tmp = field[2][this.digits[index + 1] - 1];
                this.syllables.add(tmp.substring(0, tmp.length() - 1));
            }
            if (this.digits[index] > 0) {
                if (this.digits[index] == 3) {
                    this.syllables.add(TRE_ACCENT);
                } else {
                    this.syllables.add(field[0][this.digits[index] - 1]);
                }
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new ItalianNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new ItalianNumber(number).toString();
    }
}

