/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import java.util.ArrayList;
import net.numericalchameleon.util.phoneticalphabets.PhoneticAlphabet;
import net.numericalchameleon.util.spokennumbers.AudioThread;
import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class MorseCodeNumber
extends SpokenNumber {
    private PhoneticAlphabet phoneticAlphabet;

    public MorseCodeNumber() {
        this.appendBlank = true;
        this.phoneticAlphabet = new PhoneticAlphabet(PhoneticAlphabet.MORSE);
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add(this.phoneticAlphabet.get('-'));
        }
        if (this.number.equalsIgnoreCase("0")) {
            this.syllables.add(this.phoneticAlphabet.get('0'));
        } else {
            for (int i = 0; i < this.number.length(); ++i) {
                String temp = this.phoneticAlphabet.get(this.number.charAt(i));
                this.syllables.add(temp);
            }
        }
    }

    @Override
    public String getSoundDir() {
        return "morse";
    }

    @Override
    protected int getSupportedDigits() {
        return 1000;
    }

    @Override
    public void play() {
        ArrayList<String> playvec = new ArrayList<String>();
        for (int i = 0; i < this.syllables.size(); ++i) {
            String temp = (String)this.syllables.get(i);
            for (int x = 0; x < temp.length(); ++x) {
                if (temp.charAt(x) == '.') {
                    playvec.add("dot");
                    continue;
                }
                if (temp.charAt(x) != '-') continue;
                playvec.add("dash");
            }
        }
        if (this.audioThread != null) {
            this.audioThread.interrupt();
            while (this.audioThread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.audioThread = new AudioThread(playvec, this.getSoundDir());
        this.audioThread.start();
    }
}

