/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class SpanishNumber
extends SpokenNumber {
    private static final String NULL = "cero";
    private static final String MINUS = "menos ";
    private static final String[] specialNumbers = new String[]{"uno", "dos", "tres", "cuatro", "cinco", "seis", "siete", "ocho", "nueve", "diez", "once", "doce", "trece", "catorce", "quince", "diecis\u00e9is", "diecisiete", "dieciocho", "diecinueve", "veinte", "veintiuno", "veintid\u00f3s", "veintitr\u00e9s", "veinticuatro", "veinticinco", "veintis\u00e9is", "veintisiete", "veintiocho", "veintinueve"};
    private static final String[] prefixTenths = new String[]{"treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa"};
    private static final String[] prefixHundreds = new String[]{"ciento", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos"};
    private static final String[] prefixGillions = new String[]{" millones ", " billones ", " trillones ", " cuatrillones "};
    private static final String UN = "un";
    private static final String[] prefix1Gillion = new String[]{"un mill\u00f3n ", "un bill\u00f3n ", "un trill\u00f3n ", "un cuatrill\u00f3n "};
    private static final String Y = " y ";
    private static final String MIL = "mil";
    private static final String ONCE = "once";
    private static final String VEINTIUN = "veinti\u00fan";

    public SpanishNumber() {
    }

    public SpanishNumber(long number) throws Exception {
        super(number);
    }

    public SpanishNumber(String number) throws Exception {
        super(number);
    }

    public static String toString(long number) throws Exception {
        return new SpanishNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new SpanishNumber(number).toString();
    }

    @Override
    protected int getSupportedDigits() {
        return 30;
    }

    @Override
    public String getSoundDir() {
        return "spanish";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        StringBuilder workingNumber = new StringBuilder(this.number);
        boolean negative = false;
        if (this.number.startsWith("-")) {
            negative = true;
            workingNumber.deleteCharAt(0);
        }
        if (workingNumber.length() == 0 || workingNumber.length() > this.MAX_DIGITS) {
            return;
        }
        if (this.numberType == 1) {
            this.number = workingNumber.toString();
            if (negative) {
                this.syllables.add(MINUS);
            }
            this.fillSyllables(NULL, specialNumbers);
            return;
        }
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
            return;
        }
        int i = 1;
        while (workingNumber.length() < this.MAX_DIGITS) {
            workingNumber.insert(0, "0");
            ++i;
        }
        int mill4 = Integer.parseInt(workingNumber.substring(this.MAX_DIGITS - 30, this.MAX_DIGITS - 24));
        int mill3 = Integer.parseInt(workingNumber.substring(this.MAX_DIGITS - 24, this.MAX_DIGITS - 18));
        int mill2 = Integer.parseInt(workingNumber.substring(this.MAX_DIGITS - 18, this.MAX_DIGITS - 12));
        int mill1 = Integer.parseInt(workingNumber.substring(this.MAX_DIGITS - 12, this.MAX_DIGITS - 6));
        int thou = Integer.parseInt(workingNumber.substring(this.MAX_DIGITS - 6, this.MAX_DIGITS - 3));
        int hund = Integer.parseInt(workingNumber.substring(this.MAX_DIGITS - 3, this.MAX_DIGITS));
        if (negative) {
            this.syllables.add(MINUS);
        }
        this.addSyllables(this.gillions(mill4, 3));
        this.addSyllables(this.gillions(mill3, 2));
        this.addSyllables(this.gillions(mill2, 1));
        this.addSyllables(this.gillions(mill1, 0));
        this.addSyllables(this.thousands(thou));
        this.addSyllables(this.hundreds(hund));
        this.addSyllables(this.tenths(hund % 100));
    }

    private void addSyllables(String string) {
        for (String s : string.split(" ")) {
            this.syllables.add(s + " ");
        }
    }

    private String tenths(int m) {
        if (m == 0) {
            return "";
        }
        if (m < 30) {
            return specialNumbers[m - 1];
        }
        int mod = m % 10;
        return prefixTenths[m / 10 - 3] + (mod > 0 ? Y + specialNumbers[mod - 1] : "");
    }

    private boolean isSpecialTenth(String s) {
        return s.endsWith("1");
    }

    private String specialTenths(int m) {
        switch (m) {
            case 11: {
                return ONCE;
            }
            case 21: {
                return VEINTIUN;
            }
        }
        String s = this.tenths(m);
        return this.isSpecialTenth(m + "") ? s.substring(0, s.length() - 1) : s;
    }

    private String hundreds(int m) {
        if (m < 100) {
            return "";
        }
        return m == 100 ? "cien" : prefixHundreds[m / 100 - 1] + " ";
    }

    private String thousands(int m) {
        if (m == 0) {
            return "";
        }
        if (m == 1) {
            return "mil ";
        }
        return this.hundreds(m) + this.specialTenths(m % 100) + " " + MIL + " ";
    }

    private String gillions(int m, int magnitude) {
        if (m == 0) {
            return "";
        }
        if (m == 1) {
            return prefix1Gillion[magnitude];
        }
        int t = m / 1000;
        int h = m - t * 1000;
        return this.thousands(t) + this.hundreds(h) + this.specialTenths(h % 100) + prefixGillions[magnitude];
    }

    public static void main(String[] args) {
        boolean t = true;
        BufferedReader b = new BufferedReader(new InputStreamReader(System.in));
        while (t) {
            System.out.print("Dame un n\u00famero :");
            try {
                String some = b.readLine();
                SpanishNumber sp = new SpanishNumber(some);
                System.out.println("Tu n\u00famero fu\u00e9 : " + sp.toString());
            }
            catch (Exception e) {
                System.out.println("Exception :" + e.toString());
            }
        }
    }
}

