/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class TurkishNumber
extends SpokenNumber {
    private static final String[][] field = new String[][]{{"bir ", "iki ", "\u00fc\u00e7 ", "d\u00f6rt ", "be\u015f ", "alt\u0131 ", "yedi ", "sekiz ", "dokuz "}, {"on bir", "on iki", "on \u00fc\u00e7", "on d\u00f6rt", "on be\u015f", "on alt\u0131", "on yedi", "on sekiz", "on dokuz"}, {"on ", "yirmi ", "otuz ", "k\u0131rk ", "elli ", "altm\u0131\u015f ", "yetm\u0131\u015f ", "seksen ", "doksan "}};
    private static final String[] amount = new String[]{"bin ", "milyon ", "milyar ", "bilyon ", "bin bilyon", "trilyon ", "bin trilyon "};
    private static final String NULL = "s\u0131f\u0131r";
    private static final String MINUS = "eksi";
    private static final String HUNDRED = "y\u00fcz ";

    public TurkishNumber() {
        this.appendBlank = false;
    }

    public TurkishNumber(long number) throws Exception {
        super(number);
        this.appendBlank = false;
    }

    public TurkishNumber(String number) throws Exception {
        super(number);
        this.appendBlank = false;
    }

    @Override
    protected int getSupportedDigits() {
        return 24;
    }

    @Override
    public String getSoundDir() {
        return "turkish";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("eksi ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field[0]);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            int counter = amount.length - 1;
            for (int i = this.MAX_DIGITS - 3; i > 0; i -= 3) {
                this.xtriple(i, amount[counter--]);
            }
            this.triple(0);
        }
    }

    public static String toString(long number) throws Exception {
        return new TurkishNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new TurkishNumber(number).toString();
    }

    private void triple(int index) {
        if (this.digits[index + 2] > 0) {
            if (this.digits[index + 2] > 1) {
                this.syllables.add(field[0][this.digits[index + 2] - 1]);
            }
            this.syllables.add(HUNDRED);
        }
        if (this.digits[index + 1] == 1 && this.digits[index] > 0) {
            this.syllables.add(field[1][this.digits[index] - 1]);
        } else if (this.digits[index + 1] >= 1 && this.digits[index] == 0) {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
        } else {
            if (this.digits[index + 1] > 0) {
                this.syllables.add(field[2][this.digits[index + 1] - 1]);
            }
            if (this.digits[index] > 0) {
                this.syllables.add(field[0][this.digits[index] - 1]);
            }
        }
    }

    private void xtriple(int index, String singular) {
        if (this.digits[index] + this.digits[index + 1] + this.digits[index + 2] > 0) {
            if (index != 3 || this.digits[3] != 1 || this.digits[4] != 0 || this.digits[5] != 0) {
                this.triple(index);
            }
            this.syllables.add(singular);
        }
    }
}

