/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokentime;

import net.numericalchameleon.util.spokennumbers.UKEnglishNumber;
import net.numericalchameleon.util.spokennumbers.USEnglishNumber;
import net.numericalchameleon.util.spokentime.MilitaryTime;
import net.numericalchameleon.util.spokentime.MilitaryTimeInterface;
import net.numericalchameleon.util.spokentime.NumberToWordsInterface;
import net.numericalchameleon.util.spokentime.SpokenTime;

public class EnglishTime
extends SpokenTime
implements NumberToWordsInterface,
MilitaryTimeInterface {
    private HourclockType type = HourclockType.HOURCLOCK12_COLLOQUIAL_US;
    private static final String BLANK = " ";
    private static final String MIDNIGHT = "midnight";
    private static final String NOON = "noon";
    private static final String OCLOCK = "o'clock";
    private static final String A_QUARTER = "a quarter";
    private static final String QUARTER = "quarter";
    private static final String HALF = "half";
    private static final String AFTER = "after";
    private static final String PAST = "past";
    private static final String TO = "to";
    private static final String MINUTES = "minutes";
    private static final String MINUTE = "minute";
    private static final String HUNDERT = "hundred";

    public EnglishTime(HourclockType hourclock) {
        this.type = hourclock;
    }

    @Override
    public void init() {
        this.syllables.clear();
        try {
            switch (this.type) {
                case HOURCLOCK12_COLLOQUIAL_US: 
                case HOURCLOCK12_COLLOQUIAL_UK: {
                    this.hourclock12_colloquial();
                    break;
                }
                case HOURCLOCK24_MILITARY_US: 
                case HOURCLOCK24_MILITARY_UK: {
                    this.hourclock24_military();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void hourclock12_colloquial() {
        if (this.minutes == 0) {
            if (this.hours == 0) {
                this.syllables.add(MIDNIGHT);
                return;
            }
            if (this.hours == 12) {
                this.syllables.add(NOON);
                return;
            }
            this.hoursInWords(this.hours);
            this.syllables.add(BLANK);
            this.syllables.add(OCLOCK);
        } else if (this.minutes == 15) {
            if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_UK) {
                this.syllables.add(A_QUARTER);
            } else {
                this.syllables.add(QUARTER);
            }
            this.syllables.add(BLANK);
            if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_US) {
                this.syllables.add(AFTER);
            } else {
                this.syllables.add(PAST);
            }
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours);
        } else if (this.minutes == 30) {
            if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_UK) {
                this.syllables.add(HALF);
                this.syllables.add(BLANK);
                this.syllables.add(PAST);
                this.syllables.add(BLANK);
                this.hoursInWords(this.hours);
            } else {
                this.hoursInWords(this.hours);
                this.syllables.add(BLANK);
                this.minutesInWords(this.minutes);
            }
        } else if (this.minutes == 45) {
            if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_UK) {
                this.syllables.add(A_QUARTER);
            } else {
                this.syllables.add(QUARTER);
            }
            this.syllables.add(BLANK);
            this.syllables.add(TO);
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours + 1);
        } else if (this.minutes < 30) {
            this.minutesInWords(this.minutes);
            if (this.minutes < 5) {
                this.syllables.add(BLANK);
                if (this.minutes == 1) {
                    this.syllables.add(MINUTE);
                } else {
                    this.syllables.add(MINUTES);
                }
            }
            this.syllables.add(BLANK);
            if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_US) {
                this.syllables.add(AFTER);
            } else {
                this.syllables.add(PAST);
            }
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours);
        } else if (this.minutes > 30) {
            this.minutesInWords(60 - this.minutes);
            if (60 - this.minutes < 5) {
                this.syllables.add(BLANK);
                if (60 - this.minutes == 1) {
                    this.syllables.add(MINUTE);
                } else {
                    this.syllables.add(MINUTES);
                }
            }
            this.syllables.add(BLANK);
            this.syllables.add(TO);
            this.syllables.add(BLANK);
            this.hoursInWords(this.hours + 1);
        }
    }

    private void hourclock24_military() {
        MilitaryTime mt = new MilitaryTime(this, this.hours, this.minutes);
    }

    private void hoursInWords(int hours) {
        int h = hours;
        if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_US || this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_UK) {
            if (h >= 12) {
                h -= 12;
            }
            if (h == 0) {
                h = 12;
            }
        }
        this.numberToWords(h);
    }

    @Override
    public void numberToWords(int number) {
        try {
            if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_US || this.type == HourclockType.HOURCLOCK24_MILITARY_US) {
                USEnglishNumber englishNumber = new USEnglishNumber(number);
                this.syllables.addAll(englishNumber.getSyllables());
            } else {
                UKEnglishNumber englishNumber = new UKEnglishNumber(number);
                this.syllables.addAll(englishNumber.getSyllables());
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void minutesInWords(int minutes) {
        this.numberToWords(minutes);
    }

    @Override
    public String getSoundDir() {
        if (this.type == HourclockType.HOURCLOCK12_COLLOQUIAL_UK) {
            return "uk_english";
        }
        return "us_english";
    }

    @Override
    public String timeInWords() {
        StringBuilder sb = new StringBuilder();
        for (String syllable : this.syllables) {
            sb.append(syllable);
        }
        return sb.toString();
    }

    @Override
    public void separator() {
        this.syllables.add(BLANK);
    }

    @Override
    public void hundredString() {
        this.syllables.add(HUNDERT);
    }

    public static enum HourclockType {
        HOURCLOCK12_COLLOQUIAL_US,
        HOURCLOCK24_MILITARY_US,
        HOURCLOCK12_COLLOQUIAL_UK,
        HOURCLOCK24_MILITARY_UK;

    }
}

