/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import net.beeger.squareness.SquarenessLookAndFeel;
import net.beeger.squareness.util.SquarenessTitlePane;

public class SquarenessRootPaneUI
extends BasicRootPaneUI {
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window _window;
    private JComponent _titlePane;
    private MouseInputListener _mouseInputListener;
    private LayoutManager _layoutManager;
    private LayoutManager _savedOldLayout;
    private JRootPane _root;
    private Cursor _lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent jComponent) {
        return new SquarenessRootPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this._root = (JRootPane)jComponent;
        int n = this._root.getWindowDecorationStyle();
        if (n != 0) {
            this.installClientDecorations(this._root);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this._root);
        this._layoutManager = null;
        this._mouseInputListener = null;
        this._root = null;
    }

    void installBorder(JRootPane jRootPane) {
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            LookAndFeel.installBorder(jRootPane, borderKeys[n]);
        }
    }

    private void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    private void installWindowListeners(JRootPane jRootPane, Component component) {
        this._window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this._window != null) {
            if (this._mouseInputListener == null) {
                this._mouseInputListener = this.createWindowMouseInputListener();
            }
            this._window.addMouseListener(this._mouseInputListener);
            this._window.addMouseMotionListener(this._mouseInputListener);
        }
    }

    private void uninstallWindowListeners() {
        if (this._window != null) {
            this._window.removeMouseListener(this._mouseInputListener);
            this._window.removeMouseMotionListener(this._mouseInputListener);
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this._layoutManager == null) {
            this._layoutManager = this.createLayoutManager();
        }
        this._savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this._layoutManager);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this._savedOldLayout != null) {
            jRootPane.setLayout(this._savedOldLayout);
            this._savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        JComponent jComponent = this.createTitlePane(jRootPane);
        this.setTitlePane(jRootPane, jComponent);
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this._window != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners();
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this._window != null) {
            this._window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this._window = null;
    }

    private JComponent createTitlePane(JRootPane jRootPane) {
        return new SquarenessFrameTitlePane(jRootPane);
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        JComponent jComponent2 = this.getTitlePane();
        if (jComponent2 != null) {
            jComponent2.setVisible(false);
            jLayeredPane.remove(jComponent2);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this._titlePane = jComponent;
    }

    private JComponent getTitlePane() {
        return this._titlePane;
    }

    private JRootPane getRootPane() {
        return this._root;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            int n = jRootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(jRootPane);
            if (n != 0) {
                this.installClientDecorations(jRootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners();
            if (((JRootPane)propertyChangeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this._root, this._root.getParent());
            }
        }
    }

    private static class SquarenessFrameTitlePane
    extends SquarenessTitlePane {
        private JRootPane _rootPane;
        private Window _window;

        public SquarenessFrameTitlePane(JRootPane jRootPane) {
            this._rootPane = jRootPane;
        }

        public void addNotify() {
            super.addNotify();
            this._window = SwingUtilities.getWindowAncestor(this);
            this._window.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SquarenessFrameTitlePane.this.update();
                    SquarenessFrameTitlePane.this._window.repaint();
                }
            });
            this._rootPane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SquarenessFrameTitlePane.this.update();
                    SquarenessFrameTitlePane.this._window.repaint();
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            this.update();
            Color color = graphics.getColor();
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color);
        }

        public boolean isLeftToRight() {
            return this._window != null ? this._window.getComponentOrientation().isLeftToRight() : true;
        }

        protected boolean isIconifiable() {
            return this.isFrame();
        }

        protected boolean isMaximizable() {
            return this.isFrame() && this.getFrame().isResizable();
        }

        protected boolean isClosable() {
            return true;
        }

        protected void close() {
            if (this._window != null) {
                this._window.dispatchEvent(new WindowEvent(this._window, 201));
            }
        }

        protected void iconify() {
            if (this.isFrame()) {
                Frame frame = this.getFrame();
                frame.setExtendedState(this.getFrame().getExtendedState() | 1);
            }
        }

        protected void maximize() {
            if (this.isFrame()) {
                Frame frame = this.getFrame();
                frame.setExtendedState(this.getFrame().getExtendedState() | 6);
            }
        }

        protected void restore() {
            if (this.isFrame()) {
                Frame frame = this.getFrame();
                if (this.isIconified()) {
                    frame.setExtendedState(this.getFrame().getExtendedState() & 0xFFFFFFFE);
                } else {
                    frame.setExtendedState(this.getFrame().getExtendedState() & 0xFFFFFFF9);
                }
            }
        }

        protected boolean isMaximized() {
            return this.isFrame() && (this.getFrame().getExtendedState() & 6) != 0;
        }

        protected boolean isIconified() {
            return this.isFrame() && (this.getFrame().getExtendedState() & 1) != 0;
        }

        protected String getTitle() {
            String string = null;
            if (this.isFrame()) {
                string = this.getFrame().getTitle();
            } else if (this.isDialog()) {
                string = this.getDialog().getTitle();
            }
            return string;
        }

        protected boolean isFrame() {
            return this._window instanceof Frame;
        }

        protected Frame getFrame() {
            return (Frame)this._window;
        }

        protected boolean isDialog() {
            return this._window instanceof JDialog;
        }

        protected JDialog getDialog() {
            return (JDialog)this._window;
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            JRootPane jRootPane = SquarenessRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Window window = (Window)mouseEvent.getSource();
            if (window != null) {
                window.toFront();
            }
            Point point2 = SwingUtilities.convertPoint(window, point, SquarenessRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n2 = n = frame != null ? frame.getExtendedState() : 0;
            if (SquarenessRootPaneUI.this.getTitlePane() != null && SquarenessRootPaneUI.this.getTitlePane().contains(point2)) {
                if ((frame != null && (n & 6) == 0 || dialog != null) && point.y >= 5 && point.x >= 5 && point.x < window.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = point.x;
                    this.dragOffsetY = point.y;
                }
            } else if (frame != null && frame.isResizable() && (n & 6) == 0 || dialog != null && dialog.isResizable()) {
                this.dragOffsetX = point.x;
                this.dragOffsetY = point.y;
                this.dragWidth = window.getWidth();
                this.dragHeight = window.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(window, point.x, point.y));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragCursor != 0 && SquarenessRootPaneUI.this._window != null && !SquarenessRootPaneUI.this._window.isValid()) {
                SquarenessRootPaneUI.this._window.validate();
                SquarenessRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JRootPane jRootPane = SquarenessRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n = this.getCursor(this.calculateCorner(window, mouseEvent.getX(), mouseEvent.getY()));
            if (n != 0 && (frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0 || dialog != null && dialog.isResizable())) {
                window.setCursor(Cursor.getPredefinedCursor(n));
            } else {
                window.setCursor(SquarenessRootPaneUI.this._lastCursor);
            }
        }

        private void adjust(Rectangle rectangle, Dimension dimension, int n, int n2, int n3, int n4) {
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.width += n3;
            rectangle.height += n4;
            if (dimension != null) {
                int n5;
                if (rectangle.width < dimension.width) {
                    n5 = dimension.width - rectangle.width;
                    if (n != 0) {
                        rectangle.x -= n5;
                    }
                    rectangle.width = dimension.width;
                }
                if (rectangle.height < dimension.height) {
                    n5 = dimension.height - rectangle.height;
                    if (n2 != 0) {
                        rectangle.y -= n5;
                    }
                    rectangle.height = dimension.height;
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            if (this.isMovingWindow) {
                Point point2 = window.getLocationOnScreen();
                point2.x += point.x - this.dragOffsetX;
                point2.y += point.y - this.dragOffsetY;
                window.setLocation(point2);
            } else if (this.dragCursor != 0) {
                Rectangle rectangle = window.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                Dimension dimension = window.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(rectangle, dimension, 0, 0, 0, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 8: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, 0, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 6: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, point.y - this.dragOffsetY, -(point.x - this.dragOffsetX), -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                }
                if (!rectangle.equals(rectangle2)) {
                    window.setBounds(rectangle);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        window.validate();
                        SquarenessRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            SquarenessRootPaneUI.this._lastCursor = window.getCursor();
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            window.setCursor(SquarenessRootPaneUI.this._lastCursor);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            if (!(window instanceof Frame)) {
                return;
            }
            frame = (Frame)window;
            Point point = SwingUtilities.convertPoint(window, mouseEvent.getPoint(), SquarenessRootPaneUI.this.getTitlePane());
            int n = frame.getExtendedState();
            if (SquarenessRootPaneUI.this.getTitlePane() != null && SquarenessRootPaneUI.this.getTitlePane().contains(point) && mouseEvent.getClickCount() % 2 == 0 && (mouseEvent.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                if ((n & 6) != 0) {
                    frame.setExtendedState(n & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(n | 6);
                }
                return;
            }
        }

        private int calculateCorner(Component component, int n, int n2) {
            int n3 = this.calculatePosition(n, component.getWidth());
            int n4 = this.calculatePosition(n2, component.getHeight());
            if (n3 == -1 || n4 == -1) {
                return -1;
            }
            return n4 * 5 + n3;
        }

        private int getCursor(int n) {
            if (n == -1) {
                return 0;
            }
            return cursorMapping[n];
        }

        private int calculatePosition(int n, int n2) {
            if (n < 5) {
                return 0;
            }
            if (n < 16) {
                return 1;
            }
            if (n >= n2 - 5) {
                return 4;
            }
            if (n >= n2 - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getPreferredSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SquarenessRootPaneUI && (jComponent = ((SquarenessRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getPreferredSize()) != null) {
                n5 = dimension.width;
                n6 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n6 + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMinimumSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMinimumSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SquarenessRootPaneUI && (jComponent = ((SquarenessRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMinimumSize()) != null) {
                n5 = dimension.width;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n5 + insets.top + insets.bottom);
        }

        public Dimension maximumLayoutSize(Container container) {
            int n;
            int n2;
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            Dimension dimension3;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            if (jRootPane.getContentPane() != null && (dimension3 = jRootPane.getContentPane().getMaximumSize()) != null) {
                n3 = dimension3.width;
                n4 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMaximumSize()) != null) {
                n5 = dimension2.width;
                n6 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SquarenessRootPaneUI && (jComponent = ((SquarenessRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMaximumSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            if ((n2 = Math.max(Math.max(n4, n6), n8)) != Integer.MAX_VALUE) {
                n2 = n4 + n6 + n8 + insets.top + insets.bottom;
            }
            if ((n = Math.max(Math.max(n3, n5), n7)) != Integer.MAX_VALUE) {
                n += insets.left + insets.right;
            }
            return new Dimension(n, n2);
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SquarenessRootPaneUI && (serializable = ((SquarenessRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = ((JComponent)serializable).getPreferredSize()) != null) {
                int n4 = dimension.height;
                ((Component)serializable).setBounds(0, 0, n2, n4);
                n += n4;
            }
            if (jRootPane.getJMenuBar() != null) {
                serializable = jRootPane.getJMenuBar().getPreferredSize();
                jRootPane.getJMenuBar().setBounds(0, n, n2, ((Dimension)serializable).height);
                n += ((Dimension)serializable).height;
            }
            if (jRootPane.getContentPane() != null) {
                jRootPane.getContentPane().setBounds(0, n, n2, n3 < n ? 0 : n3 - n);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

