/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import net.sourceforge.mlf.metouia.MetouiaGradients;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;
import net.sourceforge.mlf.metouia.MetouiaScrollButton;
import net.sourceforge.mlf.metouia.borders.MetouiaBorderUtilities;
import net.sourceforge.mlf.metouia.borders.MetouiaDots;

public class MetouiaScrollBarUI
extends MetalScrollBarUI {
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected MetouiaDots dots;
    private boolean freeStanding = false;

    protected void installDefaults() {
        super.installDefaults();
        this.dots = new MetouiaDots(5, 5);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetouiaScrollBarUI();
    }

    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new MetouiaScrollButton(n, this.scrollBarWidth - 0, this.freeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new MetouiaScrollButton(n, this.scrollBarWidth, this.freeStanding);
        return this.increaseButton;
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Rectangle rectangle2;
        Rectangle rectangle3;
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.freeStanding) {
                if (!bl) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            this.dots.setDotsArea(rectangle.width - 6, rectangle.height - 7);
            this.dots.paintIcon(jComponent, graphics, 4, 4);
            if (!this.freeStanding) {
                if (!bl) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.freeStanding) {
                rectangle.height += 2;
            }
            graphics.setColor(thumbHighlightColor);
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            this.dots.setDotsArea(rectangle.width - 7, rectangle.height - 6);
            this.dots.paintIcon(jComponent, graphics, 4, 5);
            if (!this.freeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        Color color = MetouiaLookAndFeel.getGradientReflection();
        Color color2 = MetouiaLookAndFeel.getGradientTranslucentReflection();
        Color color3 = MetouiaLookAndFeel.getGradientShadow();
        Color color4 = MetouiaLookAndFeel.getGradientTranslucentShadow();
        if (this.scrollbar.getOrientation() == 1) {
            rectangle3 = new Rectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width / 2, rectangle.height - 2);
            rectangle2 = new Rectangle(rectangle.x + rectangle.width / 2, rectangle.y + 1, rectangle.width / 2 + 1, rectangle.height - 2);
        } else {
            rectangle3 = new Rectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height / 2);
            rectangle2 = new Rectangle(rectangle.x + 1, rectangle.y + rectangle.height / 2, rectangle.width - 2, rectangle.height / 2 + 1);
        }
        boolean bl2 = this.scrollbar.getOrientation() == 0;
        MetouiaGradients.drawGradient(graphics, color, color2, rectangle3, bl2, true);
        MetouiaGradients.drawGradient(graphics, color4, color3, rectangle2, bl2, false);
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbShadow = MetouiaLookAndFeel.getControlDarkShadow();
        thumbHighlightColor = MetouiaLookAndFeel.getMenuBackground();
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl = jComponent.getComponentOrientation().isLeftToRight();
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.freeStanding) {
                if (!bl) {
                    ++rectangle.width;
                    graphics.translate(-1, 0);
                } else {
                    rectangle.width += 2;
                }
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                graphics.drawLine(0, 0, 0, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 2, 0, rectangle.width - 2, rectangle.height - 1);
                graphics.drawLine(1, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(1, 0, rectangle.width - 1, 0);
                graphics.setColor(highlightColor);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
            } else {
                MetouiaBorderUtilities.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.freeStanding) {
                if (!bl) {
                    --rectangle.width;
                    graphics.translate(1, 0);
                } else {
                    rectangle.width -= 2;
                }
            }
        } else {
            if (!this.freeStanding) {
                rectangle.height += 2;
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                graphics.drawLine(0, 0, rectangle.width - 1, 0);
                graphics.drawLine(0, 1, 0, rectangle.height - 1);
                graphics.drawLine(0, rectangle.height - 2, rectangle.width - 1, rectangle.height - 2);
                graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
            } else {
                MetouiaBorderUtilities.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.freeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }
}

