/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class ArmenianCalendar
extends OldWorldCalendar {
    public static final int FIRST_JULIAN_DAY = ArmenianCalendar.date2jdn_julian(552, 7, 11);
    private static final long serialVersionUID = 1L;

    public ArmenianCalendar() {
        this(ArmenianCalendar.getToday());
    }

    public ArmenianCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public ArmenianCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public ArmenianCalendar(int n) {
        this.set(n);
    }

    public ArmenianCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public ArmenianCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("ArmenianCalendar jdn2date (int n)");
        }
        int n2 = n - FIRST_JULIAN_DAY;
        int n3 = n2 / 365;
        this.doy2date(n3 + 1, n2 - 365 * n3 + 1);
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return FIRST_JULIAN_DAY - 1 + 365 * (n - 1) + this.getCumulativeDays(n, n2 - 1) + n3;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (!this.isDate(n, n2)) {
            throw new IllegalArgumentException("doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = (n2 - 1) / 30 + 1;
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("ArmenianCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return n2 < 13 ? 30 * n2 : 365;
    }

    @Override
    public boolean isLeapYear(int n) {
        return false;
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return n2 < 13 ? 30 : 5;
    }

    @Override
    public int getLastMonthOfYear(int n) {
        return 13;
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

