/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class JalaliCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336, 365};
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336, 366};
    private static final int[] days_in_month_in_ordinary_year = new int[]{0, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29};
    private static final int[] days_in_month_in_leap_year = new int[]{0, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 30};
    private static final int D33 = 12053;
    public static final int FIRST_JULIAN_DAY = JalaliCalendar.date2jdn_julian(622, 3, 19);
    private int leap;
    private int Gy;
    private int March;
    private static final int[] breaks = new int[]{-61, 9, 38, 199, 426, 686, 756, 818, 1111, 1181, 1210, 1635, 2060, 2097, 2192, 2262, 2324, 2394, 2456, 3178};
    private static final long serialVersionUID = 1L;

    public JalaliCalendar() {
        this(JalaliCalendar.getToday());
    }

    public JalaliCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public JalaliCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public JalaliCalendar(int n) {
        this.set(n);
    }

    public JalaliCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public JalaliCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("JalaliCalendar jdn2date (int n)");
        }
        boolean bl = false;
        this.jdn2date_gregorian(n);
        this.year -= 621;
        this.JalCal(this.year);
        int n2 = JalaliCalendar.date2jdn_gregorian(this.year + 621, 3, this.March);
        int n3 = n - n2;
        if (n3 >= 0) {
            if (n3 <= 185) {
                this.month = 1 + n3 / 31;
                this.day = n3 % 31 + 1;
                bl = true;
            } else {
                n3 -= 186;
            }
        } else {
            --this.year;
            n3 += 179;
            if (this.leap == 1) {
                ++n3;
            }
        }
        if (!bl) {
            this.month = 7 + n3 / 30;
            this.day = n3 % 30 + 1;
        }
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("JalaliCalendar jdn2date year=" + this.year + " month=" + this.month + " day=" + this.day + " n=" + n);
        }
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        this.JalCal(n);
        return JalaliCalendar.date2jdn_gregorian(this.Gy, 3, this.March) + 31 * (n2 - 1) - n2 / 7 * (n2 - 7) + n3 - 1;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (n2 < 1 || n2 > this.getLengthOfYear(n)) {
            throw new IllegalArgumentException("JalaliCalendar doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = n2 <= cumulative_days_in_ordinary_year[6] ? (n2 - 1) / 31 + 1 : (n2 - cumulative_days_in_ordinary_year[6] - 1) / 30 + 7;
        this.day = n2 - this.getCumulativeDays(n, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("JalaliCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        if (n < 3178) {
            this.JalCal(n);
            return this.leap == 0;
        }
        switch (n % 33) {
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 26: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return this.isLeapYear(n) ? days_in_month_in_leap_year[n2] : days_in_month_in_ordinary_year[n2];
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }

    void JalCal(int n) {
        int n2;
        int n3;
        this.Gy = n + 621;
        int n4 = -14;
        int n5 = breaks[0];
        int n6 = 0;
        if (n < n5 || n >= breaks[breaks.length - 1]) {
            throw new IllegalArgumentException("Jy too big");
        }
        for (n3 = 1; n3 < breaks.length; ++n3) {
            n2 = breaks[n3];
            n6 = n2 - n5;
            if (n < n2) break;
            n4 += n6 / 33 * 8 + n6 % 33 / 4;
            n5 = n2;
        }
        n3 = n - n5;
        n4 += n3 / 33 * 8 + (n3 % 33 + 3) / 4;
        if (n6 % 33 == 4 && n6 - n3 == 4) {
            ++n4;
        }
        n2 = this.Gy / 4 - (this.Gy / 100 + 1) * 3 / 4 - 150;
        this.March = 20 + n4 - n2;
        if (n6 - n3 < 6) {
            n3 = n3 - n6 + (n6 + 4) / 33 * 33;
        }
        this.leap = ((n3 + 1) % 33 - 1) % 4;
        if (this.leap == -1) {
            this.leap = 4;
        }
    }
}

