/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.chinese;

import fi.joensuu.joyds1.calendar.chinese.MoonPhase;
import java.util.Locale;

public class Nutation {
    private double tjd_last = 0.0;
    private double t;
    private double longnutation;
    private double obliqnutation;
    private double mobl;
    private double tobl;
    private double eq;
    private double dpsi;
    private double deps;
    private static final double PSI_COR = 0.0;
    private static final double EPS_COR = 0.0;

    public final void nutate(double d, int n, double[] dArray, double[] dArray2) {
        this.earthtilt(d);
        double d2 = Math.cos(this.mobl * (Math.PI / 180));
        double d3 = Math.sin(this.mobl * (Math.PI / 180));
        double d4 = Math.cos(this.tobl * (Math.PI / 180));
        double d5 = Math.sin(this.tobl * (Math.PI / 180));
        double d6 = Math.cos(this.dpsi / 206264.80624709636);
        double d7 = Math.sin(this.dpsi / 206264.80624709636);
        double d8 = d6;
        double d9 = -d7 * d2;
        double d10 = -d7 * d3;
        double d11 = d7 * d4;
        double d12 = d6 * d2 * d4 + d3 * d5;
        double d13 = d6 * d3 * d4 - d2 * d5;
        double d14 = d7 * d5;
        double d15 = d6 * d2 * d5 - d3 * d4;
        double d16 = d6 * d3 * d5 + d2 * d4;
        if (n == 0) {
            dArray2[0] = d8 * dArray[0] + d9 * dArray[1] + d10 * dArray[2];
            dArray2[1] = d11 * dArray[0] + d12 * dArray[1] + d13 * dArray[2];
            dArray2[2] = d14 * dArray[0] + d15 * dArray[1] + d16 * dArray[2];
        } else {
            dArray2[0] = d8 * dArray[0] + d11 * dArray[1] + d14 * dArray[2];
            dArray2[1] = d9 * dArray[0] + d12 * dArray[1] + d15 * dArray[2];
            dArray2[2] = d10 * dArray[0] + d13 * dArray[1] + d16 * dArray[2];
        }
    }

    private final void earthtilt(double d) {
        double[] dArray = new double[5];
        this.t = (d - 2451545.0) / 36525.0;
        if (Math.abs(d - this.tjd_last) > 1.0E-6) {
            this.nutation_angles(this.t);
        }
        double d2 = this.longnutation + 0.0;
        double d3 = this.obliqnutation + 0.0;
        double d4 = 84381.448 - 46.815 * this.t - 5.9E-4 * Math.pow(this.t, 2.0) + 0.001813 * Math.pow(this.t, 3.0);
        double d5 = d4 + d3;
        d5 /= 3600.0;
        Nutation.fund_args(this.t, dArray);
        double d6 = d2 * Math.cos((d4 /= 3600.0) * (Math.PI / 180)) + (0.00264 * Math.sin(dArray[4]) + 6.3E-5 * Math.sin(2.0 * dArray[4]));
        this.tjd_last = d;
        this.dpsi = d2;
        this.deps = d3;
        this.eq = d6 /= 15.0;
        this.mobl = d4;
        this.tobl = d5;
    }

    private final void nutation_angles(double d) {
        int n;
        int n2;
        int n3;
        double[] dArray = new double[]{1.0, 1.0, -1.0, -1.0, 1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, -1.0, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, -2.0, 2.0, 2.0, 2.0, 3.0, -3.0, -3.0, 3.0, -3.0, 3.0, -3.0, 3.0, 4.0, 4.0, -4.0, -4.0, 4.0, -4.0, 5.0, 5.0, 5.0, -5.0, 6.0, 6.0, 6.0, -6.0, 6.0, -7.0, 7.0, 7.0, -7.0, -8.0, 10.0, 11.0, 12.0, -13.0, -15.0, -16.0, -16.0, 17.0, -21.0, -22.0, 26.0, 29.0, 29.0, -31.0, -38.0, -46.0, 48.0, -51.0, 58.0, 59.0, 63.0, 63.0, -123.0, 129.0, -158.0, -217.0, -301.0, -386.0, -517.0, 712.0, 1426.0, 2062.0, -2274.0, -13187.0, -171996.0};
        double[] dArray2 = new double[]{0.1, -0.1, 0.1, 0.1, 0.1, 0.1, 0.2, -0.2, -0.4, 0.5, 1.2, -1.6, -3.4, -174.2};
        double[] dArray3 = new double[]{1.0, 1.0, 1.0, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, -1.0, -1.0, 1.0, -1.0, 1.0, 1.0, -1.0, -2.0, -2.0, -2.0, 3.0, 3.0, -3.0, 3.0, 3.0, -3.0, 3.0, 3.0, -3.0, 3.0, 3.0, 5.0, 6.0, 7.0, -7.0, 7.0, -8.0, 9.0, -10.0, -12.0, 13.0, 16.0, -24.0, 26.0, 27.0, 32.0, -33.0, -53.0, 54.0, -70.0, -95.0, 129.0, 200.0, 224.0, -895.0, 977.0, 5736.0, 92025.0};
        double[] dArray4 = new double[]{-0.1, -0.1, 0.3, 0.5, -0.5, -0.6, -3.1, 8.9};
        int[] nArray = new int[]{0, 0, 1, 0, 2, 1, 3, 0, 4, 0};
        int[] nArray2 = new int[]{0, 0, 0, 5, 1, 1, 3, 3, 4, 4};
        int[] nArray3 = new int[]{2, 0, 1, 1, 5, 2, 2, 0, 2, 1, 0, 3, 2, 5, 8, 1, 17, 8, 1, 18, 0, 2, 0, 8, 0, 1, 3, 2, 1, 8, 0, 17, 1, 1, 15, 1, 2, 21, 1, 1, 2, 8, 2, 0, 29, 1, 21, 2, 2, 1, 29, 2, 0, 9, 2, 5, 4, 2, 0, 4, 0, 1, 9, 2, 1, 4, 0, 2, 9, 2, 2, 4, 1, 14, 44, 2, 0, 45, 2, 5, 44, 2, 50, 0, 1, 36, 2, 2, 5, 45, 1, 37, 2, 2, 1, 45, 2, 1, 44, 2, 53, 1, 2, 8, 4, 1, 40, 3, 2, 17, 4, 2, 0, 64, 1, 39, 8, 2, 27, 4, 1, 50, 18, 1, 21, 47, 2, 44, 3, 2, 44, 8, 2, 45, 8, 1, 46, 8, 0, 67, 2, 1, 5, 74, 1, 0, 74, 2, 50, 8, 1, 5, 78, 2, 17, 53, 2, 53, 8, 2, 0, 80, 2, 0, 81, 0, 7, 79, 1, 7, 81, 2, 1, 81, 2, 24, 44, 1, 1, 79, 2, 27, 44};
        int[] nArray4 = new int[]{57, 25, 82, 34, 41, 66, 33, 36, 19, 88, 18, 104, 93, 84, 47, 28, 83, 86, 69, 75, 89, 30, 58, 73, 46, 77, 23, 32, 59, 72, 31, 16, 74, 22, 98, 38, 62, 96, 37, 35, 6, 76, 85, 51, 26, 10, 13, 63, 105, 52, 102, 67, 99, 15, 24, 14, 3, 100, 65, 11, 55, 68, 20, 87, 64, 95, 27, 60, 61, 80, 91, 94, 12, 43, 71, 42, 97, 70, 7, 49, 29, 2, 5, 92, 50, 78, 56, 17, 48, 40, 90, 8, 39, 54, 81, 21, 103, 53, 45, 101, 0, 1, 9, 44, 79, 4};
        int[] nArray5 = new int[]{81, 7, 97, 0, 39, 40, 9, 44, 45, 103, 101, 79, 1, 4};
        int[] nArray6 = new int[]{51, 98, 17, 21, 5, 2, 63, 105, 38, 52, 102, 62, 96, 37, 35, 76, 36, 88, 85, 104, 93, 84, 83, 67, 99, 8, 68, 100, 60, 61, 91, 87, 64, 80, 95, 65, 55, 94, 43, 97, 0, 71, 70, 42, 49, 92, 50, 78, 56, 90, 48, 40, 39, 54, 1, 81, 103, 53, 45, 101, 9, 44, 79, 4};
        int[] nArray7 = new int[]{53, 1, 103, 9, 44, 101, 79, 4};
        double[] dArray5 = new double[5];
        double[] dArray6 = new double[106];
        double[] dArray7 = new double[106];
        Nutation.fund_args(d, dArray5);
        int n4 = 0;
        for (n3 = 0; n3 < 10; n3 += 2) {
            double d2 = dArray5[nArray[n3]] * (double)(nArray[1 + n3] + 1);
            dArray6[n4] = Math.cos(d2);
            dArray7[n4] = Math.sin(d2);
            ++n4;
        }
        n4 = 5;
        for (n3 = 0; n3 < 10; n3 += 2) {
            n2 = nArray2[n3];
            n = nArray2[1 + n3];
            dArray6[n4] = dArray6[n2] * dArray6[n] - dArray7[n2] * dArray7[n];
            dArray7[n4] = dArray7[n2] * dArray6[n] + dArray6[n2] * dArray7[n];
            ++n4;
        }
        n4 = 10;
        for (n3 = 0; n3 < 183; n3 += 3) {
            int n5 = nArray3[n3];
            n2 = nArray3[1 + n3];
            n = nArray3[2 + n3];
            switch (n5) {
                case 0: {
                    dArray6[n4] = dArray6[n2] * dArray6[n] - dArray7[n2] * dArray7[n];
                    dArray7[n4] = dArray7[n2] * dArray6[n] + dArray6[n2] * dArray7[n];
                    ++n4;
                    break;
                }
                case 1: {
                    dArray6[n4] = dArray6[n2] * dArray6[n] + dArray7[n2] * dArray7[n];
                    dArray7[n4] = dArray7[n2] * dArray6[n] - dArray6[n2] * dArray7[n];
                    ++n4;
                    break;
                }
                case 2: {
                    double d3 = dArray6[n2] * dArray6[n];
                    double d4 = dArray7[n2] * dArray7[n];
                    double d5 = dArray7[n2] * dArray6[n];
                    double d6 = dArray6[n2] * dArray7[n];
                    dArray6[n4] = d3 - d4;
                    dArray7[n4] = d5 + d6;
                    dArray6[++n4] = d3 + d4;
                    dArray7[n4] = d5 - d6;
                    ++n4;
                }
            }
            if (n5 == 3) break;
        }
        double d7 = 0.0;
        for (n4 = 0; n4 < 106; ++n4) {
            d7 += dArray[n4] * dArray7[nArray4[n4]];
        }
        double d8 = 0.0;
        for (n4 = 0; n4 < 14; ++n4) {
            d8 += dArray2[n4] * dArray7[nArray5[n4]];
        }
        double d9 = 0.0;
        for (n4 = 0; n4 < 64; ++n4) {
            d9 += dArray3[n4] * dArray6[nArray6[n4]];
        }
        double d10 = 0.0;
        for (n4 = 0; n4 < 8; ++n4) {
            d10 += dArray4[n4] * dArray6[nArray7[n4]];
        }
        this.longnutation = (d7 + d * d8) / 10000.0;
        this.obliqnutation = (d9 + d * d10) / 10000.0;
    }

    private static void fund_args(double d, double[] dArray) {
        dArray[0] = 2.3555483935439407 + d * (8328.691422883896 + d * (1.517951635553957E-4 + 3.1028075591010306E-7 * d));
        dArray[1] = 6.240035939326023 + d * (628.3019560241842 + d * (-2.7973749400020225E-6 - 5.817764173314431E-8 * d));
        dArray[2] = 1.6279019339719611 + d * (8433.466158318453 + d * (-6.427174970469119E-5 + 5.332950492204896E-8 * d));
        dArray[3] = 5.198469513579922 + d * (7771.377146170642 + d * (-3.340851076525812E-5 + 9.211459941081184E-8 * d));
        dArray[4] = 2.1824386243609943 + d * (-33.75704593375351 + d * (3.614285992671591E-5 + 3.878509448876288E-8 * d));
        for (int i = 0; i < 5; ++i) {
            dArray[i] = MoonPhase.fmod(dArray[i], Math.PI * 2);
            if (!(dArray[i] < 0.0)) continue;
            int n = i;
            dArray[n] = dArray[n] + Math.PI * 2;
        }
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.UK);
        Nutation nutation = new Nutation();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[2] = 1.0;
        dArray[1] = 1.0;
        dArray[0] = 1.0;
        for (int i = 0; i < 3000000; ++i) {
            System.out.print(String.format(" %7d", i));
            nutation.nutate(i, 0, dArray, dArray2);
            for (int j = 0; j < 3; ++j) {
                System.out.print(String.format(" %10d %10d", (int)(10000.0 * dArray[j]), (int)(10000.0 * dArray2[j])));
            }
            System.out.println("");
        }
    }
}

