/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.chinese;

import fi.joensuu.joyds1.calendar.chinese.MoonPhase;
import fi.joensuu.joyds1.calendar.chinese.Novas;
import fi.joensuu.joyds1.calendar.chinese.Nutation;
import fi.joensuu.joyds1.calendar.chinese.SolarSystem;

public final class SolarTerm {
    private static final int FN0 = 0;
    private static final double C = 173.14463348;
    private static int HELIOC = 1;
    private static int BARYC = 0;
    private static final Nutation n = new Nutation();
    private static final SolarSystem s = new SolarSystem();

    public static final double solarterm(int n, double[] dArray) {
        double d = n < 1928 ? 0.32337962962962963 : 0.3333333333333333;
        int n2 = (int)Novas.julian_date(n - 1, 12, 18, 12.0);
        int n3 = (int)Novas.julian_date(n - 1, 12, 25, 12.0);
        double d2 = SolarTerm.termtime(n2, n3, 0.0) + d;
        for (int i = 0; i < 24; ++i) {
            int n4 = i / 2 + 1;
            int n5 = i % 2 * 14;
            n2 = (int)Novas.julian_date(n, n4, 1 + n5, 12.0);
            n3 = (int)Novas.julian_date(n, n4, 10 + n5, 12.0);
            double d3 = (double)(i + 1) * 15.0;
            dArray[i] = SolarTerm.termtime(n2, n3, d3) + d;
        }
        return d2;
    }

    private static final double termtime(double d, double d2, double d3) {
        double d4 = 3.4722222222222224E-4;
        double d5 = (Math.sqrt(5.0) - 1.0) / 2.0;
        double d6 = Math.abs(SolarTerm.timeangle(d) - d3);
        double d7 = Math.abs(SolarTerm.timeangle(d2) - d3);
        double d8 = d5 * (d2 - d);
        double d9 = d2 - d8;
        double d10 = d + d8;
        double d11 = Math.abs(SolarTerm.timeangle(d9) - d3);
        double d12 = Math.abs(SolarTerm.timeangle(d10) - d3);
        while (d2 - d > d4) {
            if (d11 < d12 && d11 < d6 && d11 < d7 || d6 < d12 && d6 < d11 && d6 < d7) {
                d2 = d10;
                d7 = d12;
                d10 = d9;
                d12 = d11;
                d8 = d5 * (d2 - d);
                d9 = d2 - d8;
                d11 = Math.abs(SolarTerm.timeangle(d9) - d3);
                continue;
            }
            d = d9;
            d6 = d11;
            d9 = d10;
            d11 = d12;
            d8 = d5 * (d2 - d);
            d10 = d + d8;
            d12 = Math.abs(SolarTerm.timeangle(d10) - d3);
        }
        return (d + d2) / 2.0;
    }

    private static final double timeangle(double d) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double d2 = SolarTerm.tdb2tdt(d);
        double d3 = d + d2 / 86400.0;
        s.solarsystem(d3, 3, HELIOC, dArray5, dArray6);
        s.solarsystem(d3, 3, BARYC, dArray3, dArray4);
        dArray2[0] = -dArray5[0];
        dArray2[1] = -dArray5[1];
        dArray2[2] = -dArray5[2];
        double d4 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]) / 173.14463348;
        SolarTerm.aberration(dArray2, dArray4, d4, dArray);
        Novas.precession(2451545.0, dArray, d3, dArray2);
        n.nutate(d3, 0, dArray2, dArray);
        double d5 = Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d6 = Math.atan2(d5 *= dArray[1] > 0.0 ? 1.0 : -1.0, dArray[0]) + 1.5707963267948966;
        if (d6 < 0.0) {
            d6 += Math.PI * 2;
        }
        return d6 *= 57.29577951308232;
    }

    private static double tdb2tdt(double d) {
        double d2 = 0.01671022;
        double d3 = 1296000.0;
        double d4 = d - 2451545.0;
        double d5 = (357.51716 + 0.985599987 * d4) * 3600.0;
        double d6 = (280.46435 + 0.9856091 * d4) * 3600.0;
        double d7 = (34.40438 + 0.083086762 * d4) * 3600.0;
        d5 = MoonPhase.fmod(d5, d3) / 206264.80624709636;
        d6 = MoonPhase.fmod(d6, d3) / 206264.80624709636;
        d7 = MoonPhase.fmod(d7, d3) / 206264.80624709636;
        double d8 = d5 + d2 * Math.sin(d5) + 0.5 * d2 * d2 * Math.sin(2.0 * d5);
        double d9 = 0.001658 * Math.sin(d8) + 2.073E-5 * Math.sin(d6 - d7);
        return d9;
    }

    private static final void aberration(double[] dArray, double[] dArray2, double d, double[] dArray3) {
        double d2;
        if (d == 0.0) {
            d2 = Math.sqrt(Math.pow(dArray[0], 2.0) + Math.pow(dArray[1], 2.0) + Math.pow(dArray[2], 2.0));
            d = d2 / 173.14463348;
        } else {
            d2 = d * 173.14463348;
        }
        double d3 = Math.sqrt(Math.pow(dArray2[0], 2.0) + Math.pow(dArray2[1], 2.0) + Math.pow(dArray2[2], 2.0));
        double d4 = d3 / 173.14463348;
        double d5 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        double d6 = d5 / (d2 * d3);
        double d7 = Math.sqrt(1.0 - Math.pow(d4, 2.0));
        double d8 = d4 * d6;
        double d9 = (1.0 + d8 / (1.0 + d7)) * d;
        double d10 = 1.0 + d8;
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = (d7 * dArray[i] + d9 * dArray2[i]) / d10;
        }
    }
}

