/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.format;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.Resources;
import fi.joensuu.joyds1.calendar.format.SimpleDateFormat;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class DateFormat {
    public static final int SHORT = 0;
    public static final int MEDIUM = 1;
    public static final int LONG = 2;
    public static final int FULL = 3;

    public abstract String format(Calendar var1);

    public Calendar parse(String string, Calendar calendar) {
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar2 = this.parse(string, calendar, parsePosition);
        if (calendar2 == null) {
            int n = parsePosition.getErrorIndex();
            if (n < 0) {
                n = parsePosition.getIndex();
            }
            throw new IllegalArgumentException(Resources.getString("format.no.date", string));
        }
        return calendar2;
    }

    public abstract Calendar parse(String var1, Calendar var2, ParsePosition var3);

    public static final DateFormat getInstance(int n, Calendar calendar, Locale locale) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                String[] stringArray = Resources.getDateFormats(calendar, locale);
                return new SimpleDateFormat(stringArray[n], calendar, locale);
            }
        }
        throw new IllegalArgumentException("Style");
    }

    public static final DateFormat getInstance(int n, Calendar calendar) {
        return DateFormat.getInstance(n, calendar, Locale.getDefault());
    }

    public static final DateFormat getInstance(int n, Locale locale) {
        return DateFormat.getInstance(n, Calendar.getInstance(locale), locale);
    }

    public static final DateFormat getInstance(int n) {
        return DateFormat.getInstance(n, Locale.getDefault());
    }

    public static final DateFormat getInstance() {
        return DateFormat.getInstance(0, Locale.getDefault());
    }
}

