/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.format;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.Resources;
import java.util.Locale;
import java.util.MissingResourceException;

public class DateFormatSymbols {
    private String[] monthNamesForLeapYears;
    private String[] monthNamesForNonLeapYears;
    private String[] shortMonthNamesForLeapYears;
    private String[] shortMonthNamesForNonLeapYears;
    private String[] weekdayNames;
    private String[] shortWeekdayNames;
    private String[] tiangan;
    private String[] dizhi;
    private String[] haabMonthName;
    private String[] tzolkinMonthName;
    private Locale locale;
    private Calendar calendar;
    private java.text.DateFormatSymbols f;

    public DateFormatSymbols() {
        this(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale) {
        this(Calendar.getInstance(locale), locale);
    }

    public DateFormatSymbols(Calendar calendar) {
        this(calendar, Locale.getDefault());
    }

    public DateFormatSymbols(Calendar calendar, Locale locale) {
        this.calendar = calendar;
        this.locale = locale;
        this.f = new java.text.DateFormatSymbols(locale);
        this.setNames();
    }

    public String getMonthName(boolean bl, int n) {
        return bl ? this.monthNamesForLeapYears[n - 1] : this.monthNamesForNonLeapYears[n - 1];
    }

    public String getShortMonthName(boolean bl, int n) {
        return bl ? this.shortMonthNamesForLeapYears[n - 1] : this.shortMonthNamesForNonLeapYears[n - 1];
    }

    public String getWeekdayName(int n) {
        return this.weekdayNames[n - 1];
    }

    public String getShortWeekdayName(int n) {
        return this.shortWeekdayNames[n - 1];
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getHaabMonthName(int n) {
        return this.haabMonthName[n - 1];
    }

    public String getTzolkinMonthName(int n) {
        return this.tzolkinMonthName[n - 1];
    }

    public String[] getMonthNamesForLeapYears() {
        return this.monthNamesForLeapYears;
    }

    public String[] getMonthNamesForNonLeapYears() {
        return this.monthNamesForNonLeapYears;
    }

    public String[] getWeekdayNames() {
        return this.weekdayNames;
    }

    public String[] getShortWeekdayNames() {
        return this.shortWeekdayNames;
    }

    public String getYearName(int n) {
        if (this.calendar.getClass().getName().indexOf("ChineseCalendar") >= 0) {
            return this.tiangan[(n + 59) % 10] + this.dizhi[(n + 59) % 12];
        }
        return String.valueOf(n);
    }

    private void setWeekdayNames(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            this.weekdayNames = new String[7];
            this.weekdayNames[0] = stringArray2[2];
            this.weekdayNames[1] = stringArray2[3];
            this.weekdayNames[2] = stringArray2[4];
            this.weekdayNames[3] = stringArray2[5];
            this.weekdayNames[4] = stringArray2[6];
            this.weekdayNames[5] = stringArray2[7];
            this.weekdayNames[6] = stringArray2[1];
        } else {
            this.weekdayNames = stringArray;
        }
    }

    private void setShortWeekdayNames(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            this.shortWeekdayNames = new String[7];
            this.shortWeekdayNames[0] = stringArray2[2];
            this.shortWeekdayNames[1] = stringArray2[3];
            this.shortWeekdayNames[2] = stringArray2[4];
            this.shortWeekdayNames[3] = stringArray2[5];
            this.shortWeekdayNames[4] = stringArray2[6];
            this.shortWeekdayNames[5] = stringArray2[7];
            this.shortWeekdayNames[6] = stringArray2[1];
        } else {
            this.shortWeekdayNames = stringArray;
        }
    }

    private void setNames() {
        String string = this.calendar.getClass().getName();
        if ((string = string.substring(string.lastIndexOf(46) + 1)).equals("ChineseCalendar")) {
            this.tiangan = this.getNames("ChineseCalendar", "Tiangan");
            this.dizhi = this.getNames("ChineseCalendar", "Dizhi");
        } else if (string.equals("MayanCalendar")) {
            this.haabMonthName = this.getNames("MayanCalendar", "HaabMonthName");
            this.tzolkinMonthName = this.getNames("MayanCalendar", "TzolkinMonthName");
        } else {
            this.monthNamesForLeapYears = this.getNames(string, "LeapMonthNames");
            this.monthNamesForNonLeapYears = this.getNames(string, "MonthNames");
            this.shortMonthNamesForLeapYears = this.getNames(string, "LeapMonthAbbreviations");
            this.shortMonthNamesForNonLeapYears = this.getNames(string, "MonthAbbreviations");
            this.weekdayNames = this.getNames(string, "DayNames");
            this.shortWeekdayNames = this.getNames(string, "DayAbbreviations");
        }
    }

    private final String[] getNames(String string, String string2) {
        try {
            return Resources.getDelimitedStringArray(string + string2, ",", this.locale);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2.equals("MonthNames")) {
                return this.f.getMonths();
            }
            if (string2.equals("MonthAbbreviations")) {
                return this.f.getShortMonths();
            }
            if (string2.equals("DayNames")) {
                return this.getDays(this.f.getWeekdays());
            }
            if (string2.equals("DayAbbreviations")) {
                return this.getDays(this.f.getShortWeekdays());
            }
            if (string2.equals("LeapMonthNames")) {
                return this.getNames(string, "MonthNames");
            }
            if (string2.equals("LeapMonthAbbreviations")) {
                return this.getNames(string, "MonthAbbreviations");
            }
            throw new IllegalArgumentException("");
        }
    }

    private final String[] getDays(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = stringArray[2];
        stringArray2[1] = stringArray[3];
        stringArray2[2] = stringArray[4];
        stringArray2[3] = stringArray[5];
        stringArray2[4] = stringArray[6];
        stringArray2[5] = stringArray[7];
        stringArray2[6] = stringArray[1];
        return stringArray2;
    }
}

