/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.format;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.FinnishCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormatSymbols;
import fi.joensuu.joyds1.calendar.format.DateParserException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class DateParser {
    private final Calendar calendar;
    private final Scanner scanner;
    private final What what;
    private final Pattern[] pattern;
    private final int[] group = new int[3];
    public static final Pattern DOT = Pattern.compile("(\\d+)[.](\\d+)[.](\\d+)");
    public static final Pattern SLASH = Pattern.compile("(\\d+)[/](\\d+)[/](\\d+)");
    public static final Pattern DASH = Pattern.compile("(\\d+)[-](\\d+)[-](\\d+)");
    public static final Pattern ISO = Pattern.compile("(\\d{4})[-](\\d{2})[-](\\d{2})");
    public static final Pattern ISO_SHORT = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})");
    public static final Pattern MAYAN = Pattern.compile("(\\d+)[.](\\d+)[.](\\d+)[.](\\d+)[.](\\d+)");
    public static final Pattern DIGITS = Pattern.compile("\\d+");

    public DateParser(Calendar calendar, Scanner scanner, Pattern pattern, What what) {
        this.calendar = (Calendar)calendar.clone();
        this.scanner = scanner;
        this.pattern = new Pattern[1];
        this.pattern[0] = pattern;
        this.what = this.pattern[0].equals(ISO) || this.pattern[0].equals(ISO_SHORT) ? What.YMD : what;
    }

    public DateParser(Calendar calendar, Scanner scanner, Pattern pattern, Pattern pattern2, Pattern pattern3, int n, int n2, int n3, What what) {
        this.calendar = (Calendar)calendar.clone();
        this.scanner = scanner;
        this.what = what;
        this.pattern = new Pattern[3];
        this.pattern[0] = pattern;
        this.pattern[1] = pattern2;
        this.pattern[2] = pattern3;
        this.group[0] = n;
        this.group[1] = n2;
        this.group[2] = n3;
    }

    public final Calendar parse() throws DateParserException {
        if (!this.scanner.hasNext()) {
            return null;
        }
        switch (this.pattern.length) {
            case 1: {
                return this.parse1();
            }
            case 3: {
                return this.parse3();
            }
        }
        throw new RuntimeException("Number of patterns is not 1 or 3.");
    }

    public final Scanner getScanner() {
        return this.scanner;
    }

    public static final DateParser createFinnishDateParser(Scanner scanner) {
        Locale locale = new Locale("fi", "FI");
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = dateFormatSymbols.getMonthNamesForNonLeapYears();
        Pattern pattern = Pattern.compile(DateParser.createPatternString(stringArray, "ta"), 66);
        Pattern pattern2 = Pattern.compile("(\\d+)[.]");
        return new DateParser(new FinnishCalendar(), scanner, DIGITS, pattern, pattern2, 0, -1, 1, What.DMY);
    }

    public static final DateParser createEuropeanDateParser(Calendar calendar, Scanner scanner, Locale locale) {
        return DateParser.createEuropeanDateParser(calendar, scanner, locale, What.DMY);
    }

    public static final DateParser createEuropeanDateParser(Calendar calendar, Scanner scanner, Locale locale, What what) {
        Pattern pattern = DateParser.createMonthPattern(calendar, locale);
        return new DateParser(calendar, scanner, DIGITS, pattern, DIGITS, 0, -1, 0, what);
    }

    public static final DateParser createUSDateParser(Calendar calendar, Scanner scanner) {
        Pattern pattern = DateParser.createMonthPattern(calendar, Locale.US);
        Pattern pattern2 = Pattern.compile("(\\d+)[,]");
        return new DateParser(calendar, scanner, DIGITS, pattern, pattern2, 0, -1, 1, What.MDY);
    }

    public static final DateParser createUSDateParser(Calendar calendar, Scanner scanner, Locale locale) {
        Pattern pattern = DateParser.createMonthPattern(calendar, locale);
        Pattern pattern2 = Pattern.compile("(\\d+)[,]");
        return new DateParser(calendar, scanner, DIGITS, pattern, pattern2, 0, -1, 1, What.MDY);
    }

    public static final Pattern createMonthPattern(Calendar calendar, Locale locale) {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(calendar, locale);
        String[] stringArray = dateFormatSymbols.getMonthNamesForNonLeapYears();
        return Pattern.compile(DateParser.createPatternString(stringArray), 66);
    }

    private final Calendar parse1() throws DateParserException {
        String[] stringArray = new String[1];
        try {
            stringArray[0] = this.scanner.next(this.pattern[0]);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DateParserException("parse1", new String[]{""});
        }
        MatchResult matchResult = this.scanner.match();
        if (this.pattern[0].equals(MAYAN)) {
            this.calendar.set(Integer.parseInt(matchResult.group(1)), Integer.parseInt(matchResult.group(2)), Integer.parseInt(matchResult.group(3)), Integer.parseInt(matchResult.group(4)), Integer.parseInt(matchResult.group(5)));
        } else {
            switch (this.what) {
                case YMD: {
                    this.calendar.set(Integer.parseInt(matchResult.group(1)), Integer.parseInt(matchResult.group(2)), Integer.parseInt(matchResult.group(3)));
                    break;
                }
                case YDM: {
                    this.calendar.set(Integer.parseInt(matchResult.group(1)), Integer.parseInt(matchResult.group(3)), Integer.parseInt(matchResult.group(2)));
                    break;
                }
                case MYD: {
                    this.calendar.set(Integer.parseInt(matchResult.group(2)), Integer.parseInt(matchResult.group(1)), Integer.parseInt(matchResult.group(3)));
                    break;
                }
                case MDY: {
                    this.calendar.set(Integer.parseInt(matchResult.group(3)), Integer.parseInt(matchResult.group(1)), Integer.parseInt(matchResult.group(2)));
                    break;
                }
                case DYM: {
                    this.calendar.set(Integer.parseInt(matchResult.group(2)), Integer.parseInt(matchResult.group(3)), Integer.parseInt(matchResult.group(1)));
                    break;
                }
                case DMY: {
                    this.calendar.set(Integer.parseInt(matchResult.group(3)), Integer.parseInt(matchResult.group(2)), Integer.parseInt(matchResult.group(1)));
                }
            }
        }
        return this.calendar;
    }

    private final Calendar parse3() throws DateParserException {
        switch (this.what) {
            case YMD: {
                MatchResult[] matchResultArray = this.scan3(this.pattern[0], this.pattern[1], this.pattern[2]);
                this.set(matchResultArray[0], matchResultArray[1], matchResultArray[2]);
                break;
            }
            case YDM: {
                MatchResult[] matchResultArray = this.scan3(this.pattern[0], this.pattern[2], this.pattern[1]);
                this.set(matchResultArray[0], matchResultArray[2], matchResultArray[1]);
                break;
            }
            case MYD: {
                MatchResult[] matchResultArray = this.scan3(this.pattern[1], this.pattern[0], this.pattern[2]);
                this.set(matchResultArray[1], matchResultArray[0], matchResultArray[2]);
                break;
            }
            case MDY: {
                MatchResult[] matchResultArray = this.scan3(this.pattern[1], this.pattern[2], this.pattern[0]);
                this.set(matchResultArray[2], matchResultArray[0], matchResultArray[1]);
                break;
            }
            case DYM: {
                MatchResult[] matchResultArray = this.scan3(this.pattern[2], this.pattern[0], this.pattern[1]);
                this.set(matchResultArray[1], matchResultArray[2], matchResultArray[0]);
                break;
            }
            case DMY: {
                MatchResult[] matchResultArray = this.scan3(this.pattern[2], this.pattern[1], this.pattern[0]);
                this.set(matchResultArray[2], matchResultArray[1], matchResultArray[0]);
            }
        }
        return this.calendar;
    }

    private final MatchResult[] scan3(Pattern pattern, Pattern pattern2, Pattern pattern3) throws DateParserException {
        String[] stringArray = new String[3];
        MatchResult[] matchResultArray = new MatchResult[3];
        try {
            stringArray[0] = this.scanner.next(pattern);
            matchResultArray[0] = this.scanner.match();
            stringArray[1] = this.scanner.next(pattern2);
            matchResultArray[1] = this.scanner.match();
            stringArray[2] = this.scanner.next(pattern3);
            matchResultArray[2] = this.scanner.match();
            return matchResultArray;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DateParserException("scan3", stringArray);
        }
    }

    private final void set(MatchResult matchResult, MatchResult matchResult2, MatchResult matchResult3) {
        int n = -1;
        if (this.group[1] >= 0) {
            n = Integer.parseInt(matchResult2.group(this.group[1]));
        } else {
            for (int i = 1; i <= matchResult2.groupCount(); ++i) {
                if (matchResult2.group(i) == null) continue;
                n = i;
                break;
            }
        }
        this.calendar.set(Integer.parseInt(matchResult.group(this.group[0])), n, Integer.parseInt(matchResult3.group(this.group[2])));
    }

    private static final String createPatternString(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            if (i > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append("(");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static final String createPatternString(String[] stringArray) {
        return DateParser.createPatternString(stringArray, "");
    }

    public static enum What {
        YMD,
        YDM,
        MYD,
        MDY,
        DYM,
        DMY;

    }
}

