/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.jcalendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.CalendarMath;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormatSymbols;
import fi.joensuu.joyds1.calendar.jcalendar.JDayChooser;
import fi.joensuu.joyds1.calendar.jcalendar.JMonthChooser;
import fi.joensuu.joyds1.calendar.jcalendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JCalendarPanel
extends JPanel
implements PropertyChangeListener {
    protected JYearChooser yearChooser = null;
    protected JMonthChooser monthChooser = null;
    protected JDayChooser dayChooser = null;
    private Calendar calendar;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;
    private static final long serialVersionUID = 1L;

    public JCalendarPanel() {
        this(new GregorianCalendar(), new DateFormatSymbols(), 0);
    }

    public JCalendarPanel(int n) {
        this(new GregorianCalendar(), new DateFormatSymbols(), n);
    }

    public JCalendarPanel(Calendar calendar, DateFormatSymbols dateFormatSymbols) {
        this(calendar, dateFormatSymbols, 0);
    }

    public JCalendarPanel(Calendar calendar) {
        this(calendar, new DateFormatSymbols(calendar), 0);
    }

    public JCalendarPanel(Calendar calendar, DateFormatSymbols dateFormatSymbols, int n) {
        this.calendar = calendar;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        this.monthChooser = new JMonthChooser(this.calendar, dateFormatSymbols, n);
        this.yearChooser = new JYearChooser(this.calendar.getYear(), this.calendar.getFirstYear(), this.calendar.getYear() + 1000, 1);
        this.monthChooser.setYearChooser(this.yearChooser);
        jPanel.add(this.monthChooser);
        jPanel.add(this.yearChooser);
        this.dayChooser = new JDayChooser(this.calendar, dateFormatSymbols);
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener(this);
        this.add((Component)jPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        this.initialized = true;
    }

    private void setCalendar(Calendar calendar, boolean bl) {
        Calendar calendar2 = this.calendar;
        this.calendar = calendar;
        if (bl) {
            this.yearChooser.setYear(calendar.getYear());
            this.monthChooser.setMonth(calendar.getMonth());
            this.dayChooser.setDay(calendar.getDay());
        }
        this.firePropertyChange("calendar", calendar2, this.calendar);
    }

    public void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            Locale locale2 = this.locale;
            this.locale = locale;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.firePropertyChange("locale", locale2, this.locale);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(color);
            this.monthChooser.setForeground(color);
            this.yearChooser.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(color);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.calendar != null) {
            Calendar calendar = (Calendar)this.calendar.clone();
            if (propertyChangeEvent.getPropertyName().equals("day")) {
                calendar.set(this.calendar.getYear(), this.calendar.getMonth(), (Integer)propertyChangeEvent.getNewValue());
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("month")) {
                CalendarMath.setMonth(calendar, (Integer)propertyChangeEvent.getNewValue(), false);
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("year")) {
                CalendarMath.setYear(calendar, (Integer)propertyChangeEvent.getNewValue(), false);
                this.setCalendar(calendar, false);
            }
        }
    }

    @Override
    public String getName() {
        return "JCalendarPanel";
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.dayChooser != null) {
            this.dayChooser.setEnabled(bl);
            this.monthChooser.setEnabled(bl);
            this.yearChooser.setEnabled(bl);
        }
    }

    public JDayChooser getDayChooser() {
        return this.dayChooser;
    }

    public JMonthChooser getMonthChooser() {
        return this.monthChooser;
    }

    public JYearChooser getYearChooser() {
        return this.yearChooser;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JCalendarFrame");
        JCalendarPanel jCalendarPanel = new JCalendarPanel(new GregorianCalendar(), new DateFormatSymbols());
        jFrame.getContentPane().add(jCalendarPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

