/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.complex;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Vector;
import jscicalc.Base;
import jscicalc.Notation;
import jscicalc.StringArray;

public class DoubleFormat {
    private final double number;
    private Base base;
    private Notation notation;
    private int precision;
    private Vector<Integer> digits;
    private long exponent;
    public static final long BIAS = 1023L;
    public static final long E_MAX = 1023L;
    public static final long E_MIN = -1022L;
    public static final Vector<String> basePoint = new Vector<String>(Arrays.asList("."));
    public static final String startExponent = "<sup style=\"font-size:60%;\">";
    public static final String endExponent = "</sup>";
    public static final Vector<String> minus = new Vector<String>(Arrays.asList("&#8722;"));
    public static final Vector<String> NaN = new Vector<String>(Arrays.asList("N", "a", "N"));
    public static final Vector<String> infinity = new Vector<String>(Arrays.asList("&#8734;"));
    public static final Vector<String> minusInfinity = new Vector<String>(Arrays.asList("&#8722;", "&#8734;"));
    public static final String startHTML = "<html>";
    public static final String endHTML = "</html>";
    public static final Vector<String> imPrefix = new Vector<String>(Arrays.asList("i"));
    public static final Vector<String> argumentPrefix = new Vector<String>(Arrays.asList("e"));
    public static final Vector<String> plus = new Vector<String>(Arrays.asList("+"));
    public final HTMLStringRepresentation NullRepresentation = new HTMLStringRepresentation(new StringArray(), 0);

    public DoubleFormat(double d, Base base) {
        this.number = d;
        this.base = base;
        this.notation = new Notation();
        this.setPrecision(this.maxPrecision());
    }

    public void setPrecision(int n) {
        if (n == this.precision) {
            return;
        }
        this.precision = n;
        this.reset();
        if (this.digits.size() <= n) {
            return;
        }
        int n2 = this.digits.get(n);
        this.digits.setSize(n);
        if (n2 < DoubleFormat.midDigit(this.base)) {
            while (this.digits.size() > 0 && this.digits.lastElement() == 0) {
                this.digits.setSize(this.digits.size() - 1);
            }
            return;
        }
        if (this.roundUp()) {
            return;
        }
        ++this.exponent;
    }

    public void setBase(Base base) {
        this.base = base;
    }

    public void setNotation(Notation notation) {
        this.notation = notation;
    }

    private boolean roundUp() {
        int n = this.digits.size() - 1;
        if (n == -1) {
            this.digits.add(1);
            return false;
        }
        int n2 = this.digits.get(n);
        if (++n2 == DoubleFormat.baseInt(this.base)) {
            this.digits.remove(n);
            return this.roundUp();
        }
        this.digits.set(n, n2);
        return true;
    }

    public HTMLStringRepresentation representation() {
        return new HTMLStringRepresentation();
    }

    private HTMLStringRepresentation standard() {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        if (this.number < 0.0) {
            vector.addAll(minus);
            ++n2;
        }
        if (this.exponent < 0L) {
            vector.add("0");
            ++n2;
            vector.addAll(basePoint);
            ++n2;
            n = 0;
            while ((long)n < -this.exponent - 1L) {
                vector.add("0");
                ++n2;
                ++n;
            }
            for (n = 0; n < this.digits.size(); ++n) {
                vector.add(Character.toString(DoubleFormat.getDigit(this.digits.elementAt(n))));
                ++n2;
            }
        } else {
            n = 0;
            while ((long)n < StrictMath.max(this.exponent + 1L, (long)this.digits.size()) && (long)n < StrictMath.max(this.exponent + 1L, (long)this.digits.size())) {
                if ((long)n == this.exponent + 1L) {
                    vector.addAll(basePoint);
                    ++n2;
                }
                if (n < this.digits.size()) {
                    vector.add(Character.toString(DoubleFormat.getDigit(this.digits.elementAt(n))));
                } else {
                    vector.add("0");
                }
                ++n2;
                ++n;
            }
        }
        StringArray stringArray = new StringArray();
        stringArray.add(vector);
        return new HTMLStringRepresentation(stringArray, n2);
    }

    /*
     * WARNING - void declaration
     */
    public HTMLStringRepresentation scientific() {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        if (this.number < 0.0) {
            vector.addAll(minus);
            ++n;
        }
        boolean bl = this.digits.size() > 1;
        for (Integer object2 : this.digits) {
            vector.add(Character.toString(DoubleFormat.getDigit(object2)));
            ++n;
            if (!bl) continue;
            vector.addAll(basePoint);
            ++n;
            bl = false;
        }
        if (this.getEStringLength() > 0) {
            vector.add(this.getEString());
            n += this.getEStringLength();
        }
        int n2 = (int)this.exponent;
        String string = new String(startExponent);
        if (this.exponent < 0L) {
            String string2 = string.concat(minus.firstElement());
            ++n;
            n2 = -n2;
            vector.add(string2);
            String string3 = new String("");
        }
        String string4 = null;
        switch (this.base) {
            case OCTAL: {
                string4 = Integer.toOctalString(n2);
                break;
            }
            case HEXADECIMAL: {
                string4 = Integer.toHexString(n2).toUpperCase();
                break;
            }
            default: {
                string4 = Integer.toString(n2);
            }
        }
        System.out.println("* " + string4);
        for (int i = 0; i < string4.length(); ++i) {
            void var5_11;
            String string5 = Character.toString(string4.charAt(i));
            if (this.exponent != 0L) {
                String string6 = var5_11.concat(string5);
            }
            if (i == string4.length() - 1) {
                String string7 = string5.concat(endExponent);
            }
            vector.add(var5_11);
        }
        StringArray stringArray = new StringArray();
        stringArray.add(vector);
        System.out.println(stringArray);
        System.out.println(n += string4.length());
        return new HTMLStringRepresentation(stringArray, n);
    }

    private void reset() {
        this.digits = new Vector();
        if (this.number == 0.0) {
            this.digits.add(0);
            this.exponent = 0L;
            return;
        }
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            return;
        }
        switch (this.base) {
            case BINARY: {
                this.setupBin();
                break;
            }
            case OCTAL: {
                this.setupOct();
                break;
            }
            case HEXADECIMAL: {
                this.setupHex();
                break;
            }
            default: {
                this.setupDec();
            }
        }
        if (StrictMath.abs(this.number) < 1.0) {
            this.exponent = -this.exponent;
        }
    }

    private void setupDec() {
        BigDecimal bigDecimal = new BigDecimal(this.number < 0.0 ? -this.number : this.number);
        this.exponent = bigDecimal.precision() - bigDecimal.scale() - 1;
        int n = (int)StrictMath.signum(this.exponent);
        if (n < 0) {
            this.exponent = -1L * this.exponent;
        }
        String string = bigDecimal.unscaledValue().toString();
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            Character c = Character.valueOf(cArray[i]);
            this.digits.add(DoubleFormat.getInt(c.charValue()));
        }
        while (this.digits.size() > 0 && this.digits.lastElement() == 0) {
            this.digits.setSize(this.digits.size() - 1);
        }
    }

    private void setupHex() {
        long l = Double.doubleToRawLongBits(this.number);
        this.exponent = (l & 0x7FF0000000000000L) >>> 52;
        long l2 = l & 0xFFFFFFFFFFFFFL;
        this.exponent -= 1023L;
        boolean bl = this.exponent == -1023L;
        int n = (int)StrictMath.signum(this.exponent);
        if (n == -1) {
            this.exponent = -this.exponent;
        }
        if (!bl) {
            l2 |= 0x10000000000000L;
        } else if ((l2 <<= 1) != 0L) {
            while ((l2 & 0x8000000000000L) == 0L) {
                ++this.exponent;
                l2 <<= 1;
            }
        }
        while (this.exponent % 4L != 0L) {
            l2 <<= 1;
            if (n == -1) {
                ++this.exponent;
                continue;
            }
            --this.exponent;
        }
        this.exponent >>>= 2;
        for (int i = 0; i < 14; ++i) {
            int n2 = (int)(l2 & 0xFL);
            this.digits.add(0, n2);
            l2 >>>= 4;
        }
    }

    private void setupOct() {
        long l = Double.doubleToRawLongBits(this.number);
        this.exponent = (l & 0x7FF0000000000000L) >>> 52;
        long l2 = l & 0xFFFFFFFFFFFFFL;
        this.exponent -= 1023L;
        boolean bl = this.exponent == -1023L;
        int n = (int)StrictMath.signum(this.exponent);
        if (n == -1) {
            this.exponent = -this.exponent;
        }
        if (!bl) {
            l2 |= 0x10000000000000L;
        } else if ((l2 <<= 1) != 0L) {
            while ((l2 & 0x8000000000000L) == 0L) {
                ++this.exponent;
                l2 <<= 1;
            }
        }
        while (this.exponent % 3L != 0L) {
            l2 <<= 1;
            if (n == -1) {
                ++this.exponent;
                continue;
            }
            --this.exponent;
        }
        this.exponent /= 3L;
        l2 <<= 2;
        for (int i = 0; i < 19; ++i) {
            int n2 = (int)(l2 & 7L);
            this.digits.add(0, n2);
            l2 >>>= 3;
        }
    }

    private void setupBin() {
        long l = Double.doubleToRawLongBits(this.number);
        this.exponent = (l & 0x7FF0000000000000L) >>> 52;
        long l2 = l & 0xFFFFFFFFFFFFFL;
        this.exponent -= 1023L;
        boolean bl = this.exponent == -1023L;
        int n = (int)StrictMath.signum(this.exponent);
        if (n == -1) {
            this.exponent = -this.exponent;
        }
        if (!bl) {
            l2 |= 0x10000000000000L;
        } else if ((l2 <<= 1) != 0L) {
            while ((l2 & 0x8000000000000L) == 0L) {
                ++this.exponent;
                l2 <<= 1;
            }
        }
        for (int i = 0; i < 53; ++i) {
            int n2 = (int)(l2 & 1L);
            this.digits.add(0, n2);
            l2 >>>= 1;
        }
    }

    public double getNumber() {
        return this.number;
    }

    public double getAbsNumber() {
        return StrictMath.abs(this.number);
    }

    private static char getDigit(int n) {
        switch (n) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return '?';
    }

    private static int getInt(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    public static int midDigit(Base base) {
        switch (base) {
            case BINARY: {
                return 1;
            }
            case OCTAL: {
                return 4;
            }
            case HEXADECIMAL: {
                return 8;
            }
        }
        return 5;
    }

    public static int baseInt(Base base) {
        switch (base) {
            case BINARY: {
                return 2;
            }
            case OCTAL: {
                return 8;
            }
            case HEXADECIMAL: {
                return 16;
            }
        }
        return 10;
    }

    private int maxPrecision() {
        switch (this.base) {
            case BINARY: {
                return 52;
            }
            case OCTAL: {
                return 17;
            }
            case HEXADECIMAL: {
                return 13;
            }
        }
        return 14;
    }

    public String getEString() {
        switch (this.base) {
            case BINARY: {
                return "";
            }
            case OCTAL: {
                return "";
            }
            case HEXADECIMAL: {
                return "";
            }
        }
        return "";
    }

    public int getEStringLength() {
        switch (this.base) {
            case BINARY: {
                return 0;
            }
            case OCTAL: {
                return 0;
            }
            case HEXADECIMAL: {
                return 0;
            }
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        DoubleFormat doubleFormat = new DoubleFormat(-4.2035492222884317E-246, Base.DECIMAL);
        Notation notation = new Notation();
        notation.setScientific();
        doubleFormat.setNotation(notation);
        HTMLStringRepresentation hTMLStringRepresentation = doubleFormat.representation();
        System.out.print(hTMLStringRepresentation.string + " (length = ");
        System.out.print(hTMLStringRepresentation.length);
        System.out.println(")");
        for (int i = 14; i > 0; --i) {
            System.out.print(i);
            System.out.print(": ");
            doubleFormat.setPrecision(i);
            hTMLStringRepresentation = doubleFormat.representation();
            System.out.print(hTMLStringRepresentation.string + " (length = ");
            System.out.print(hTMLStringRepresentation.length);
            System.out.println(")");
        }
    }

    public class HTMLStringRepresentation {
        public final StringArray string;
        public final int length;

        private HTMLStringRepresentation(StringArray stringArray, int n) {
            this.string = stringArray;
            this.length = n;
        }

        public HTMLStringRepresentation() {
            if (Double.isNaN(DoubleFormat.this.number)) {
                String[] stringArray = new String[]{"N", "a", "N"};
                this.string = new StringArray();
                this.string.add(stringArray);
                this.length = 3;
            } else if (Double.isInfinite(DoubleFormat.this.number)) {
                this.string = new StringArray();
                if (DoubleFormat.this.number < 0.0) {
                    this.string.add(minusInfinity);
                    this.length = 2;
                } else {
                    this.string.add(infinity);
                    this.length = 1;
                }
            } else {
                HTMLStringRepresentation hTMLStringRepresentation = DoubleFormat.this.notation.standard() ? DoubleFormat.this.standard() : DoubleFormat.this.scientific();
                this.string = hTMLStringRepresentation.string;
                this.length = hTMLStringRepresentation.length;
            }
        }

        public boolean isOne() {
            if (this.string.size() != 1) {
                return false;
            }
            if (((Vector)this.string.firstElement()).size() != 1) {
                return false;
            }
            return ((Vector)this.string.firstElement()).elementAt(0) == "1";
        }

        public boolean isMinusOne() {
            if (this.string.size() != 1) {
                return false;
            }
            if (((Vector)this.string.firstElement()).size() != 2) {
                return false;
            }
            if (((Vector)this.string.firstElement()).elementAt(0) != minus.elementAt(0)) {
                return false;
            }
            return ((Vector)this.string.firstElement()).elementAt(1) == "1";
        }
    }
}

