/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import javax.swing.JFrame;
import jscicalc.Error;
import jscicalc.OObject;
import jscicalc.ReadOnlyCalculatorApplet;
import jscicalc.graph.Locus;
import jscicalc.graph.Menu;
import jscicalc.graph.Model;
import jscicalc.graph.View;

public class Graph
extends JFrame {
    private Menu menu;
    private Model model = new Model();
    private View view = new View(this.model, this);
    private static final long serialVersionUID = 1L;

    public Graph(ReadOnlyCalculatorApplet readOnlyCalculatorApplet) {
        super("Scientific Calculator Graph");
        this.menu = new Menu(readOnlyCalculatorApplet, this.view, this.model);
        this.setJMenuBar(this.menu);
        int n = readOnlyCalculatorApplet.graphHeight();
        this.setSize(3 * n / 2, n);
        this.setDefaultCloseOperation(1);
        this.setContentPane(this.view);
        this.setVisible(true);
    }

    public void setLocus(OObject oObject) {
        if (oObject != null && !(oObject instanceof Error)) {
            Locus locus = new Locus(oObject, this.view);
            this.model.reset(locus);
            this.view.repaint();
        }
    }

    public void updateMenu() {
        this.menu.updateSizes();
    }
}

