/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;

public class Unwinkel
extends JComponent {
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double DEG_PER_RAD = 57.29577951308232;
    private static final double UNKNOWN = 9999.0;
    private static final double REAL_SMALL = 1.0E-5;
    private Image source;
    private int srcWidth;
    private int srcHeight;
    private double srcXPixPerDeg;
    private double srcYPixPerDeg;
    private double srcCenterX;
    private double srcCenterY;
    private int dstWidth;
    private int dstHeight;
    private double dstXPixPerDeg;
    private double dstYPixPerDeg;
    private double dstXDegPerPix;
    private double dstYDegPerPix;
    private double dstCenterX;
    private double dstCenterY;
    private int[] invArray;
    private Color bgcolor = Color.black;
    private int bgcolorRGB = this.bgcolor.getRGB();
    private int fgcolorRGB = this.bgcolorRGB ^ 0xFFFFFF;
    private double copLong = 0.0;
    private double copLat = 0.0;
    private double cosCOPLat = Math.cos(Unwinkel.toRadians(this.copLat));
    private double sinCOPLat = Math.sin(Unwinkel.toRadians(this.copLat));
    private static final double COS_PHI0 = 0.6366197723675814;
    private double rS;
    private boolean needsUpdate = true;

    public Unwinkel(int dw, int dh, Image src) {
        this.dstWidth = dw;
        this.dstHeight = dh;
        this.dstCenterX = 0.5 * (double)this.dstWidth;
        this.dstCenterY = 0.5 * (double)this.dstHeight;
        this.dstXDegPerPix = 360.0 / (double)this.dstWidth;
        this.dstYDegPerPix = 180.0 / (double)this.dstHeight;
        this.setSourceMap(src);
        this.needsUpdate = true;
    }

    public void drawMap(Graphics g) {
        if (this.needsUpdate) {
            this.calculateInverseArray();
        }
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.dstWidth, this.dstHeight);
        this.drawMapUsingInvArray(g);
    }

    private void drawMapUsingInvArray(Graphics g) {
        int offset = 0;
        int maxSrcPixels = this.srcWidth * this.srcHeight;
        int maxDstPixels = this.dstWidth * this.dstHeight;
        int[] srcPixels = new int[maxSrcPixels];
        int[] dstPixels = new int[maxDstPixels];
        try {
            PixelGrabber grabber = new PixelGrabber(this.source, 0, 0, this.srcWidth, this.srcHeight, srcPixels, 0, this.srcWidth);
            try {
                grabber.grabPixels();
            }
            catch (Exception ignore) {
                return;
            }
            int row = 0;
            while (row < this.dstHeight) {
                int col = 0;
                while (col < this.dstWidth) {
                    offset = row * this.dstWidth + col;
                    if (this.invArray[offset] - 1 > 0 && this.invArray[offset] < maxSrcPixels) {
                        dstPixels[offset] = srcPixels[this.invArray[offset]];
                    } else if (this.invArray[offset] == -100) {
                        dstPixels[offset] = this.fgcolorRGB;
                    }
                    ++col;
                }
                ++row;
            }
            g.setColor(this.bgcolor);
            g.fillRect(0, 0, this.dstWidth, this.dstHeight);
            g.drawImage(this.createImage(new MemoryImageSource(this.dstWidth, this.dstHeight, dstPixels, 0, this.dstWidth)), 0, 0, this);
        }
        catch (Exception exc) {
            System.out.println("drawMapUsingInvArray : " + exc.toString());
        }
    }

    private void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while (y < this.dstHeight) {
            double lat = 90.9 * (this.dstCenterY - (double)y) / this.dstCenterY;
            if (!(Math.abs(lat) > 90.0)) {
                int x = 0;
                while (x < this.dstWidth) {
                    double lon = 181.8 * (this.dstCenterX - (double)x) / this.dstCenterX;
                    Point p = this.transformLL2XY(lon, lat);
                    int xMap = p.x + 1;
                    int yMap = p.y;
                    while (xMap >= this.srcWidth) {
                        xMap -= this.srcWidth;
                    }
                    while (xMap < 0) {
                        xMap += this.srcWidth;
                    }
                    this.invArray[y * this.dstWidth + x] = yMap * this.srcWidth + xMap;
                    ++x;
                }
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    private void clearInverseArray() {
        if (this.invArray == null) {
            this.invArray = new int[this.dstWidth * this.dstHeight];
        }
        int j = 0;
        while (j < this.dstHeight) {
            int i = 0;
            while (i < this.dstWidth) {
                this.invArray[j * this.dstWidth + i] = -1;
                ++i;
            }
            ++j;
        }
    }

    private void setSourceMap(Image img) {
        this.source = img;
        int oldWidth = this.srcWidth;
        int oldHeight = this.srcHeight;
        this.srcWidth = this.source.getWidth(this);
        this.srcHeight = this.source.getHeight(this);
        this.srcCenterX = 0.5 * (double)this.srcWidth;
        this.srcCenterY = 0.5 * (double)this.srcHeight;
        this.srcXPixPerDeg = (double)this.srcWidth / 360.0;
        this.srcYPixPerDeg = (double)this.srcHeight / 180.0;
        this.rS = (double)this.srcWidth / 5.141592653589793;
        if (this.srcWidth != oldWidth || this.srcHeight != oldHeight) {
            this.needsUpdate = true;
        }
    }

    private Point transformLL2XY(double longitude, double latitude) {
        double dlambda = longitude - this.copLong;
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        double dlambdaRad = -Unwinkel.toRadians(dlambda);
        double phiRad = Unwinkel.toRadians(latitude);
        double dlambdaRadOver2 = 0.5 * dlambdaRad;
        double cosPhi = Math.cos(phiRad);
        double cosD = cosPhi * Math.cos(dlambdaRadOver2);
        double d = Math.acos(cosD);
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(d) < 1.0E-5) {
            x = 0.0;
            y = 0.0;
        } else {
            double dOverSqrtC = d / Math.sin(d);
            x = 0.5 * this.rS * (dlambdaRad * 0.6366197723675814 + 2.0 * dOverSqrtC * cosPhi * Math.sin(dlambdaRadOver2));
            y = 0.5 * this.rS * (phiRad + dOverSqrtC * Math.sin(phiRad));
        }
        y = this.srcCenterY - y;
        if (x < this.srcCenterX) {
            double pct = 1.0 - y / (double)this.dstHeight;
            x *= 1.0 - 0.0132 * pct;
        }
        x = this.srcCenterX + x;
        return new Point((int)x, (int)y);
    }

    private static final double toDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    private static final double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }
}

