/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.colorbar.ACTColorbar;
import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import gov.nasa.giss.graphics.colorbar.CWCColorbar;
import gov.nasa.giss.graphics.colorbar.PAL1Colorbar;
import gov.nasa.giss.graphics.colorbar.PAL2Colorbar;
import gov.nasa.giss.graphics.colorbar.PALColorbar;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class Colorbar {
    private AbstractColorbar colorbar;

    public Colorbar(Frame listener) throws IOException, FileNotFoundException, MalformedURLException {
        FileDialog fd = new FileDialog(listener, "Please select an ACT, CWC, PAL, PA1 or PA2 colorbar.", 0);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.toLowerCase().endsWith(".act") || name.toLowerCase().endsWith(".cwc") || name.toLowerCase().endsWith(".pal") || name.toLowerCase().endsWith(".pa1") || name.toLowerCase().endsWith(".pa2")) {
                    return true;
                }
                return new File(dir, name).isDirectory();
            }
        };
        fd.setFilenameFilter(filter);
        ((Component)fd).setVisible(true);
        if (fd.getFile() == null) {
            throw new FileNotFoundException("No file was selected");
        }
        this.initFromFile(new File(fd.getDirectory(), fd.getFile()));
    }

    public Colorbar(File f) throws IOException, FileNotFoundException {
        this.initFromFile(f);
    }

    public Colorbar(URL url) throws IOException, FileNotFoundException {
        if (url == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (url.getFile().toLowerCase().endsWith(".act")) {
            this.colorbar = new ACTColorbar(url);
        } else if (url.getFile().toLowerCase().endsWith(".cwc")) {
            this.colorbar = new CWCColorbar(url);
        } else if (url.getFile().toLowerCase().endsWith(".pal")) {
            this.colorbar = new PALColorbar(url);
        } else if (url.getFile().toLowerCase().endsWith(".pa1")) {
            this.colorbar = new PAL1Colorbar(url);
        } else if (url.getFile().toLowerCase().endsWith(".pa2")) {
            this.colorbar = new PAL2Colorbar(url);
        } else {
            throw new FileNotFoundException("Colorbar has unknown extension.");
        }
    }

    public Colorbar(byte[] b, String identifier) throws IOException {
        if (identifier.toLowerCase().endsWith(".act")) {
            this.colorbar = new ACTColorbar(b, identifier);
        } else if (identifier.toLowerCase().endsWith(".cwc")) {
            this.colorbar = new CWCColorbar(b, identifier);
        } else if (identifier.toLowerCase().endsWith(".pal")) {
            this.colorbar = new PALColorbar(b, identifier);
        } else if (identifier.toLowerCase().endsWith(".pa1")) {
            this.colorbar = new PAL1Colorbar(b, identifier);
        } else if (identifier.toLowerCase().endsWith(".pa2")) {
            this.colorbar = new PAL2Colorbar(b, identifier);
        } else {
            throw new IOException("Unknown color table type: " + identifier);
        }
    }

    public Colorbar(int preset) throws IOException {
        this.colorbar = new PALColorbar(preset);
    }

    private void initFromFile(File f) throws IOException, FileNotFoundException {
        if (f == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        if (f.getName().toLowerCase().endsWith(".act")) {
            this.colorbar = new ACTColorbar(f);
        } else if (f.getName().toLowerCase().endsWith(".cwc")) {
            this.colorbar = new CWCColorbar(f);
        } else if (f.getName().toLowerCase().endsWith(".pal")) {
            this.colorbar = new PALColorbar(f);
        } else if (f.getName().toLowerCase().endsWith(".pa1")) {
            this.colorbar = new PAL1Colorbar(f);
        } else if (f.getName().toLowerCase().endsWith(".pa2")) {
            this.colorbar = new PAL2Colorbar(f);
        } else {
            throw new FileNotFoundException("Colorbar has unknown extension.");
        }
    }

    public String getName() {
        return this.colorbar.getName();
    }

    public String getIdentifier() {
        return this.colorbar.getIdentifier();
    }

    public String toString() {
        return this.colorbar.getName();
    }

    public int getColorCount() {
        return this.colorbar.getColorCount();
    }

    public Color getColorAt(int bin) {
        return this.colorbar.getColorAt(bin);
    }

    public Color getColorAt(int bin, boolean flipped) {
        return this.colorbar.getColorAt(bin, flipped);
    }

    public int getRGBAt(int bin) {
        return this.colorbar.getRGBAt(bin);
    }

    public int getRGBAt(int bin, boolean flipped) {
        return this.colorbar.getRGBAt(bin, flipped);
    }

    public Color getMinOutlierColor() {
        return this.colorbar.getMinOutlierColor();
    }

    public Color getMinOutlierColor(boolean flipped) {
        return this.colorbar.getMinOutlierColor(flipped);
    }

    public int getMinOutlierRGB() {
        return this.colorbar.getMinOutlierRGB();
    }

    public int getMinOutlierRGB(boolean flipped) {
        return this.colorbar.getMinOutlierRGB(flipped);
    }

    public Color getMaxOutlierColor() {
        return this.colorbar.getMaxOutlierColor();
    }

    public Color getMaxOutlierColor(boolean flipped) {
        return this.colorbar.getMaxOutlierColor(flipped);
    }

    public int getMaxOutlierRGB() {
        return this.colorbar.getMaxOutlierRGB();
    }

    public int getMaxOutlierRGB(boolean flipped) {
        return this.colorbar.getMaxOutlierRGB(flipped);
    }
}

