/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.ControlCurve;
import java.awt.Graphics;
import java.awt.Polygon;

public class NatCubic
extends ControlCurve {
    final int STEPS = 12;

    Cubic[] calcNaturalCubic(int n, int[] x) {
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        int i = 1;
        while (i < n) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
            ++i;
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        i = 1;
        while (i < n) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
            ++i;
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        i = n - 1;
        while (i >= 0) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
            --i;
        }
        Cubic[] C = new Cubic[n];
        i = 0;
        while (i < n) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
            ++i;
        }
        return C;
    }

    public void paint(Graphics g) {
        if (this.pts.npoints >= 2) {
            Cubic[] x = this.calcNaturalCubic(this.pts.npoints - 1, this.pts.xpoints);
            Cubic[] y = this.calcNaturalCubic(this.pts.npoints - 1, this.pts.ypoints);
            Polygon p = new Polygon();
            p.addPoint(Math.round(x[0].eval(0.0f)), Math.round(y[0].eval(0.0f)));
            int i = 0;
            while (i < x.length) {
                int j = 1;
                while (j <= 12) {
                    float u = (float)j / 12.0f;
                    p.addPoint(Math.round(x[i].eval(u)), Math.round(y[i].eval(u)));
                    ++j;
                }
                ++i;
            }
            g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
        }
    }

    public class Cubic {
        float a;
        float b;
        float c;
        float d;

        public Cubic(float a, float b, float c, float d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public float eval(float u) {
            return ((this.d * u + this.c) * u + this.b) * u + this.a;
        }
    }
}

